/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.Skeleton2;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class AtomTree
extends AbstractAtom
implements Atom {
    private final HColor lineColor;
    private final List<Atom> cells = new ArrayList<Atom>();
    private final Map<Atom, Integer> levels = new HashMap<Atom, Integer>();
    private final double margin = 2.0;

    public AtomTree(HColor lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Skeleton2 skeleton = new Skeleton2();
        double width = 0.0;
        double height = 0.0;
        for (Atom cell : this.cells) {
            Dimension2D dim = cell.calculateDimension(stringBounder);
            height += dim.getHeight();
            int level = this.getLevel(cell);
            width = Math.max(width, skeleton.getXEndForLevel(level) + 2.0 + dim.getWidth());
        }
        return new Dimension2DDouble(width, height);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ugInit) {
        Skeleton2 skeleton = new Skeleton2();
        double y = 0.0;
        UGraphic ug = ugInit;
        for (Atom cell : this.cells) {
            int level = this.getLevel(cell);
            cell.drawU(ug.apply(UTranslate.dx(2.0 + skeleton.getXEndForLevel(level))));
            Dimension2D dim = cell.calculateDimension(ug.getStringBounder());
            skeleton.add(level, y + dim.getHeight() / 2.0);
            ug = ug.apply(UTranslate.dy(dim.getHeight()));
            y += dim.getHeight();
        }
        skeleton.draw(ugInit.apply(this.lineColor));
    }

    private int getLevel(Atom atom) {
        return this.levels.get(atom);
    }

    public void addCell(Atom cell, int level) {
        this.cells.add(cell);
        this.levels.put(cell, level);
    }
}

