/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;

public class AtomMath
extends AbstractAtom
implements Atom {
    private final ScientificEquationSafe math;
    private final HColor foreground;
    private final HColor background;
    private final ColorMapper colorMapper;
    private Dimension2D dim;

    public AtomMath(ScientificEquationSafe math, HColor foreground, HColor background, ColorMapper colorMapper) {
        this.math = math;
        this.colorMapper = colorMapper;
        this.foreground = foreground;
        this.background = background;
    }

    private Dimension2D calculateDimensionSlow(StringBounder stringBounder) {
        BufferedImage image = this.math.getImage(Color.BLACK, Color.WHITE).withScale(1.0).getImage();
        return new Dimension2DDouble(image.getWidth(), image.getHeight());
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.dim == null) {
            this.dim = this.calculateDimensionSlow(stringBounder);
        }
        return this.dim;
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        boolean isSvg = ug.matchesProperty("SVG");
        Color back = this.background == null ? null : this.getColor(this.background, Color.WHITE);
        Color fore = this.getColor(this.foreground, Color.BLACK);
        if (isSvg) {
            UImageSvg svg = this.math.getSvg(1.0, fore, back);
            ug.draw(svg);
        } else {
            UImage image = new UImage(this.math.getImage(fore, back)).withFormula(this.math.getFormula());
            ug.draw(image);
        }
    }

    private Color getColor(HColor color, Color defaultValue) {
        if (color instanceof HColorSimple) {
            return this.colorMapper.toColor(color);
        }
        return defaultValue;
    }
}

