"""
    Cisco SD-WAN vManage API

    The vManage API exposes the functionality of operations maintaining devices and the overlay network  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: vmanage@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)


class MonitoringHealthApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_devices_health_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/health/devices',
                'operation_id': 'get_devices_health',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'page_size',
                    'sort_by',
                    'sort_order',
                    'starting_device_id',
                    'site_id',
                    'group_id',
                    'group_id2',
                    'vpn_id',
                    'reachable',
                    'control_status',
                    'personality',
                    'health',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort_by':
                        (str,),
                    'sort_order':
                        (str,),
                    'starting_device_id':
                        (str,),
                    'site_id':
                        (str,),
                    'group_id':
                        (str,),
                    'group_id2':
                        (str,),
                    'vpn_id':
                        (str,),
                    'reachable':
                        (bool,),
                    'control_status':
                        (str,),
                    'personality':
                        (str,),
                    'health':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort_by': 'sortBy',
                    'sort_order': 'sortOrder',
                    'starting_device_id': 'startingDeviceId',
                    'site_id': 'siteId',
                    'group_id': 'group_id',
                    'group_id2': 'groupId',
                    'vpn_id': 'vpnId',
                    'reachable': 'reachable',
                    'control_status': 'controlStatus',
                    'personality': 'personality',
                    'health': 'health',
                },
                'location_map': {
                    'page': 'query',
                    'page_size': 'query',
                    'sort_by': 'query',
                    'sort_order': 'query',
                    'starting_device_id': 'query',
                    'site_id': 'query',
                    'group_id': 'query',
                    'group_id2': 'query',
                    'vpn_id': 'query',
                    'reachable': 'query',
                    'control_status': 'query',
                    'personality': 'query',
                    'health': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_devices_health_overview_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/health/devices/overview',
                'operation_id': 'get_devices_health_overview',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vpn_id',
                    'vpn_id2',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vpn_id':
                        (str,),
                    'vpn_id2':
                        (str,),
                },
                'attribute_map': {
                    'vpn_id': 'vpn_id',
                    'vpn_id2': 'vpnId',
                },
                'location_map': {
                    'vpn_id': 'query',
                    'vpn_id2': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_devices_health(
        self,
        **kwargs
    ):
        """get_devices_health  # noqa: E501

        gets page fo devices with health properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_health(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Page Number. [optional]
            page_size (int): Page Size. [optional]
            sort_by (str): Sort By Property. [optional]
            sort_order (str): Sort Order. [optional]
            starting_device_id (str): Optional device ID to start first page. [optional]
            site_id (str): Optional site ID to filter devices. [optional]
            group_id (str): Optional group ID to filter devices. [optional]
            group_id2 (str): Optional group ID to filter devices. [optional]
            vpn_id (str): Optional vpn ID to filter devices. [optional]
            reachable (bool): [optional]
            control_status (str): [optional]
            personality (str): [optional]
            health (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_devices_health_endpoint.call_with_http_info(**kwargs)

    def get_devices_health_overview(
        self,
        **kwargs
    ):
        """get_devices_health_overview  # noqa: E501

        gets devices health overview  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_health_overview(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            vpn_id (str): Optional vpn ID to filter devices. [optional]
            vpn_id2 (str): Optional vpn ID to filter devices. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_devices_health_overview_endpoint.call_with_http_info(**kwargs)

