"""
    Cisco SD-WAN vManage API

    The vManage API exposes the functionality of operations maintaining devices and the overlay network  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: vmanage@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.cellular import Cellular
from openapi_client.model.cellular_profile import CellularProfile
from openapi_client.model.ethernet import Ethernet
from openapi_client.model.network_protocol import NetworkProtocol
from openapi_client.model.security_policy import SecurityPolicy
from openapi_client.model.vpn import Vpn
from openapi_client.model.wifi import Wifi


class ConfigurationFeatureProfileMobilityApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_basic_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/basic',
                'operation_id': 'create_basic_profile_parcel_for_mobility',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'body',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_cellular_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/cellular',
                'operation_id': 'create_cellular_profile_parcel_for_mobility',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'cellular_profile',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'cellular_profile':
                        (CellularProfile,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'cellular_profile': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_ethernet_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/ethernet',
                'operation_id': 'create_ethernet_profile_parcel_for_mobility',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'ethernet',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'ethernet':
                        (Ethernet,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'ethernet': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_mobility_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/cli/{cliId}/config',
                'operation_id': 'create_mobility_config_profile_parcel_for_cli',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'body',
                ],
                'required': [
                    'cli_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_network_protocol_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/networkProtocol',
                'operation_id': 'create_network_protocol_profile_parcel_for_mobility',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'network_protocol',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'network_protocol':
                        (NetworkProtocol,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'network_protocol': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_security_policy_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/securityPolicy',
                'operation_id': 'create_security_policy_profile_parcel_for_mobility',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'security_policy',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'security_policy':
                        (SecurityPolicy,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'security_policy': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_vpn_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/vpn',
                'operation_id': 'create_vpn_profile_parcel_for_mobility',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'vpn',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'vpn':
                        (Vpn,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'vpn': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_wifi_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/wifi',
                'operation_id': 'create_wifi_profile_parcel_for_mobility',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'wifi',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'wifi':
                        (Wifi,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'wifi': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_a_cellular_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId}',
                'operation_id': 'delete_a_cellular_profile_parcel_for_mobility',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'cellular_id',
                ],
                'required': [
                    'profile_id',
                    'cellular_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'cellular_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'cellular_id': 'cellularId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'cellular_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_a_vpn_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId}',
                'operation_id': 'delete_a_vpn_profile_parcel_for_mobility',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'vpn_id',
                ],
                'required': [
                    'profile_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_basic_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/basic/{parcelId}',
                'operation_id': 'delete_basic_profile_parcel_for_mobility',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'parcel_id',
                ],
                'required': [
                    'profile_id',
                    'parcel_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'parcel_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'parcel_id': 'parcelId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'parcel_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_ethernet_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId}',
                'operation_id': 'delete_ethernet_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'ethernet_id',
                ],
                'required': [
                    'profile_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_mobility_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/cli/{cliId}/config/{configId}',
                'operation_id': 'delete_mobility_config_profile_parcel_for_cli',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'config_id',
                ],
                'required': [
                    'cli_id',
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'config_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                    'config_id': 'configId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'config_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_network_protocol_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId}',
                'operation_id': 'delete_network_protocol_profile_parcel_for_mobility',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'network_protocol_id',
                ],
                'required': [
                    'profile_id',
                    'network_protocol_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'network_protocol_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'network_protocol_id': 'networkProtocolId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'network_protocol_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_security_policy_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId}',
                'operation_id': 'delete_security_policy_profile_parcel_for_mobility',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'security_policy_id',
                ],
                'required': [
                    'profile_id',
                    'security_policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'security_policy_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'security_policy_id': 'securityPolicyId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'security_policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_wifi_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId}',
                'operation_id': 'delete_wifi_profile_parcel_for_mobility',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'wifi_id',
                ],
                'required': [
                    'profile_id',
                    'wifi_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'wifi_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'wifi_id': 'wifiId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'wifi_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.edit_basic_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/basic/{parcelId}',
                'operation_id': 'edit_basic_profile_parcel_for_mobility',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'parcel_id',
                    'body',
                ],
                'required': [
                    'profile_id',
                    'parcel_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'parcel_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'parcel_id': 'parcelId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'parcel_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_cellular_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId}',
                'operation_id': 'edit_cellular_profile_parcel_for_mobility',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'cellular_id',
                    'cellular',
                ],
                'required': [
                    'profile_id',
                    'cellular_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'cellular_id':
                        (str,),
                    'cellular':
                        (Cellular,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'cellular_id': 'cellularId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'cellular_id': 'path',
                    'cellular': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_ethernet_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId}',
                'operation_id': 'edit_ethernet_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'ethernet_id',
                    'body',
                ],
                'required': [
                    'profile_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'ethernet_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_mobility_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/cli/{cliId}/config/{configId}',
                'operation_id': 'edit_mobility_config_profile_parcel_for_cli',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'config_id',
                    'body',
                ],
                'required': [
                    'cli_id',
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'config_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                    'config_id': 'configId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'config_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_network_protocol_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId}',
                'operation_id': 'edit_network_protocol_profile_parcel_for_mobility',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'network_protocol_id',
                    'network_protocol',
                ],
                'required': [
                    'profile_id',
                    'network_protocol_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'network_protocol_id':
                        (str,),
                    'network_protocol':
                        (NetworkProtocol,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'network_protocol_id': 'networkProtocolId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'network_protocol_id': 'path',
                    'network_protocol': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_security_policy_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId}',
                'operation_id': 'edit_security_policy_profile_parcel_for_mobility',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'security_policy_id',
                    'security_policy',
                ],
                'required': [
                    'profile_id',
                    'security_policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'security_policy_id':
                        (str,),
                    'security_policy':
                        (SecurityPolicy,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'security_policy_id': 'securityPolicyId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'security_policy_id': 'path',
                    'security_policy': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_vpn_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId}',
                'operation_id': 'edit_vpn_profile_parcel_for_mobility',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'vpn_id',
                    'vpn',
                ],
                'required': [
                    'profile_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'vpn':
                        (Vpn,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'vpn_id': 'path',
                    'vpn': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_wifi_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId}',
                'operation_id': 'edit_wifi_profile_parcel_for_mobility',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'wifi_id',
                    'wifi',
                ],
                'required': [
                    'profile_id',
                    'wifi_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'wifi_id':
                        (str,),
                    'wifi':
                        (Wifi,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'wifi_id': 'wifiId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'wifi_id': 'path',
                    'wifi': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_basic_profile_parcel_by_parcel_id_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/basic/{parcelId}',
                'operation_id': 'get_basic_profile_parcel_by_parcel_id_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'parcel_id',
                ],
                'required': [
                    'profile_id',
                    'parcel_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'parcel_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'parcel_id': 'parcelId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'parcel_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_basic_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/basic',
                'operation_id': 'get_basic_profile_parcel_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId}',
                'operation_id': 'get_cellular_profile_parcel_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'cellular_id',
                ],
                'required': [
                    'profile_id',
                    'cellular_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'cellular_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'cellular_id': 'cellularId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'cellular_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_profile_parcel_list_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/cellular',
                'operation_id': 'get_cellular_profile_parcel_list_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ethernet_profile_parcel_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId}',
                'operation_id': 'get_ethernet_profile_parcel',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'ethernet_id',
                ],
                'required': [
                    'profile_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ethernet_profile_parcels_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/ethernet',
                'operation_id': 'get_ethernet_profile_parcels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_mobility_config_profile_parcel_by_parcel_id_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/cli/{cliId}/config/{configId}',
                'operation_id': 'get_mobility_config_profile_parcel_by_parcel_id_for_cli',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'config_id',
                ],
                'required': [
                    'cli_id',
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'config_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                    'config_id': 'configId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'config_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_mobility_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/cli/{cliId}/config',
                'operation_id': 'get_mobility_config_profile_parcel_for_cli',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                ],
                'required': [
                    'cli_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                },
                'location_map': {
                    'cli_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_mobility_feature_profile_by_global_id_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}',
                'operation_id': 'get_mobility_feature_profile_by_global_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_mobility_global_basic_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/basic/schema',
                'operation_id': 'get_mobility_global_basic_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_network_protocol_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId}',
                'operation_id': 'get_network_protocol_profile_parcel_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'network_protocol_id',
                ],
                'required': [
                    'profile_id',
                    'network_protocol_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'network_protocol_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'network_protocol_id': 'networkProtocolId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'network_protocol_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_network_protocol_profile_parcel_list_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/networkProtocol',
                'operation_id': 'get_network_protocol_profile_parcel_list_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_security_policy_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId}',
                'operation_id': 'get_security_policy_profile_parcel_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'security_policy_id',
                ],
                'required': [
                    'profile_id',
                    'security_policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'security_policy_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'security_policy_id': 'securityPolicyId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'security_policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_security_policy_profile_parcel_list_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/securityPolicy',
                'operation_id': 'get_security_policy_profile_parcel_list_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_vpn_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId}',
                'operation_id': 'get_vpn_profile_parcel_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'vpn_id',
                ],
                'required': [
                    'profile_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_vpn_profile_parcel_list_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/vpn',
                'operation_id': 'get_vpn_profile_parcel_list_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_wifi_profile_parcel_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId}',
                'operation_id': 'get_wifi_profile_parcel_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'wifi_id',
                ],
                'required': [
                    'profile_id',
                    'wifi_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'wifi_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'wifi_id': 'wifiId',
                },
                'location_map': {
                    'profile_id': 'path',
                    'wifi_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_wifi_profile_parcel_list_for_mobility_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/mobility/global/{profileId}/wifi',
                'operation_id': 'get_wifi_profile_parcel_list_for_mobility',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                ],
                'required': [
                    'profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                },
                'location_map': {
                    'profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_basic_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """create_basic_profile_parcel_for_mobility  # noqa: E501

        Create a Basic Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_basic_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            body (str): Basic Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.create_basic_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def create_cellular_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """create_cellular_profile_parcel_for_mobility  # noqa: E501

        Create an cellular Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cellular_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            cellular_profile (CellularProfile): Cellular Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.create_cellular_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def create_ethernet_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """create_ethernet_profile_parcel_for_mobility  # noqa: E501

        Create an ethernet Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ethernet_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            ethernet (Ethernet): Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.create_ethernet_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def create_mobility_config_profile_parcel_for_cli(
        self,
        cli_id,
        **kwargs
    ):
        """create_mobility_config_profile_parcel_for_cli  # noqa: E501

        Create a config Profile Parcel for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_mobility_config_profile_parcel_for_cli(cli_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID

        Keyword Args:
            body (str): cli config Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        return self.create_mobility_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def create_network_protocol_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """create_network_protocol_profile_parcel_for_mobility  # noqa: E501

        Create an NetworkProtocol Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_network_protocol_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            network_protocol (NetworkProtocol): NetworkProtocol Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.create_network_protocol_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def create_security_policy_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """create_security_policy_profile_parcel_for_mobility  # noqa: E501

        Create an SecurityPolicy Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_security_policy_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            security_policy (SecurityPolicy): SecurityPolicy Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.create_security_policy_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def create_vpn_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """create_vpn_profile_parcel_for_mobility  # noqa: E501

        Create an Vpn Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vpn_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            vpn (Vpn): Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.create_vpn_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def create_wifi_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """create_wifi_profile_parcel_for_mobility  # noqa: E501

        Create an Wifi Profile Parcel for Mobility feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wifi_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            wifi (Wifi): Wifi Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.create_wifi_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def delete_a_cellular_profile_parcel_for_mobility(
        self,
        profile_id,
        cellular_id,
        **kwargs
    ):
        """delete_a_cellular_profile_parcel_for_mobility  # noqa: E501

        Delete a Cellular Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_a_cellular_profile_parcel_for_mobility(profile_id, cellular_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            cellular_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['cellular_id'] = \
            cellular_id
        return self.delete_a_cellular_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def delete_a_vpn_profile_parcel_for_mobility(
        self,
        profile_id,
        vpn_id,
        **kwargs
    ):
        """delete_a_vpn_profile_parcel_for_mobility  # noqa: E501

        Delete a Vpn Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_a_vpn_profile_parcel_for_mobility(profile_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.delete_a_vpn_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def delete_basic_profile_parcel_for_mobility(
        self,
        profile_id,
        parcel_id,
        **kwargs
    ):
        """delete_basic_profile_parcel_for_mobility  # noqa: E501

        Delete a Basic Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_basic_profile_parcel_for_mobility(profile_id, parcel_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            parcel_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['parcel_id'] = \
            parcel_id
        return self.delete_basic_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def delete_ethernet_profile_parcel_for_system(
        self,
        profile_id,
        ethernet_id,
        **kwargs
    ):
        """delete_ethernet_profile_parcel_for_system  # noqa: E501

        Delete a Ethernet Profile Parcel for feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ethernet_profile_parcel_for_system(profile_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            ethernet_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.delete_ethernet_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_mobility_config_profile_parcel_for_cli(
        self,
        cli_id,
        config_id,
        **kwargs
    ):
        """delete_mobility_config_profile_parcel_for_cli  # noqa: E501

        Delete a config Profile Parcel for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mobility_config_profile_parcel_for_cli(cli_id, config_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID
            config_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        kwargs['config_id'] = \
            config_id
        return self.delete_mobility_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def delete_network_protocol_profile_parcel_for_mobility(
        self,
        profile_id,
        network_protocol_id,
        **kwargs
    ):
        """delete_network_protocol_profile_parcel_for_mobility  # noqa: E501

        Delete a Network Protocol Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            network_protocol_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['network_protocol_id'] = \
            network_protocol_id
        return self.delete_network_protocol_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def delete_security_policy_profile_parcel_for_mobility(
        self,
        profile_id,
        security_policy_id,
        **kwargs
    ):
        """delete_security_policy_profile_parcel_for_mobility  # noqa: E501

        Delete a Security Policy Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            security_policy_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['security_policy_id'] = \
            security_policy_id
        return self.delete_security_policy_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def delete_wifi_profile_parcel_for_mobility(
        self,
        profile_id,
        wifi_id,
        **kwargs
    ):
        """delete_wifi_profile_parcel_for_mobility  # noqa: E501

        Delete an Wifi Profile Parcel for Mobility feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_wifi_profile_parcel_for_mobility(profile_id, wifi_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            wifi_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['wifi_id'] = \
            wifi_id
        return self.delete_wifi_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def edit_basic_profile_parcel_for_mobility(
        self,
        profile_id,
        parcel_id,
        **kwargs
    ):
        """edit_basic_profile_parcel_for_mobility  # noqa: E501

        Update a Basic Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_basic_profile_parcel_for_mobility(profile_id, parcel_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            parcel_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Basic Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['parcel_id'] = \
            parcel_id
        return self.edit_basic_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def edit_cellular_profile_parcel_for_mobility(
        self,
        profile_id,
        cellular_id,
        **kwargs
    ):
        """edit_cellular_profile_parcel_for_mobility  # noqa: E501

        Edit an Cellular Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_cellular_profile_parcel_for_mobility(profile_id, cellular_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            cellular_id (str): Profile Parcel ID

        Keyword Args:
            cellular (Cellular): Cellular Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['cellular_id'] = \
            cellular_id
        return self.edit_cellular_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def edit_ethernet_profile_parcel_for_system(
        self,
        profile_id,
        ethernet_id,
        **kwargs
    ):
        """edit_ethernet_profile_parcel_for_system  # noqa: E501

        Update a Ethernet Profile Parcel for feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_ethernet_profile_parcel_for_system(profile_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            ethernet_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.edit_ethernet_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_mobility_config_profile_parcel_for_cli(
        self,
        cli_id,
        config_id,
        **kwargs
    ):
        """edit_mobility_config_profile_parcel_for_cli  # noqa: E501

        Update a config Profile Parcel for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_mobility_config_profile_parcel_for_cli(cli_id, config_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID
            config_id (str): Profile Parcel ID

        Keyword Args:
            body (str): cli config Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        kwargs['config_id'] = \
            config_id
        return self.edit_mobility_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def edit_network_protocol_profile_parcel_for_mobility(
        self,
        profile_id,
        network_protocol_id,
        **kwargs
    ):
        """edit_network_protocol_profile_parcel_for_mobility  # noqa: E501

        Edit an Network Protocol Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            network_protocol_id (str): Profile Parcel ID

        Keyword Args:
            network_protocol (NetworkProtocol): Network Protocol Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['network_protocol_id'] = \
            network_protocol_id
        return self.edit_network_protocol_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def edit_security_policy_profile_parcel_for_mobility(
        self,
        profile_id,
        security_policy_id,
        **kwargs
    ):
        """edit_security_policy_profile_parcel_for_mobility  # noqa: E501

        Edit an Security Policy Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            security_policy_id (str): Profile Parcel ID

        Keyword Args:
            security_policy (SecurityPolicy): Security Policy Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['security_policy_id'] = \
            security_policy_id
        return self.edit_security_policy_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def edit_vpn_profile_parcel_for_mobility(
        self,
        profile_id,
        vpn_id,
        **kwargs
    ):
        """edit_vpn_profile_parcel_for_mobility  # noqa: E501

        Edit an Vpn Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_vpn_profile_parcel_for_mobility(profile_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            vpn (Vpn): Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.edit_vpn_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def edit_wifi_profile_parcel_for_mobility(
        self,
        profile_id,
        wifi_id,
        **kwargs
    ):
        """edit_wifi_profile_parcel_for_mobility  # noqa: E501

        Edit an Wifi Profile Parcel for Mobility feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_wifi_profile_parcel_for_mobility(profile_id, wifi_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            wifi_id (str): Profile Parcel ID

        Keyword Args:
            wifi (Wifi): Wifi Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['wifi_id'] = \
            wifi_id
        return self.edit_wifi_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_basic_profile_parcel_by_parcel_id_for_mobility(
        self,
        profile_id,
        parcel_id,
        **kwargs
    ):
        """get_basic_profile_parcel_by_parcel_id_for_mobility  # noqa: E501

        Get Basic Profile Parcel by parcelId for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_basic_profile_parcel_by_parcel_id_for_mobility(profile_id, parcel_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            parcel_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['parcel_id'] = \
            parcel_id
        return self.get_basic_profile_parcel_by_parcel_id_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_basic_profile_parcel_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """get_basic_profile_parcel_for_mobility  # noqa: E501

        Get Basic Profile Parcels for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_basic_profile_parcel_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_basic_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_cellular_profile_parcel_for_mobility(
        self,
        profile_id,
        cellular_id,
        **kwargs
    ):
        """get_cellular_profile_parcel_for_mobility  # noqa: E501

        Get an Mobility Cellular Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_profile_parcel_for_mobility(profile_id, cellular_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            cellular_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['cellular_id'] = \
            cellular_id
        return self.get_cellular_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_cellular_profile_parcel_list_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """get_cellular_profile_parcel_list_for_mobility  # noqa: E501

        Get an Mobility Cellular Profile Parcel list for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_profile_parcel_list_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_cellular_profile_parcel_list_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_ethernet_profile_parcel(
        self,
        profile_id,
        ethernet_id,
        **kwargs
    ):
        """get_ethernet_profile_parcel  # noqa: E501

        Get Ethernet Profile Parcels for feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ethernet_profile_parcel(profile_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            ethernet_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.get_ethernet_profile_parcel_endpoint.call_with_http_info(**kwargs)

    def get_ethernet_profile_parcels(
        self,
        profile_id,
        **kwargs
    ):
        """get_ethernet_profile_parcels  # noqa: E501

        Get Ethernet Profile Parcels for feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ethernet_profile_parcels(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_ethernet_profile_parcels_endpoint.call_with_http_info(**kwargs)

    def get_mobility_config_profile_parcel_by_parcel_id_for_cli(
        self,
        cli_id,
        config_id,
        **kwargs
    ):
        """get_mobility_config_profile_parcel_by_parcel_id_for_cli  # noqa: E501

        Get config Profile Parcel by configId for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mobility_config_profile_parcel_by_parcel_id_for_cli(cli_id, config_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID
            config_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        kwargs['config_id'] = \
            config_id
        return self.get_mobility_config_profile_parcel_by_parcel_id_for_cli_endpoint.call_with_http_info(**kwargs)

    def get_mobility_config_profile_parcel_for_cli(
        self,
        cli_id,
        **kwargs
    ):
        """get_mobility_config_profile_parcel_for_cli  # noqa: E501

        Get config Profile Parcels for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mobility_config_profile_parcel_for_cli(cli_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        return self.get_mobility_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def get_mobility_feature_profile_by_global_id(
        self,
        profile_id,
        **kwargs
    ):
        """get_mobility_feature_profile_by_global_id  # noqa: E501

        Get a Mobility Global Feature Profile by profileId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mobility_feature_profile_by_global_id(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile Id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_mobility_feature_profile_by_global_id_endpoint.call_with_http_info(**kwargs)

    def get_mobility_global_basic_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_mobility_global_basic_parcel_schema_by_schema_type  # noqa: E501

        Get a Mobility Global Basic Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mobility_global_basic_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_mobility_global_basic_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_network_protocol_profile_parcel_for_mobility(
        self,
        profile_id,
        network_protocol_id,
        **kwargs
    ):
        """get_network_protocol_profile_parcel_for_mobility  # noqa: E501

        Get an Mobility NetworkProtocol Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            network_protocol_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['network_protocol_id'] = \
            network_protocol_id
        return self.get_network_protocol_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_network_protocol_profile_parcel_list_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """get_network_protocol_profile_parcel_list_for_mobility  # noqa: E501

        Get an Mobility NetworkProtocol Profile Parcel list for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_network_protocol_profile_parcel_list_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_network_protocol_profile_parcel_list_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_security_policy_profile_parcel_for_mobility(
        self,
        profile_id,
        security_policy_id,
        **kwargs
    ):
        """get_security_policy_profile_parcel_for_mobility  # noqa: E501

        Get an Mobility SecurityPolicy Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            security_policy_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['security_policy_id'] = \
            security_policy_id
        return self.get_security_policy_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_security_policy_profile_parcel_list_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """get_security_policy_profile_parcel_list_for_mobility  # noqa: E501

        Get an Mobility SecurityPolicy Profile Parcel list for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_security_policy_profile_parcel_list_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_security_policy_profile_parcel_list_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_vpn_profile_parcel_for_mobility(
        self,
        profile_id,
        vpn_id,
        **kwargs
    ):
        """get_vpn_profile_parcel_for_mobility  # noqa: E501

        Get an Mobility Vpn Profile Parcel for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vpn_profile_parcel_for_mobility(profile_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_vpn_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_vpn_profile_parcel_list_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """get_vpn_profile_parcel_list_for_mobility  # noqa: E501

        Get an Mobility Vpn Profile Parcel list for Mobility Global Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vpn_profile_parcel_list_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_vpn_profile_parcel_list_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_wifi_profile_parcel_for_mobility(
        self,
        profile_id,
        wifi_id,
        **kwargs
    ):
        """get_wifi_profile_parcel_for_mobility  # noqa: E501

        Get an Wifi Profile Parcel for Mobility feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wifi_profile_parcel_for_mobility(profile_id, wifi_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID
            wifi_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['wifi_id'] = \
            wifi_id
        return self.get_wifi_profile_parcel_for_mobility_endpoint.call_with_http_info(**kwargs)

    def get_wifi_profile_parcel_list_for_mobility(
        self,
        profile_id,
        **kwargs
    ):
        """get_wifi_profile_parcel_list_for_mobility  # noqa: E501

        Get Wifi Profile Parcel List for Mobility feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wifi_profile_parcel_list_for_mobility(profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        return self.get_wifi_profile_parcel_list_for_mobility_endpoint.call_with_http_info(**kwargs)

