"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


class StandaloneInvestmentTransactionSubtype(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'account_fee': (str,),  # noqa: E501
            'assignment': (str,),  # noqa: E501
            'buy': (str,),  # noqa: E501
            'buy_to_cover': (str,),  # noqa: E501
            'contribution': (str,),  # noqa: E501
            'deposit': (str,),  # noqa: E501
            'distribution': (str,),  # noqa: E501
            'dividend': (str,),  # noqa: E501
            'dividend_reinvestment': (str,),  # noqa: E501
            'exercise': (str,),  # noqa: E501
            'expire': (str,),  # noqa: E501
            'fund_fee': (str,),  # noqa: E501
            'interest': (str,),  # noqa: E501
            'interest_receivable': (str,),  # noqa: E501
            'interest_reinvestment': (str,),  # noqa: E501
            'legal_fee': (str,),  # noqa: E501
            'loan_payment': (str,),  # noqa: E501
            'long_term_capital_gain': (str,),  # noqa: E501
            'long_term_capital_gain_reinvestment': (str,),  # noqa: E501
            'management_fee': (str,),  # noqa: E501
            'margin_expense': (str,),  # noqa: E501
            'merger': (str,),  # noqa: E501
            'miscellaneous_fee': (str,),  # noqa: E501
            'non_qualified_dividend': (str,),  # noqa: E501
            'non_resident_tax': (str,),  # noqa: E501
            'pending_credit': (str,),  # noqa: E501
            'pending_debit': (str,),  # noqa: E501
            'qualified_dividend': (str,),  # noqa: E501
            'rebalance': (str,),  # noqa: E501
            'return_of_principal': (str,),  # noqa: E501
            'sell': (str,),  # noqa: E501
            'sell_short': (str,),  # noqa: E501
            'short_term_capital_gain': (str,),  # noqa: E501
            'short_term_capital_gain_reinvestment': (str,),  # noqa: E501
            'spin_off': (str,),  # noqa: E501
            'split': (str,),  # noqa: E501
            'stock_distribution': (str,),  # noqa: E501
            'tax': (str,),  # noqa: E501
            'tax_withheld': (str,),  # noqa: E501
            'transfer': (str,),  # noqa: E501
            'transfer_fee': (str,),  # noqa: E501
            'trust_fee': (str,),  # noqa: E501
            'unqualified_gain': (str,),  # noqa: E501
            'withdrawal': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'account_fee': 'account fee',  # noqa: E501
        'assignment': 'assignment',  # noqa: E501
        'buy': 'buy',  # noqa: E501
        'buy_to_cover': 'buy to cover',  # noqa: E501
        'contribution': 'contribution',  # noqa: E501
        'deposit': 'deposit',  # noqa: E501
        'distribution': 'distribution',  # noqa: E501
        'dividend': 'dividend',  # noqa: E501
        'dividend_reinvestment': 'dividend reinvestment',  # noqa: E501
        'exercise': 'exercise',  # noqa: E501
        'expire': 'expire',  # noqa: E501
        'fund_fee': 'fund fee',  # noqa: E501
        'interest': 'interest',  # noqa: E501
        'interest_receivable': 'interest receivable',  # noqa: E501
        'interest_reinvestment': 'interest reinvestment',  # noqa: E501
        'legal_fee': 'legal fee',  # noqa: E501
        'loan_payment': 'loan payment',  # noqa: E501
        'long_term_capital_gain': 'long-term capital gain',  # noqa: E501
        'long_term_capital_gain_reinvestment': 'long-term capital gain reinvestment',  # noqa: E501
        'management_fee': 'management fee',  # noqa: E501
        'margin_expense': 'margin expense',  # noqa: E501
        'merger': 'merger',  # noqa: E501
        'miscellaneous_fee': 'miscellaneous fee',  # noqa: E501
        'non_qualified_dividend': 'non-qualified dividend',  # noqa: E501
        'non_resident_tax': 'non-resident tax',  # noqa: E501
        'pending_credit': 'pending credit',  # noqa: E501
        'pending_debit': 'pending debit',  # noqa: E501
        'qualified_dividend': 'qualified dividend',  # noqa: E501
        'rebalance': 'rebalance',  # noqa: E501
        'return_of_principal': 'return of principal',  # noqa: E501
        'sell': 'sell',  # noqa: E501
        'sell_short': 'sell short',  # noqa: E501
        'short_term_capital_gain': 'short-term capital gain',  # noqa: E501
        'short_term_capital_gain_reinvestment': 'short-term capital gain reinvestment',  # noqa: E501
        'spin_off': 'spin off',  # noqa: E501
        'split': 'split',  # noqa: E501
        'stock_distribution': 'stock distribution',  # noqa: E501
        'tax': 'tax',  # noqa: E501
        'tax_withheld': 'tax withheld',  # noqa: E501
        'transfer': 'transfer',  # noqa: E501
        'transfer_fee': 'transfer fee',  # noqa: E501
        'trust_fee': 'trust fee',  # noqa: E501
        'unqualified_gain': 'unqualified gain',  # noqa: E501
        'withdrawal': 'withdrawal',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """StandaloneInvestmentTransactionSubtype - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account_fee (str): Fees paid for account maintenance. [optional]  # noqa: E501
            assignment (str): Assignment of short option holding. [optional]  # noqa: E501
            buy (str): Purchase to open or increase a position. [optional]  # noqa: E501
            buy_to_cover (str): Purchase to close a short position. [optional]  # noqa: E501
            contribution (str): Inflow of assets into a tax-advantaged account. [optional]  # noqa: E501
            deposit (str): Inflow of cash into an account. [optional]  # noqa: E501
            distribution (str): Outflow of assets from a tax-advantaged account. [optional]  # noqa: E501
            dividend (str): Inflow of cash from a dividend. [optional]  # noqa: E501
            dividend_reinvestment (str): Purchase using proceeds from a cash dividend. [optional]  # noqa: E501
            exercise (str): Exercise of an option or warrant contract. [optional]  # noqa: E501
            expire (str): Expiration of an option or warrant contract . [optional]  # noqa: E501
            fund_fee (str): Fees paid for administration of a mutual fund or other pooled investment vehicle. [optional]  # noqa: E501
            interest (str): Inflow of cash from interest. [optional]  # noqa: E501
            interest_receivable (str): Inflow of cash from interest receivable. [optional]  # noqa: E501
            interest_reinvestment (str): Purchase using proceeds from a cash interest payment. [optional]  # noqa: E501
            legal_fee (str): Fees paid for legal charges or services. [optional]  # noqa: E501
            loan_payment (str): Inflow of cash related to payment on a loan. [optional]  # noqa: E501
            long_term_capital_gain (str): Long-term capital gain received as cash. [optional]  # noqa: E501
            long_term_capital_gain_reinvestment (str): Purchase using long-term capital gain cash proceeds. [optional]  # noqa: E501
            management_fee (str): Fees paid for investment management of a mutual fund or other pooled investment vehicle. [optional]  # noqa: E501
            margin_expense (str): Fees paid for maintaining margin debt. [optional]  # noqa: E501
            merger (str): Stock exchanged at a pre-defined ratio as part of a merger between companies. [optional]  # noqa: E501
            miscellaneous_fee (str): Fee associated with various account or holding actions. [optional]  # noqa: E501
            non_qualified_dividend (str): Inflow of cash from a non-qualified dividend. [optional]  # noqa: E501
            non_resident_tax (str): Taxes paid on behalf of the investor for non-residency in investment jurisdiction. [optional]  # noqa: E501
            pending_credit (str): Pending inflow of cash. [optional]  # noqa: E501
            pending_debit (str): Pending outflow of cash. [optional]  # noqa: E501
            qualified_dividend (str): Inflow of cash from a qualified dividend. [optional]  # noqa: E501
            rebalance (str): Rebalancing transaction (buy or sell) with no net impact to value in the account. [optional]  # noqa: E501
            return_of_principal (str): Repayment of loan principal. [optional]  # noqa: E501
            sell (str): Sell to close or decrease an existing holding. [optional]  # noqa: E501
            sell_short (str): Sell to open a short position. [optional]  # noqa: E501
            short_term_capital_gain (str): Short-term capital gain received as cash. [optional]  # noqa: E501
            short_term_capital_gain_reinvestment (str): Purchase using short-term capital gain cash proceeds. [optional]  # noqa: E501
            spin_off (str): Inflow of stock from spin-off transaction of an existing holding. [optional]  # noqa: E501
            split (str): Inflow of stock from a forward split of an existing holding. [optional]  # noqa: E501
            stock_distribution (str): Inflow of stock from a distribution. [optional]  # noqa: E501
            tax (str): Taxes paid on behalf of the investor. [optional]  # noqa: E501
            tax_withheld (str): Taxes withheld on behalf of the customer. [optional]  # noqa: E501
            transfer (str): Movement of assets into or out of an account. [optional]  # noqa: E501
            transfer_fee (str): Fees incurred for transfer of a holding or account. [optional]  # noqa: E501
            trust_fee (str): Fees related to adminstration of a trust account. [optional]  # noqa: E501
            unqualified_gain (str): Unqualified capital gain received as cash. [optional]  # noqa: E501
            withdrawal (str): Outflow of cash from an account. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
