# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 8
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_2_1.api_client import ApiClient


class PerformanceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_performance_dataset(self, performance_dataset, **kwargs):  # noqa: E501
        """create_performance_dataset  # noqa: E501

        Create a new dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_performance_dataset(performance_dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PerformanceDatasetCreateParams performance_dataset: (required)
        :return: CreatePerformanceDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_performance_dataset_with_http_info(performance_dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.create_performance_dataset_with_http_info(performance_dataset, **kwargs)  # noqa: E501
            return data

    def create_performance_dataset_with_http_info(self, performance_dataset, **kwargs):  # noqa: E501
        """create_performance_dataset  # noqa: E501

        Create a new dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_performance_dataset_with_http_info(performance_dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PerformanceDatasetCreateParams performance_dataset: (required)
        :return: CreatePerformanceDatasetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['performance_dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_performance_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'performance_dataset' is set
        if ('performance_dataset' not in params or
                params['performance_dataset'] is None):
            raise ValueError("Missing the required parameter `performance_dataset` when calling `create_performance_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'performance_dataset' in params:
            body_params = params['performance_dataset']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/datasets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatePerformanceDatasetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_performance_dataset(self, performance_dataset_id, **kwargs):  # noqa: E501
        """delete_performance_dataset  # noqa: E501

        Delete the performance dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_performance_dataset(performance_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str performance_dataset_id: Delete the performance dataset. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_performance_dataset_with_http_info(performance_dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_performance_dataset_with_http_info(performance_dataset_id, **kwargs)  # noqa: E501
            return data

    def delete_performance_dataset_with_http_info(self, performance_dataset_id, **kwargs):  # noqa: E501
        """delete_performance_dataset  # noqa: E501

        Delete the performance dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_performance_dataset_with_http_info(performance_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str performance_dataset_id: Delete the performance dataset. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['performance_dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_performance_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'performance_dataset_id' is set
        if ('performance_dataset_id' not in params or
                params['performance_dataset_id'] is None):
            raise ValueError("Missing the required parameter `performance_dataset_id` when calling `delete_performance_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'performance_dataset_id' in params:
            path_params['PerformanceDatasetId'] = params['performance_dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/datasets/{PerformanceDatasetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_performance_dataset(self, performance_dataset_id, **kwargs):  # noqa: E501
        """get_performance_dataset  # noqa: E501

        Retrieve the performance dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_dataset(performance_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str performance_dataset_id: Retrieve the performance dataset. (required)
        :return: PerformanceDatasets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_performance_dataset_with_http_info(performance_dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_performance_dataset_with_http_info(performance_dataset_id, **kwargs)  # noqa: E501
            return data

    def get_performance_dataset_with_http_info(self, performance_dataset_id, **kwargs):  # noqa: E501
        """get_performance_dataset  # noqa: E501

        Retrieve the performance dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_dataset_with_http_info(performance_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str performance_dataset_id: Retrieve the performance dataset. (required)
        :return: PerformanceDatasets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['performance_dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'performance_dataset_id' is set
        if ('performance_dataset_id' not in params or
                params['performance_dataset_id'] is None):
            raise ValueError("Missing the required parameter `performance_dataset_id` when calling `get_performance_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'performance_dataset_id' in params:
            path_params['PerformanceDatasetId'] = params['performance_dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/datasets/{PerformanceDatasetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PerformanceDatasets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_performance_metric(self, performance_metric_id, **kwargs):  # noqa: E501
        """get_performance_metric  # noqa: E501

        View a single performance metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_metric(performance_metric_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str performance_metric_id: View a single performance metric. (required)
        :return: PerformanceMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_performance_metric_with_http_info(performance_metric_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_performance_metric_with_http_info(performance_metric_id, **kwargs)  # noqa: E501
            return data

    def get_performance_metric_with_http_info(self, performance_metric_id, **kwargs):  # noqa: E501
        """get_performance_metric  # noqa: E501

        View a single performance metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_metric_with_http_info(performance_metric_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str performance_metric_id: View a single performance metric. (required)
        :return: PerformanceMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['performance_metric_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_metric" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'performance_metric_id' is set
        if ('performance_metric_id' not in params or
                params['performance_metric_id'] is None):
            raise ValueError("Missing the required parameter `performance_metric_id` when calling `get_performance_metric`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'performance_metric_id' in params:
            path_params['PerformanceMetricId'] = params['performance_metric_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/metrics/{PerformanceMetricId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PerformanceMetrics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_performance_metrics(self, **kwargs):  # noqa: E501
        """get_performance_metrics  # noqa: E501

        List all metrics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_metrics(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str dir: The direction of the sort.
        :return: PerformanceMetricsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_performance_metrics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_performance_metrics_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_performance_metrics_with_http_info(self, **kwargs):  # noqa: E501
        """get_performance_metrics  # noqa: E501

        List all metrics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_metrics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str dir: The direction of the sort.
        :return: PerformanceMetricsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_performance_metrics`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_performance_metrics`, length must be greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_performance_metrics`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PerformanceMetricsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_performance_settings(self, **kwargs):  # noqa: E501
        """get_performance_settings  # noqa: E501

        List all performance settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PerformanceSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_performance_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_performance_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_performance_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_performance_settings  # noqa: E501

        List all performance settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_performance_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PerformanceSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PerformanceSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_performance_datasets(self, **kwargs):  # noqa: E501
        """list_performance_datasets  # noqa: E501

        List all datasets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_performance_datasets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: PerformanceDatasetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_performance_datasets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_performance_datasets_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_performance_datasets_with_http_info(self, **kwargs):  # noqa: E501
        """list_performance_datasets  # noqa: E501

        List all datasets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_performance_datasets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: PerformanceDatasetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_performance_datasets" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_performance_datasets`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_performance_datasets`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_performance_datasets`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_performance_datasets`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_performance_datasets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_performance_datasets`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_performance_datasets`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/datasets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PerformanceDatasetsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_performance_dataset(self, performance_dataset, performance_dataset_id, **kwargs):  # noqa: E501
        """update_performance_dataset  # noqa: E501

        Modify the name of the performance dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_performance_dataset(performance_dataset, performance_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PerformanceDataset performance_dataset: (required)
        :param str performance_dataset_id: Modify the name of the performance dataset. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_performance_dataset_with_http_info(performance_dataset, performance_dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_performance_dataset_with_http_info(performance_dataset, performance_dataset_id, **kwargs)  # noqa: E501
            return data

    def update_performance_dataset_with_http_info(self, performance_dataset, performance_dataset_id, **kwargs):  # noqa: E501
        """update_performance_dataset  # noqa: E501

        Modify the name of the performance dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_performance_dataset_with_http_info(performance_dataset, performance_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PerformanceDataset performance_dataset: (required)
        :param str performance_dataset_id: Modify the name of the performance dataset. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['performance_dataset', 'performance_dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_performance_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'performance_dataset' is set
        if ('performance_dataset' not in params or
                params['performance_dataset'] is None):
            raise ValueError("Missing the required parameter `performance_dataset` when calling `update_performance_dataset`")  # noqa: E501
        # verify the required parameter 'performance_dataset_id' is set
        if ('performance_dataset_id' not in params or
                params['performance_dataset_id'] is None):
            raise ValueError("Missing the required parameter `performance_dataset_id` when calling `update_performance_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'performance_dataset_id' in params:
            path_params['PerformanceDatasetId'] = params['performance_dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'performance_dataset' in params:
            body_params = params['performance_dataset']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/datasets/{PerformanceDatasetId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_performance_settings(self, performance_settings, **kwargs):  # noqa: E501
        """update_performance_settings  # noqa: E501

        Configure performance settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_performance_settings(performance_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PerformanceSettingsExtended performance_settings: (required)
        :param bool force: Allow modification of settings outside of recommended limits
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_performance_settings_with_http_info(performance_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_performance_settings_with_http_info(performance_settings, **kwargs)  # noqa: E501
            return data

    def update_performance_settings_with_http_info(self, performance_settings, **kwargs):  # noqa: E501
        """update_performance_settings  # noqa: E501

        Configure performance settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_performance_settings_with_http_info(performance_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PerformanceSettingsExtended performance_settings: (required)
        :param bool force: Allow modification of settings outside of recommended limits
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['performance_settings', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_performance_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'performance_settings' is set
        if ('performance_settings' not in params or
                params['performance_settings'] is None):
            raise ValueError("Missing the required parameter `performance_settings` when calling `update_performance_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'performance_settings' in params:
            body_params = params['performance_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/performance/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
