# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 8
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_2_1.api_client import ApiClient


class AuthApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_auth_cache_item(self, auth_cache_item, **kwargs):  # noqa: E501
        """create_auth_cache_item  # noqa: E501

        Flush the Security Objects Cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_cache_item(auth_cache_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthCacheItem auth_cache_item: (required)
        :param str zone: Specifies access zone from which to flush objects.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_cache_item_with_http_info(auth_cache_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_cache_item_with_http_info(auth_cache_item, **kwargs)  # noqa: E501
            return data

    def create_auth_cache_item_with_http_info(self, auth_cache_item, **kwargs):  # noqa: E501
        """create_auth_cache_item  # noqa: E501

        Flush the Security Objects Cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_cache_item_with_http_info(auth_cache_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthCacheItem auth_cache_item: (required)
        :param str zone: Specifies access zone from which to flush objects.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_cache_item', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_cache_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_cache_item' is set
        if ('auth_cache_item' not in params or
                params['auth_cache_item'] is None):
            raise ValueError("Missing the required parameter `auth_cache_item` when calling `create_auth_cache_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_cache_item' in params:
            body_params = params['auth_cache_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/auth/cache', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_group(self, auth_group, **kwargs):  # noqa: E501
        """create_auth_group  # noqa: E501

        Create a new group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_group(auth_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthGroupCreateParams auth_group: (required)
        :param bool force: Skip validation checks when creating a group.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_group_with_http_info(auth_group, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_group_with_http_info(auth_group, **kwargs)  # noqa: E501
            return data

    def create_auth_group_with_http_info(self, auth_group, **kwargs):  # noqa: E501
        """create_auth_group  # noqa: E501

        Create a new group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_group_with_http_info(auth_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthGroupCreateParams auth_group: (required)
        :param bool force: Skip validation checks when creating a group.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_group', 'force', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_group' is set
        if ('auth_group' not in params or
                params['auth_group'] is None):
            raise ValueError("Missing the required parameter `auth_group` when calling `create_auth_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_group' in params:
            body_params = params['auth_group']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_refresh_item(self, auth_refresh_item, **kwargs):  # noqa: E501
        """create_auth_refresh_item  # noqa: E501

        Refresh the authentication service configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_refresh_item(auth_refresh_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty auth_refresh_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_refresh_item_with_http_info(auth_refresh_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_refresh_item_with_http_info(auth_refresh_item, **kwargs)  # noqa: E501
            return data

    def create_auth_refresh_item_with_http_info(self, auth_refresh_item, **kwargs):  # noqa: E501
        """create_auth_refresh_item  # noqa: E501

        Refresh the authentication service configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_refresh_item_with_http_info(auth_refresh_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty auth_refresh_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_refresh_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_refresh_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_refresh_item' is set
        if ('auth_refresh_item' not in params or
                params['auth_refresh_item'] is None):
            raise ValueError("Missing the required parameter `auth_refresh_item` when calling `create_auth_refresh_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_refresh_item' in params:
            body_params = params['auth_refresh_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/auth/refresh', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_role(self, auth_role, **kwargs):  # noqa: E501
        """create_auth_role  # noqa: E501

        Create a new role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_role(auth_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthRoleCreateParams auth_role: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_role_with_http_info(auth_role, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_role_with_http_info(auth_role, **kwargs)  # noqa: E501
            return data

    def create_auth_role_with_http_info(self, auth_role, **kwargs):  # noqa: E501
        """create_auth_role  # noqa: E501

        Create a new role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_role_with_http_info(auth_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthRoleCreateParams auth_role: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_role', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_role' is set
        if ('auth_role' not in params or
                params['auth_role'] is None):
            raise ValueError("Missing the required parameter `auth_role` when calling `create_auth_role`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `create_auth_role`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `create_auth_role`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_role' in params:
            body_params = params['auth_role']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_user(self, auth_user, **kwargs):  # noqa: E501
        """create_auth_user  # noqa: E501

        Create a new user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_user(auth_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthUserCreateParams auth_user: (required)
        :param bool force: Skip validation checks when creating user.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_user_with_http_info(auth_user, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_user_with_http_info(auth_user, **kwargs)  # noqa: E501
            return data

    def create_auth_user_with_http_info(self, auth_user, **kwargs):  # noqa: E501
        """create_auth_user  # noqa: E501

        Create a new user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_user_with_http_info(auth_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthUserCreateParams auth_user: (required)
        :param bool force: Skip validation checks when creating user.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_user', 'force', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_user' is set
        if ('auth_user' not in params or
                params['auth_user'] is None):
            raise ValueError("Missing the required parameter `auth_user` when calling `create_auth_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_user' in params:
            body_params = params['auth_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_mapping_identities(self, mapping_identities, **kwargs):  # noqa: E501
        """create_mapping_identities  # noqa: E501

        Manually set or modify a mapping between two personae.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_mapping_identities(mapping_identities, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MappingIdentitiesCreateParams mapping_identities: (required)
        :param bool _2way: Create a bi-directional mapping from source to target and target to source.
        :param str zone: Optional zone.
        :param bool replace: Replace existing mappings.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_mapping_identities_with_http_info(mapping_identities, **kwargs)  # noqa: E501
        else:
            (data) = self.create_mapping_identities_with_http_info(mapping_identities, **kwargs)  # noqa: E501
            return data

    def create_mapping_identities_with_http_info(self, mapping_identities, **kwargs):  # noqa: E501
        """create_mapping_identities  # noqa: E501

        Manually set or modify a mapping between two personae.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_mapping_identities_with_http_info(mapping_identities, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MappingIdentitiesCreateParams mapping_identities: (required)
        :param bool _2way: Create a bi-directional mapping from source to target and target to source.
        :param str zone: Optional zone.
        :param bool replace: Replace existing mappings.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mapping_identities', '_2way', 'zone', 'replace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_mapping_identities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mapping_identities' is set
        if ('mapping_identities' not in params or
                params['mapping_identities'] is None):
            raise ValueError("Missing the required parameter `mapping_identities` when calling `create_mapping_identities`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_2way' in params:
            query_params.append(('2way', params['_2way']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mapping_identities' in params:
            body_params = params['mapping_identities']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/identities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_mapping_identity(self, mapping_identity, mapping_identity_id, **kwargs):  # noqa: E501
        """create_mapping_identity  # noqa: E501

        Manually set or modify a mapping between two personae.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_mapping_identity(mapping_identity, mapping_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty mapping_identity: (required)
        :param str mapping_identity_id: Manually set or modify a mapping between two personae. (required)
        :param str type: Desired mapping target to fetch/generate.
        :param str zone: Optional zone.
        :return: MappingIdentities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_mapping_identity_with_http_info(mapping_identity, mapping_identity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_mapping_identity_with_http_info(mapping_identity, mapping_identity_id, **kwargs)  # noqa: E501
            return data

    def create_mapping_identity_with_http_info(self, mapping_identity, mapping_identity_id, **kwargs):  # noqa: E501
        """create_mapping_identity  # noqa: E501

        Manually set or modify a mapping between two personae.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_mapping_identity_with_http_info(mapping_identity, mapping_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty mapping_identity: (required)
        :param str mapping_identity_id: Manually set or modify a mapping between two personae. (required)
        :param str type: Desired mapping target to fetch/generate.
        :param str zone: Optional zone.
        :return: MappingIdentities
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mapping_identity', 'mapping_identity_id', 'type', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_mapping_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mapping_identity' is set
        if ('mapping_identity' not in params or
                params['mapping_identity'] is None):
            raise ValueError("Missing the required parameter `mapping_identity` when calling `create_mapping_identity`")  # noqa: E501
        # verify the required parameter 'mapping_identity_id' is set
        if ('mapping_identity_id' not in params or
                params['mapping_identity_id'] is None):
            raise ValueError("Missing the required parameter `mapping_identity_id` when calling `create_mapping_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mapping_identity_id' in params:
            path_params['MappingIdentityId'] = params['mapping_identity_id']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mapping_identity' in params:
            body_params = params['mapping_identity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/identities/{MappingIdentityId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MappingIdentities',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_providers_ads_item(self, providers_ads_item, **kwargs):  # noqa: E501
        """create_providers_ads_item  # noqa: E501

        Create a new ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_ads_item(providers_ads_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersAdsItem providers_ads_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_providers_ads_item_with_http_info(providers_ads_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_providers_ads_item_with_http_info(providers_ads_item, **kwargs)  # noqa: E501
            return data

    def create_providers_ads_item_with_http_info(self, providers_ads_item, **kwargs):  # noqa: E501
        """create_providers_ads_item  # noqa: E501

        Create a new ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_ads_item_with_http_info(providers_ads_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersAdsItem providers_ads_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ads_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_providers_ads_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ads_item' is set
        if ('providers_ads_item' not in params or
                params['providers_ads_item'] is None):
            raise ValueError("Missing the required parameter `providers_ads_item` when calling `create_providers_ads_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_ads_item' in params:
            body_params = params['providers_ads_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ads', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_providers_file_item(self, providers_file_item, **kwargs):  # noqa: E501
        """create_providers_file_item  # noqa: E501

        Create a new file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_file_item(providers_file_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersFileItem providers_file_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_providers_file_item_with_http_info(providers_file_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_providers_file_item_with_http_info(providers_file_item, **kwargs)  # noqa: E501
            return data

    def create_providers_file_item_with_http_info(self, providers_file_item, **kwargs):  # noqa: E501
        """create_providers_file_item  # noqa: E501

        Create a new file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_file_item_with_http_info(providers_file_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersFileItem providers_file_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_file_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_providers_file_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_file_item' is set
        if ('providers_file_item' not in params or
                params['providers_file_item'] is None):
            raise ValueError("Missing the required parameter `providers_file_item` when calling `create_providers_file_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_file_item' in params:
            body_params = params['providers_file_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_providers_krb5_item(self, providers_krb5_item, **kwargs):  # noqa: E501
        """create_providers_krb5_item  # noqa: E501

        Create a new KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_krb5_item(providers_krb5_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersKrb5Item providers_krb5_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_providers_krb5_item_with_http_info(providers_krb5_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_providers_krb5_item_with_http_info(providers_krb5_item, **kwargs)  # noqa: E501
            return data

    def create_providers_krb5_item_with_http_info(self, providers_krb5_item, **kwargs):  # noqa: E501
        """create_providers_krb5_item  # noqa: E501

        Create a new KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_krb5_item_with_http_info(providers_krb5_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersKrb5Item providers_krb5_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_krb5_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_providers_krb5_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_krb5_item' is set
        if ('providers_krb5_item' not in params or
                params['providers_krb5_item'] is None):
            raise ValueError("Missing the required parameter `providers_krb5_item` when calling `create_providers_krb5_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_krb5_item' in params:
            body_params = params['providers_krb5_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/krb5', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_providers_ldap_item(self, providers_ldap_item, **kwargs):  # noqa: E501
        """create_providers_ldap_item  # noqa: E501

        Create a new LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_ldap_item(providers_ldap_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersLdapItem providers_ldap_item: (required)
        :param bool force: Ignore unresolvable server URIs.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_providers_ldap_item_with_http_info(providers_ldap_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_providers_ldap_item_with_http_info(providers_ldap_item, **kwargs)  # noqa: E501
            return data

    def create_providers_ldap_item_with_http_info(self, providers_ldap_item, **kwargs):  # noqa: E501
        """create_providers_ldap_item  # noqa: E501

        Create a new LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_ldap_item_with_http_info(providers_ldap_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersLdapItem providers_ldap_item: (required)
        :param bool force: Ignore unresolvable server URIs.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ldap_item', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_providers_ldap_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ldap_item' is set
        if ('providers_ldap_item' not in params or
                params['providers_ldap_item'] is None):
            raise ValueError("Missing the required parameter `providers_ldap_item` when calling `create_providers_ldap_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_ldap_item' in params:
            body_params = params['providers_ldap_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ldap', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_providers_nis_item(self, providers_nis_item, **kwargs):  # noqa: E501
        """create_providers_nis_item  # noqa: E501

        Create a new NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_nis_item(providers_nis_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersNisItem providers_nis_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_providers_nis_item_with_http_info(providers_nis_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_providers_nis_item_with_http_info(providers_nis_item, **kwargs)  # noqa: E501
            return data

    def create_providers_nis_item_with_http_info(self, providers_nis_item, **kwargs):  # noqa: E501
        """create_providers_nis_item  # noqa: E501

        Create a new NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_providers_nis_item_with_http_info(providers_nis_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersNisItem providers_nis_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_nis_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_providers_nis_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_nis_item' is set
        if ('providers_nis_item' not in params or
                params['providers_nis_item'] is None):
            raise ValueError("Missing the required parameter `providers_nis_item` when calling `create_providers_nis_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_nis_item' in params:
            body_params = params['providers_nis_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/nis', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_krb5_domain(self, settings_krb5_domain, **kwargs):  # noqa: E501
        """create_settings_krb5_domain  # noqa: E501

        Create a new krb5 domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_krb5_domain(settings_krb5_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5DomainCreateParams settings_krb5_domain: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_settings_krb5_domain_with_http_info(settings_krb5_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_krb5_domain_with_http_info(settings_krb5_domain, **kwargs)  # noqa: E501
            return data

    def create_settings_krb5_domain_with_http_info(self, settings_krb5_domain, **kwargs):  # noqa: E501
        """create_settings_krb5_domain  # noqa: E501

        Create a new krb5 domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_krb5_domain_with_http_info(settings_krb5_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5DomainCreateParams settings_krb5_domain: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_krb5_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_domain' is set
        if ('settings_krb5_domain' not in params or
                params['settings_krb5_domain'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_domain` when calling `create_settings_krb5_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_krb5_domain' in params:
            body_params = params['settings_krb5_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/domains', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_krb5_realm(self, settings_krb5_realm, **kwargs):  # noqa: E501
        """create_settings_krb5_realm  # noqa: E501

        Create a new krb5 realm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_krb5_realm(settings_krb5_realm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5RealmCreateParams settings_krb5_realm: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_settings_krb5_realm_with_http_info(settings_krb5_realm, **kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_krb5_realm_with_http_info(settings_krb5_realm, **kwargs)  # noqa: E501
            return data

    def create_settings_krb5_realm_with_http_info(self, settings_krb5_realm, **kwargs):  # noqa: E501
        """create_settings_krb5_realm  # noqa: E501

        Create a new krb5 realm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_krb5_realm_with_http_info(settings_krb5_realm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5RealmCreateParams settings_krb5_realm: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_realm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_krb5_realm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_realm' is set
        if ('settings_krb5_realm' not in params or
                params['settings_krb5_realm'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_realm` when calling `create_settings_krb5_realm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_krb5_realm' in params:
            body_params = params['settings_krb5_realm']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/realms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_auth_group(self, auth_group_id, **kwargs):  # noqa: E501
        """delete_auth_group  # noqa: E501

        Delete the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_group(auth_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_group_id: Delete the group. (required)
        :param bool cached: If true, flush the group from the cache.
        :param str zone: Filter groups by zone.
        :param str provider: Filter groups by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_auth_group_with_http_info(auth_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_auth_group_with_http_info(auth_group_id, **kwargs)  # noqa: E501
            return data

    def delete_auth_group_with_http_info(self, auth_group_id, **kwargs):  # noqa: E501
        """delete_auth_group  # noqa: E501

        Delete the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_group_with_http_info(auth_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_group_id: Delete the group. (required)
        :param bool cached: If true, flush the group from the cache.
        :param str zone: Filter groups by zone.
        :param str provider: Filter groups by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_group_id', 'cached', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_auth_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_group_id' is set
        if ('auth_group_id' not in params or
                params['auth_group_id'] is None):
            raise ValueError("Missing the required parameter `auth_group_id` when calling `delete_auth_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_group_id' in params:
            path_params['AuthGroupId'] = params['auth_group_id']  # noqa: E501

        query_params = []
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/groups/{AuthGroupId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_auth_groups(self, **kwargs):  # noqa: E501
        """delete_auth_groups  # noqa: E501

        Flush the groups cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool cached: If true, only flush cached objects.
        :param str zone: Filter groups by zone.
        :param str provider: Filter groups by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_auth_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_auth_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_auth_groups_with_http_info(self, **kwargs):  # noqa: E501
        """delete_auth_groups  # noqa: E501

        Flush the groups cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool cached: If true, only flush cached objects.
        :param str zone: Filter groups by zone.
        :param str provider: Filter groups by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cached', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_auth_groups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/groups', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_auth_role(self, auth_role_id, **kwargs):  # noqa: E501
        """delete_auth_role  # noqa: E501

        Delete the role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_role(auth_role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_role_id: Delete the role. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_auth_role_with_http_info(auth_role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_auth_role_with_http_info(auth_role_id, **kwargs)  # noqa: E501
            return data

    def delete_auth_role_with_http_info(self, auth_role_id, **kwargs):  # noqa: E501
        """delete_auth_role  # noqa: E501

        Delete the role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_role_with_http_info(auth_role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_role_id: Delete the role. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_role_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_auth_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_role_id' is set
        if ('auth_role_id' not in params or
                params['auth_role_id'] is None):
            raise ValueError("Missing the required parameter `auth_role_id` when calling `delete_auth_role`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `delete_auth_role`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `delete_auth_role`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'auth_role_id' in params:
            path_params['AuthRoleId'] = params['auth_role_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/roles/{AuthRoleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_auth_user(self, auth_user_id, **kwargs):  # noqa: E501
        """delete_auth_user  # noqa: E501

        Delete the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_user(auth_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_user_id: Delete the user. (required)
        :param bool cached: If true, flush the user from the cache.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_auth_user_with_http_info(auth_user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_auth_user_with_http_info(auth_user_id, **kwargs)  # noqa: E501
            return data

    def delete_auth_user_with_http_info(self, auth_user_id, **kwargs):  # noqa: E501
        """delete_auth_user  # noqa: E501

        Delete the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_user_with_http_info(auth_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_user_id: Delete the user. (required)
        :param bool cached: If true, flush the user from the cache.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_user_id', 'cached', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_auth_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_user_id' is set
        if ('auth_user_id' not in params or
                params['auth_user_id'] is None):
            raise ValueError("Missing the required parameter `auth_user_id` when calling `delete_auth_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_user_id' in params:
            path_params['AuthUserId'] = params['auth_user_id']  # noqa: E501

        query_params = []
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/users/{AuthUserId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_auth_users(self, **kwargs):  # noqa: E501
        """delete_auth_users  # noqa: E501

        Flush the users cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool cached: If true, only flush cached objects.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_auth_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_auth_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_auth_users_with_http_info(self, **kwargs):  # noqa: E501
        """delete_auth_users  # noqa: E501

        Flush the users cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool cached: If true, only flush cached objects.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cached', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_auth_users" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/users', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_mapping_identities(self, **kwargs):  # noqa: E501
        """delete_mapping_identities  # noqa: E501

        Flush the entire idmap cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mapping_identities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter to apply when deleting identity mappings.
        :param str zone: Optional zone.
        :param bool remove: Delete mapping instead of flush mapping cache.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_mapping_identities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_mapping_identities_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_mapping_identities_with_http_info(self, **kwargs):  # noqa: E501
        """delete_mapping_identities  # noqa: E501

        Flush the entire idmap cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mapping_identities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter to apply when deleting identity mappings.
        :param str zone: Optional zone.
        :param bool remove: Delete mapping instead of flush mapping cache.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'zone', 'remove']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mapping_identities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'remove' in params:
            query_params.append(('remove', params['remove']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/identities', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_mapping_identity(self, mapping_identity_id, **kwargs):  # noqa: E501
        """delete_mapping_identity  # noqa: E501

        Flush the entire idmap cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mapping_identity(mapping_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str mapping_identity_id: Flush the entire idmap cache. (required)
        :param str zone: Optional zone.
        :param bool _2way: Delete the bi-directional mapping from source to target and target to source.
        :param str target: Target identity persona.
        :param bool remove: Delete mapping instead of flush mapping from cache.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_mapping_identity_with_http_info(mapping_identity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_mapping_identity_with_http_info(mapping_identity_id, **kwargs)  # noqa: E501
            return data

    def delete_mapping_identity_with_http_info(self, mapping_identity_id, **kwargs):  # noqa: E501
        """delete_mapping_identity  # noqa: E501

        Flush the entire idmap cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mapping_identity_with_http_info(mapping_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str mapping_identity_id: Flush the entire idmap cache. (required)
        :param str zone: Optional zone.
        :param bool _2way: Delete the bi-directional mapping from source to target and target to source.
        :param str target: Target identity persona.
        :param bool remove: Delete mapping instead of flush mapping from cache.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mapping_identity_id', 'zone', '_2way', 'target', 'remove']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mapping_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mapping_identity_id' is set
        if ('mapping_identity_id' not in params or
                params['mapping_identity_id'] is None):
            raise ValueError("Missing the required parameter `mapping_identity_id` when calling `delete_mapping_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mapping_identity_id' in params:
            path_params['MappingIdentityId'] = params['mapping_identity_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if '_2way' in params:
            query_params.append(('2way', params['_2way']))  # noqa: E501
        if 'target' in params:
            query_params.append(('target', params['target']))  # noqa: E501
        if 'remove' in params:
            query_params.append(('remove', params['remove']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/identities/{MappingIdentityId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_providers_ads_by_id(self, providers_ads_id, **kwargs):  # noqa: E501
        """delete_providers_ads_by_id  # noqa: E501

        Delete the ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_ads_by_id(providers_ads_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ads_id: Delete the ADS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_providers_ads_by_id_with_http_info(providers_ads_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_providers_ads_by_id_with_http_info(providers_ads_id, **kwargs)  # noqa: E501
            return data

    def delete_providers_ads_by_id_with_http_info(self, providers_ads_id, **kwargs):  # noqa: E501
        """delete_providers_ads_by_id  # noqa: E501

        Delete the ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_ads_by_id_with_http_info(providers_ads_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ads_id: Delete the ADS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ads_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_providers_ads_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ads_id' is set
        if ('providers_ads_id' not in params or
                params['providers_ads_id'] is None):
            raise ValueError("Missing the required parameter `providers_ads_id` when calling `delete_providers_ads_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_ads_id' in params:
            path_params['ProvidersAdsId'] = params['providers_ads_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ads/{ProvidersAdsId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_providers_file_by_id(self, providers_file_id, **kwargs):  # noqa: E501
        """delete_providers_file_by_id  # noqa: E501

        Delete the file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_file_by_id(providers_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_file_id: Delete the file provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_providers_file_by_id_with_http_info(providers_file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_providers_file_by_id_with_http_info(providers_file_id, **kwargs)  # noqa: E501
            return data

    def delete_providers_file_by_id_with_http_info(self, providers_file_id, **kwargs):  # noqa: E501
        """delete_providers_file_by_id  # noqa: E501

        Delete the file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_file_by_id_with_http_info(providers_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_file_id: Delete the file provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_providers_file_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_file_id' is set
        if ('providers_file_id' not in params or
                params['providers_file_id'] is None):
            raise ValueError("Missing the required parameter `providers_file_id` when calling `delete_providers_file_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_file_id' in params:
            path_params['ProvidersFileId'] = params['providers_file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/file/{ProvidersFileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_providers_krb5_by_id(self, providers_krb5_id, **kwargs):  # noqa: E501
        """delete_providers_krb5_by_id  # noqa: E501

        Delete the KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_krb5_by_id(providers_krb5_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_krb5_id: Delete the KRB5 provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_providers_krb5_by_id_with_http_info(providers_krb5_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_providers_krb5_by_id_with_http_info(providers_krb5_id, **kwargs)  # noqa: E501
            return data

    def delete_providers_krb5_by_id_with_http_info(self, providers_krb5_id, **kwargs):  # noqa: E501
        """delete_providers_krb5_by_id  # noqa: E501

        Delete the KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_krb5_by_id_with_http_info(providers_krb5_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_krb5_id: Delete the KRB5 provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_krb5_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_providers_krb5_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_krb5_id' is set
        if ('providers_krb5_id' not in params or
                params['providers_krb5_id'] is None):
            raise ValueError("Missing the required parameter `providers_krb5_id` when calling `delete_providers_krb5_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_krb5_id' in params:
            path_params['ProvidersKrb5Id'] = params['providers_krb5_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/krb5/{ProvidersKrb5Id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_providers_ldap_by_id(self, providers_ldap_id, **kwargs):  # noqa: E501
        """delete_providers_ldap_by_id  # noqa: E501

        Delete the LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_ldap_by_id(providers_ldap_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ldap_id: Delete the LDAP provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_providers_ldap_by_id_with_http_info(providers_ldap_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_providers_ldap_by_id_with_http_info(providers_ldap_id, **kwargs)  # noqa: E501
            return data

    def delete_providers_ldap_by_id_with_http_info(self, providers_ldap_id, **kwargs):  # noqa: E501
        """delete_providers_ldap_by_id  # noqa: E501

        Delete the LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_ldap_by_id_with_http_info(providers_ldap_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ldap_id: Delete the LDAP provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ldap_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_providers_ldap_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ldap_id' is set
        if ('providers_ldap_id' not in params or
                params['providers_ldap_id'] is None):
            raise ValueError("Missing the required parameter `providers_ldap_id` when calling `delete_providers_ldap_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_ldap_id' in params:
            path_params['ProvidersLdapId'] = params['providers_ldap_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ldap/{ProvidersLdapId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_providers_local_by_id(self, providers_local_id, **kwargs):  # noqa: E501
        """delete_providers_local_by_id  # noqa: E501

        Delete the local provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_local_by_id(providers_local_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_local_id: Delete the local provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_providers_local_by_id_with_http_info(providers_local_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_providers_local_by_id_with_http_info(providers_local_id, **kwargs)  # noqa: E501
            return data

    def delete_providers_local_by_id_with_http_info(self, providers_local_id, **kwargs):  # noqa: E501
        """delete_providers_local_by_id  # noqa: E501

        Delete the local provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_local_by_id_with_http_info(providers_local_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_local_id: Delete the local provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_local_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_providers_local_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_local_id' is set
        if ('providers_local_id' not in params or
                params['providers_local_id'] is None):
            raise ValueError("Missing the required parameter `providers_local_id` when calling `delete_providers_local_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_local_id' in params:
            path_params['ProvidersLocalId'] = params['providers_local_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/local/{ProvidersLocalId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_providers_nis_by_id(self, providers_nis_id, **kwargs):  # noqa: E501
        """delete_providers_nis_by_id  # noqa: E501

        Delete the NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_nis_by_id(providers_nis_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_nis_id: Delete the NIS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_providers_nis_by_id_with_http_info(providers_nis_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_providers_nis_by_id_with_http_info(providers_nis_id, **kwargs)  # noqa: E501
            return data

    def delete_providers_nis_by_id_with_http_info(self, providers_nis_id, **kwargs):  # noqa: E501
        """delete_providers_nis_by_id  # noqa: E501

        Delete the NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_providers_nis_by_id_with_http_info(providers_nis_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_nis_id: Delete the NIS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_nis_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_providers_nis_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_nis_id' is set
        if ('providers_nis_id' not in params or
                params['providers_nis_id'] is None):
            raise ValueError("Missing the required parameter `providers_nis_id` when calling `delete_providers_nis_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_nis_id' in params:
            path_params['ProvidersNisId'] = params['providers_nis_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/nis/{ProvidersNisId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_krb5_domain(self, settings_krb5_domain_id, **kwargs):  # noqa: E501
        """delete_settings_krb5_domain  # noqa: E501

        Remove a krb5 domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_krb5_domain(settings_krb5_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_domain_id: Remove a krb5 domain. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_settings_krb5_domain_with_http_info(settings_krb5_domain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_krb5_domain_with_http_info(settings_krb5_domain_id, **kwargs)  # noqa: E501
            return data

    def delete_settings_krb5_domain_with_http_info(self, settings_krb5_domain_id, **kwargs):  # noqa: E501
        """delete_settings_krb5_domain  # noqa: E501

        Remove a krb5 domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_krb5_domain_with_http_info(settings_krb5_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_domain_id: Remove a krb5 domain. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_domain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_krb5_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_domain_id' is set
        if ('settings_krb5_domain_id' not in params or
                params['settings_krb5_domain_id'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_domain_id` when calling `delete_settings_krb5_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_krb5_domain_id' in params:
            path_params['SettingsKrb5DomainId'] = params['settings_krb5_domain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/domains/{SettingsKrb5DomainId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_krb5_realm(self, settings_krb5_realm_id, **kwargs):  # noqa: E501
        """delete_settings_krb5_realm  # noqa: E501

        Remove a realm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_krb5_realm(settings_krb5_realm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_realm_id: Remove a realm. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_settings_krb5_realm_with_http_info(settings_krb5_realm_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_krb5_realm_with_http_info(settings_krb5_realm_id, **kwargs)  # noqa: E501
            return data

    def delete_settings_krb5_realm_with_http_info(self, settings_krb5_realm_id, **kwargs):  # noqa: E501
        """delete_settings_krb5_realm  # noqa: E501

        Remove a realm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_krb5_realm_with_http_info(settings_krb5_realm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_realm_id: Remove a realm. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_realm_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_krb5_realm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_realm_id' is set
        if ('settings_krb5_realm_id' not in params or
                params['settings_krb5_realm_id'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_realm_id` when calling `delete_settings_krb5_realm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_krb5_realm_id' in params:
            path_params['SettingsKrb5RealmId'] = params['settings_krb5_realm_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/realms/{SettingsKrb5RealmId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_access_user(self, auth_access_user, **kwargs):  # noqa: E501
        """get_auth_access_user  # noqa: E501

        Determine user's access rights to a file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_access_user(auth_access_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_access_user: Determine user's access rights to a file (required)
        :param str path: Path to the file. Must be within /ifs.
        :param str share: SMB share name
        :param str zone: Access zone the user is in.
        :param bool numeric: Show the user's numeric identifier.
        :return: AuthAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_access_user_with_http_info(auth_access_user, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_access_user_with_http_info(auth_access_user, **kwargs)  # noqa: E501
            return data

    def get_auth_access_user_with_http_info(self, auth_access_user, **kwargs):  # noqa: E501
        """get_auth_access_user  # noqa: E501

        Determine user's access rights to a file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_access_user_with_http_info(auth_access_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_access_user: Determine user's access rights to a file (required)
        :param str path: Path to the file. Must be within /ifs.
        :param str share: SMB share name
        :param str zone: Access zone the user is in.
        :param bool numeric: Show the user's numeric identifier.
        :return: AuthAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_access_user', 'path', 'share', 'zone', 'numeric']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_access_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_access_user' is set
        if ('auth_access_user' not in params or
                params['auth_access_user'] is None):
            raise ValueError("Missing the required parameter `auth_access_user` when calling `get_auth_access_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_access_user' in params:
            path_params['AuthAccessUser'] = params['auth_access_user']  # noqa: E501

        query_params = []
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'share' in params:
            query_params.append(('share', params['share']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'numeric' in params:
            query_params.append(('numeric', params['numeric']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/access/{AuthAccessUser}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthAccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_error_error(self, auth_error_error, **kwargs):  # noqa: E501
        """get_auth_error_error  # noqa: E501

        Get descriptions for auth error codes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_error_error(auth_error_error, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_error_error: Get descriptions for auth error codes (required)
        :return: AuthError
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_error_error_with_http_info(auth_error_error, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_error_error_with_http_info(auth_error_error, **kwargs)  # noqa: E501
            return data

    def get_auth_error_error_with_http_info(self, auth_error_error, **kwargs):  # noqa: E501
        """get_auth_error_error  # noqa: E501

        Get descriptions for auth error codes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_error_error_with_http_info(auth_error_error, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_error_error: Get descriptions for auth error codes (required)
        :return: AuthError
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_error_error']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_error_error" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_error_error' is set
        if ('auth_error_error' not in params or
                params['auth_error_error'] is None):
            raise ValueError("Missing the required parameter `auth_error_error` when calling `get_auth_error_error`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_error_error' in params:
            path_params['AuthErrorError'] = params['auth_error_error']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/error/{AuthErrorError}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthError',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_group(self, auth_group_id, **kwargs):  # noqa: E501
        """get_auth_group  # noqa: E501

        Retrieve the group information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_group(auth_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_group_id: Retrieve the group information. (required)
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param bool query_member_of: Enumerate all groups that a group is a member of.
        :param str zone: Filter groups by zone.
        :param str provider: Filter groups by provider.
        :return: AuthGroups
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_group_with_http_info(auth_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_group_with_http_info(auth_group_id, **kwargs)  # noqa: E501
            return data

    def get_auth_group_with_http_info(self, auth_group_id, **kwargs):  # noqa: E501
        """get_auth_group  # noqa: E501

        Retrieve the group information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_group_with_http_info(auth_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_group_id: Retrieve the group information. (required)
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param bool query_member_of: Enumerate all groups that a group is a member of.
        :param str zone: Filter groups by zone.
        :param str provider: Filter groups by provider.
        :return: AuthGroups
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_group_id', 'cached', 'resolve_names', 'query_member_of', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_group_id' is set
        if ('auth_group_id' not in params or
                params['auth_group_id'] is None):
            raise ValueError("Missing the required parameter `auth_group_id` when calling `get_auth_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_group_id' in params:
            path_params['AuthGroupId'] = params['auth_group_id']  # noqa: E501

        query_params = []
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'query_member_of' in params:
            query_params.append(('query_member_of', params['query_member_of']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/groups/{AuthGroupId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthGroups',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_id(self, **kwargs):  # noqa: E501
        """get_auth_id  # noqa: E501

        Retrieve the current security token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthId
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_id_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_id_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_id_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_id  # noqa: E501

        Retrieve the current security token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthId
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_id" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/id', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthId',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_ldap_template(self, auth_ldap_template_id, **kwargs):  # noqa: E501
        """get_auth_ldap_template  # noqa: E501

        Retrieve the LDAP provider template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_ldap_template(auth_ldap_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_ldap_template_id: Retrieve the LDAP provider template. (required)
        :return: AuthLdapTemplates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_ldap_template_with_http_info(auth_ldap_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_ldap_template_with_http_info(auth_ldap_template_id, **kwargs)  # noqa: E501
            return data

    def get_auth_ldap_template_with_http_info(self, auth_ldap_template_id, **kwargs):  # noqa: E501
        """get_auth_ldap_template  # noqa: E501

        Retrieve the LDAP provider template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_ldap_template_with_http_info(auth_ldap_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_ldap_template_id: Retrieve the LDAP provider template. (required)
        :return: AuthLdapTemplates
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_ldap_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_ldap_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_ldap_template_id' is set
        if ('auth_ldap_template_id' not in params or
                params['auth_ldap_template_id'] is None):
            raise ValueError("Missing the required parameter `auth_ldap_template_id` when calling `get_auth_ldap_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_ldap_template_id' in params:
            path_params['AuthLdapTemplateId'] = params['auth_ldap_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/ldap-templates/{AuthLdapTemplateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthLdapTemplates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_ldap_templates(self, **kwargs):  # noqa: E501
        """get_auth_ldap_templates  # noqa: E501

        List all LDAP provider templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_ldap_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthLdapTemplatesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_ldap_templates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_ldap_templates_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_ldap_templates_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_ldap_templates  # noqa: E501

        List all LDAP provider templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_ldap_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthLdapTemplatesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_ldap_templates" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/ldap-templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthLdapTemplatesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_log_level(self, **kwargs):  # noqa: E501
        """get_auth_log_level  # noqa: E501

        Get the current authentications service and netlogon logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_log_level(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_log_level_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_log_level_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_log_level_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_log_level  # noqa: E501

        Get the current authentications service and netlogon logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_log_level_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_log_level" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/auth/log-level', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthLogLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_netgroup(self, auth_netgroup_id, **kwargs):  # noqa: E501
        """get_auth_netgroup  # noqa: E501

        Retrieve the user information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_netgroup(auth_netgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_netgroup_id: Retrieve the user information. (required)
        :param bool ignore_errors: Ignore netgroup errors.
        :param bool recursive: Perform recursive search.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: AuthNetgroups
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_netgroup_with_http_info(auth_netgroup_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_netgroup_with_http_info(auth_netgroup_id, **kwargs)  # noqa: E501
            return data

    def get_auth_netgroup_with_http_info(self, auth_netgroup_id, **kwargs):  # noqa: E501
        """get_auth_netgroup  # noqa: E501

        Retrieve the user information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_netgroup_with_http_info(auth_netgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_netgroup_id: Retrieve the user information. (required)
        :param bool ignore_errors: Ignore netgroup errors.
        :param bool recursive: Perform recursive search.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: AuthNetgroups
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_netgroup_id', 'ignore_errors', 'recursive', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_netgroup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_netgroup_id' is set
        if ('auth_netgroup_id' not in params or
                params['auth_netgroup_id'] is None):
            raise ValueError("Missing the required parameter `auth_netgroup_id` when calling `get_auth_netgroup`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_netgroup_id' in params:
            path_params['AuthNetgroupId'] = params['auth_netgroup_id']  # noqa: E501

        query_params = []
        if 'ignore_errors' in params:
            query_params.append(('ignore_errors', params['ignore_errors']))  # noqa: E501
        if 'recursive' in params:
            query_params.append(('recursive', params['recursive']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/netgroups/{AuthNetgroupId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthNetgroups',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_privileges(self, **kwargs):  # noqa: E501
        """get_auth_privileges  # noqa: E501

        List all privileges.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_privileges(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Specifies which access zone to use.
        :return: AuthPrivileges
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_privileges_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_privileges_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_privileges_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_privileges  # noqa: E501

        List all privileges.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_privileges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Specifies which access zone to use.
        :return: AuthPrivileges
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_privileges" % key
                )
            params[key] = val
        del params['kwargs']

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_auth_privileges`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_auth_privileges`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/privileges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthPrivileges',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_role(self, auth_role_id, **kwargs):  # noqa: E501
        """get_auth_role  # noqa: E501

        Retrieve the role information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_role(auth_role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_role_id: Retrieve the role information. (required)
        :param bool resolve_names: Resolve names of personas.
        :param str zone: Specifies which access zone to use.
        :return: AuthRoles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_role_with_http_info(auth_role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_role_with_http_info(auth_role_id, **kwargs)  # noqa: E501
            return data

    def get_auth_role_with_http_info(self, auth_role_id, **kwargs):  # noqa: E501
        """get_auth_role  # noqa: E501

        Retrieve the role information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_role_with_http_info(auth_role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_role_id: Retrieve the role information. (required)
        :param bool resolve_names: Resolve names of personas.
        :param str zone: Specifies which access zone to use.
        :return: AuthRoles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_role_id', 'resolve_names', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_role_id' is set
        if ('auth_role_id' not in params or
                params['auth_role_id'] is None):
            raise ValueError("Missing the required parameter `auth_role_id` when calling `get_auth_role`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_auth_role`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_auth_role`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'auth_role_id' in params:
            path_params['AuthRoleId'] = params['auth_role_id']  # noqa: E501

        query_params = []
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/roles/{AuthRoleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthRoles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_shells(self, **kwargs):  # noqa: E501
        """get_auth_shells  # noqa: E501

        List all shells.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_shells(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthShells
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_shells_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_shells_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_shells_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_shells  # noqa: E501

        List all shells.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_shells_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthShells
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_shells" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/shells', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthShells',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_user(self, auth_user_id, **kwargs):  # noqa: E501
        """get_auth_user  # noqa: E501

        Retrieve the user information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_user(auth_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_user_id: Retrieve the user information. (required)
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param bool query_member_of: Enumerate all users that a group is a member of.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: AuthUsers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_user_with_http_info(auth_user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_user_with_http_info(auth_user_id, **kwargs)  # noqa: E501
            return data

    def get_auth_user_with_http_info(self, auth_user_id, **kwargs):  # noqa: E501
        """get_auth_user  # noqa: E501

        Retrieve the user information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_user_with_http_info(auth_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_user_id: Retrieve the user information. (required)
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param bool query_member_of: Enumerate all users that a group is a member of.
        :param str zone: Filter users by zone.
        :param str provider: Filter users by provider.
        :return: AuthUsers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_user_id', 'cached', 'resolve_names', 'query_member_of', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_user_id' is set
        if ('auth_user_id' not in params or
                params['auth_user_id'] is None):
            raise ValueError("Missing the required parameter `auth_user_id` when calling `get_auth_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_user_id' in params:
            path_params['AuthUserId'] = params['auth_user_id']  # noqa: E501

        query_params = []
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'query_member_of' in params:
            query_params.append(('query_member_of', params['query_member_of']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/users/{AuthUserId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthUsers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_wellknown(self, auth_wellknown_id, **kwargs):  # noqa: E501
        """get_auth_wellknown  # noqa: E501

        Retrieve the wellknown persona.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_wellknown(auth_wellknown_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_wellknown_id: Retrieve the wellknown persona. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: AuthWellknowns
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_wellknown_with_http_info(auth_wellknown_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_wellknown_with_http_info(auth_wellknown_id, **kwargs)  # noqa: E501
            return data

    def get_auth_wellknown_with_http_info(self, auth_wellknown_id, **kwargs):  # noqa: E501
        """get_auth_wellknown  # noqa: E501

        Retrieve the wellknown persona.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_wellknown_with_http_info(auth_wellknown_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_wellknown_id: Retrieve the wellknown persona. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: AuthWellknowns
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_wellknown_id', 'scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_wellknown" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_wellknown_id' is set
        if ('auth_wellknown_id' not in params or
                params['auth_wellknown_id'] is None):
            raise ValueError("Missing the required parameter `auth_wellknown_id` when calling `get_auth_wellknown`")  # noqa: E501

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_auth_wellknown`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_auth_wellknown`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'auth_wellknown_id' in params:
            path_params['AuthWellknownId'] = params['auth_wellknown_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/wellknowns/{AuthWellknownId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthWellknowns',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_wellknowns(self, **kwargs):  # noqa: E501
        """get_auth_wellknowns  # noqa: E501

        List all wellknown personas.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_wellknowns(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthWellknowns
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_wellknowns_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_wellknowns_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_wellknowns_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_wellknowns  # noqa: E501

        List all wellknown personas.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_wellknowns_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthWellknowns
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_wellknowns" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/wellknowns', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthWellknowns',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapping_dump(self, **kwargs):  # noqa: E501
        """get_mapping_dump  # noqa: E501

        Retrieve all identity mappings (uid, gid, sid, and on-disk) for the supplied source persona.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_dump(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool nocreate: Idmap should attempt to create missing identity mappings.
        :param str zone: Optional zone.
        :return: MappingDump
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mapping_dump_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mapping_dump_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mapping_dump_with_http_info(self, **kwargs):  # noqa: E501
        """get_mapping_dump  # noqa: E501

        Retrieve all identity mappings (uid, gid, sid, and on-disk) for the supplied source persona.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_dump_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool nocreate: Idmap should attempt to create missing identity mappings.
        :param str zone: Optional zone.
        :return: MappingDump
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nocreate', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapping_dump" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'nocreate' in params:
            query_params.append(('nocreate', params['nocreate']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/auth/mapping/dump', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MappingDump',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapping_identity(self, mapping_identity_id, **kwargs):  # noqa: E501
        """get_mapping_identity  # noqa: E501

        Retrieve all identity mappings (uid, gid, sid, and on-disk) for the supplied source persona.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_identity(mapping_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str mapping_identity_id: Retrieve all identity mappings (uid, gid, sid, and on-disk) for the supplied source persona. (required)
        :param bool nocreate: Idmap should attempt to create missing identity mappings.
        :param str zone: Optional zone.
        :return: MappingIdentities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mapping_identity_with_http_info(mapping_identity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mapping_identity_with_http_info(mapping_identity_id, **kwargs)  # noqa: E501
            return data

    def get_mapping_identity_with_http_info(self, mapping_identity_id, **kwargs):  # noqa: E501
        """get_mapping_identity  # noqa: E501

        Retrieve all identity mappings (uid, gid, sid, and on-disk) for the supplied source persona.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_identity_with_http_info(mapping_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str mapping_identity_id: Retrieve all identity mappings (uid, gid, sid, and on-disk) for the supplied source persona. (required)
        :param bool nocreate: Idmap should attempt to create missing identity mappings.
        :param str zone: Optional zone.
        :return: MappingIdentities
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mapping_identity_id', 'nocreate', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapping_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mapping_identity_id' is set
        if ('mapping_identity_id' not in params or
                params['mapping_identity_id'] is None):
            raise ValueError("Missing the required parameter `mapping_identity_id` when calling `get_mapping_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mapping_identity_id' in params:
            path_params['MappingIdentityId'] = params['mapping_identity_id']  # noqa: E501

        query_params = []
        if 'nocreate' in params:
            query_params.append(('nocreate', params['nocreate']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/identities/{MappingIdentityId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MappingIdentities',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapping_users_lookup(self, **kwargs):  # noqa: E501
        """get_mapping_users_lookup  # noqa: E501

        Retrieve the user information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_users_lookup(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int primary_gid: The user's primary group ID.
        :param int uid: The user ID.
        :param str zone: The zone the user belongs to.
        :param list[int] gid: The IDs of the groups that the user belongs to.
        :param str user: The user name.
        :param str kerberos_principal: The Kerberos principal name, of the form user@realm.
        :return: MappingUsersLookup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mapping_users_lookup_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mapping_users_lookup_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mapping_users_lookup_with_http_info(self, **kwargs):  # noqa: E501
        """get_mapping_users_lookup  # noqa: E501

        Retrieve the user information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_users_lookup_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int primary_gid: The user's primary group ID.
        :param int uid: The user ID.
        :param str zone: The zone the user belongs to.
        :param list[int] gid: The IDs of the groups that the user belongs to.
        :param str user: The user name.
        :param str kerberos_principal: The Kerberos principal name, of the form user@realm.
        :return: MappingUsersLookup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['primary_gid', 'uid', 'zone', 'gid', 'user', 'kerberos_principal']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapping_users_lookup" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'primary_gid' in params:
            query_params.append(('primary_gid', params['primary_gid']))  # noqa: E501
        if 'uid' in params:
            query_params.append(('uid', params['uid']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'gid' in params:
            query_params.append(('gid', params['gid']))  # noqa: E501
            collection_formats['gid'] = 'csv'  # noqa: E501
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
        if 'kerberos_principal' in params:
            query_params.append(('kerberos_principal', params['kerberos_principal']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/users/lookup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MappingUsersLookup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapping_users_rules(self, **kwargs):  # noqa: E501
        """get_mapping_users_rules  # noqa: E501

        Retrieve the user mapping rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_users_rules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: The zone to which the user mapping applies.
        :return: MappingUsersRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mapping_users_rules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mapping_users_rules_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mapping_users_rules_with_http_info(self, **kwargs):  # noqa: E501
        """get_mapping_users_rules  # noqa: E501

        Retrieve the user mapping rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapping_users_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: The zone to which the user mapping applies.
        :return: MappingUsersRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapping_users_rules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/users/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MappingUsersRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_ads_by_id(self, providers_ads_id, **kwargs):  # noqa: E501
        """get_providers_ads_by_id  # noqa: E501

        Retrieve the ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_ads_by_id(providers_ads_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ads_id: Retrieve the ADS provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersAds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_ads_by_id_with_http_info(providers_ads_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_ads_by_id_with_http_info(providers_ads_id, **kwargs)  # noqa: E501
            return data

    def get_providers_ads_by_id_with_http_info(self, providers_ads_id, **kwargs):  # noqa: E501
        """get_providers_ads_by_id  # noqa: E501

        Retrieve the ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_ads_by_id_with_http_info(providers_ads_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ads_id: Retrieve the ADS provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersAds
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ads_id', 'scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_ads_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ads_id' is set
        if ('providers_ads_id' not in params or
                params['providers_ads_id'] is None):
            raise ValueError("Missing the required parameter `providers_ads_id` when calling `get_providers_ads_by_id`")  # noqa: E501

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_ads_by_id`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_ads_by_id`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'providers_ads_id' in params:
            path_params['ProvidersAdsId'] = params['providers_ads_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ads/{ProvidersAdsId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersAds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_duo(self, **kwargs):  # noqa: E501
        """get_providers_duo  # noqa: E501

        Retrieve Duo provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_duo(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ProvidersDuo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_duo_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_duo_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_providers_duo_with_http_info(self, **kwargs):  # noqa: E501
        """get_providers_duo  # noqa: E501

        Retrieve Duo provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_duo_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ProvidersDuo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_duo" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/duo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersDuo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_file_by_id(self, providers_file_id, **kwargs):  # noqa: E501
        """get_providers_file_by_id  # noqa: E501

        Retrieve the file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_file_by_id(providers_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_file_id: Retrieve the file provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_file_by_id_with_http_info(providers_file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_file_by_id_with_http_info(providers_file_id, **kwargs)  # noqa: E501
            return data

    def get_providers_file_by_id_with_http_info(self, providers_file_id, **kwargs):  # noqa: E501
        """get_providers_file_by_id  # noqa: E501

        Retrieve the file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_file_by_id_with_http_info(providers_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_file_id: Retrieve the file provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_file_id', 'scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_file_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_file_id' is set
        if ('providers_file_id' not in params or
                params['providers_file_id'] is None):
            raise ValueError("Missing the required parameter `providers_file_id` when calling `get_providers_file_by_id`")  # noqa: E501

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_file_by_id`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_file_by_id`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'providers_file_id' in params:
            path_params['ProvidersFileId'] = params['providers_file_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/file/{ProvidersFileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_krb5_by_id(self, providers_krb5_id, **kwargs):  # noqa: E501
        """get_providers_krb5_by_id  # noqa: E501

        Retrieve the KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_krb5_by_id(providers_krb5_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_krb5_id: Retrieve the KRB5 provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersKrb5
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_krb5_by_id_with_http_info(providers_krb5_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_krb5_by_id_with_http_info(providers_krb5_id, **kwargs)  # noqa: E501
            return data

    def get_providers_krb5_by_id_with_http_info(self, providers_krb5_id, **kwargs):  # noqa: E501
        """get_providers_krb5_by_id  # noqa: E501

        Retrieve the KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_krb5_by_id_with_http_info(providers_krb5_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_krb5_id: Retrieve the KRB5 provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersKrb5
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_krb5_id', 'scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_krb5_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_krb5_id' is set
        if ('providers_krb5_id' not in params or
                params['providers_krb5_id'] is None):
            raise ValueError("Missing the required parameter `providers_krb5_id` when calling `get_providers_krb5_by_id`")  # noqa: E501

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_krb5_by_id`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_krb5_by_id`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'providers_krb5_id' in params:
            path_params['ProvidersKrb5Id'] = params['providers_krb5_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/krb5/{ProvidersKrb5Id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersKrb5',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_ldap_by_id(self, providers_ldap_id, **kwargs):  # noqa: E501
        """get_providers_ldap_by_id  # noqa: E501

        Retrieve the LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_ldap_by_id(providers_ldap_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ldap_id: Retrieve the LDAP provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLdap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_ldap_by_id_with_http_info(providers_ldap_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_ldap_by_id_with_http_info(providers_ldap_id, **kwargs)  # noqa: E501
            return data

    def get_providers_ldap_by_id_with_http_info(self, providers_ldap_id, **kwargs):  # noqa: E501
        """get_providers_ldap_by_id  # noqa: E501

        Retrieve the LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_ldap_by_id_with_http_info(providers_ldap_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_ldap_id: Retrieve the LDAP provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLdap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ldap_id', 'scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_ldap_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ldap_id' is set
        if ('providers_ldap_id' not in params or
                params['providers_ldap_id'] is None):
            raise ValueError("Missing the required parameter `providers_ldap_id` when calling `get_providers_ldap_by_id`")  # noqa: E501

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_ldap_by_id`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_ldap_by_id`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'providers_ldap_id' in params:
            path_params['ProvidersLdapId'] = params['providers_ldap_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ldap/{ProvidersLdapId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersLdap',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_local(self, **kwargs):  # noqa: E501
        """get_providers_local  # noqa: E501

        List all local providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_local(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLocal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_local_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_local_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_providers_local_with_http_info(self, **kwargs):  # noqa: E501
        """get_providers_local  # noqa: E501

        List all local providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_local_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLocal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_local" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_local`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_local`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/local', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersLocal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_local_by_id(self, providers_local_id, **kwargs):  # noqa: E501
        """get_providers_local_by_id  # noqa: E501

        Retrieve the local provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_local_by_id(providers_local_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_local_id: Retrieve the local provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLocal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_local_by_id_with_http_info(providers_local_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_local_by_id_with_http_info(providers_local_id, **kwargs)  # noqa: E501
            return data

    def get_providers_local_by_id_with_http_info(self, providers_local_id, **kwargs):  # noqa: E501
        """get_providers_local_by_id  # noqa: E501

        Retrieve the local provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_local_by_id_with_http_info(providers_local_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_local_id: Retrieve the local provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLocal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_local_id', 'scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_local_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_local_id' is set
        if ('providers_local_id' not in params or
                params['providers_local_id'] is None):
            raise ValueError("Missing the required parameter `providers_local_id` when calling `get_providers_local_by_id`")  # noqa: E501

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_local_by_id`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_local_by_id`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'providers_local_id' in params:
            path_params['ProvidersLocalId'] = params['providers_local_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/local/{ProvidersLocalId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersLocal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_nis_by_id(self, providers_nis_id, **kwargs):  # noqa: E501
        """get_providers_nis_by_id  # noqa: E501

        Retrieve the NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_nis_by_id(providers_nis_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_nis_id: Retrieve the NIS provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersNis
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_nis_by_id_with_http_info(providers_nis_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_nis_by_id_with_http_info(providers_nis_id, **kwargs)  # noqa: E501
            return data

    def get_providers_nis_by_id_with_http_info(self, providers_nis_id, **kwargs):  # noqa: E501
        """get_providers_nis_by_id  # noqa: E501

        Retrieve the NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_nis_by_id_with_http_info(providers_nis_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str providers_nis_id: Retrieve the NIS provider. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersNis
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_nis_id', 'scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_nis_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_nis_id' is set
        if ('providers_nis_id' not in params or
                params['providers_nis_id'] is None):
            raise ValueError("Missing the required parameter `providers_nis_id` when calling `get_providers_nis_by_id`")  # noqa: E501

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_nis_by_id`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_providers_nis_by_id`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'providers_nis_id' in params:
            path_params['ProvidersNisId'] = params['providers_nis_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/nis/{ProvidersNisId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersNis',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_providers_summary(self, **kwargs):  # noqa: E501
        """get_providers_summary  # noqa: E501

        Retrieve the summary information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_summary(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: Filter providers by groupnet.
        :param str zone: Filter providers by zone.
        :return: ProvidersSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_providers_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_providers_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_providers_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_providers_summary  # noqa: E501

        Retrieve the summary information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_providers_summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: Filter providers by groupnet.
        :param str zone: Filter providers by zone.
        :return: ProvidersSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_providers_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'groupnet' in params:
            query_params.append(('groupnet', params['groupnet']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/auth/providers/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_acls(self, **kwargs):  # noqa: E501
        """get_settings_acls  # noqa: E501

        Retrieve the ACL policy settings and preset configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_acls(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preset: If specified the preset configuration values for all applicable ACL policies are returned.
        :return: SettingsAcls
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_acls_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_acls_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_settings_acls_with_http_info(self, **kwargs):  # noqa: E501
        """get_settings_acls  # noqa: E501

        Retrieve the ACL policy settings and preset configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_acls_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preset: If specified the preset configuration values for all applicable ACL policies are returned.
        :return: SettingsAcls
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['preset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_acls" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'preset' in params:
            query_params.append(('preset', params['preset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/settings/acls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsAcls',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_global(self, **kwargs):  # noqa: E501
        """get_settings_global  # noqa: E501

        Retrieve the global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Zone which contains any per-zone settings.
        :return: SettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_settings_global  # noqa: E501

        Retrieve the global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Zone which contains any per-zone settings.
        :return: SettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_settings_global`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_settings_global`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_krb5_defaults(self, **kwargs):  # noqa: E501
        """get_settings_krb5_defaults  # noqa: E501

        Retrieve the krb5 settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_krb5_defaults(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsKrb5Defaults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_krb5_defaults_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_krb5_defaults_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_settings_krb5_defaults_with_http_info(self, **kwargs):  # noqa: E501
        """get_settings_krb5_defaults  # noqa: E501

        Retrieve the krb5 settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_krb5_defaults_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsKrb5Defaults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_krb5_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/defaults', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsKrb5Defaults',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_krb5_domain(self, settings_krb5_domain_id, **kwargs):  # noqa: E501
        """get_settings_krb5_domain  # noqa: E501

        View the krb5 domain settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_krb5_domain(settings_krb5_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_domain_id: View the krb5 domain settings. (required)
        :return: SettingsKrb5Domains
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_krb5_domain_with_http_info(settings_krb5_domain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_krb5_domain_with_http_info(settings_krb5_domain_id, **kwargs)  # noqa: E501
            return data

    def get_settings_krb5_domain_with_http_info(self, settings_krb5_domain_id, **kwargs):  # noqa: E501
        """get_settings_krb5_domain  # noqa: E501

        View the krb5 domain settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_krb5_domain_with_http_info(settings_krb5_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_domain_id: View the krb5 domain settings. (required)
        :return: SettingsKrb5Domains
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_domain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_krb5_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_domain_id' is set
        if ('settings_krb5_domain_id' not in params or
                params['settings_krb5_domain_id'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_domain_id` when calling `get_settings_krb5_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_krb5_domain_id' in params:
            path_params['SettingsKrb5DomainId'] = params['settings_krb5_domain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/domains/{SettingsKrb5DomainId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsKrb5Domains',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_krb5_realm(self, settings_krb5_realm_id, **kwargs):  # noqa: E501
        """get_settings_krb5_realm  # noqa: E501

        Retrieve the krb5 settings for realms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_krb5_realm(settings_krb5_realm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_realm_id: Retrieve the krb5 settings for realms. (required)
        :return: SettingsKrb5Realms
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_krb5_realm_with_http_info(settings_krb5_realm_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_krb5_realm_with_http_info(settings_krb5_realm_id, **kwargs)  # noqa: E501
            return data

    def get_settings_krb5_realm_with_http_info(self, settings_krb5_realm_id, **kwargs):  # noqa: E501
        """get_settings_krb5_realm  # noqa: E501

        Retrieve the krb5 settings for realms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_krb5_realm_with_http_info(settings_krb5_realm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_krb5_realm_id: Retrieve the krb5 settings for realms. (required)
        :return: SettingsKrb5Realms
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_realm_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_krb5_realm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_realm_id' is set
        if ('settings_krb5_realm_id' not in params or
                params['settings_krb5_realm_id'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_realm_id` when calling `get_settings_krb5_realm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_krb5_realm_id' in params:
            path_params['SettingsKrb5RealmId'] = params['settings_krb5_realm_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/realms/{SettingsKrb5RealmId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsKrb5Realms',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_mapping(self, **kwargs):  # noqa: E501
        """get_settings_mapping  # noqa: E501

        Retrieve the mapping settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_mapping(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Access zone which contains mapping settings.
        :return: SettingsMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_mapping_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_mapping_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_settings_mapping_with_http_info(self, **kwargs):  # noqa: E501
        """get_settings_mapping  # noqa: E501

        Retrieve the mapping settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_mapping_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Access zone which contains mapping settings.
        :return: SettingsMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_mapping" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_settings_mapping`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_settings_mapping`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/mapping', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsMapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_auth_groups(self, **kwargs):  # noqa: E501
        """list_auth_groups  # noqa: E501

        List all groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: Filter groups by domain.
        :param str zone: Filter groups by zone.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param str filter: Filter groups by name prefix.
        :param int limit: Return no more than this many results at once (see resume).
        :param str provider: Filter groups by provider.
        :param bool query_member_of: Enumerate all groups that a group is a member of.
        :return: AuthGroupsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_auth_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_auth_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_auth_groups_with_http_info(self, **kwargs):  # noqa: E501
        """list_auth_groups  # noqa: E501

        List all groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: Filter groups by domain.
        :param str zone: Filter groups by zone.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param str filter: Filter groups by name prefix.
        :param int limit: Return no more than this many results at once (see resume).
        :param str provider: Filter groups by provider.
        :param bool query_member_of: Enumerate all groups that a group is a member of.
        :return: AuthGroupsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain', 'zone', 'resume', 'cached', 'resolve_names', 'filter', 'limit', 'provider', 'query_member_of']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_auth_groups" % key
                )
            params[key] = val
        del params['kwargs']

        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_auth_groups`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_auth_groups`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_auth_groups`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_auth_groups`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'domain' in params:
            query_params.append(('domain', params['domain']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501
        if 'query_member_of' in params:
            query_params.append(('query_member_of', params['query_member_of']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthGroupsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_auth_roles(self, **kwargs):  # noqa: E501
        """list_auth_roles  # noqa: E501

        List all roles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_roles(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Specifies which access zone to use.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool resolve_names: Resolve names of personas.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: AuthRolesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_auth_roles_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_auth_roles_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_auth_roles_with_http_info(self, **kwargs):  # noqa: E501
        """list_auth_roles  # noqa: E501

        List all roles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Specifies which access zone to use.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool resolve_names: Resolve names of personas.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: AuthRolesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'resolve_names', 'limit', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_auth_roles" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_auth_roles`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_auth_roles`, length must be greater than or equal to `0`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `list_auth_roles`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `list_auth_roles`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_auth_roles`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_auth_roles`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_auth_roles`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_auth_roles`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_auth_roles`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthRolesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_auth_users(self, **kwargs):  # noqa: E501
        """list_auth_users  # noqa: E501

        List all users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: Filter users by domain.
        :param str zone: Filter users by zone.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param str filter: Filter users by name prefix.
        :param int limit: Return no more than this many results at once (see resume).
        :param str provider: Filter users by provider.
        :param bool query_member_of: Enumerate all users that a group is a member of.
        :return: AuthUsersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_auth_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_auth_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_auth_users_with_http_info(self, **kwargs):  # noqa: E501
        """list_auth_users  # noqa: E501

        List all users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_auth_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: Filter users by domain.
        :param str zone: Filter users by zone.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool cached: If true, only return cached objects.
        :param bool resolve_names: Resolve names of personas.
        :param str filter: Filter users by name prefix.
        :param int limit: Return no more than this many results at once (see resume).
        :param str provider: Filter users by provider.
        :param bool query_member_of: Enumerate all users that a group is a member of.
        :return: AuthUsersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain', 'zone', 'resume', 'cached', 'resolve_names', 'filter', 'limit', 'provider', 'query_member_of']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_auth_users" % key
                )
            params[key] = val
        del params['kwargs']

        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_auth_users`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_auth_users`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_auth_users`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_auth_users`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'domain' in params:
            query_params.append(('domain', params['domain']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'cached' in params:
            query_params.append(('cached', params['cached']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501
        if 'query_member_of' in params:
            query_params.append(('query_member_of', params['query_member_of']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthUsersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_providers_ads(self, **kwargs):  # noqa: E501
        """list_providers_ads  # noqa: E501

        List all ADS providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_ads(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersAdsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_providers_ads_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_providers_ads_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_providers_ads_with_http_info(self, **kwargs):  # noqa: E501
        """list_providers_ads  # noqa: E501

        List all ADS providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_ads_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersAdsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_providers_ads" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_ads`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_ads`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ads', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersAdsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_providers_file(self, **kwargs):  # noqa: E501
        """list_providers_file  # noqa: E501

        List all file providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_providers_file_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_providers_file_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_providers_file_with_http_info(self, **kwargs):  # noqa: E501
        """list_providers_file  # noqa: E501

        List all file providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_providers_file" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_file`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_file`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_providers_krb5(self, **kwargs):  # noqa: E501
        """list_providers_krb5  # noqa: E501

        List all KRB5 providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_krb5(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersKrb5Extended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_providers_krb5_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_providers_krb5_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_providers_krb5_with_http_info(self, **kwargs):  # noqa: E501
        """list_providers_krb5  # noqa: E501

        List all KRB5 providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_krb5_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersKrb5Extended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_providers_krb5" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_krb5`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_krb5`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/krb5', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersKrb5Extended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_providers_ldap(self, **kwargs):  # noqa: E501
        """list_providers_ldap  # noqa: E501

        List all LDAP providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_ldap(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLdap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_providers_ldap_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_providers_ldap_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_providers_ldap_with_http_info(self, **kwargs):  # noqa: E501
        """list_providers_ldap  # noqa: E501

        List all LDAP providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_ldap_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersLdap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_providers_ldap" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_ldap`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_ldap`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ldap', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersLdap',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_providers_nis(self, **kwargs):  # noqa: E501
        """list_providers_nis  # noqa: E501

        List all NIS providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_nis(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersNis
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_providers_nis_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_providers_nis_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_providers_nis_with_http_info(self, **kwargs):  # noqa: E501
        """list_providers_nis  # noqa: E501

        List all NIS providers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_nis_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: ProvidersNis
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_providers_nis" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_nis`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `list_providers_nis`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/nis', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProvidersNis',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_settings_krb5_domains(self, **kwargs):  # noqa: E501
        """list_settings_krb5_domains  # noqa: E501

        Retrieve the krb5 settings for domains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_krb5_domains(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsKrb5Domains
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_settings_krb5_domains_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_settings_krb5_domains_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_settings_krb5_domains_with_http_info(self, **kwargs):  # noqa: E501
        """list_settings_krb5_domains  # noqa: E501

        Retrieve the krb5 settings for domains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_krb5_domains_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsKrb5Domains
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_settings_krb5_domains" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/domains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsKrb5Domains',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_settings_krb5_realms(self, **kwargs):  # noqa: E501
        """list_settings_krb5_realms  # noqa: E501

        Retrieve the krb5 settings for realms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_krb5_realms(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsKrb5Realms
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_settings_krb5_realms_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_settings_krb5_realms_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_settings_krb5_realms_with_http_info(self, **kwargs):  # noqa: E501
        """list_settings_krb5_realms  # noqa: E501

        Retrieve the krb5 settings for realms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_krb5_realms_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsKrb5Realms
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_settings_krb5_realms" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/realms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsKrb5Realms',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_auth_group(self, auth_group, auth_group_id, **kwargs):  # noqa: E501
        """update_auth_group  # noqa: E501

        Modify the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_group(auth_group, auth_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthGroup auth_group: (required)
        :param str auth_group_id: Modify the group. (required)
        :param bool force: Changes to the group ID can result in loss of access to the file system. To mitigate this risk of lost access, the force option is required for group ID changes.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_auth_group_with_http_info(auth_group, auth_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_auth_group_with_http_info(auth_group, auth_group_id, **kwargs)  # noqa: E501
            return data

    def update_auth_group_with_http_info(self, auth_group, auth_group_id, **kwargs):  # noqa: E501
        """update_auth_group  # noqa: E501

        Modify the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_group_with_http_info(auth_group, auth_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthGroup auth_group: (required)
        :param str auth_group_id: Modify the group. (required)
        :param bool force: Changes to the group ID can result in loss of access to the file system. To mitigate this risk of lost access, the force option is required for group ID changes.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_group', 'auth_group_id', 'force', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_auth_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_group' is set
        if ('auth_group' not in params or
                params['auth_group'] is None):
            raise ValueError("Missing the required parameter `auth_group` when calling `update_auth_group`")  # noqa: E501
        # verify the required parameter 'auth_group_id' is set
        if ('auth_group_id' not in params or
                params['auth_group_id'] is None):
            raise ValueError("Missing the required parameter `auth_group_id` when calling `update_auth_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_group_id' in params:
            path_params['AuthGroupId'] = params['auth_group_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_group' in params:
            body_params = params['auth_group']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/groups/{AuthGroupId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_auth_log_level(self, auth_log_level, **kwargs):  # noqa: E501
        """update_auth_log_level  # noqa: E501

        Set the current authentication service and netlogon logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_log_level(auth_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthLogLevelExtended auth_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_auth_log_level_with_http_info(auth_log_level, **kwargs)  # noqa: E501
        else:
            (data) = self.update_auth_log_level_with_http_info(auth_log_level, **kwargs)  # noqa: E501
            return data

    def update_auth_log_level_with_http_info(self, auth_log_level, **kwargs):  # noqa: E501
        """update_auth_log_level  # noqa: E501

        Set the current authentication service and netlogon logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_log_level_with_http_info(auth_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthLogLevelExtended auth_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_log_level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_auth_log_level" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_log_level' is set
        if ('auth_log_level' not in params or
                params['auth_log_level'] is None):
            raise ValueError("Missing the required parameter `auth_log_level` when calling `update_auth_log_level`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_log_level' in params:
            body_params = params['auth_log_level']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/auth/log-level', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_auth_role(self, auth_role, auth_role_id, **kwargs):  # noqa: E501
        """update_auth_role  # noqa: E501

        Modify the role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_role(auth_role, auth_role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthRole auth_role: (required)
        :param str auth_role_id: Modify the role. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_auth_role_with_http_info(auth_role, auth_role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_auth_role_with_http_info(auth_role, auth_role_id, **kwargs)  # noqa: E501
            return data

    def update_auth_role_with_http_info(self, auth_role, auth_role_id, **kwargs):  # noqa: E501
        """update_auth_role  # noqa: E501

        Modify the role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_role_with_http_info(auth_role, auth_role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthRole auth_role: (required)
        :param str auth_role_id: Modify the role. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_role', 'auth_role_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_auth_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_role' is set
        if ('auth_role' not in params or
                params['auth_role'] is None):
            raise ValueError("Missing the required parameter `auth_role` when calling `update_auth_role`")  # noqa: E501
        # verify the required parameter 'auth_role_id' is set
        if ('auth_role_id' not in params or
                params['auth_role_id'] is None):
            raise ValueError("Missing the required parameter `auth_role_id` when calling `update_auth_role`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `update_auth_role`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `update_auth_role`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'auth_role_id' in params:
            path_params['AuthRoleId'] = params['auth_role_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_role' in params:
            body_params = params['auth_role']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/roles/{AuthRoleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_auth_user(self, auth_user, auth_user_id, **kwargs):  # noqa: E501
        """update_auth_user  # noqa: E501

        Modify the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_user(auth_user, auth_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthUser auth_user: (required)
        :param str auth_user_id: Modify the user. (required)
        :param bool force: Changes to the user ID can result in loss of access to the file system. To mitigate this risk of lost access, the force option is required for user ID changes.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_auth_user_with_http_info(auth_user, auth_user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_auth_user_with_http_info(auth_user, auth_user_id, **kwargs)  # noqa: E501
            return data

    def update_auth_user_with_http_info(self, auth_user, auth_user_id, **kwargs):  # noqa: E501
        """update_auth_user  # noqa: E501

        Modify the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_user_with_http_info(auth_user, auth_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthUser auth_user: (required)
        :param str auth_user_id: Modify the user. (required)
        :param bool force: Changes to the user ID can result in loss of access to the file system. To mitigate this risk of lost access, the force option is required for user ID changes.
        :param str zone: Optional zone.
        :param str provider: Optional provider type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auth_user', 'auth_user_id', 'force', 'zone', 'provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_auth_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_user' is set
        if ('auth_user' not in params or
                params['auth_user'] is None):
            raise ValueError("Missing the required parameter `auth_user` when calling `update_auth_user`")  # noqa: E501
        # verify the required parameter 'auth_user_id' is set
        if ('auth_user_id' not in params or
                params['auth_user_id'] is None):
            raise ValueError("Missing the required parameter `auth_user_id` when calling `update_auth_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_user_id' in params:
            path_params['AuthUserId'] = params['auth_user_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auth_user' in params:
            body_params = params['auth_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/users/{AuthUserId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_mapping_import(self, mapping_import, **kwargs):  # noqa: E501
        """update_mapping_import  # noqa: E501

        Set or update a list of mappings between two personae.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_mapping_import(mapping_import, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MappingDump mapping_import: (required)
        :param str zone: Optional zone.
        :param bool replace: Specify whether existing mappings should be replaced. The default behavior is to leave existing mappings intact and return an error.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_mapping_import_with_http_info(mapping_import, **kwargs)  # noqa: E501
        else:
            (data) = self.update_mapping_import_with_http_info(mapping_import, **kwargs)  # noqa: E501
            return data

    def update_mapping_import_with_http_info(self, mapping_import, **kwargs):  # noqa: E501
        """update_mapping_import  # noqa: E501

        Set or update a list of mappings between two personae.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_mapping_import_with_http_info(mapping_import, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MappingDump mapping_import: (required)
        :param str zone: Optional zone.
        :param bool replace: Specify whether existing mappings should be replaced. The default behavior is to leave existing mappings intact and return an error.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mapping_import', 'zone', 'replace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_mapping_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mapping_import' is set
        if ('mapping_import' not in params or
                params['mapping_import'] is None):
            raise ValueError("Missing the required parameter `mapping_import` when calling `update_mapping_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mapping_import' in params:
            body_params = params['mapping_import']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/auth/mapping/import', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_mapping_users_rules(self, mapping_users_rules, **kwargs):  # noqa: E501
        """update_mapping_users_rules  # noqa: E501

        Modify the user mapping rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_mapping_users_rules(mapping_users_rules, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MappingUsersRulesExtended mapping_users_rules: (required)
        :param str zone: The zone to which the user mapping applies.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_mapping_users_rules_with_http_info(mapping_users_rules, **kwargs)  # noqa: E501
        else:
            (data) = self.update_mapping_users_rules_with_http_info(mapping_users_rules, **kwargs)  # noqa: E501
            return data

    def update_mapping_users_rules_with_http_info(self, mapping_users_rules, **kwargs):  # noqa: E501
        """update_mapping_users_rules  # noqa: E501

        Modify the user mapping rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_mapping_users_rules_with_http_info(mapping_users_rules, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MappingUsersRulesExtended mapping_users_rules: (required)
        :param str zone: The zone to which the user mapping applies.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mapping_users_rules', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_mapping_users_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mapping_users_rules' is set
        if ('mapping_users_rules' not in params or
                params['mapping_users_rules'] is None):
            raise ValueError("Missing the required parameter `mapping_users_rules` when calling `update_mapping_users_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mapping_users_rules' in params:
            body_params = params['mapping_users_rules']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/mapping/users/rules', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_providers_ads_by_id(self, providers_ads_id_params, providers_ads_id, **kwargs):  # noqa: E501
        """update_providers_ads_by_id  # noqa: E501

        Modify the ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_ads_by_id(providers_ads_id_params, providers_ads_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersAdsIdParams providers_ads_id_params: (required)
        :param str providers_ads_id: Modify the ADS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_providers_ads_by_id_with_http_info(providers_ads_id_params, providers_ads_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_providers_ads_by_id_with_http_info(providers_ads_id_params, providers_ads_id, **kwargs)  # noqa: E501
            return data

    def update_providers_ads_by_id_with_http_info(self, providers_ads_id_params, providers_ads_id, **kwargs):  # noqa: E501
        """update_providers_ads_by_id  # noqa: E501

        Modify the ADS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_ads_by_id_with_http_info(providers_ads_id_params, providers_ads_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersAdsIdParams providers_ads_id_params: (required)
        :param str providers_ads_id: Modify the ADS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ads_id_params', 'providers_ads_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_providers_ads_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ads_id_params' is set
        if ('providers_ads_id_params' not in params or
                params['providers_ads_id_params'] is None):
            raise ValueError("Missing the required parameter `providers_ads_id_params` when calling `update_providers_ads_by_id`")  # noqa: E501
        # verify the required parameter 'providers_ads_id' is set
        if ('providers_ads_id' not in params or
                params['providers_ads_id'] is None):
            raise ValueError("Missing the required parameter `providers_ads_id` when calling `update_providers_ads_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_ads_id' in params:
            path_params['ProvidersAdsId'] = params['providers_ads_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_ads_id_params' in params:
            body_params = params['providers_ads_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ads/{ProvidersAdsId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_providers_duo(self, providers_duo, **kwargs):  # noqa: E501
        """update_providers_duo  # noqa: E501

        Modify Duo provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_duo(providers_duo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersDuoExtended providers_duo: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_providers_duo_with_http_info(providers_duo, **kwargs)  # noqa: E501
        else:
            (data) = self.update_providers_duo_with_http_info(providers_duo, **kwargs)  # noqa: E501
            return data

    def update_providers_duo_with_http_info(self, providers_duo, **kwargs):  # noqa: E501
        """update_providers_duo  # noqa: E501

        Modify Duo provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_duo_with_http_info(providers_duo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersDuoExtended providers_duo: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_duo']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_providers_duo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_duo' is set
        if ('providers_duo' not in params or
                params['providers_duo'] is None):
            raise ValueError("Missing the required parameter `providers_duo` when calling `update_providers_duo`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_duo' in params:
            body_params = params['providers_duo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/duo', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_providers_file_by_id(self, providers_file_id_params, providers_file_id, **kwargs):  # noqa: E501
        """update_providers_file_by_id  # noqa: E501

        Modify the file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_file_by_id(providers_file_id_params, providers_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersFileIdParams providers_file_id_params: (required)
        :param str providers_file_id: Modify the file provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_providers_file_by_id_with_http_info(providers_file_id_params, providers_file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_providers_file_by_id_with_http_info(providers_file_id_params, providers_file_id, **kwargs)  # noqa: E501
            return data

    def update_providers_file_by_id_with_http_info(self, providers_file_id_params, providers_file_id, **kwargs):  # noqa: E501
        """update_providers_file_by_id  # noqa: E501

        Modify the file provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_file_by_id_with_http_info(providers_file_id_params, providers_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersFileIdParams providers_file_id_params: (required)
        :param str providers_file_id: Modify the file provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_file_id_params', 'providers_file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_providers_file_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_file_id_params' is set
        if ('providers_file_id_params' not in params or
                params['providers_file_id_params'] is None):
            raise ValueError("Missing the required parameter `providers_file_id_params` when calling `update_providers_file_by_id`")  # noqa: E501
        # verify the required parameter 'providers_file_id' is set
        if ('providers_file_id' not in params or
                params['providers_file_id'] is None):
            raise ValueError("Missing the required parameter `providers_file_id` when calling `update_providers_file_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_file_id' in params:
            path_params['ProvidersFileId'] = params['providers_file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_file_id_params' in params:
            body_params = params['providers_file_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/file/{ProvidersFileId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_providers_krb5_by_id(self, providers_krb5_id_params, providers_krb5_id, **kwargs):  # noqa: E501
        """update_providers_krb5_by_id  # noqa: E501

        Modify the KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_krb5_by_id(providers_krb5_id_params, providers_krb5_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersKrb5IdParams providers_krb5_id_params: (required)
        :param str providers_krb5_id: Modify the KRB5 provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_providers_krb5_by_id_with_http_info(providers_krb5_id_params, providers_krb5_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_providers_krb5_by_id_with_http_info(providers_krb5_id_params, providers_krb5_id, **kwargs)  # noqa: E501
            return data

    def update_providers_krb5_by_id_with_http_info(self, providers_krb5_id_params, providers_krb5_id, **kwargs):  # noqa: E501
        """update_providers_krb5_by_id  # noqa: E501

        Modify the KRB5 provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_krb5_by_id_with_http_info(providers_krb5_id_params, providers_krb5_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersKrb5IdParams providers_krb5_id_params: (required)
        :param str providers_krb5_id: Modify the KRB5 provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_krb5_id_params', 'providers_krb5_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_providers_krb5_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_krb5_id_params' is set
        if ('providers_krb5_id_params' not in params or
                params['providers_krb5_id_params'] is None):
            raise ValueError("Missing the required parameter `providers_krb5_id_params` when calling `update_providers_krb5_by_id`")  # noqa: E501
        # verify the required parameter 'providers_krb5_id' is set
        if ('providers_krb5_id' not in params or
                params['providers_krb5_id'] is None):
            raise ValueError("Missing the required parameter `providers_krb5_id` when calling `update_providers_krb5_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_krb5_id' in params:
            path_params['ProvidersKrb5Id'] = params['providers_krb5_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_krb5_id_params' in params:
            body_params = params['providers_krb5_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/krb5/{ProvidersKrb5Id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_providers_ldap_by_id(self, providers_ldap_id_params, providers_ldap_id, **kwargs):  # noqa: E501
        """update_providers_ldap_by_id  # noqa: E501

        Modify the LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_ldap_by_id(providers_ldap_id_params, providers_ldap_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersLdapIdParams providers_ldap_id_params: (required)
        :param str providers_ldap_id: Modify the LDAP provider. (required)
        :param bool force: Ignore unresolvable server URIs.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_providers_ldap_by_id_with_http_info(providers_ldap_id_params, providers_ldap_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_providers_ldap_by_id_with_http_info(providers_ldap_id_params, providers_ldap_id, **kwargs)  # noqa: E501
            return data

    def update_providers_ldap_by_id_with_http_info(self, providers_ldap_id_params, providers_ldap_id, **kwargs):  # noqa: E501
        """update_providers_ldap_by_id  # noqa: E501

        Modify the LDAP provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_ldap_by_id_with_http_info(providers_ldap_id_params, providers_ldap_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersLdapIdParams providers_ldap_id_params: (required)
        :param str providers_ldap_id: Modify the LDAP provider. (required)
        :param bool force: Ignore unresolvable server URIs.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ldap_id_params', 'providers_ldap_id', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_providers_ldap_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_ldap_id_params' is set
        if ('providers_ldap_id_params' not in params or
                params['providers_ldap_id_params'] is None):
            raise ValueError("Missing the required parameter `providers_ldap_id_params` when calling `update_providers_ldap_by_id`")  # noqa: E501
        # verify the required parameter 'providers_ldap_id' is set
        if ('providers_ldap_id' not in params or
                params['providers_ldap_id'] is None):
            raise ValueError("Missing the required parameter `providers_ldap_id` when calling `update_providers_ldap_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_ldap_id' in params:
            path_params['ProvidersLdapId'] = params['providers_ldap_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_ldap_id_params' in params:
            body_params = params['providers_ldap_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/ldap/{ProvidersLdapId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_providers_local_by_id(self, providers_local_id_params, providers_local_id, **kwargs):  # noqa: E501
        """update_providers_local_by_id  # noqa: E501

        Modify the local provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_local_by_id(providers_local_id_params, providers_local_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersLocalIdParams providers_local_id_params: (required)
        :param str providers_local_id: Modify the local provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_providers_local_by_id_with_http_info(providers_local_id_params, providers_local_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_providers_local_by_id_with_http_info(providers_local_id_params, providers_local_id, **kwargs)  # noqa: E501
            return data

    def update_providers_local_by_id_with_http_info(self, providers_local_id_params, providers_local_id, **kwargs):  # noqa: E501
        """update_providers_local_by_id  # noqa: E501

        Modify the local provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_local_by_id_with_http_info(providers_local_id_params, providers_local_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersLocalIdParams providers_local_id_params: (required)
        :param str providers_local_id: Modify the local provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_local_id_params', 'providers_local_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_providers_local_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_local_id_params' is set
        if ('providers_local_id_params' not in params or
                params['providers_local_id_params'] is None):
            raise ValueError("Missing the required parameter `providers_local_id_params` when calling `update_providers_local_by_id`")  # noqa: E501
        # verify the required parameter 'providers_local_id' is set
        if ('providers_local_id' not in params or
                params['providers_local_id'] is None):
            raise ValueError("Missing the required parameter `providers_local_id` when calling `update_providers_local_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_local_id' in params:
            path_params['ProvidersLocalId'] = params['providers_local_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_local_id_params' in params:
            body_params = params['providers_local_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/local/{ProvidersLocalId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_providers_nis_by_id(self, providers_nis_id_params, providers_nis_id, **kwargs):  # noqa: E501
        """update_providers_nis_by_id  # noqa: E501

        Modify the NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_nis_by_id(providers_nis_id_params, providers_nis_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersNisIdParams providers_nis_id_params: (required)
        :param str providers_nis_id: Modify the NIS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_providers_nis_by_id_with_http_info(providers_nis_id_params, providers_nis_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_providers_nis_by_id_with_http_info(providers_nis_id_params, providers_nis_id, **kwargs)  # noqa: E501
            return data

    def update_providers_nis_by_id_with_http_info(self, providers_nis_id_params, providers_nis_id, **kwargs):  # noqa: E501
        """update_providers_nis_by_id  # noqa: E501

        Modify the NIS provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_providers_nis_by_id_with_http_info(providers_nis_id_params, providers_nis_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProvidersNisIdParams providers_nis_id_params: (required)
        :param str providers_nis_id: Modify the NIS provider. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_nis_id_params', 'providers_nis_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_providers_nis_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'providers_nis_id_params' is set
        if ('providers_nis_id_params' not in params or
                params['providers_nis_id_params'] is None):
            raise ValueError("Missing the required parameter `providers_nis_id_params` when calling `update_providers_nis_by_id`")  # noqa: E501
        # verify the required parameter 'providers_nis_id' is set
        if ('providers_nis_id' not in params or
                params['providers_nis_id'] is None):
            raise ValueError("Missing the required parameter `providers_nis_id` when calling `update_providers_nis_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'providers_nis_id' in params:
            path_params['ProvidersNisId'] = params['providers_nis_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'providers_nis_id_params' in params:
            body_params = params['providers_nis_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/providers/nis/{ProvidersNisId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_acls(self, settings_acls, **kwargs):  # noqa: E501
        """update_settings_acls  # noqa: E501

        Modify cluster ACL policy settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_acls(settings_acls, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsAclsExtended settings_acls: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_acls_with_http_info(settings_acls, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_acls_with_http_info(settings_acls, **kwargs)  # noqa: E501
            return data

    def update_settings_acls_with_http_info(self, settings_acls, **kwargs):  # noqa: E501
        """update_settings_acls  # noqa: E501

        Modify cluster ACL policy settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_acls_with_http_info(settings_acls, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsAclsExtended settings_acls: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_acls']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_acls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_acls' is set
        if ('settings_acls' not in params or
                params['settings_acls'] is None):
            raise ValueError("Missing the required parameter `settings_acls` when calling `update_settings_acls`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_acls' in params:
            body_params = params['settings_acls']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/auth/settings/acls', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_global(self, settings_global, **kwargs):  # noqa: E501
        """update_settings_global  # noqa: E501

        Modify the global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_global(settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsGlobalGlobalSettings settings_global: (required)
        :param str zone: Zone which contains any per-zone settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_global_with_http_info(settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_global_with_http_info(settings_global, **kwargs)  # noqa: E501
            return data

    def update_settings_global_with_http_info(self, settings_global, **kwargs):  # noqa: E501
        """update_settings_global  # noqa: E501

        Modify the global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_global_with_http_info(settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsGlobalGlobalSettings settings_global: (required)
        :param str zone: Zone which contains any per-zone settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_global', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_global' is set
        if ('settings_global' not in params or
                params['settings_global'] is None):
            raise ValueError("Missing the required parameter `settings_global` when calling `update_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_global' in params:
            body_params = params['settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_krb5_defaults(self, settings_krb5_defaults, **kwargs):  # noqa: E501
        """update_settings_krb5_defaults  # noqa: E501

        Modify the krb5 settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_krb5_defaults(settings_krb5_defaults, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5DefaultsKrb5Settings settings_krb5_defaults: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_krb5_defaults_with_http_info(settings_krb5_defaults, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_krb5_defaults_with_http_info(settings_krb5_defaults, **kwargs)  # noqa: E501
            return data

    def update_settings_krb5_defaults_with_http_info(self, settings_krb5_defaults, **kwargs):  # noqa: E501
        """update_settings_krb5_defaults  # noqa: E501

        Modify the krb5 settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_krb5_defaults_with_http_info(settings_krb5_defaults, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5DefaultsKrb5Settings settings_krb5_defaults: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_defaults']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_krb5_defaults" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_defaults' is set
        if ('settings_krb5_defaults' not in params or
                params['settings_krb5_defaults'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_defaults` when calling `update_settings_krb5_defaults`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_krb5_defaults' in params:
            body_params = params['settings_krb5_defaults']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/defaults', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_krb5_domain(self, settings_krb5_domain, settings_krb5_domain_id, **kwargs):  # noqa: E501
        """update_settings_krb5_domain  # noqa: E501

        Modify the krb5 domain settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_krb5_domain(settings_krb5_domain, settings_krb5_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5Domain settings_krb5_domain: (required)
        :param str settings_krb5_domain_id: Modify the krb5 domain settings. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_krb5_domain_with_http_info(settings_krb5_domain, settings_krb5_domain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_krb5_domain_with_http_info(settings_krb5_domain, settings_krb5_domain_id, **kwargs)  # noqa: E501
            return data

    def update_settings_krb5_domain_with_http_info(self, settings_krb5_domain, settings_krb5_domain_id, **kwargs):  # noqa: E501
        """update_settings_krb5_domain  # noqa: E501

        Modify the krb5 domain settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_krb5_domain_with_http_info(settings_krb5_domain, settings_krb5_domain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5Domain settings_krb5_domain: (required)
        :param str settings_krb5_domain_id: Modify the krb5 domain settings. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_domain', 'settings_krb5_domain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_krb5_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_domain' is set
        if ('settings_krb5_domain' not in params or
                params['settings_krb5_domain'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_domain` when calling `update_settings_krb5_domain`")  # noqa: E501
        # verify the required parameter 'settings_krb5_domain_id' is set
        if ('settings_krb5_domain_id' not in params or
                params['settings_krb5_domain_id'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_domain_id` when calling `update_settings_krb5_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_krb5_domain_id' in params:
            path_params['SettingsKrb5DomainId'] = params['settings_krb5_domain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_krb5_domain' in params:
            body_params = params['settings_krb5_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/domains/{SettingsKrb5DomainId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_krb5_realm(self, settings_krb5_realm, settings_krb5_realm_id, **kwargs):  # noqa: E501
        """update_settings_krb5_realm  # noqa: E501

        Modify the krb5 realm settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_krb5_realm(settings_krb5_realm, settings_krb5_realm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5Realm settings_krb5_realm: (required)
        :param str settings_krb5_realm_id: Modify the krb5 realm settings. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_krb5_realm_with_http_info(settings_krb5_realm, settings_krb5_realm_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_krb5_realm_with_http_info(settings_krb5_realm, settings_krb5_realm_id, **kwargs)  # noqa: E501
            return data

    def update_settings_krb5_realm_with_http_info(self, settings_krb5_realm, settings_krb5_realm_id, **kwargs):  # noqa: E501
        """update_settings_krb5_realm  # noqa: E501

        Modify the krb5 realm settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_krb5_realm_with_http_info(settings_krb5_realm, settings_krb5_realm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsKrb5Realm settings_krb5_realm: (required)
        :param str settings_krb5_realm_id: Modify the krb5 realm settings. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_krb5_realm', 'settings_krb5_realm_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_krb5_realm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_krb5_realm' is set
        if ('settings_krb5_realm' not in params or
                params['settings_krb5_realm'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_realm` when calling `update_settings_krb5_realm`")  # noqa: E501
        # verify the required parameter 'settings_krb5_realm_id' is set
        if ('settings_krb5_realm_id' not in params or
                params['settings_krb5_realm_id'] is None):
            raise ValueError("Missing the required parameter `settings_krb5_realm_id` when calling `update_settings_krb5_realm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_krb5_realm_id' in params:
            path_params['SettingsKrb5RealmId'] = params['settings_krb5_realm_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_krb5_realm' in params:
            body_params = params['settings_krb5_realm']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/krb5/realms/{SettingsKrb5RealmId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_mapping(self, settings_mapping, **kwargs):  # noqa: E501
        """update_settings_mapping  # noqa: E501

        Modify the mapping settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_mapping(settings_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsMappingMappingSettings settings_mapping: (required)
        :param str zone: Access zone which contains mapping settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_mapping_with_http_info(settings_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_mapping_with_http_info(settings_mapping, **kwargs)  # noqa: E501
            return data

    def update_settings_mapping_with_http_info(self, settings_mapping, **kwargs):  # noqa: E501
        """update_settings_mapping  # noqa: E501

        Modify the mapping settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_mapping_with_http_info(settings_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsMappingMappingSettings settings_mapping: (required)
        :param str zone: Access zone which contains mapping settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_mapping', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_mapping' is set
        if ('settings_mapping' not in params or
                params['settings_mapping'] is None):
            raise ValueError("Missing the required parameter `settings_mapping` when calling `update_settings_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_mapping' in params:
            body_params = params['settings_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/auth/settings/mapping', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
