# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 8
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_2_1.api_client import ApiClient


class AntivirusApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_antivirus_policy(self, antivirus_policy, **kwargs):  # noqa: E501
        """create_antivirus_policy  # noqa: E501

        Create new antivirus scan policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_antivirus_policy(antivirus_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusPolicyCreateParams antivirus_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_antivirus_policy_with_http_info(antivirus_policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_antivirus_policy_with_http_info(antivirus_policy, **kwargs)  # noqa: E501
            return data

    def create_antivirus_policy_with_http_info(self, antivirus_policy, **kwargs):  # noqa: E501
        """create_antivirus_policy  # noqa: E501

        Create new antivirus scan policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_antivirus_policy_with_http_info(antivirus_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusPolicyCreateParams antivirus_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_antivirus_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_policy' is set
        if ('antivirus_policy' not in params or
                params['antivirus_policy'] is None):
            raise ValueError("Missing the required parameter `antivirus_policy` when calling `create_antivirus_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'antivirus_policy' in params:
            body_params = params['antivirus_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_antivirus_scan_item(self, antivirus_scan_item, **kwargs):  # noqa: E501
        """create_antivirus_scan_item  # noqa: E501

        Manually scan a file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_antivirus_scan_item(antivirus_scan_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusScanItem antivirus_scan_item: (required)
        :return: CreateAntivirusScanItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_antivirus_scan_item_with_http_info(antivirus_scan_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_antivirus_scan_item_with_http_info(antivirus_scan_item, **kwargs)  # noqa: E501
            return data

    def create_antivirus_scan_item_with_http_info(self, antivirus_scan_item, **kwargs):  # noqa: E501
        """create_antivirus_scan_item  # noqa: E501

        Manually scan a file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_antivirus_scan_item_with_http_info(antivirus_scan_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusScanItem antivirus_scan_item: (required)
        :return: CreateAntivirusScanItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_scan_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_antivirus_scan_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_scan_item' is set
        if ('antivirus_scan_item' not in params or
                params['antivirus_scan_item'] is None):
            raise ValueError("Missing the required parameter `antivirus_scan_item` when calling `create_antivirus_scan_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'antivirus_scan_item' in params:
            body_params = params['antivirus_scan_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/scan', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAntivirusScanItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_antivirus_server(self, antivirus_server, **kwargs):  # noqa: E501
        """create_antivirus_server  # noqa: E501

        Create new antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_antivirus_server(antivirus_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusServerCreateParams antivirus_server: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_antivirus_server_with_http_info(antivirus_server, **kwargs)  # noqa: E501
        else:
            (data) = self.create_antivirus_server_with_http_info(antivirus_server, **kwargs)  # noqa: E501
            return data

    def create_antivirus_server_with_http_info(self, antivirus_server, **kwargs):  # noqa: E501
        """create_antivirus_server  # noqa: E501

        Create new antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_antivirus_server_with_http_info(antivirus_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusServerCreateParams antivirus_server: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_server' is set
        if ('antivirus_server' not in params or
                params['antivirus_server'] is None):
            raise ValueError("Missing the required parameter `antivirus_server` when calling `create_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'antivirus_server' in params:
            body_params = params['antivirus_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/servers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_antivirus_policies(self, **kwargs):  # noqa: E501
        """delete_antivirus_policies  # noqa: E501

        Delete all antivirus scan policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_antivirus_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_antivirus_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_antivirus_policies_with_http_info(self, **kwargs):  # noqa: E501
        """delete_antivirus_policies  # noqa: E501

        Delete all antivirus scan policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_antivirus_policies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/policies', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_antivirus_policy(self, antivirus_policy_id, **kwargs):  # noqa: E501
        """delete_antivirus_policy  # noqa: E501

        Delete an antivirus scan policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_policy(antivirus_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_policy_id: Delete an antivirus scan policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_antivirus_policy_with_http_info(antivirus_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_antivirus_policy_with_http_info(antivirus_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_antivirus_policy_with_http_info(self, antivirus_policy_id, **kwargs):  # noqa: E501
        """delete_antivirus_policy  # noqa: E501

        Delete an antivirus scan policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_policy_with_http_info(antivirus_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_policy_id: Delete an antivirus scan policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_antivirus_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_policy_id' is set
        if ('antivirus_policy_id' not in params or
                params['antivirus_policy_id'] is None):
            raise ValueError("Missing the required parameter `antivirus_policy_id` when calling `delete_antivirus_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_policy_id' in params:
            path_params['AntivirusPolicyId'] = params['antivirus_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/policies/{AntivirusPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_antivirus_server(self, antivirus_server_id, **kwargs):  # noqa: E501
        """delete_antivirus_server  # noqa: E501

        Delete an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_server(antivirus_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_server_id: Delete an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_antivirus_server_with_http_info(antivirus_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_antivirus_server_with_http_info(antivirus_server_id, **kwargs)  # noqa: E501
            return data

    def delete_antivirus_server_with_http_info(self, antivirus_server_id, **kwargs):  # noqa: E501
        """delete_antivirus_server  # noqa: E501

        Delete an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_server_with_http_info(antivirus_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_server_id: Delete an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_server_id' is set
        if ('antivirus_server_id' not in params or
                params['antivirus_server_id'] is None):
            raise ValueError("Missing the required parameter `antivirus_server_id` when calling `delete_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_server_id' in params:
            path_params['AntivirusServerId'] = params['antivirus_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/servers/{AntivirusServerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_antivirus_servers(self, **kwargs):  # noqa: E501
        """delete_antivirus_servers  # noqa: E501

        Delete all antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_antivirus_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_antivirus_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_antivirus_servers_with_http_info(self, **kwargs):  # noqa: E501
        """delete_antivirus_servers  # noqa: E501

        Delete all antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_antivirus_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_antivirus_servers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/servers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_reports_scan(self, reports_scan_id, **kwargs):  # noqa: E501
        """delete_reports_scan  # noqa: E501

        Delete one antivirus scan report, and all of its associated threat reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reports_scan(reports_scan_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reports_scan_id: Delete one antivirus scan report, and all of its associated threat reports. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_reports_scan_with_http_info(reports_scan_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_reports_scan_with_http_info(reports_scan_id, **kwargs)  # noqa: E501
            return data

    def delete_reports_scan_with_http_info(self, reports_scan_id, **kwargs):  # noqa: E501
        """delete_reports_scan  # noqa: E501

        Delete one antivirus scan report, and all of its associated threat reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reports_scan_with_http_info(reports_scan_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reports_scan_id: Delete one antivirus scan report, and all of its associated threat reports. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reports_scan_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reports_scan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reports_scan_id' is set
        if ('reports_scan_id' not in params or
                params['reports_scan_id'] is None):
            raise ValueError("Missing the required parameter `reports_scan_id` when calling `delete_reports_scan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'reports_scan_id' in params:
            path_params['ReportsScanId'] = params['reports_scan_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/reports/scans/{ReportsScanId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_reports_scans(self, **kwargs):  # noqa: E501
        """delete_reports_scans  # noqa: E501

        Delete antivirus scan reports, and any threat reports associated with those scans.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reports_scans(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int age: An amount of time in seconds. If present, only reports older than this age are deleted.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_reports_scans_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_reports_scans_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_reports_scans_with_http_info(self, **kwargs):  # noqa: E501
        """delete_reports_scans  # noqa: E501

        Delete antivirus scan reports, and any threat reports associated with those scans.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reports_scans_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int age: An amount of time in seconds. If present, only reports older than this age are deleted.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['age']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reports_scans" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'age' in params:
            query_params.append(('age', params['age']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/reports/scans', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_antivirus_policy(self, antivirus_policy_id, **kwargs):  # noqa: E501
        """get_antivirus_policy  # noqa: E501

        Retrieve one antivirus scan policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_policy(antivirus_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_policy_id: Retrieve one antivirus scan policy. (required)
        :return: AntivirusPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_antivirus_policy_with_http_info(antivirus_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_antivirus_policy_with_http_info(antivirus_policy_id, **kwargs)  # noqa: E501
            return data

    def get_antivirus_policy_with_http_info(self, antivirus_policy_id, **kwargs):  # noqa: E501
        """get_antivirus_policy  # noqa: E501

        Retrieve one antivirus scan policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_policy_with_http_info(antivirus_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_policy_id: Retrieve one antivirus scan policy. (required)
        :return: AntivirusPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_antivirus_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_policy_id' is set
        if ('antivirus_policy_id' not in params or
                params['antivirus_policy_id'] is None):
            raise ValueError("Missing the required parameter `antivirus_policy_id` when calling `get_antivirus_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_policy_id' in params:
            path_params['AntivirusPolicyId'] = params['antivirus_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/policies/{AntivirusPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AntivirusPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_antivirus_quarantine_path(self, antivirus_quarantine_path, **kwargs):  # noqa: E501
        """get_antivirus_quarantine_path  # noqa: E501

        Retrieve the quarantine status of the file at the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_quarantine_path(antivirus_quarantine_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_quarantine_path: Retrieve the quarantine status of the file at the specified path. (required)
        :return: AntivirusQuarantine
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_antivirus_quarantine_path_with_http_info(antivirus_quarantine_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_antivirus_quarantine_path_with_http_info(antivirus_quarantine_path, **kwargs)  # noqa: E501
            return data

    def get_antivirus_quarantine_path_with_http_info(self, antivirus_quarantine_path, **kwargs):  # noqa: E501
        """get_antivirus_quarantine_path  # noqa: E501

        Retrieve the quarantine status of the file at the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_quarantine_path_with_http_info(antivirus_quarantine_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_quarantine_path: Retrieve the quarantine status of the file at the specified path. (required)
        :return: AntivirusQuarantine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_quarantine_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_antivirus_quarantine_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_quarantine_path' is set
        if ('antivirus_quarantine_path' not in params or
                params['antivirus_quarantine_path'] is None):
            raise ValueError("Missing the required parameter `antivirus_quarantine_path` when calling `get_antivirus_quarantine_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_quarantine_path' in params:
            path_params['AntivirusQuarantinePath'] = params['antivirus_quarantine_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/quarantine/{AntivirusQuarantinePath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AntivirusQuarantine',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_antivirus_server(self, antivirus_server_id, **kwargs):  # noqa: E501
        """get_antivirus_server  # noqa: E501

        Retrieve one antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_server(antivirus_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_server_id: Retrieve one antivirus server entry. (required)
        :return: AntivirusServers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_antivirus_server_with_http_info(antivirus_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_antivirus_server_with_http_info(antivirus_server_id, **kwargs)  # noqa: E501
            return data

    def get_antivirus_server_with_http_info(self, antivirus_server_id, **kwargs):  # noqa: E501
        """get_antivirus_server  # noqa: E501

        Retrieve one antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_server_with_http_info(antivirus_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str antivirus_server_id: Retrieve one antivirus server entry. (required)
        :return: AntivirusServers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_server_id' is set
        if ('antivirus_server_id' not in params or
                params['antivirus_server_id'] is None):
            raise ValueError("Missing the required parameter `antivirus_server_id` when calling `get_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_server_id' in params:
            path_params['AntivirusServerId'] = params['antivirus_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/servers/{AntivirusServerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AntivirusServers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_antivirus_settings(self, **kwargs):  # noqa: E501
        """get_antivirus_settings  # noqa: E501

        Retrieve the Antivirus settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AntivirusSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_antivirus_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_antivirus_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_antivirus_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_antivirus_settings  # noqa: E501

        Retrieve the Antivirus settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_antivirus_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AntivirusSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_antivirus_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/antivirus/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AntivirusSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reports_scan(self, reports_scan_id, **kwargs):  # noqa: E501
        """get_reports_scan  # noqa: E501

        Retrieve one antivirus scan report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_scan(reports_scan_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reports_scan_id: Retrieve one antivirus scan report. (required)
        :return: ReportsScans
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reports_scan_with_http_info(reports_scan_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_reports_scan_with_http_info(reports_scan_id, **kwargs)  # noqa: E501
            return data

    def get_reports_scan_with_http_info(self, reports_scan_id, **kwargs):  # noqa: E501
        """get_reports_scan  # noqa: E501

        Retrieve one antivirus scan report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_scan_with_http_info(reports_scan_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reports_scan_id: Retrieve one antivirus scan report. (required)
        :return: ReportsScans
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reports_scan_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reports_scan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reports_scan_id' is set
        if ('reports_scan_id' not in params or
                params['reports_scan_id'] is None):
            raise ValueError("Missing the required parameter `reports_scan_id` when calling `get_reports_scan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'reports_scan_id' in params:
            path_params['ReportsScanId'] = params['reports_scan_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/reports/scans/{ReportsScanId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportsScans',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reports_scans(self, **kwargs):  # noqa: E501
        """get_reports_scans  # noqa: E501

        List antivirus scan reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_scans(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str status: If present, only scan reports with this status will be returned.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param int offset: The position of the first item returned for a paginated query within the full result set.
        :param str dir: The direction of the sort.
        :param str policy_id: If present, only reports for scans associated with this policy will be returned.
        :return: ReportsScansExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reports_scans_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reports_scans_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reports_scans_with_http_info(self, **kwargs):  # noqa: E501
        """get_reports_scans  # noqa: E501

        List antivirus scan reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_scans_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str status: If present, only scan reports with this status will be returned.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param int offset: The position of the first item returned for a paginated query within the full result set.
        :param str dir: The direction of the sort.
        :param str policy_id: If present, only reports for scans associated with this policy will be returned.
        :return: ReportsScansExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'status', 'resume', 'limit', 'offset', 'dir', 'policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reports_scans" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_reports_scans`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_reports_scans`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_reports_scans`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_reports_scans`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_reports_scans`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_reports_scans`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_reports_scans`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_reports_scans`, must be a value greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_reports_scans`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'policy_id' in params:
            query_params.append(('policy_id', params['policy_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/reports/scans', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportsScansExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reports_threat(self, reports_threat_id, **kwargs):  # noqa: E501
        """get_reports_threat  # noqa: E501

        Retrieve one antivirus threat report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_threat(reports_threat_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reports_threat_id: Retrieve one antivirus threat report. (required)
        :return: ReportsThreats
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reports_threat_with_http_info(reports_threat_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_reports_threat_with_http_info(reports_threat_id, **kwargs)  # noqa: E501
            return data

    def get_reports_threat_with_http_info(self, reports_threat_id, **kwargs):  # noqa: E501
        """get_reports_threat  # noqa: E501

        Retrieve one antivirus threat report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_threat_with_http_info(reports_threat_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reports_threat_id: Retrieve one antivirus threat report. (required)
        :return: ReportsThreats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reports_threat_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reports_threat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reports_threat_id' is set
        if ('reports_threat_id' not in params or
                params['reports_threat_id'] is None):
            raise ValueError("Missing the required parameter `reports_threat_id` when calling `get_reports_threat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'reports_threat_id' in params:
            path_params['ReportsThreatId'] = params['reports_threat_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/reports/threats/{ReportsThreatId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportsThreats',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reports_threats(self, **kwargs):  # noqa: E501
        """get_reports_threats  # noqa: E501

        List antivirus threat reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_threats(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str scan_id: If present, only returns threat reports associated with the given scan report.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str file: If present, only returns threat reports for the given file.
        :param int offset: The position of the first item returned for a paginated query within the full result set.
        :param str remediation: If present, only returns threat reports with the given remediation.
        :param str dir: The direction of the sort.
        :return: ReportsThreatsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reports_threats_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reports_threats_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reports_threats_with_http_info(self, **kwargs):  # noqa: E501
        """get_reports_threats  # noqa: E501

        List antivirus threat reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_threats_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str scan_id: If present, only returns threat reports associated with the given scan report.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str file: If present, only returns threat reports for the given file.
        :param int offset: The position of the first item returned for a paginated query within the full result set.
        :param str remediation: If present, only returns threat reports with the given remediation.
        :param str dir: The direction of the sort.
        :return: ReportsThreatsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'scan_id', 'resume', 'limit', 'file', 'offset', 'remediation', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reports_threats" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_reports_threats`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_reports_threats`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_reports_threats`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_reports_threats`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_reports_threats`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_reports_threats`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_reports_threats`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_reports_threats`, must be a value greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_reports_threats`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'scan_id' in params:
            query_params.append(('scan_id', params['scan_id']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'file' in params:
            query_params.append(('file', params['file']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'remediation' in params:
            query_params.append(('remediation', params['remediation']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/reports/threats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportsThreatsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_antivirus_policies(self, **kwargs):  # noqa: E501
        """list_antivirus_policies  # noqa: E501

        List antivirus scan policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_antivirus_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: AntivirusPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_antivirus_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_antivirus_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_antivirus_policies_with_http_info(self, **kwargs):  # noqa: E501
        """list_antivirus_policies  # noqa: E501

        List antivirus scan policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_antivirus_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: AntivirusPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_antivirus_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_antivirus_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_antivirus_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_antivirus_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_antivirus_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_antivirus_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_antivirus_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_antivirus_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AntivirusPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_antivirus_servers(self, **kwargs):  # noqa: E501
        """list_antivirus_servers  # noqa: E501

        List antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_antivirus_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: AntivirusServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_antivirus_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_antivirus_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_antivirus_servers_with_http_info(self, **kwargs):  # noqa: E501
        """list_antivirus_servers  # noqa: E501

        List antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_antivirus_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: AntivirusServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_antivirus_servers" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_antivirus_servers`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_antivirus_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_antivirus_servers`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_antivirus_servers`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_antivirus_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_antivirus_servers`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_antivirus_servers`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/servers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AntivirusServersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_antivirus_policy(self, antivirus_policy, antivirus_policy_id, **kwargs):  # noqa: E501
        """update_antivirus_policy  # noqa: E501

        Modify an antivirus scan policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_policy(antivirus_policy, antivirus_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusPolicy antivirus_policy: (required)
        :param str antivirus_policy_id: Modify an antivirus scan policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_antivirus_policy_with_http_info(antivirus_policy, antivirus_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_antivirus_policy_with_http_info(antivirus_policy, antivirus_policy_id, **kwargs)  # noqa: E501
            return data

    def update_antivirus_policy_with_http_info(self, antivirus_policy, antivirus_policy_id, **kwargs):  # noqa: E501
        """update_antivirus_policy  # noqa: E501

        Modify an antivirus scan policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_policy_with_http_info(antivirus_policy, antivirus_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusPolicy antivirus_policy: (required)
        :param str antivirus_policy_id: Modify an antivirus scan policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_policy', 'antivirus_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_antivirus_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_policy' is set
        if ('antivirus_policy' not in params or
                params['antivirus_policy'] is None):
            raise ValueError("Missing the required parameter `antivirus_policy` when calling `update_antivirus_policy`")  # noqa: E501
        # verify the required parameter 'antivirus_policy_id' is set
        if ('antivirus_policy_id' not in params or
                params['antivirus_policy_id'] is None):
            raise ValueError("Missing the required parameter `antivirus_policy_id` when calling `update_antivirus_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_policy_id' in params:
            path_params['AntivirusPolicyId'] = params['antivirus_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'antivirus_policy' in params:
            body_params = params['antivirus_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/policies/{AntivirusPolicyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_antivirus_quarantine_path(self, antivirus_quarantine_path_params, antivirus_quarantine_path, **kwargs):  # noqa: E501
        """update_antivirus_quarantine_path  # noqa: E501

        Set the quarantine status of the file at the specified path.  Use either an empty object {} in the request body or {\"quarantined\":true} to quarantine the file, and {\"quarantined\":false} to unquarantine the file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_quarantine_path(antivirus_quarantine_path_params, antivirus_quarantine_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusQuarantinePathParams antivirus_quarantine_path_params: (required)
        :param str antivirus_quarantine_path: Set the quarantine status of the file at the specified path.  Use either an empty object {} in the request body or {\"quarantined\":true} to quarantine the file, and {\"quarantined\":false} to unquarantine the file. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_antivirus_quarantine_path_with_http_info(antivirus_quarantine_path_params, antivirus_quarantine_path, **kwargs)  # noqa: E501
        else:
            (data) = self.update_antivirus_quarantine_path_with_http_info(antivirus_quarantine_path_params, antivirus_quarantine_path, **kwargs)  # noqa: E501
            return data

    def update_antivirus_quarantine_path_with_http_info(self, antivirus_quarantine_path_params, antivirus_quarantine_path, **kwargs):  # noqa: E501
        """update_antivirus_quarantine_path  # noqa: E501

        Set the quarantine status of the file at the specified path.  Use either an empty object {} in the request body or {\"quarantined\":true} to quarantine the file, and {\"quarantined\":false} to unquarantine the file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_quarantine_path_with_http_info(antivirus_quarantine_path_params, antivirus_quarantine_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusQuarantinePathParams antivirus_quarantine_path_params: (required)
        :param str antivirus_quarantine_path: Set the quarantine status of the file at the specified path.  Use either an empty object {} in the request body or {\"quarantined\":true} to quarantine the file, and {\"quarantined\":false} to unquarantine the file. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_quarantine_path_params', 'antivirus_quarantine_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_antivirus_quarantine_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_quarantine_path_params' is set
        if ('antivirus_quarantine_path_params' not in params or
                params['antivirus_quarantine_path_params'] is None):
            raise ValueError("Missing the required parameter `antivirus_quarantine_path_params` when calling `update_antivirus_quarantine_path`")  # noqa: E501
        # verify the required parameter 'antivirus_quarantine_path' is set
        if ('antivirus_quarantine_path' not in params or
                params['antivirus_quarantine_path'] is None):
            raise ValueError("Missing the required parameter `antivirus_quarantine_path` when calling `update_antivirus_quarantine_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_quarantine_path' in params:
            path_params['AntivirusQuarantinePath'] = params['antivirus_quarantine_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'antivirus_quarantine_path_params' in params:
            body_params = params['antivirus_quarantine_path_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/quarantine/{AntivirusQuarantinePath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_antivirus_server(self, antivirus_server, antivirus_server_id, **kwargs):  # noqa: E501
        """update_antivirus_server  # noqa: E501

        Modify an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_server(antivirus_server, antivirus_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusServer antivirus_server: (required)
        :param str antivirus_server_id: Modify an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_antivirus_server_with_http_info(antivirus_server, antivirus_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_antivirus_server_with_http_info(antivirus_server, antivirus_server_id, **kwargs)  # noqa: E501
            return data

    def update_antivirus_server_with_http_info(self, antivirus_server, antivirus_server_id, **kwargs):  # noqa: E501
        """update_antivirus_server  # noqa: E501

        Modify an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_server_with_http_info(antivirus_server, antivirus_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusServer antivirus_server: (required)
        :param str antivirus_server_id: Modify an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_server', 'antivirus_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_server' is set
        if ('antivirus_server' not in params or
                params['antivirus_server'] is None):
            raise ValueError("Missing the required parameter `antivirus_server` when calling `update_antivirus_server`")  # noqa: E501
        # verify the required parameter 'antivirus_server_id' is set
        if ('antivirus_server_id' not in params or
                params['antivirus_server_id'] is None):
            raise ValueError("Missing the required parameter `antivirus_server_id` when calling `update_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirus_server_id' in params:
            path_params['AntivirusServerId'] = params['antivirus_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'antivirus_server' in params:
            body_params = params['antivirus_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/antivirus/servers/{AntivirusServerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_antivirus_settings(self, antivirus_settings, **kwargs):  # noqa: E501
        """update_antivirus_settings  # noqa: E501

        Modify the Antivirus settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_settings(antivirus_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusSettingsExtended antivirus_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_antivirus_settings_with_http_info(antivirus_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_antivirus_settings_with_http_info(antivirus_settings, **kwargs)  # noqa: E501
            return data

    def update_antivirus_settings_with_http_info(self, antivirus_settings, **kwargs):  # noqa: E501
        """update_antivirus_settings  # noqa: E501

        Modify the Antivirus settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_antivirus_settings_with_http_info(antivirus_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AntivirusSettingsExtended antivirus_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirus_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_antivirus_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirus_settings' is set
        if ('antivirus_settings' not in params or
                params['antivirus_settings'] is None):
            raise ValueError("Missing the required parameter `antivirus_settings` when calling `update_antivirus_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'antivirus_settings' in params:
            body_params = params['antivirus_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/antivirus/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
