/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;

public interface DatasetGraph
extends Transactional,
Closeable {
    public Graph getDefaultGraph();

    public Graph getGraph(Node var1);

    public Graph getUnionGraph();

    public boolean containsGraph(Node var1);

    public void setDefaultGraph(Graph var1);

    public void addGraph(Node var1, Graph var2);

    public void removeGraph(Node var1);

    public Iterator<Node> listGraphNodes();

    public void add(Quad var1);

    public void delete(Quad var1);

    public void add(Node var1, Node var2, Node var3, Node var4);

    default public void addAll(DatasetGraph src) {
        src.find().forEachRemaining(this::add);
    }

    public void delete(Node var1, Node var2, Node var3, Node var4);

    public void deleteAny(Node var1, Node var2, Node var3, Node var4);

    default public Iterator<Quad> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    public Iterator<Quad> find(Quad var1);

    public Iterator<Quad> find(Node var1, Node var2, Node var3, Node var4);

    public Iterator<Quad> findNG(Node var1, Node var2, Node var3, Node var4);

    default public Stream<Quad> stream(Node g, Node s, Node p, Node o) {
        return Iter.asStream(this.find(g, s, p, o));
    }

    default public Stream<Quad> stream() {
        return this.stream(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    public boolean contains(Node var1, Node var2, Node var3, Node var4);

    public boolean contains(Quad var1);

    public void clear();

    public boolean isEmpty();

    public Lock getLock();

    public Context getContext();

    public long size();

    @Override
    public void close();

    public PrefixMap prefixes();

    public boolean supportsTransactions();

    default public boolean supportsTransactionAbort() {
        return false;
    }
}

