from _typeshed import Self
from collections.abc import Iterator, Sequence
from typing import Any, ClassVar, overload
from typing_extensions import Final, Literal

from panda3d._typing import Vec3Like, Vec4Like
from panda3d.core._dtoolbase import TypedObject
from panda3d.core._dtoolutil import ostream
from panda3d.core._express import TypedReferenceCount
from panda3d.core._linmath import LMatrix3f, LPoint3f, LQuaternionf, LVecBase3f, LVecBase4f, LVector3f
from panda3d.core._pgraph import NodePath
from panda3d.core._putil import BitMask32

class dxBody:
    DtoolClassDict: ClassVar[dict[str, Any]]

class dxGeom:
    DtoolClassDict: ClassVar[dict[str, Any]]

class dxJoint:
    DtoolClassDict: ClassVar[dict[str, Any]]

class dxJointGroup:
    DtoolClassDict: ClassVar[dict[str, Any]]

class dxSpace:
    DtoolClassDict: ClassVar[dict[str, Any]]

class dxTriMeshData:
    DtoolClassDict: ClassVar[dict[str, Any]]

class dxWorld:
    DtoolClassDict: ClassVar[dict[str, Any]]

class OdeWorld(TypedObject):
    def __init__(self, copy: OdeWorld = ...) -> None: ...
    def __bool__(self) -> bool: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    def destroy(self) -> None: ...
    def is_empty(self) -> bool:
        """Returns true if the ID is 0, meaning the OdeWorld does not point to a valid
        world.  It is an error to call a method on an empty world.  Note that an
        empty OdeWorld also evaluates to False.
        """
    def get_id(self) -> dxWorld:
        """Returns the underlying dWorldID."""
    @overload
    def set_gravity(self, vec: Vec3Like) -> None: ...
    @overload
    def set_gravity(self, x: float, y: float, z: float) -> None: ...
    def set_erp(self, erp: float) -> None: ...
    def set_cfm(self, cfm: float) -> None: ...
    def set_quick_step_num_iterations(self, num: int) -> None: ...
    def set_quick_step_w(self, over_relaxation: float) -> None: ...
    def set_contact_max_correcting_vel(self, vel: float) -> None: ...
    def set_contact_surface_layer(self, depth: float) -> None: ...
    def set_auto_disable_linear_threshold(self, linear_threshold: float) -> None: ...
    def set_auto_disable_angular_threshold(self, angular_threshold: float) -> None: ...
    def set_auto_disable_steps(self, steps: int) -> None: ...
    def set_auto_disable_time(self, time: float) -> None: ...
    def set_auto_disable_flag(self, do_auto_disable: int) -> None: ...
    def get_gravity(self) -> LVecBase3f: ...
    def get_erp(self) -> float: ...
    def get_cfm(self) -> float: ...
    def get_quick_step_num_iterations(self) -> int: ...
    def get_quick_step_w(self) -> float: ...
    def get_contact_max_correcting_vel(self) -> float: ...
    def get_contact_surface_layer(self) -> float: ...
    def get_auto_disable_linear_threshold(self) -> float: ...
    def get_auto_disable_angular_threshold(self) -> float: ...
    def get_auto_disable_steps(self) -> int: ...
    def get_auto_disable_time(self) -> float: ...
    def get_auto_disable_flag(self) -> int: ...
    @overload
    def impulse_to_force(self, stepsize: float, impulse: Vec3Like) -> LVecBase3f: ...
    @overload
    def impulse_to_force(self, stepsize: float, ix: float, iy: float, iz: float) -> LVecBase3f: ...
    def step(self, stepsize: float) -> None: ...
    def quick_step(self, stepsize: float) -> None: ...
    def compare_to(self, other: OdeWorld) -> int: ...
    def init_surface_table(self, num_surfaces: str) -> None: ...
    def add_body_dampening(self, body: OdeBody, surface: int) -> None:
        """void assign_surface_body(OdeBody& body, int surface);"""
    def set_surface_entry(
        self,
        pos1: str,
        pos2: str,
        mu: float,
        bounce: float,
        bounce_vel: float,
        soft_erp: float,
        soft_cfm: float,
        slip: float,
        dampen: float,
    ) -> None: ...
    def apply_dampening(self, dt: float, body: OdeBody) -> float: ...
    isEmpty = is_empty
    getId = get_id
    setGravity = set_gravity
    setErp = set_erp
    setCfm = set_cfm
    setQuickStepNumIterations = set_quick_step_num_iterations
    setQuickStepW = set_quick_step_w
    setContactMaxCorrectingVel = set_contact_max_correcting_vel
    setContactSurfaceLayer = set_contact_surface_layer
    setAutoDisableLinearThreshold = set_auto_disable_linear_threshold
    setAutoDisableAngularThreshold = set_auto_disable_angular_threshold
    setAutoDisableSteps = set_auto_disable_steps
    setAutoDisableTime = set_auto_disable_time
    setAutoDisableFlag = set_auto_disable_flag
    getGravity = get_gravity
    getErp = get_erp
    getCfm = get_cfm
    getQuickStepNumIterations = get_quick_step_num_iterations
    getQuickStepW = get_quick_step_w
    getContactMaxCorrectingVel = get_contact_max_correcting_vel
    getContactSurfaceLayer = get_contact_surface_layer
    getAutoDisableLinearThreshold = get_auto_disable_linear_threshold
    getAutoDisableAngularThreshold = get_auto_disable_angular_threshold
    getAutoDisableSteps = get_auto_disable_steps
    getAutoDisableTime = get_auto_disable_time
    getAutoDisableFlag = get_auto_disable_flag
    impulseToForce = impulse_to_force
    quickStep = quick_step
    compareTo = compare_to
    initSurfaceTable = init_surface_table
    addBodyDampening = add_body_dampening
    setSurfaceEntry = set_surface_entry
    applyDampening = apply_dampening

class OdeJointGroup(TypedObject):
    def __init__(self) -> None: ...
    def destroy(self) -> None: ...
    def get_id(self) -> dxJointGroup: ...
    def empty(self) -> None: ...
    def compare_to(self, other: OdeJointGroup) -> int: ...
    getId = get_id
    compareTo = compare_to

class OdeJointFeedback:
    DtoolClassDict: ClassVar[dict[str, Any]]
    def __init__(self, __param0: OdeJointFeedback = ...) -> None: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    def get_force1(self) -> LVector3f: ...
    def get_force2(self) -> LVector3f: ...
    def get_torque1(self) -> LVector3f: ...
    def get_torque2(self) -> LVector3f: ...
    getForce1 = get_force1
    getForce2 = get_force2
    getTorque1 = get_torque1
    getTorque2 = get_torque2

class OdeJoint(TypedObject):
    JT_none: Final[Literal[0]]
    JTNone: Final[Literal[0]]
    JT_ball: Final[Literal[1]]
    JTBall: Final[Literal[1]]
    JT_hinge: Final[Literal[2]]
    JTHinge: Final[Literal[2]]
    JT_slider: Final[Literal[3]]
    JTSlider: Final[Literal[3]]
    JT_contact: Final[Literal[4]]
    JTContact: Final[Literal[4]]
    JT_universal: Final[Literal[5]]
    JTUniversal: Final[Literal[5]]
    JT_hinge2: Final[Literal[6]]
    JTHinge2: Final[Literal[6]]
    JT_fixed: Final[Literal[7]]
    JTFixed: Final[Literal[7]]
    JT_null: Final[Literal[8]]
    JTNull: Final[Literal[8]]
    JT_a_motor: Final[Literal[9]]
    JTAMotor: Final[Literal[9]]
    JT_l_motor: Final[Literal[10]]
    JTLMotor: Final[Literal[10]]
    JT_plane2d: Final[Literal[11]]
    JTPlane2d: Final[Literal[11]]
    def __bool__(self) -> bool: ...
    def __eq__(self, __other: object) -> bool: ...
    def destroy(self) -> None: ...
    def is_empty(self) -> bool:
        """Returns true if the ID is 0, meaning the OdeJoint does not point to a valid
        joint.  It is an error to call a method on an empty joint.  Note that an
        empty OdeJoint also evaluates to False.
        """
    def get_id(self) -> dxJoint:
        """Returns the underlying dJointID."""
    def get_joint_type(self) -> int:
        """INLINE void *get_data();"""
    def get_body(self, index: int) -> OdeBody: ...
    @overload
    def set_feedback(self, flag: bool = ...) -> None: ...
    @overload
    def set_feedback(self, __param0: OdeJointFeedback) -> None: ...
    def get_feedback(self) -> OdeJointFeedback: ...
    def attach(self, body1, body2) -> None: ...
    def attach_bodies(self, body1: OdeBody, body2: OdeBody) -> None:
        """Attaches two OdeBody objects to this joint.  Order is important.  Consider
        using the OdeJoint::attach extension function if you're using the Python
        interface.
        """
    def attach_body(self, body: OdeBody, index: int) -> None:
        """Attaches a single OdeBody to this joint at the specified index (0 or 1).
        The other index will be set to the environment (null). Consider using the
        OdeJoint::attach extension function if you're using the Python interface.
        """
    def detach(self) -> None: ...
    def write(self, out: ostream = ..., indent: int = ...) -> None: ...
    def compare_to(self, other: OdeJoint) -> int: ...
    def convert(self): ...
    def convert_to_ball(self) -> OdeBallJoint: ...
    def convert_to_hinge(self) -> OdeHingeJoint: ...
    def convert_to_slider(self) -> OdeSliderJoint: ...
    def convert_to_contact(self) -> OdeContactJoint: ...
    def convert_to_universal(self) -> OdeUniversalJoint: ...
    def convert_to_hinge2(self) -> OdeHinge2Joint: ...
    def convert_to_fixed(self) -> OdeFixedJoint: ...
    def convert_to_null(self) -> OdeNullJoint: ...
    def convert_to_a_motor(self) -> OdeAMotorJoint: ...
    def convert_to_l_motor(self) -> OdeLMotorJoint: ...
    def convert_to_plane2d(self) -> OdePlane2dJoint: ...
    isEmpty = is_empty
    getId = get_id
    getJointType = get_joint_type
    getBody = get_body
    setFeedback = set_feedback
    getFeedback = get_feedback
    attachBodies = attach_bodies
    attachBody = attach_body
    compareTo = compare_to
    convertToBall = convert_to_ball
    convertToHinge = convert_to_hinge
    convertToSlider = convert_to_slider
    convertToContact = convert_to_contact
    convertToUniversal = convert_to_universal
    convertToHinge2 = convert_to_hinge2
    convertToFixed = convert_to_fixed
    convertToNull = convert_to_null
    convertToAMotor = convert_to_a_motor
    convertToLMotor = convert_to_l_motor
    convertToPlane2d = convert_to_plane2d

class OdeAMotorJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    def set_num_axes(self, num: int) -> None: ...
    @overload
    def set_axis(self, anum: int, rel: int, axis: Vec3Like) -> None: ...
    @overload
    def set_axis(self, anum: int, rel: int, x: float, y: float, z: float) -> None: ...
    def set_angle(self, anum: int, angle: float) -> None: ...
    def set_mode(self, mode: int) -> None: ...
    def add_torques(self, torque1: float, torque2: float, torque3: float) -> None: ...
    def get_num_axes(self) -> int: ...
    def get_axis(self, anum: int) -> LVecBase3f: ...
    def get_axis_rel(self, anum: int) -> int: ...
    def get_angle(self, anum: int) -> float: ...
    def get_angle_rate(self, anum: int) -> float: ...
    def get_mode(self) -> int: ...
    def set_param_lo_stop(self, axis: int, val: float) -> None: ...
    def set_param_hi_stop(self, axis: int, val: float) -> None: ...
    def set_param_vel(self, axis: int, val: float) -> None: ...
    def set_param_f_max(self, axis: int, val: float) -> None: ...
    def set_param_fudge_factor(self, axis: int, val: float) -> None: ...
    def set_param_bounce(self, axis: int, val: float) -> None: ...
    def set_param_CFM(self, axis: int, val: float) -> None: ...
    def set_param_stop_ERP(self, axis: int, val: float) -> None: ...
    def set_param_stop_CFM(self, axis: int, val: float) -> None: ...
    def get_param_lo_stop(self, axis: int) -> float: ...
    def get_param_hi_stop(self, axis: int) -> float: ...
    def get_param_vel(self, axis: int) -> float: ...
    def get_param_f_max(self, axis: int) -> float: ...
    def get_param_fudge_factor(self, axis: int) -> float: ...
    def get_param_bounce(self, axis: int) -> float: ...
    def get_param_CFM(self, axis: int) -> float: ...
    def get_param_stop_ERP(self, axis: int) -> float: ...
    def get_param_stop_CFM(self, axis: int) -> float: ...
    def get_axes(self) -> tuple[LVecBase3f, ...]: ...
    setNumAxes = set_num_axes
    setAxis = set_axis
    setAngle = set_angle
    setMode = set_mode
    addTorques = add_torques
    getNumAxes = get_num_axes
    getAxis = get_axis
    getAxisRel = get_axis_rel
    getAngle = get_angle
    getAngleRate = get_angle_rate
    getMode = get_mode
    setParamLoStop = set_param_lo_stop
    setParamHiStop = set_param_hi_stop
    setParamVel = set_param_vel
    setParamFMax = set_param_f_max
    setParamFudgeFactor = set_param_fudge_factor
    setParamBounce = set_param_bounce
    setParamCFM = set_param_CFM
    setParamStopERP = set_param_stop_ERP
    setParamStopCFM = set_param_stop_CFM
    getParamLoStop = get_param_lo_stop
    getParamHiStop = get_param_hi_stop
    getParamVel = get_param_vel
    getParamFMax = get_param_f_max
    getParamFudgeFactor = get_param_fudge_factor
    getParamBounce = get_param_bounce
    getParamCFM = get_param_CFM
    getParamStopERP = get_param_stop_ERP
    getParamStopCFM = get_param_stop_CFM
    getAxes = get_axes

class OdeBallJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    @overload
    def set_anchor(self, anchor: Vec3Like) -> None: ...
    @overload
    def set_anchor(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_anchor2(self, anchor: Vec3Like) -> None: ...
    @overload
    def set_anchor2(self, x: float, y: float, z: float) -> None: ...
    def get_anchor(self) -> LVecBase3f: ...
    def get_anchor2(self) -> LVecBase3f: ...
    setAnchor = set_anchor
    setAnchor2 = set_anchor2
    getAnchor = get_anchor
    getAnchor2 = get_anchor2

class OdeMass(TypedReferenceCount):
    def __init__(self, copy: OdeMass = ...) -> None: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    def check(self) -> int: ...
    def set_zero(self) -> None: ...
    @overload
    def set_parameters(self, themass: float, center: Vec3Like, r: LMatrix3f) -> None: ...
    @overload
    def set_parameters(
        self,
        themass: float,
        cgx: float,
        cgy: float,
        cgz: float,
        I11: float,
        I22: float,
        I33: float,
        I12: float,
        I13: float,
        I23: float,
    ) -> None: ...
    def set_sphere(self, density: float, radius: float) -> None: ...
    def set_sphere_total(self, total_mass: float, radius: float) -> None: ...
    def set_capsule(self, density: float, direction: int, radius: float, length: float) -> None: ...
    def set_capsule_total(self, total_mass: float, direction: int, radius: float, length: float) -> None: ...
    def set_cylinder(self, density: float, direction: int, radius: float, length: float) -> None: ...
    def set_cylinder_total(self, total_mass: float, direction: int, radius: float, length: float) -> None: ...
    @overload
    def set_box(self, density: float, size: Vec3Like) -> None: ...
    @overload
    def set_box(self, density: float, lx: float, ly: float, lz: float) -> None: ...
    @overload
    def set_box_total(self, total_mass: float, size: Vec3Like) -> None: ...
    @overload
    def set_box_total(self, total_mass: float, lx: float, ly: float, lz: float) -> None: ...
    def adjust(self, newmass: float) -> None: ...
    @overload
    def translate(self, pos: Vec3Like) -> None: ...
    @overload
    def translate(self, x: float, y: float, z: float) -> None: ...
    def rotate(self, r: LMatrix3f) -> None: ...
    def add(self, other: OdeMass) -> None: ...
    def get_magnitude(self) -> float: ...
    def get_center(self) -> LPoint3f: ...
    def get_inertial_tensor(self) -> LMatrix3f: ...
    def write(self, out: ostream = ..., indent: int = ...) -> None: ...
    setZero = set_zero
    setParameters = set_parameters
    setSphere = set_sphere
    setSphereTotal = set_sphere_total
    setCapsule = set_capsule
    setCapsuleTotal = set_capsule_total
    setCylinder = set_cylinder
    setCylinderTotal = set_cylinder_total
    setBox = set_box
    setBoxTotal = set_box_total
    getMagnitude = get_magnitude
    getCenter = get_center
    getInertialTensor = get_inertial_tensor

class OdeBody(TypedObject):
    @property
    def joints(self) -> Sequence: ...
    def __init__(self, world: OdeWorld) -> None: ...
    def __bool__(self) -> bool: ...
    def destroy(self) -> None: ...
    def is_empty(self) -> bool:
        """Returns true if the ID is 0, meaning the OdeBody does not point to a valid
        body.  It is an error to call a method on an empty body.  Note that an
        empty OdeBody also evaluates to False.
        """
    def get_id(self) -> dxBody:
        """Returns the underlying dBodyID."""
    def set_auto_disable_linear_threshold(self, linear_threshold: float) -> None: ...
    def set_auto_disable_angular_threshold(self, angular_threshold: float) -> None: ...
    def set_auto_disable_steps(self, steps: int) -> None: ...
    def set_auto_disable_time(self, time: float) -> None: ...
    def set_auto_disable_flag(self, do_auto_disable: int) -> None: ...
    def set_auto_disable_defaults(self) -> None: ...
    def set_data(self, data) -> None: ...
    @overload
    def set_position(self, pos: Vec3Like) -> None: ...
    @overload
    def set_position(self, x: float, y: float, z: float) -> None: ...
    def set_rotation(self, r: LMatrix3f) -> None: ...
    def set_quaternion(self, q: Vec4Like) -> None: ...
    @overload
    def set_linear_vel(self, vel: Vec3Like) -> None: ...
    @overload
    def set_linear_vel(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_angular_vel(self, vel: Vec3Like) -> None: ...
    @overload
    def set_angular_vel(self, x: float, y: float, z: float) -> None: ...
    def set_mass(self, mass: OdeMass) -> None: ...
    def get_auto_disable_linear_threshold(self) -> float: ...
    def get_auto_disable_angular_threshold(self) -> float: ...
    def get_auto_disable_steps(self) -> int: ...
    def get_auto_disable_time(self) -> float: ...
    def get_auto_disable_flag(self) -> int: ...
    def get_data(self) -> bytes: ...
    def get_position(self) -> LVecBase3f: ...
    def get_rotation(self) -> LMatrix3f: ...
    def get_quaternion(self) -> LVecBase4f: ...
    def get_linear_vel(self) -> LVecBase3f: ...
    def get_angular_vel(self) -> LVecBase3f: ...
    def get_mass(self) -> OdeMass: ...
    @overload
    def add_force(self, f: Vec3Like) -> None: ...
    @overload
    def add_force(self, fx: float, fy: float, fz: float) -> None: ...
    @overload
    def add_torque(self, f: Vec3Like) -> None: ...
    @overload
    def add_torque(self, fx: float, fy: float, fz: float) -> None: ...
    @overload
    def add_rel_force(self, f: Vec3Like) -> None: ...
    @overload
    def add_rel_force(self, fx: float, fy: float, fz: float) -> None: ...
    @overload
    def add_rel_torque(self, f: Vec3Like) -> None: ...
    @overload
    def add_rel_torque(self, fx: float, fy: float, fz: float) -> None: ...
    @overload
    def add_force_at_pos(self, f: Vec3Like, pos: Vec3Like) -> None: ...
    @overload
    def add_force_at_pos(self, fx: float, fy: float, fz: float, px: float, py: float, pz: float) -> None: ...
    @overload
    def add_force_at_rel_pos(self, f: Vec3Like, pos: Vec3Like) -> None: ...
    @overload
    def add_force_at_rel_pos(self, fx: float, fy: float, fz: float, px: float, py: float, pz: float) -> None: ...
    @overload
    def add_rel_force_at_pos(self, f: Vec3Like, pos: Vec3Like) -> None: ...
    @overload
    def add_rel_force_at_pos(self, fx: float, fy: float, fz: float, px: float, py: float, pz: float) -> None: ...
    @overload
    def add_rel_force_at_rel_pos(self, f: Vec3Like, pos: Vec3Like) -> None: ...
    @overload
    def add_rel_force_at_rel_pos(self, fx: float, fy: float, fz: float, px: float, py: float, pz: float) -> None: ...
    @overload
    def set_force(self, f: Vec3Like) -> None: ...
    @overload
    def set_force(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_torque(self, f: Vec3Like) -> None: ...
    @overload
    def set_torque(self, x: float, y: float, z: float) -> None: ...
    @overload
    def get_rel_point_pos(self, pos: Vec3Like) -> LPoint3f: ...
    @overload
    def get_rel_point_pos(self, px: float, py: float, pz: float) -> LPoint3f: ...
    @overload
    def get_rel_point_vel(self, pos: Vec3Like) -> LPoint3f: ...
    @overload
    def get_rel_point_vel(self, px: float, py: float, pz: float) -> LPoint3f: ...
    @overload
    def get_point_vel(self, pos: Vec3Like) -> LPoint3f: ...
    @overload
    def get_point_vel(self, px: float, py: float, pz: float) -> LPoint3f: ...
    @overload
    def get_pos_rel_point(self, pos: Vec3Like) -> LPoint3f: ...
    @overload
    def get_pos_rel_point(self, px: float, py: float, pz: float) -> LPoint3f: ...
    @overload
    def vector_to_world(self, pos: Vec3Like) -> LVecBase3f: ...
    @overload
    def vector_to_world(self, px: float, py: float, pz: float) -> LVecBase3f: ...
    @overload
    def vector_from_world(self, pos: Vec3Like) -> LVecBase3f: ...
    @overload
    def vector_from_world(self, px: float, py: float, pz: float) -> LVecBase3f: ...
    def set_finite_rotation_mode(self, mode: int) -> None: ...
    @overload
    def set_finite_rotation_axis(self, axis: Vec3Like) -> None: ...
    @overload
    def set_finite_rotation_axis(self, x: float, y: float, z: float) -> None: ...
    def get_finite_rotation_mode(self) -> int: ...
    def get_finite_rotation_axis(self) -> LVecBase3f: ...
    def get_num_joints(self) -> int: ...
    def get_joint(self, index: int) -> OdeJoint: ...
    def get_converted_joint(self, i: int): ...
    def enable(self) -> None: ...
    def disable(self) -> None: ...
    def is_enabled(self) -> int: ...
    def set_gravity_mode(self, mode: int) -> None: ...
    def get_gravity_mode(self) -> int: ...
    def write(self, out: ostream = ..., indent: int = ...) -> None: ...
    def compare_to(self, other: OdeBody) -> int: ...
    def get_joints(self) -> tuple[OdeJoint, ...]: ...
    isEmpty = is_empty
    getId = get_id
    setAutoDisableLinearThreshold = set_auto_disable_linear_threshold
    setAutoDisableAngularThreshold = set_auto_disable_angular_threshold
    setAutoDisableSteps = set_auto_disable_steps
    setAutoDisableTime = set_auto_disable_time
    setAutoDisableFlag = set_auto_disable_flag
    setAutoDisableDefaults = set_auto_disable_defaults
    setData = set_data
    setPosition = set_position
    setRotation = set_rotation
    setQuaternion = set_quaternion
    setLinearVel = set_linear_vel
    setAngularVel = set_angular_vel
    setMass = set_mass
    getAutoDisableLinearThreshold = get_auto_disable_linear_threshold
    getAutoDisableAngularThreshold = get_auto_disable_angular_threshold
    getAutoDisableSteps = get_auto_disable_steps
    getAutoDisableTime = get_auto_disable_time
    getAutoDisableFlag = get_auto_disable_flag
    getData = get_data
    getPosition = get_position
    getRotation = get_rotation
    getQuaternion = get_quaternion
    getLinearVel = get_linear_vel
    getAngularVel = get_angular_vel
    getMass = get_mass
    addForce = add_force
    addTorque = add_torque
    addRelForce = add_rel_force
    addRelTorque = add_rel_torque
    addForceAtPos = add_force_at_pos
    addForceAtRelPos = add_force_at_rel_pos
    addRelForceAtPos = add_rel_force_at_pos
    addRelForceAtRelPos = add_rel_force_at_rel_pos
    setForce = set_force
    setTorque = set_torque
    getRelPointPos = get_rel_point_pos
    getRelPointVel = get_rel_point_vel
    getPointVel = get_point_vel
    getPosRelPoint = get_pos_rel_point
    vectorToWorld = vector_to_world
    vectorFromWorld = vector_from_world
    setFiniteRotationMode = set_finite_rotation_mode
    setFiniteRotationAxis = set_finite_rotation_axis
    getFiniteRotationMode = get_finite_rotation_mode
    getFiniteRotationAxis = get_finite_rotation_axis
    getNumJoints = get_num_joints
    getJoint = get_joint
    getConvertedJoint = get_converted_joint
    isEnabled = is_enabled
    setGravityMode = set_gravity_mode
    getGravityMode = get_gravity_mode
    compareTo = compare_to
    getJoints = get_joints

class OdeSpace(TypedObject):
    def __bool__(self) -> bool: ...
    def destroy(self) -> None: ...
    def is_empty(self) -> bool:
        """Returns true if the ID is 0, meaning the OdeSpace does not point to a valid
        space.  It is an error to call a method on an empty space.  Note that an
        empty OdeSpace also evaluates to False.
        """
    def set_cleanup(self, mode: int) -> None: ...
    def get_cleanup(self) -> int: ...
    @overload
    def query(self, geom: OdeGeom) -> int: ...
    @overload
    def query(self, space: OdeSpace) -> int: ...
    def get_num_geoms(self) -> int: ...
    def get_AABB(self, min: Vec3Like, max: Vec3Like) -> None: ...
    def get_AA_bounds(self) -> tuple[LPoint3f, LPoint3f]: ...
    def is_space(self) -> int: ...
    def get_class(self) -> int: ...
    def set_category_bits(self, bits: BitMask32 | int) -> None: ...
    def set_collide_bits(self, bits: BitMask32 | int) -> None: ...
    def get_category_bits(self) -> BitMask32: ...
    def get_collide_bits(self) -> BitMask32: ...
    def enable(self) -> None: ...
    def disable(self) -> None: ...
    def is_enabled(self) -> int: ...
    def set_auto_collide_world(self, __param0: OdeWorld) -> None: ...
    def set_auto_collide_joint_group(self, __param0: OdeJointGroup) -> None: ...
    @overload
    def add(self, geom: OdeGeom) -> None: ...
    @overload
    def add(self, space: OdeSpace) -> None: ...
    @overload
    def remove(self, geom: OdeGeom) -> None: ...
    @overload
    def remove(self, space: OdeSpace) -> None: ...
    def clean(self) -> None: ...
    def get_geom(self, i: int) -> OdeGeom: ...
    def get_space(self) -> OdeSpace: ...
    def write(self, out: ostream = ..., indent: int = ...) -> None: ...
    def convert_to_simple_space(self) -> OdeSimpleSpace: ...
    def convert_to_hash_space(self) -> OdeHashSpace: ...
    def convert_to_quad_tree_space(self) -> OdeQuadTreeSpace: ...
    def convert(self): ...
    def get_converted_geom(self, i: int): ...
    def get_converted_space(self): ...
    def auto_collide(self) -> None: ...
    def collide(self, arg, near_callback) -> int: ...
    @overload
    def set_collide_id(self, geom: OdeGeom, collide_id: int) -> int: ...
    @overload
    def set_collide_id(self, collide_id: int, id: dxGeom) -> int: ...
    @overload
    def set_surface_type(self, geom: OdeGeom, surface_type: int) -> None: ...
    @overload
    def set_surface_type(self, surface_type: int, id: dxGeom) -> None: ...
    @overload
    def get_surface_type(self, geom: OdeGeom) -> int: ...
    @overload
    def get_surface_type(self, o1: dxGeom) -> int: ...
    @overload
    def get_collide_id(self, geom: OdeGeom) -> int: ...
    @overload
    def get_collide_id(self, o1: dxGeom) -> int: ...
    def set_collision_event(self, event_name: str) -> None: ...
    def get_collision_event(self) -> str: ...
    isEmpty = is_empty
    setCleanup = set_cleanup
    getCleanup = get_cleanup
    getNumGeoms = get_num_geoms
    getAABB = get_AABB
    getAABounds = get_AA_bounds
    isSpace = is_space
    getClass = get_class
    setCategoryBits = set_category_bits
    setCollideBits = set_collide_bits
    getCategoryBits = get_category_bits
    getCollideBits = get_collide_bits
    isEnabled = is_enabled
    setAutoCollideWorld = set_auto_collide_world
    setAutoCollideJointGroup = set_auto_collide_joint_group
    getGeom = get_geom
    getSpace = get_space
    convertToSimpleSpace = convert_to_simple_space
    convertToHashSpace = convert_to_hash_space
    convertToQuadTreeSpace = convert_to_quad_tree_space
    getConvertedGeom = get_converted_geom
    getConvertedSpace = get_converted_space
    autoCollide = auto_collide
    setCollideId = set_collide_id
    setSurfaceType = set_surface_type
    getSurfaceType = get_surface_type
    getCollideId = get_collide_id
    setCollisionEvent = set_collision_event
    getCollisionEvent = get_collision_event

class OdeGeom(TypedObject):
    GC_sphere: Final[Literal[0]]
    GCSphere: Final[Literal[0]]
    GC_box: Final[Literal[1]]
    GCBox: Final[Literal[1]]
    GC_capped_cylinder: Final[Literal[2]]
    GCCappedCylinder: Final[Literal[2]]
    GC_cylinder: Final[Literal[3]]
    GCCylinder: Final[Literal[3]]
    GC_plane: Final[Literal[4]]
    GCPlane: Final[Literal[4]]
    GC_ray: Final[Literal[5]]
    GCRay: Final[Literal[5]]
    GC_tri_mesh: Final[Literal[8]]
    GCTriMesh: Final[Literal[8]]
    GC_simple_space: Final[Literal[10]]
    GCSimpleSpace: Final[Literal[10]]
    GC_hash_space: Final[Literal[11]]
    GCHashSpace: Final[Literal[11]]
    GC_quad_tree_space: Final[Literal[12]]
    GCQuadTreeSpace: Final[Literal[12]]
    def __bool__(self) -> bool: ...
    def destroy(self) -> None: ...
    def is_empty(self) -> bool:
        """Returns true if the ID is 0, meaning the OdeGeom does not point to a valid
        geom.  It is an error to call a method on an empty geom.  Note that an
        empty OdeGeom also evaluates to False.
        """
    def get_id(self) -> dxGeom:
        """Returns the underlying dGeomID."""
    def set_body(self, body: OdeBody) -> None:
        """INLINE void set_data(void* data);"""
    def has_body(self) -> bool: ...
    def get_body(self) -> OdeBody: ...
    @overload
    def set_position(self, pos: Vec3Like) -> None: ...
    @overload
    def set_position(self, x: float, y: float, z: float) -> None: ...
    def set_rotation(self, r: LMatrix3f) -> None: ...
    def set_quaternion(self, q: Vec4Like) -> None: ...
    def get_position(self) -> LPoint3f: ...
    def get_rotation(self) -> LMatrix3f: ...
    def get_quaternion(self) -> LQuaternionf: ...
    def get_AABB(self, min: Vec3Like, max: Vec3Like) -> None: ...
    def get_AA_bounds(self) -> tuple[LPoint3f, LPoint3f]: ...
    def is_space(self) -> int: ...
    def get_class(self) -> int: ...
    def set_category_bits(self, bits: BitMask32 | int) -> None: ...
    def set_collide_bits(self, bits: BitMask32 | int) -> None: ...
    def get_category_bits(self) -> BitMask32: ...
    def get_collide_bits(self) -> BitMask32: ...
    def enable(self) -> None: ...
    def disable(self) -> None: ...
    def is_enabled(self) -> int: ...
    @overload
    def set_offset_position(self, pos: Vec3Like) -> None: ...
    @overload
    def set_offset_position(self, x: float, y: float, z: float) -> None: ...
    def set_offset_rotation(self, r: LMatrix3f) -> None: ...
    def set_offset_quaternion(self, q: Vec4Like) -> None: ...
    @overload
    def set_offset_world_position(self, pos: Vec3Like) -> None: ...
    @overload
    def set_offset_world_position(self, x: float, y: float, z: float) -> None: ...
    def set_offset_world_rotation(self, r: LMatrix3f) -> None: ...
    def set_offset_world_quaternion(self, q: Vec4Like) -> None: ...
    def clear_offset(self) -> None: ...
    def is_offset(self) -> int: ...
    def get_offset_position(self) -> LPoint3f: ...
    def get_offset_rotation(self) -> LMatrix3f: ...
    def get_offset_quaternion(self) -> LQuaternionf: ...
    def get_space(self) -> OdeSpace: ...
    def get_converted_space(self): ...
    def write(self, out: ostream = ..., indent: int = ...) -> None: ...
    def compare_to(self, other: OdeGeom) -> int: ...
    def convert(self): ...
    def convert_to_box(self) -> OdeBoxGeom: ...
    def convert_to_capped_cylinder(self) -> OdeCappedCylinderGeom: ...
    def convert_to_cylinder(self) -> OdeCylinderGeom:
        """OdeConvexGeom convert_to_convex() const;"""
    def convert_to_plane(self) -> OdePlaneGeom:
        """OdeHeightfieldGeom convert_to_heightfield() const;"""
    def convert_to_ray(self) -> OdeRayGeom: ...
    def convert_to_sphere(self) -> OdeSphereGeom: ...
    def convert_to_tri_mesh(self) -> OdeTriMeshGeom: ...
    def convert_to_simple_space(self) -> OdeSimpleSpace: ...
    def convert_to_hash_space(self) -> OdeHashSpace: ...
    def convert_to_quad_tree_space(self) -> OdeQuadTreeSpace: ...
    isEmpty = is_empty
    getId = get_id
    setBody = set_body
    hasBody = has_body
    getBody = get_body
    setPosition = set_position
    setRotation = set_rotation
    setQuaternion = set_quaternion
    getPosition = get_position
    getRotation = get_rotation
    getQuaternion = get_quaternion
    getAABB = get_AABB
    getAABounds = get_AA_bounds
    isSpace = is_space
    getClass = get_class
    setCategoryBits = set_category_bits
    setCollideBits = set_collide_bits
    getCategoryBits = get_category_bits
    getCollideBits = get_collide_bits
    isEnabled = is_enabled
    setOffsetPosition = set_offset_position
    setOffsetRotation = set_offset_rotation
    setOffsetQuaternion = set_offset_quaternion
    setOffsetWorldPosition = set_offset_world_position
    setOffsetWorldRotation = set_offset_world_rotation
    setOffsetWorldQuaternion = set_offset_world_quaternion
    clearOffset = clear_offset
    isOffset = is_offset
    getOffsetPosition = get_offset_position
    getOffsetRotation = get_offset_rotation
    getOffsetQuaternion = get_offset_quaternion
    getSpace = get_space
    getConvertedSpace = get_converted_space
    compareTo = compare_to
    convertToBox = convert_to_box
    convertToCappedCylinder = convert_to_capped_cylinder
    convertToCylinder = convert_to_cylinder
    convertToPlane = convert_to_plane
    convertToRay = convert_to_ray
    convertToSphere = convert_to_sphere
    convertToTriMesh = convert_to_tri_mesh
    convertToSimpleSpace = convert_to_simple_space
    convertToHashSpace = convert_to_hash_space
    convertToQuadTreeSpace = convert_to_quad_tree_space

class OdeBoxGeom(OdeGeom):
    @overload
    def __init__(self, space: OdeSpace, size: Vec3Like) -> None: ...
    @overload
    def __init__(self, lx: float, ly: float, lz: float) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, lx: float, ly: float, lz: float) -> None: ...
    @overload
    def set_lengths(self, size: Vec3Like) -> None: ...
    @overload
    def set_lengths(self, lx: float, ly: float, lz: float) -> None: ...
    def get_lengths(self) -> LVecBase3f: ...
    @overload
    def get_point_depth(self, p: Vec3Like) -> float: ...
    @overload
    def get_point_depth(self, x: float, y: float, z: float) -> float: ...
    setLengths = set_lengths
    getLengths = get_lengths
    getPointDepth = get_point_depth

class OdeCappedCylinderGeom(OdeGeom):
    @overload
    def __init__(self, radius: float, length: float) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, radius: float, length: float) -> None: ...
    def set_params(self, radius: float, length: float) -> None: ...
    def get_radius(self) -> float: ...
    def get_length(self) -> float: ...
    @overload
    def get_point_depth(self, p: Vec3Like) -> float: ...
    @overload
    def get_point_depth(self, x: float, y: float, z: float) -> float: ...
    setParams = set_params
    getRadius = get_radius
    getLength = get_length
    getPointDepth = get_point_depth

class OdeContactGeom(TypedReferenceCount):
    def __init__(self, copy: OdeContactGeom = ...) -> None: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    def get_pos(self) -> LVecBase3f: ...
    def get_normal(self) -> LVecBase3f: ...
    def get_depth(self) -> float: ...
    def get_g1(self) -> OdeGeom: ...
    def get_g2(self) -> OdeGeom: ...
    def get_side1(self) -> int: ...
    def get_side2(self) -> int: ...
    def set_pos(self, pos: Vec3Like) -> None: ...
    def set_normal(self, normal: Vec3Like) -> None: ...
    def set_depth(self, depth: float) -> None: ...
    def set_g1(self, geom: OdeGeom) -> None: ...
    def set_g2(self, geom: OdeGeom) -> None: ...
    getPos = get_pos
    getNormal = get_normal
    getDepth = get_depth
    getG1 = get_g1
    getG2 = get_g2
    getSide1 = get_side1
    getSide2 = get_side2
    setPos = set_pos
    setNormal = set_normal
    setDepth = set_depth
    setG1 = set_g1
    setG2 = set_g2

class OdeCollisionEntry(TypedReferenceCount):
    """A class used to hold information about a collision that has occurred."""

    def __init__(self, __param0: OdeCollisionEntry) -> None: ...
    def __bool__(self) -> bool: ...
    def __getitem__(self, n: int) -> OdeContactGeom: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    def get_geom1(self) -> OdeGeom:
        """Returns the first geom in the collision."""
    def get_geom2(self) -> OdeGeom:
        """Returns the second geom in the collision."""
    def get_body1(self) -> OdeBody:
        """Returns the first body in the collision."""
    def get_body2(self) -> OdeBody:
        """Returns the second body in the collision."""
    def get_num_contacts(self) -> int:
        """Returns the number of contacts in the collision."""
    def get_contact_point(self, n: int) -> LPoint3f:
        """Returns the nth contact point in the collision.  This does exactly the same
        as get_contact_geom(n).get_pos().
        """
    def get_contact_geom(self, n: int) -> OdeContactGeom:
        """Returns the nth contact geom in the collision."""
    def is_empty(self) -> bool:
        """Returns true if the entry holds no contacts."""
    def get_contact_points(self) -> tuple[LPoint3f, ...]: ...
    def get_contact_geoms(self) -> tuple[OdeContactGeom, ...]: ...
    getGeom1 = get_geom1
    getGeom2 = get_geom2
    getBody1 = get_body1
    getBody2 = get_body2
    getNumContacts = get_num_contacts
    getContactPoint = get_contact_point
    getContactGeom = get_contact_geom
    isEmpty = is_empty
    getContactPoints = get_contact_points
    getContactGeoms = get_contact_geoms

class OdeSurfaceParameters(TypedObject):
    MF_contact_mu2: Final[Literal[1]]
    MFContactMu2: Final[Literal[1]]
    MF_contactFDir1: Final[Literal[2]]
    MFContactFDir1: Final[Literal[2]]
    MF_contactBounce: Final[Literal[4]]
    MFContactBounce: Final[Literal[4]]
    MF_contactSoftERP: Final[Literal[8]]
    MFContactSoftERP: Final[Literal[8]]
    MF_contactSoftCFM: Final[Literal[16]]
    MFContactSoftCFM: Final[Literal[16]]
    MF_contactMotion1: Final[Literal[32]]
    MFContactMotion1: Final[Literal[32]]
    MF_contactMotion2: Final[Literal[64]]
    MFContactMotion2: Final[Literal[64]]
    MF_contactSlip1: Final[Literal[128]]
    MFContactSlip1: Final[Literal[128]]
    MF_contactSlip2: Final[Literal[256]]
    MFContactSlip2: Final[Literal[256]]
    MF_contactApprox0: Final[Literal[0]]
    MFContactApprox0: Final[Literal[0]]
    MF_contactApprox1_1: Final[Literal[4096]]
    MFContactApprox11: Final[Literal[4096]]
    MF_contactApprox1_2: Final[Literal[8192]]
    MFContactApprox12: Final[Literal[8192]]
    MF_contactApprox1: Final[Literal[12288]]
    MFContactApprox1: Final[Literal[12288]]
    def __init__(self, mode: int = ..., mu: float = ...) -> None: ...
    def set_mode(self, mode: int) -> None: ...
    def set_mu(self, mu: float) -> None: ...
    def set_mu2(self, mu2: float) -> None: ...
    def set_bounce(self, bounce: float) -> None: ...
    def set_bounce_vel(self, bounce_vel: float) -> None: ...
    def set_soft_erp(self, soft_erp: float) -> None: ...
    def set_soft_cfm(self, soft_cfm: float) -> None: ...
    def set_motion1(self, motion: float) -> None: ...
    def set_motion2(self, motion: float) -> None: ...
    def set_slip1(self, slip: float) -> None: ...
    def set_slip2(self, slip: float) -> None: ...
    def get_mode(self) -> int: ...
    def get_mu(self) -> float: ...
    def get_mu2(self) -> float: ...
    def get_bounce(self) -> float: ...
    def get_bounce_vel(self) -> float: ...
    def get_soft_erp(self) -> float: ...
    def get_soft_cfm(self) -> float: ...
    def get_motion1(self) -> float: ...
    def get_motion2(self) -> float: ...
    def get_slip1(self) -> float: ...
    def get_slip2(self) -> float: ...
    setMode = set_mode
    setMu = set_mu
    setMu2 = set_mu2
    setBounce = set_bounce
    setBounceVel = set_bounce_vel
    setSoftErp = set_soft_erp
    setSoftCfm = set_soft_cfm
    setMotion1 = set_motion1
    setMotion2 = set_motion2
    setSlip1 = set_slip1
    setSlip2 = set_slip2
    getMode = get_mode
    getMu = get_mu
    getMu2 = get_mu2
    getBounce = get_bounce
    getBounceVel = get_bounce_vel
    getSoftErp = get_soft_erp
    getSoftCfm = get_soft_cfm
    getMotion1 = get_motion1
    getMotion2 = get_motion2
    getSlip1 = get_slip1
    getSlip2 = get_slip2

class OdeContact(TypedReferenceCount):
    def __init__(self) -> None: ...
    def get_surface(self) -> OdeSurfaceParameters: ...
    def get_geom(self) -> OdeContactGeom: ...
    def get_fdir1(self) -> LVecBase3f: ...
    def set_surface(self, surface_parameters: OdeSurfaceParameters | int) -> None: ...
    def set_geom(self, contact_geom: OdeContactGeom) -> None: ...
    def set_fdir1(self, fdir1: Vec3Like) -> None: ...
    getSurface = get_surface
    getGeom = get_geom
    getFdir1 = get_fdir1
    setSurface = set_surface
    setGeom = set_geom
    setFdir1 = set_fdir1

class OdeContactJoint(OdeJoint):
    @overload
    def __init__(self, world: OdeWorld, contact: OdeContact) -> None: ...
    @overload
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup, contact: OdeContact) -> None: ...

class OdeCylinderGeom(OdeGeom):
    @overload
    def __init__(self, radius: float, length: float) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, radius: float, length: float) -> None: ...
    def set_params(self, radius: float, length: float) -> None: ...
    def get_radius(self) -> float: ...
    def get_length(self) -> float: ...
    setParams = set_params
    getRadius = get_radius
    getLength = get_length

class OdeFixedJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    def set(self) -> None: ...

class OdeHashSpace(OdeSpace):
    def __init__(self, space: OdeSpace = ...) -> None: ...
    def set_levels(self, minlevel: int, maxlevel: int) -> None: ...
    def get_min_level(self) -> int: ...
    def get_max_level(self) -> int: ...
    setLevels = set_levels
    getMinLevel = get_min_level
    getMaxLevel = get_max_level

class OdeHinge2Joint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    @overload
    def set_anchor(self, anchor: Vec3Like) -> None: ...
    @overload
    def set_anchor(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_axis1(self, axis: Vec3Like) -> None: ...
    @overload
    def set_axis1(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_axis2(self, axis: Vec3Like) -> None: ...
    @overload
    def set_axis2(self, x: float, y: float, z: float) -> None: ...
    def add_torques(self, torque1: float, torque2: float) -> None: ...
    def get_anchor(self) -> LVecBase3f: ...
    def get_anchor2(self) -> LVecBase3f: ...
    def get_axis1(self) -> LVecBase3f: ...
    def get_axis2(self) -> LVecBase3f: ...
    def get_angle1(self) -> float: ...
    def get_angle1_rate(self) -> float: ...
    def get_angle2_rate(self) -> float: ...
    def set_param_lo_stop(self, axis: int, val: float) -> None: ...
    def set_param_hi_stop(self, axis: int, val: float) -> None: ...
    def set_param_vel(self, axis: int, val: float) -> None: ...
    def set_param_f_max(self, axis: int, val: float) -> None: ...
    def set_param_fudge_factor(self, axis: int, val: float) -> None: ...
    def set_param_bounce(self, axis: int, val: float) -> None: ...
    def set_param_CFM(self, axis: int, val: float) -> None: ...
    def set_param_stop_ERP(self, axis: int, val: float) -> None: ...
    def set_param_stop_CFM(self, axis: int, val: float) -> None: ...
    def set_param_suspension_ERP(self, axis: int, val: float) -> None: ...
    def set_param_suspension_CFM(self, axis: int, val: float) -> None: ...
    def get_param_lo_stop(self, axis: int) -> float: ...
    def get_param_hi_stop(self, axis: int) -> float: ...
    def get_param_vel(self, axis: int) -> float: ...
    def get_param_f_max(self, axis: int) -> float: ...
    def get_param_fudge_factor(self, axis: int) -> float: ...
    def get_param_bounce(self, axis: int) -> float: ...
    def get_param_CFM(self, axis: int) -> float: ...
    def get_param_stop_ERP(self, axis: int) -> float: ...
    def get_param_stop_CFM(self, axis: int) -> float: ...
    def get_param_suspension_ERP(self, axis: int) -> float: ...
    def get_param_suspension_CFM(self, axis: int) -> float: ...
    setAnchor = set_anchor
    setAxis1 = set_axis1
    setAxis2 = set_axis2
    addTorques = add_torques
    getAnchor = get_anchor
    getAnchor2 = get_anchor2
    getAxis1 = get_axis1
    getAxis2 = get_axis2
    getAngle1 = get_angle1
    getAngle1Rate = get_angle1_rate
    getAngle2Rate = get_angle2_rate
    setParamLoStop = set_param_lo_stop
    setParamHiStop = set_param_hi_stop
    setParamVel = set_param_vel
    setParamFMax = set_param_f_max
    setParamFudgeFactor = set_param_fudge_factor
    setParamBounce = set_param_bounce
    setParamCFM = set_param_CFM
    setParamStopERP = set_param_stop_ERP
    setParamStopCFM = set_param_stop_CFM
    setParamSuspensionERP = set_param_suspension_ERP
    setParamSuspensionCFM = set_param_suspension_CFM
    getParamLoStop = get_param_lo_stop
    getParamHiStop = get_param_hi_stop
    getParamVel = get_param_vel
    getParamFMax = get_param_f_max
    getParamFudgeFactor = get_param_fudge_factor
    getParamBounce = get_param_bounce
    getParamCFM = get_param_CFM
    getParamStopERP = get_param_stop_ERP
    getParamStopCFM = get_param_stop_CFM
    getParamSuspensionERP = get_param_suspension_ERP
    getParamSuspensionCFM = get_param_suspension_CFM

class OdeHingeJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    @overload
    def set_anchor(self, anchor: Vec3Like) -> None: ...
    @overload
    def set_anchor(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_anchor_delta(self, anchor: Vec3Like, vec: Vec3Like) -> None: ...
    @overload
    def set_anchor_delta(self, x: float, y: float, z: float, ax: float, ay: float, az: float) -> None: ...
    @overload
    def set_axis(self, axis: Vec3Like) -> None: ...
    @overload
    def set_axis(self, x: float, y: float, z: float) -> None: ...
    def add_torque(self, torque: float) -> None: ...
    def get_anchor(self) -> LVecBase3f: ...
    def get_anchor2(self) -> LVecBase3f: ...
    def get_axis(self) -> LVecBase3f: ...
    def get_angle(self) -> float: ...
    def get_angle_rate(self) -> float: ...
    def set_param_lo_stop(self, val: float) -> None: ...
    def set_param_hi_stop(self, val: float) -> None: ...
    def set_param_vel(self, val: float) -> None: ...
    def set_param_f_max(self, val: float) -> None: ...
    def set_param_fudge_factor(self, val: float) -> None: ...
    def set_param_bounce(self, val: float) -> None: ...
    def set_param_CFM(self, val: float) -> None: ...
    def set_param_stop_ERP(self, val: float) -> None: ...
    def set_param_stop_CFM(self, val: float) -> None: ...
    def get_param_lo_stop(self) -> float: ...
    def get_param_hi_stop(self) -> float: ...
    def get_param_vel(self) -> float: ...
    def get_param_f_max(self) -> float: ...
    def get_param_fudge_factor(self) -> float: ...
    def get_param_bounce(self) -> float: ...
    def get_param_CFM(self) -> float: ...
    def get_param_stop_ERP(self) -> float: ...
    def get_param_stop_CFM(self) -> float: ...
    setAnchor = set_anchor
    setAnchorDelta = set_anchor_delta
    setAxis = set_axis
    addTorque = add_torque
    getAnchor = get_anchor
    getAnchor2 = get_anchor2
    getAxis = get_axis
    getAngle = get_angle
    getAngleRate = get_angle_rate
    setParamLoStop = set_param_lo_stop
    setParamHiStop = set_param_hi_stop
    setParamVel = set_param_vel
    setParamFMax = set_param_f_max
    setParamFudgeFactor = set_param_fudge_factor
    setParamBounce = set_param_bounce
    setParamCFM = set_param_CFM
    setParamStopERP = set_param_stop_ERP
    setParamStopCFM = set_param_stop_CFM
    getParamLoStop = get_param_lo_stop
    getParamHiStop = get_param_hi_stop
    getParamVel = get_param_vel
    getParamFMax = get_param_f_max
    getParamFudgeFactor = get_param_fudge_factor
    getParamBounce = get_param_bounce
    getParamCFM = get_param_CFM
    getParamStopERP = get_param_stop_ERP
    getParamStopCFM = get_param_stop_CFM

class OdeJointCollection:
    DtoolClassDict: ClassVar[dict[str, Any]]
    def __init__(self, copy: OdeJointCollection = ...) -> None: ...
    def __getitem__(self, index: int) -> OdeJoint: ...
    def __len__(self) -> int: ...
    def __iadd__(self: Self, other: OdeJointCollection) -> Self: ...
    def __add__(self, other: OdeJointCollection) -> OdeJointCollection: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    def __iter__(self) -> Iterator[OdeJoint]: ...  # Doesn't actually exist
    def assign(self: Self, copy: Self) -> Self: ...
    def add_joint(self, joint: OdeJoint) -> None: ...
    def remove_joint(self, joint: OdeJoint) -> bool: ...
    def add_joints_from(self, other: OdeJointCollection) -> None: ...
    def remove_joints_from(self, other: OdeJointCollection) -> None: ...
    def remove_duplicate_joints(self) -> None: ...
    def has_joint(self, joint: OdeJoint) -> bool: ...
    def clear(self) -> None: ...
    def is_empty(self) -> bool: ...
    def get_num_joints(self) -> int: ...
    def get_joint(self, index: int) -> OdeJoint: ...
    def get_joints(self) -> tuple[OdeJoint, ...]: ...
    addJoint = add_joint
    removeJoint = remove_joint
    addJointsFrom = add_joints_from
    removeJointsFrom = remove_joints_from
    removeDuplicateJoints = remove_duplicate_joints
    hasJoint = has_joint
    isEmpty = is_empty
    getNumJoints = get_num_joints
    getJoint = get_joint
    getJoints = get_joints

class OdeLMotorJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    def set_num_axes(self, num: int) -> None: ...
    @overload
    def set_axis(self, anum: int, rel: int, axis: Vec3Like) -> None: ...
    @overload
    def set_axis(self, anum: int, rel: int, x: float, y: float, z: float) -> None: ...
    def set_param(self, parameter: int, value: float) -> None: ...
    def get_num_axes(self) -> int: ...
    def get_axis(self, anum: int) -> LVecBase3f: ...
    def get_param(self, parameter: int) -> float: ...
    def get_axes(self) -> tuple[LVecBase3f, ...]: ...
    setNumAxes = set_num_axes
    setAxis = set_axis
    setParam = set_param
    getNumAxes = get_num_axes
    getAxis = get_axis
    getParam = get_param
    getAxes = get_axes

class OdeNullJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...

class OdePlane2dJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    def set_x_param(self, parameter: int, value: float) -> None: ...
    def set_y_param(self, parameter: int, value: float) -> None: ...
    def set_angle_param(self, parameter: int, value: float) -> None: ...
    setXParam = set_x_param
    setYParam = set_y_param
    setAngleParam = set_angle_param

class OdePlaneGeom(OdeGeom):
    @overload
    def __init__(self, params: Vec4Like) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, params: Vec4Like) -> None: ...
    @overload
    def __init__(self, a: float, b: float, c: float, d: float) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, a: float, b: float, c: float, d: float) -> None: ...
    @overload
    def set_params(self, params: Vec4Like) -> None: ...
    @overload
    def set_params(self, a: float, b: float, c: float, d: float) -> None: ...
    def get_params(self) -> LVecBase4f: ...
    @overload
    def get_point_depth(self, p: Vec3Like) -> float: ...
    @overload
    def get_point_depth(self, x: float, y: float, z: float) -> float: ...
    setParams = set_params
    getParams = get_params
    getPointDepth = get_point_depth

class OdeQuadTreeSpace(OdeSpace):
    @overload
    def __init__(self, center: Vec3Like, extents: Vec3Like, depth: int) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, center: Vec3Like, extents: Vec3Like, depth: int) -> None: ...

class OdeRayGeom(OdeGeom):
    @overload
    def __init__(self, length: float) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, length: float) -> None: ...
    def set_length(self, length: float) -> None: ...
    def get_length(self) -> float: ...
    @overload
    def set(self, start: Vec3Like, dir: Vec3Like) -> None: ...
    @overload
    def set(self, px: float, py: float, pz: float, dx: float, dy: float, dz: float) -> None: ...
    def get(self, start: Vec3Like, dir: Vec3Like) -> None: ...
    def get_start(self) -> LVecBase3f: ...
    def get_direction(self) -> LVecBase3f: ...
    def set_params(self, first_contact: int, backface_cull: int) -> None: ...
    def get_first_contact(self) -> int: ...
    def get_backface_cull(self) -> int: ...
    def set_closest_hit(self, closest_hit: int) -> None: ...
    def get_closest_hit(self) -> int: ...
    setLength = set_length
    getLength = get_length
    getStart = get_start
    getDirection = get_direction
    setParams = set_params
    getFirstContact = get_first_contact
    getBackfaceCull = get_backface_cull
    setClosestHit = set_closest_hit
    getClosestHit = get_closest_hit

class OdeSimpleSpace(OdeSpace):
    def __init__(self, space: OdeSpace = ...) -> None: ...

class OdeSliderJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    @overload
    def set_axis(self, axis: Vec3Like) -> None: ...
    @overload
    def set_axis(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_axis_delta(self, axis: Vec3Like, vec: Vec3Like) -> None: ...
    @overload
    def set_axis_delta(self, x: float, y: float, z: float, ax: float, ay: float, az: float) -> None: ...
    def add_force(self, force: float) -> None: ...
    def get_position(self) -> float: ...
    def get_position_rate(self) -> float: ...
    def get_axis(self) -> LVecBase3f: ...
    def set_param_lo_stop(self, val: float) -> None: ...
    def set_param_hi_stop(self, val: float) -> None: ...
    def set_param_vel(self, val: float) -> None: ...
    def set_param_f_max(self, val: float) -> None: ...
    def set_param_fudge_factor(self, val: float) -> None: ...
    def set_param_bounce(self, val: float) -> None: ...
    def set_param_CFM(self, val: float) -> None: ...
    def set_param_stop_ERP(self, val: float) -> None: ...
    def set_param_stop_CFM(self, val: float) -> None: ...
    def get_param_lo_stop(self) -> float: ...
    def get_param_hi_stop(self) -> float: ...
    def get_param_vel(self) -> float: ...
    def get_param_f_max(self) -> float: ...
    def get_param_fudge_factor(self) -> float: ...
    def get_param_bounce(self) -> float: ...
    def get_param_CFM(self) -> float: ...
    def get_param_stop_ERP(self) -> float: ...
    def get_param_stop_CFM(self) -> float: ...
    setAxis = set_axis
    setAxisDelta = set_axis_delta
    addForce = add_force
    getPosition = get_position
    getPositionRate = get_position_rate
    getAxis = get_axis
    setParamLoStop = set_param_lo_stop
    setParamHiStop = set_param_hi_stop
    setParamVel = set_param_vel
    setParamFMax = set_param_f_max
    setParamFudgeFactor = set_param_fudge_factor
    setParamBounce = set_param_bounce
    setParamCFM = set_param_CFM
    setParamStopERP = set_param_stop_ERP
    setParamStopCFM = set_param_stop_CFM
    getParamLoStop = get_param_lo_stop
    getParamHiStop = get_param_hi_stop
    getParamVel = get_param_vel
    getParamFMax = get_param_f_max
    getParamFudgeFactor = get_param_fudge_factor
    getParamBounce = get_param_bounce
    getParamCFM = get_param_CFM
    getParamStopERP = get_param_stop_ERP
    getParamStopCFM = get_param_stop_CFM

class OdeSphereGeom(OdeGeom):
    @overload
    def __init__(self, geom: OdeGeom) -> None: ...
    @overload
    def __init__(self, radius: float) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, radius: float) -> None: ...
    def set_radius(self, radius: float) -> None: ...
    def get_radius(self) -> float: ...
    @overload
    def get_point_depth(self, p: Vec3Like) -> float: ...
    @overload
    def get_point_depth(self, x: float, y: float, z: float) -> float: ...
    setRadius = set_radius
    getRadius = get_radius
    getPointDepth = get_point_depth

class OdeTriMeshData(TypedReferenceCount):
    DT_face_normals: Final[Literal[0]]
    DTFaceNormals: Final[Literal[0]]
    DT_last_transformation: Final[Literal[1]]
    DTLastTransformation: Final[Literal[1]]
    def __init__(self, model: NodePath, use_normals: bool = ...) -> None: ...
    def destroy(self) -> None: ...
    def write(self, out: ostream = ..., indent: int = ...) -> None: ...
    def write_faces(self, out: ostream) -> None: ...
    writeFaces = write_faces

class OdeTriMeshGeom(OdeGeom):
    @overload
    def __init__(self, data: NodePath | OdeTriMeshData) -> None:
        """ODE_API dGeomID dCreateTriMesh(dSpaceID space, dTriMeshDataID Data, dTriCallback* Callback, dTriArrayCallback* ArrayCallback, dTriRayCallback* RayCallback);"""
    @overload
    def __init__(self, copy: NodePath | OdeTriMeshData | OdeTriMeshGeom) -> None: ...
    @overload
    def __init__(self, space: OdeSpace, data: NodePath | OdeTriMeshData) -> None: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    def set_tri_mesh_data(self, data: NodePath | OdeTriMeshData) -> None: ...
    def get_tri_mesh_data(self) -> OdeTriMeshData: ...
    def set_data(self, data: NodePath | OdeTriMeshData) -> None: ...
    def get_data(self) -> OdeTriMeshData: ...
    def enable_TC(self, geom_class: int, enable: int) -> None: ...
    def is_TC_enabled(self, geom_class: int) -> int: ...
    def clear_TC_cache(self, geom: OdeGeom) -> None: ...
    def get_triangle(self, face_index: int, v0: Vec3Like, v1: Vec3Like, v2: Vec3Like) -> None: ...
    def get_point(self, face_index: int, u: float, v: float) -> LPoint3f: ...
    def get_num_triangles(self) -> int: ...
    setTriMeshData = set_tri_mesh_data
    getTriMeshData = get_tri_mesh_data
    setData = set_data
    getData = get_data
    enableTC = enable_TC
    isTCEnabled = is_TC_enabled
    clearTCCache = clear_TC_cache
    getTriangle = get_triangle
    getPoint = get_point
    getNumTriangles = get_num_triangles

class OdeUniversalJoint(OdeJoint):
    def __init__(self, world: OdeWorld, joint_group: OdeJointGroup = ...) -> None: ...
    @overload
    def set_anchor(self, anchor: Vec3Like) -> None: ...
    @overload
    def set_anchor(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_axis1(self, axis: Vec3Like) -> None: ...
    @overload
    def set_axis1(self, x: float, y: float, z: float) -> None: ...
    @overload
    def set_axis2(self, axis: Vec3Like) -> None: ...
    @overload
    def set_axis2(self, x: float, y: float, z: float) -> None: ...
    def add_torques(self, torque1: float, torque2: float) -> None: ...
    def get_anchor(self) -> LVecBase3f: ...
    def get_anchor2(self) -> LVecBase3f: ...
    def get_axis1(self) -> LVecBase3f: ...
    def get_axis2(self) -> LVecBase3f: ...
    def get_angle1(self) -> float: ...
    def get_angle2(self) -> float: ...
    def get_angle1_rate(self) -> float: ...
    def get_angle2_rate(self) -> float: ...
    def set_param_lo_stop(self, axis: int, val: float) -> None: ...
    def set_param_hi_stop(self, axis: int, val: float) -> None: ...
    def set_param_vel(self, axis: int, val: float) -> None: ...
    def set_param_f_max(self, axis: int, val: float) -> None: ...
    def set_param_fudge_factor(self, axis: int, val: float) -> None: ...
    def set_param_bounce(self, axis: int, val: float) -> None: ...
    def set_param_CFM(self, axis: int, val: float) -> None: ...
    def set_param_stop_ERP(self, axis: int, val: float) -> None: ...
    def set_param_stop_CFM(self, axis: int, val: float) -> None: ...
    def get_param_lo_stop(self, axis: int) -> float: ...
    def get_param_hi_stop(self, axis: int) -> float: ...
    def get_param_vel(self, axis: int) -> float: ...
    def get_param_f_max(self, axis: int) -> float: ...
    def get_param_fudge_factor(self, axis: int) -> float: ...
    def get_param_bounce(self, axis: int) -> float: ...
    def get_param_CFM(self, axis: int) -> float: ...
    def get_param_stop_ERP(self, axis: int) -> float: ...
    def get_param_stop_CFM(self, axis: int) -> float: ...
    setAnchor = set_anchor
    setAxis1 = set_axis1
    setAxis2 = set_axis2
    addTorques = add_torques
    getAnchor = get_anchor
    getAnchor2 = get_anchor2
    getAxis1 = get_axis1
    getAxis2 = get_axis2
    getAngle1 = get_angle1
    getAngle2 = get_angle2
    getAngle1Rate = get_angle1_rate
    getAngle2Rate = get_angle2_rate
    setParamLoStop = set_param_lo_stop
    setParamHiStop = set_param_hi_stop
    setParamVel = set_param_vel
    setParamFMax = set_param_f_max
    setParamFudgeFactor = set_param_fudge_factor
    setParamBounce = set_param_bounce
    setParamCFM = set_param_CFM
    setParamStopERP = set_param_stop_ERP
    setParamStopCFM = set_param_stop_CFM
    getParamLoStop = get_param_lo_stop
    getParamHiStop = get_param_hi_stop
    getParamVel = get_param_vel
    getParamFMax = get_param_f_max
    getParamFudgeFactor = get_param_fudge_factor
    getParamBounce = get_param_bounce
    getParamCFM = get_param_CFM
    getParamStopERP = get_param_stop_ERP
    getParamStopCFM = get_param_stop_CFM

class OdeUtil:
    DtoolClassDict: ClassVar[dict[str, Any]]
    def __init__(self, __param0: OdeUtil = ...) -> None: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, __memo: object) -> Self: ...
    @staticmethod
    def get_connecting_joint(body1: OdeBody, body2: OdeBody) -> OdeJoint:
        """Returns the joint that connects the given bodies."""
    @staticmethod
    def get_connecting_joint_list(body1: OdeBody, body2: OdeBody) -> OdeJointCollection:
        """Returns a collection of joints connecting the specified bodies."""
    @staticmethod
    def are_connected(body1: OdeBody, body2: OdeBody) -> int:
        """Returns 1 if the given bodies are connected by a joint, returns 0
        otherwise.
        """
    @staticmethod
    def are_connected_excluding(body1: OdeBody, body2: OdeBody, joint_type: int) -> int:
        """Returns 1 if the given bodies are connected by a joint that does not match
        the given joint_type, returns 0 otherwise.  This is useful for deciding
        whether to add contact joints between two bodies: if they are already
        connected by non-contact joints then it may not be appropriate to add
        contacts, however it is okay to add more contact between bodies that
        already have contacts.
        """
    @staticmethod
    def collide(geom1: OdeGeom, geom2: OdeGeom, max_contacts: int = ...) -> OdeCollisionEntry:
        """Given two geometry objects that potentially touch (geom1 and geom2),
        generate contact information for them.  Returns an OdeCollisionEntry.
        """
    @staticmethod
    def collide2(geom1: OdeGeom, geom2: OdeGeom, arg, callback) -> int: ...
    @staticmethod
    def space_to_geom(space: OdeSpace) -> OdeGeom: ...
    @staticmethod
    def get_infinity() -> float:
        """RAU we can't access OC_infinity as constants are not exposed in python"""
    @staticmethod
    def rand_get_seed() -> int: ...
    @staticmethod
    def rand_set_seed(s: int) -> None: ...
    getConnectingJoint = get_connecting_joint
    getConnectingJointList = get_connecting_joint_list
    areConnected = are_connected
    areConnectedExcluding = are_connected_excluding
    spaceToGeom = space_to_geom
    getInfinity = get_infinity
    randGetSeed = rand_get_seed
    randSetSeed = rand_set_seed

DxBody = dxBody
DxGeom = dxGeom
DxJoint = dxJoint
DxJointGroup = dxJointGroup
DxSpace = dxSpace
DxTriMeshData = dxTriMeshData
DxWorld = dxWorld
