__all__ = ['EventManager']

from typing import ClassVar
from typing_extensions import Literal, TypeAlias

from direct.directnotify.Notifier import Notifier
from direct.task.Task import Task
from panda3d.core import Event, EventHandler, EventParameter, EventQueue, TypedReferenceCount, TypedWritableReferenceCount

_EventParameterValue: TypeAlias = int | float | str | TypedReferenceCount | TypedWritableReferenceCount | None

class EventManager:
    notify: ClassVar[Notifier | None]
    eventQueue: EventQueue | None
    eventHandler: EventHandler | None
    def __init__(self, eventQueue: EventQueue | None = ...) -> None: ...
    def do_events(self) -> None: ...
    def eventLoopTask(self, task: Task) -> Literal[1]: ...
    def parseEventParameter(self, eventParameter: EventParameter) -> _EventParameterValue: ...
    def process_event(self, event: Event) -> None: ...
    def processEventPstats(self, event: Event) -> None: ...
    def restart(self) -> None: ...
    def shutdown(self) -> None: ...
    doEvents = do_events
    processEvent = process_event
