__all__ = ['Interval']

from collections.abc import Callable
from tkinter import Toplevel
from typing import ClassVar
from typing_extensions import Literal, TypeAlias

from direct.directnotify.Notifier import Notifier
from direct.showbase.DirectObject import DirectObject
from panda3d.core import PStatCollector, PythonTask

_EventType: TypeAlias = Literal[0, 1, 2, 3, 4, 5, 6, 7]
_State: TypeAlias = Literal[0, 1, 2, 3]

class Interval(DirectObject):
    notify: ClassVar[Notifier]
    playbackCounter: ClassVar[int]
    name: str
    duration: float
    state: _State
    currT: float
    doneEvent: str
    setTHooks: list[Callable[[int], object]]
    pstats: PStatCollector | None
    openEnded: bool
    t: float
    play_rate: float
    done_event: str
    def __init__(self, name: str, duration: float, openEnded: bool = ...) -> None: ...
    def getName(self) -> str: ...
    def getDuration(self) -> float: ...
    def getOpenEnded(self) -> bool: ...
    def setLoop(self, loop: bool = ...) -> None: ...
    def getLoop(self) -> bool: ...
    def getState(self) -> _State: ...
    def isPaused(self) -> bool: ...
    def isStopped(self) -> bool: ...
    def setT(self, t: float) -> None: ...
    def getT(self) -> float: ...
    def start(self, startT: float = ..., endT: float = ..., playRate: float = ...) -> PythonTask: ...
    def loop(self, startT: float = ..., endT: float = ..., playRate: float = ...) -> None: ...
    def pause(self) -> float: ...
    def resume(self, startT: float | None = ...) -> None: ...
    def resumeUntil(self, endT: float) -> None: ...
    def finish(self) -> None: ...
    def clearToInitial(self) -> None: ...
    def isPlaying(self) -> bool: ...
    def getPlayRate(self) -> float: ...
    def setPlayRate(self, playRate: float) -> None: ...
    def setDoneEvent(self, event: str) -> None: ...
    def getDoneEvent(self) -> str: ...
    def privDoEvent(self, t: float, event: _EventType) -> None: ...
    def privInitialize(self, t: float) -> None: ...
    def privInstant(self) -> None: ...
    def privStep(self, t: float) -> None: ...
    def privFinalize(self) -> None: ...
    def privReverseInitialize(self, t: float) -> None: ...
    def privReverseInstant(self) -> None: ...
    def privReverseFinalize(self) -> None: ...
    def privInterrupt(self) -> None: ...
    def intervalDone(self) -> None: ...
    def setupPlay(self, startT: float, endT: float, playRate: float, doLoop: bool) -> None: ...
    def setupResume(self) -> None: ...
    def stepPlay(self) -> bool: ...
    def __repr__(self, indent: int = ...) -> str: ...
    @property
    def open_ended(self) -> bool: ...
    @property
    def stopped(self) -> bool: ...
    def privPostEvent(self) -> None: ...
    def popupControls(self, tl: Toplevel | None = ...) -> None: ...
