"""
Binance C2C REST API

OpenAPI Specification for the Binance C2C REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import GetC2CTradeHistoryResponse


class C2CApi:
    """API Client for C2CApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def get_c2_c_trade_history(
        self,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetC2CTradeHistoryResponse]:
        """
                Get C2C Trade History (USER_DATA)
                GET /sapi/v1/c2c/orderMatch/listUserOrderHistory
                https://developers.binance.com/docs/c2c/rest-api/Get-C2C-Trade-History

                Get C2C Trade History

        * The max interval between startTime and endTime is 30 days.
        * If startTime and endTime are not sent, the recent 7 days' data will be returned.
        * The earliest startTime is supported on June 10, 2020
        * Return up to 200 records per request.

        Weight: 1

                Args:
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    page (Optional[int]): Default 1
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetC2CTradeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/c2c/orderMatch/listUserOrderHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetC2CTradeHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )
