<!--
Please make sure your PR title follows the Conventional Commits specification:
https://www.conventionalcommits.org/

Format: <type>(<scope>): <subject>

Examples:
- feat(auth): add ability to specify custom store ID
- fix: correct typo in README.md
- docs(api): update API documentation with new endpoints
-->

## Description

<!-- Briefly describe the changes in this PR -->

## Type of Change

<!-- Mark the appropriate option with an "x" (e.g. [x]) -->

- [ ] feat: A new feature
- [ ] fix: A bug fix
- [ ] docs: Documentation only changes
- [ ] style: Changes that do not affect the meaning of the code
- [ ] refactor: A code change that neither fixes a bug nor adds a feature
- [ ] perf: A code change that improves performance
- [ ] test: Adding missing tests or correcting existing tests
- [ ] build: Changes that affect the build system or external dependencies
- [ ] ci: Changes to our CI configuration files and scripts
- [ ] chore: Other changes that don't modify src or test files
- [ ] security: Security-related changes

## Scope (Optional)

<!-- What part of the codebase does this PR affect? e.g., auth, api, cli -->

## What

<!-- What changes were made in this PR? -->

## Why

<!-- Why were these changes needed? -->

## How

<!-- How were these changes implemented? -->

## Testing

<!-- How were these changes tested? -->

## Checklist

<!-- Mark the appropriate options with an "x" (e.g. [x]) -->

- [ ] I have read the [CONTRIBUTING](../CONTRIBUTING.md) document
- [ ] My code follows the code style of this project
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] I have updated the documentation accordingly
- [ ] All new and existing tests passed
- [ ] My commit messages follow the [Conventional Commits](https://www.conventionalcommits.org/) specification

## Related Issues

<!-- List any related issues using the GitHub issue linking syntax: -->
<!-- e.g., Closes #123, Fixes #456 -->

## Additional Context

<!-- Add any other context about the PR here. -->
