"""
    University Photo API

     ## Introduction  The Photo API allows access to Photos of members of the University. The Photos exposed by this API are expected to be a good representation of the person they relate to.  The API broadly follows the principles of REST and strives to provide an interface that can be easily consumed by downstream systems.  ### Stability  This release of the Photo API is a `beta` offering: a service we are moving towards live but which requires wider testing with a broader group of users.  ### Versioning  The Photo API is versioned using URL path prefixes in the format: `/v1beta1/photos`. This follows the pattern established by the [GCP API](https://cloud.google.com/apis/design/versioning). Breaking changes will not be made without a change in API major version, however non-breaking changes will be introduced without changes to the version path prefix. All changes will be documented in the project's [CHANGELOG](https://gitlab.developers.cam.ac.uk/uis/devops/iam/photo-api/-/blob/master/CHANGELOG.md)  The available versions of the API are listed at the API's root.  ### Domain  The Photo API serves Photos of members of the University, linking a Photo to an individual through `PhotoIdentifiers` (see below) which pertain to a person record within an external system.  The Photos served by the Photo API are expected to be of sufficient quality to identify the person they represent. Photos which have been reviewed and determined to be sufficient quality are marked as having the status `approved` and exposed through the `approved-photos` endpoints.  ### Data source  The Photos exposed by the Photo API are currently a mirror of card Photos contained within the [Card Database](https://webservices.admin.cam.ac.uk/uc/). With Photos being synced from the Card Database to the Photo API hourly.  In future, the Photo API will be extended to allow Photos to be created and 'approved' using the API.  ## Core entities  ### The `Photo` Entity  The `Photo` entity contains information and metadata about a Photo of a member of the university. The `status` field on a Photo indicates whether this Photo has been reviewed and approved. Only Photos which have the status `approved` are exposed through the `approved-photos` endpoints. Each photo entity has a unique identifier - termed UUID - which is used in the system to refer to the specific photo entity. The UUID is provided in JSON documents as the `id` property.   Each Photo entity contains a link to the image data itself and a thumbnail for this Photo, which is guaranteed to be less than 128x128 pixels. Images are served by redirecting to a temporary URL provided by the service used to host images. These temporary URLs will expire after an hour and should not be retained for long-lasting access to a given Photo.  Each Photo may contain a block of JSON metadata recording information about the Photo. Photos cannot be updated once created (apart from to move their status to `approved`) hence this metadata should not be used to store application state or any other information which is not related to the content of the Photo.  Each Photo will have a set of `PhotoIdentifier` which allow the Photo to be linked to a person record within another system.  ### The `PhotoIdentifier` Entity  The `PhotoIdentifier` entity holds the `value` and `scheme` of a given identifier. The `value` field of a `PhotoIdentifier` is a simple ID string - e.g. `wgd23` or `000001`. The `scheme` field of a `PhotoIdentifier` indicates what system this identifier relates to or was issued by. This allows many identifiers which relate to different systems to be recorded against a single `Photo`.  The supported schemes are: * `v1.person.identifiers.cam.ac.uk`: The CRSID of the person represented by this Photo * `person.v1.student-records.university.identifiers.cam.ac.uk`: The CamSIS identifier (USN) of the person represented by this Photo * `person.v1.human-resources.university.identifiers.cam.ac.uk`: The CHRIS identifier (staff number) of the person represented by this Photo * `photo.v1.legacy-card.university.identifiers.cam.ac.uk`: The id of this Photo within the legacy card system  ## Using the API  ### Auth  To authenticate against the Photo API, an application must be registered within the API Gateway and granted access to the `University Photo` product. Details of how to register an application and grant access to products can be found in the [API Gateway Getting Started Guide](https://developer.api.apps.cam.ac.uk/start-using-an-api).    # noqa: E501

    The version of the OpenAPI document: v1beta1
    Contact: devops+photoapi@uis.cam.ac.uk
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.photo_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.photo_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.photo_client.model.bad_request import BadRequest
from identitylib.photo_client.model.forbidden import Forbidden
from identitylib.photo_client.model.internal_server_error import InternalServerError
from identitylib.photo_client.model.not_found import NotFound
from identitylib.photo_client.model.paginated_v1_beta1_photo_identifier_summary_list import PaginatedV1Beta1PhotoIdentifierSummaryList
from identitylib.photo_client.model.patched_v1_beta1_photo_identifier_summary_request import PatchedV1Beta1PhotoIdentifierSummaryRequest
from identitylib.photo_client.model.unauthorized import Unauthorized


class PhotoIdentifiersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1beta1_photo_identifiers_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedV1Beta1PhotoIdentifierSummaryList,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photo-identifiers',
                'operation_id': 'v1beta1_photo_identifiers_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cursor',
                    'deleted_at__gte',
                    'deleted_at__is_null',
                    'deleted_at__isnull',
                    'deleted_at__lte',
                    'identifier',
                    'page_size',
                    'retain_until__gte',
                    'retain_until__is_null',
                    'retain_until__isnull',
                    'retain_until__lte',
                    'scheme',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cursor':
                        (str,),
                    'deleted_at__gte':
                        (str,),
                    'deleted_at__is_null':
                        (bool,),
                    'deleted_at__isnull':
                        (bool,),
                    'deleted_at__lte':
                        (str,),
                    'identifier':
                        (str,),
                    'page_size':
                        (int,),
                    'retain_until__gte':
                        (str,),
                    'retain_until__is_null':
                        (bool,),
                    'retain_until__isnull':
                        (bool,),
                    'retain_until__lte':
                        (str,),
                    'scheme':
                        (str,),
                },
                'attribute_map': {
                    'cursor': 'cursor',
                    'deleted_at__gte': 'deleted_at__gte',
                    'deleted_at__is_null': 'deleted_at__isNull',
                    'deleted_at__isnull': 'deleted_at__isnull',
                    'deleted_at__lte': 'deleted_at__lte',
                    'identifier': 'identifier',
                    'page_size': 'pageSize',
                    'retain_until__gte': 'retain_until__gte',
                    'retain_until__is_null': 'retain_until__isNull',
                    'retain_until__isnull': 'retain_until__isnull',
                    'retain_until__lte': 'retain_until__lte',
                    'scheme': 'scheme',
                },
                'location_map': {
                    'cursor': 'query',
                    'deleted_at__gte': 'query',
                    'deleted_at__is_null': 'query',
                    'deleted_at__isnull': 'query',
                    'deleted_at__lte': 'query',
                    'identifier': 'query',
                    'page_size': 'query',
                    'retain_until__gte': 'query',
                    'retain_until__is_null': 'query',
                    'retain_until__isnull': 'query',
                    'retain_until__lte': 'query',
                    'scheme': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photo_identifiers_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photo-identifiers/{id}',
                'operation_id': 'v1beta1_photo_identifiers_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'action',
                    'patched_v1_beta1_photo_identifier_summary_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'action',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('action',): {

                        "HARD_DELETE": "hard_delete",
                        "RESTORE": "restore",
                        "SET_RETENTION": "set_retention"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'action':
                        (str,),
                    'patched_v1_beta1_photo_identifier_summary_request':
                        (PatchedV1Beta1PhotoIdentifierSummaryRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'action': 'action',
                },
                'location_map': {
                    'id': 'path',
                    'action': 'query',
                    'patched_v1_beta1_photo_identifier_summary_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def v1beta1_photo_identifiers_list(
        self,
        **kwargs
    ):
        """List photo identifiers  # noqa: E501

         ## List photo identifiers  Returns a list of photo identifiers associated with the photos.  ### Permissions  Principals with the `PHOTO_VIEWER` permission are able to view all photo identifiers contained within the photo system.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photo_identifiers_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cursor (str): The pagination cursor value.. [optional]
            deleted_at__gte (str): Filter deletedAt by IsoDateTime greater than. [optional]
            deleted_at__is_null (bool): Filter deletedAt by IsoDateTime is Null. [optional]
            deleted_at__isnull (bool): [optional]
            deleted_at__lte (str): Filter deletedAt by IsoDateTime less than. [optional]
            identifier (str): PhotoIdentifier to get photos for using format `<value>@<scheme>`. [optional]
            page_size (int): Number of results to return per page.. [optional]
            retain_until__gte (str): Filter retainUntil by IsoDateTime greater than. [optional]
            retain_until__is_null (bool): Filter retainUntil by IsoDateTime is Null. [optional]
            retain_until__isnull (bool): [optional]
            retain_until__lte (str): Filter retainUntil by IsoDateTime less than. [optional]
            scheme (str): PhotoIdentifier scheme to get photos for using format `<scheme>`. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedV1Beta1PhotoIdentifierSummaryList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.v1beta1_photo_identifiers_list_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photo_identifiers_partial_update(
        self,
        id,
        **kwargs
    ):
        """Update a photo identifier by photo identifier UUID.  # noqa: E501

         ## Update the photo identifier  This method allows a client to submit an action in the request query for a given photo identifier. The allowed actions are `set_retention`, `restore` and `hard_delete`.  ### Permissions  Principals with the `CARD_ADMIN` permission will be able to affect this endpoint.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photo_identifiers_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo identifier.

        Keyword Args:
            action (str): Action applied to the photo identifier.. [optional]
            patched_v1_beta1_photo_identifier_summary_request (PatchedV1Beta1PhotoIdentifierSummaryRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photo_identifiers_partial_update_endpoint.call_with_http_info(**kwargs)

