// Copyright (c) Mito
import React from 'react';
/*
    At the top of the file browser, users can select
    pieces of the path.
*/
function FileBrowserPathSelector(props) {
    var _a;
    /*
        Updates the selected path to go back up some number
        of folders to a given index.
    */
    const updateSelectedPath = (i) => {
        if (props.pathParts === undefined) {
            return;
        }
        const subPathParts = props.pathParts.slice(0, i + 1);
        props.setCurrPathParts(subPathParts);
    };
    return (React.createElement("div", { className: 'flexbox-row file-browser-path-selector' }, (_a = props.pathParts) === null || _a === void 0 ? void 0 : _a.map((pathPart, i) => {
        // We do not display the leading part of the path that
        // does not add anything to the users information
        if (pathPart === '/' || pathPart === '' || pathPart == 'C:' || pathPart === 'D:') {
            return React.createElement(React.Fragment, null);
        }
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'file-browser-path-part', key: i, onClick: () => { updateSelectedPath(i); } }, pathPart),
            React.createElement("div", { className: 'file-browser-path-seperator' }, "/")));
    })));
}
export default FileBrowserPathSelector;
//# sourceMappingURL=FileBrowserPathSelector.js.map