// Copyright (c) Mito
import React, { useEffect, useState, useRef } from 'react';
import '../../../css/elements/Input.css';
import { classNames } from '../../utils/classNames';
/**
 * The input component is a text field that allows the user
 * to input a single item. It is meant for a single line of text,
 * like an email!
 */
const Input = (props) => {
    const ref = useRef(null);
    // We store the width as state so that we can update it on focus
    // if there is a widthOnFocus
    const [width, setWidth] = useState(props.width);
    // Make defaults easier to work with
    const widthWithDefault = width || 'block';
    const autoFocus = props.autoFocus || false;
    const widthClass = `element-width-${widthWithDefault}`;
    // If there is right text, then we calcuate how much padding to give it, so that it doesn't
    // overlap with the text that is being typed in the input. We give 6px to each letter of the
    // text, and for a 5px padding on each side of the text
    const paddingRight = props.rightText !== undefined ? props.rightText.length * 6 + 10 : undefined;
    /*
        Setting the autoFocus field on the input element only seems to work when the input field
        is inside of a form. Many times, the input fields we want to autofocus on is not part of a
        form in Mito. So here, we manually set the focus.
    */
    useEffect(() => {
        var _a;
        if (autoFocus) {
            (_a = ref.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, []);
    return (React.createElement("div", { className: 'input-container' },
        React.createElement("input", { id: props.id, className: classNames('input', 'text-body-2', widthClass, props.className), style: { paddingRight: paddingRight }, value: props.value, placeholder: props.placeholder, onKeyDown: props.onKeyDown, onKeyPress: props.onKeyPress, onChange: props.onChange, onClick: props.onClick, onDoubleClick: props.onDoubleClick, autoFocus: props.autoFocus, required: props.required, disabled: props.disabled, ref: ref, onFocus: (e) => {
                if (props.onFocus !== undefined) {
                    props.onFocus(e);
                }
                if (props.widthOnFocus !== undefined) {
                    setWidth(props.widthOnFocus);
                }
            }, onBlur: (e) => {
                if (props.onBlur !== undefined) {
                    props.onBlur(e);
                }
                setWidth(props.width);
            } }),
        props.rightText &&
            React.createElement("div", { className: 'input-right-text' }, props.rightText)));
};
export default Input;
//# sourceMappingURL=Input.js.map