# AUTOGENERATED! DO NOT EDIT! File to edit: 01_PreProcessor.ipynb (unless otherwise specified).

__all__ = ['PreProcessor']

# Cell
from .DataFrameLoader import *

# Cell
# hide
import pandas as pd
from sklearn.compose import ColumnTransformer
from sklearn.pipeline import Pipeline
from sklearn.impute import SimpleImputer
from sklearn.preprocessing import OneHotEncoder
from sklearn.ensemble import RandomForestRegressor
from sklearn.metrics import mean_absolute_error

# Cell

class PreProcessor:
    """
    Represent PreProcessor class

    Attributes:
    numerical_transformer: Numerical Columns Tranformer
    categorical_transformer: Categorical Columns Transformer
    preprocessor: Preprocessor for Columns Tranformer
    """

    def __init__(self):
        self.numerical_transformer = None
        self.categorical_transformer = None
        self.column_tranfomer = None

    def __str__(self):
        """Returns human readable string reprsentation"""
        return "PreProcessor object with attributes: numerical_transformer, categorical_transformer, preprocessor"

    def __repr__(self):
        return self.__str__()

#     def __lt__(self):
#         """returns: boolean"""
#         return True

    # PreProcess core methods
    # Preprocessing for numerical data
    def preprocess_numerical_data(self):
        self.numerical_transformer = SimpleImputer(strategy='constant')

    # Preprocessing for categorical data
    def preprocess_categorical_data(self):
        self.categorical_transformer = Pipeline(steps=[
        ('imputer', SimpleImputer(strategy='most_frequent')),
        ('onehot', OneHotEncoder(handle_unknown='ignore'))
        ])

    # Bundle preprocessing for numerical and categorical data
    def preprocess_data(self, numerical_cols, categorical_cols):
        self.preprocess_numerical_data()
        self.preprocess_categorical_data()
        self.column_tranfomer = ColumnTransformer(
            transformers=[
                ('num', self.numerical_transformer, numerical_cols),
                ('cat', self.categorical_transformer, categorical_cols)
            ])
        return self