""" handle lingering issues with jupyterlab 1.x build
"""

# Copyright (c) 2023 ipyforcegraph contributors.
# Distributed under the terms of the Modified BSD License.

import shutil
import subprocess
import sys
from pathlib import Path

HERE = Path(__file__).parent
ROOT = HERE.parent

JLPM = shutil.which("jlpm")


def watch():
    """after preparing, start watchers"""
    print("watching src...", flush=True)
    ts = subprocess.Popen([JLPM, "watch"], cwd=str(ROOT))
    ext = subprocess.Popen(["jupyter", "labextension", "watch", "."])

    def stop():
        print("stopping watchers...", flush=True)
        ext.terminate()
        ts.terminate()
        ts.wait()
        ext.wait()
        print("...watchers stopped!", flush=True)

    print("Starting lab...", flush=True)

    lab = subprocess.Popen(
        ["jupyter", "lab", "--no-browser", "--debug"],
        cwd=str(ROOT),
        stdin=subprocess.PIPE,
    )

    try:
        lab.wait()
    except KeyboardInterrupt:
        print(
            "attempting to stop lab, you may want to check your process monitor",
            flush=True,
        )
    finally:
        stop()
        lab.terminate()
        lab.communicate(b"y\n")

    stop()
    lab.wait()
    return 0


if __name__ == "__main__":
    if "watch" in sys.argv:
        sys.exit(watch())
