<!-- You can erase any parts of this template not applicable to your Pull Request. -->

If this Pull Request fixes an open [Issue](../../../issues) please include [auto-closing keywords](https://help.github.com/articles/closing-issues-via-commit-messages/).

## Types of changes
<!--- What types of changes does your code introduce? Put an `x` in all the boxes that apply: -->
- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to change)

## Checklist
- [ ] I have checked to ensure there aren't other open [Pull Requests](../../../pulls) for the same update/change.
- [ ] I have read the **CONTRIBUTING** document.
- [ ] My code follows the code style of this project.
- [ ] If my change requires a change to the documentation I have updated the documentation accordingly.
- [ ] I have added type annotations to any new functions.
- [ ] I have added tests to cover my changes.
- [ ] All new and existing tests passed.
- [ ] `mypy` does not raise any errors.
- [ ] I have run `tox -e qa` to sort the imports and apply the project's code style.


## Description
<!--Provide a clear and concise description of the changes you have made.-->


## Other Additional Information:
<!--Any additional information, related issues, etc.-->
