import logging
from enum import IntEnum
from typing import Optional

class Level(IntEnum):
    DEBUG: int
    INFO: int
    WARNING: int
    ERROR: int
    CRITICAL: int
    NONE: int

class _Color(IntEnum):
    DEBUG: int
    INFO: int
    WARNING: int
    ERROR: int
    CRITICAL: int

class _LogFormatter(logging.Formatter):
    def __init__(self, color: Optional[bool] = ...) -> None: ...
    def formatMessage(self, record: logging.LogRecord) -> str: ...

class Logger:
    def __init__(self, name: str, level: Optional[Level] = ..., file: Optional[str] = ..., color: Optional[bool] = ...) -> None: ...
    @property
    def file(self) -> str: ...
    @property
    def handlers(self) -> list[logging.Handler]: ...
    @property
    def level(self) -> Level: ...
    @level.setter
    def level(self, level) -> None: ...
    @property
    def name(self) -> str: ...
    def critical(self, msg: str) -> None: ...
    def debug(self, msg: str) -> None: ...
    def error(self, msg: str) -> None: ...
    def info(self, msg: str) -> None: ...
    def warning(self, msg: str) -> None: ...
    def remove_handler(self, handler: logging.Handler) -> None: ...
