# punx - Python Utilities for NeXus HDF5 files

[![image](https://img.shields.io/github/release/prjemian/punx.svg)](https://github.com/prjemian/punx/releases)
[![image](https://img.shields.io/github/tag/prjemian/punx.svg)](https://github.com/prjemian/punx/tags)
[![Build Status](https://img.shields.io/github/workflow/status/prjemian/punx/Unit%20Tests)](https://github.com/prjemian/punx/actions?query=workflow%3A%22Unit+Tests%22+branch%3Amain)
[![PyPI](https://img.shields.io/pypi/v/punx.svg)](https://pypi.python.org/pypi/punx)
[![conda-forge](https://img.shields.io/conda/vn/conda-forge/punx)](https://anaconda.org/conda-forge/punx)

## [Documentation](http://punx.readthedocs.io)

The *punx* package provides these features:

- Validate NeXus HDF5 data files
- Choose the NeXus [release](https://github.com/nexusformat/definitions/releases) to use for validation
- Validate NeXus NXDL files
- Display NeXus HDF5 data file structure
- Display NeXus class hierarchy (stretch goal, graphical output)


## Package Details

- author:   Pete R. Jemian
- email:   <prjemian@gmail.com>
- copyright:   2014-2021, Pete R. Jemian
- license:   Creative Commons Attribution 4.0 International Public License (see [LICENSE.txt](punx/LICENSE.txt))
- URL:   <https://punx.readthedocs.io>
- git:   <https://github.com/prjemian/punx>
- issues:   <https://github.com/prjemian/punx/issues>
- citation:   [![DOI: 10.5281/zenodo.1471686](https://zenodo.org/badge/DOI/10.5281/zenodo.1471686.svg)](https://doi.org/10.5281/zenodo.1471686)
- static code analyses:
  [![Code Coverage](https://coveralls.io/repos/github/prjemian/punx/badge.svg?branch=master)](https://coveralls.io/github/prjemian/punx?branch=master)
  [![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/prjemian/punx.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/prjemian/punx/context:python)
  [![Total alerts](https://img.shields.io/lgtm/alerts/g/prjemian/punx.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/prjemian/punx/alerts/)
