# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package RNA;
use base qw(Exporter);
use base qw(DynaLoader);
package RNAc;
bootstrap RNA;
package RNA;
@EXPORT = qw();
=head1 NAME

RNA - interface to the ViennaRNA C-library (libRNA.a)

=head1 SYNOPSIS

  use RNA;
  $seq = "CGCAGGGAUACCCGCG";
  ($struct, $mfe) = RNA::fold($seq);  #predict mfe structure of $seq
  RNA::PS_rna_plot($seq, $struct, "rna.ps");  # write PS plot to rna.ps
  $F = RNA::pf_fold($seq);   # compute partition function and pair pobabilities
  RNA::PS_dot_plot($seq, "dot.ps");          # write dot plot to dot.ps
  ...

=head1 DESCRIPTION

The RNA.pm package gives access to almost all functions in the libRNA.a
library of the Vienna RNA PACKAGE. The Perl wrapper is generated using
SWIG http://www.swig.org/ with relatively little manual intervention.
For each C function in the library the perl package provides a function
of the same name and calling convention (with few exceptions). For
detailed information you should therefore also consult the documentation
of the library (info RNAlib).

Note that in general C arrays are wrapped into opaque objects that can
only be accessed via helper functions. SWIG provides a couple of general
purpose helper functions, see the section at the end of this file. C
structures are wrapped into Perl objects using SWIG's shadow class
mechanism, resulting in a tied hash with keys named after the structure
members.

For the interrested reader we list for each scalar type of the
corepsonding C variable in brackets, and point out the header files
containing the C declaration.

=head2 Folding Routines

Minimum free Energy Folding (from fold.h)

=over 4

=item fold SEQUENCE

=item fold SEQUENCE, CONSTRAINTS

computes the minimum free energy structure of the string SEQUENCE and returns
the predicted structure and energy, e.g.

  ($structure, $mfe) = RNA::fold("UGUGUCGAUGUGCUAU");

If a second argument is supplied and
L<$fold_constrained|/$fold_constrained>==1 the CONSTRAINTS string is
used to specify constraints on the predicted structure.  The
characters '|', 'x', '<', '>' mark bases that are paired, unpaired,
paired upstream, or downstream, respectively; matching brackets "( )"
denote base pairs, dots '.' are used for unconstrained bases.

In the two argument version the CONSTRAINTS string is modified and holds the
predicted structure upon return. This is done for backwards compatibility only,
and might change in future versions.

=item energy_of_struct SEQUENCE, STRUCTURE

returns the energy of SEQUENCE on STRUCTURE (in kcal/mol). The string structure
must hold a valid secondary structure in bracket notation.

=item update_fold_params

recalculate the pair matrix and energy parameters after a change in folding
parameters. In many cases (such as changes to
L<$temperature|/$temperature>) the fold() routine will call
update_fold_params automatically when necessary.

=item free_arrays

frees memory allocated internally when calling L<fold|/fold>.


=item cofold SEQUENCE

=item cofold SEQUENCE, CONSTRAINTS

works as fold, but SEQUENCE may be the concatenation of two RNAs in order
compute their hybridization structure. E.g.:

  $seq1  ="CGCAGGGAUACCCGCG";
  $seq2  ="GCGCCCAUAGGGACGC";
  $RNA::cut_point = length($seq1)+1;
  ($costruct, $comfe) = RNA::cofold($seq1 . $seq2);

=item duplexfold SEQ1 SEQ2

compute the structure upon hybridization of SEQ1 and SEQ2. In contrast to
cofold only intra-molecular pairs are allowed. Thus, the algorithm runs in
O(n1*n2) time where n1 and n2 are the lengths of the sequences. The result
is returned in a C struct containing the innermost base pair (i,j) the
structure and energy. E.g:

  $seq1 ="CGCAGGGAUACCCGCG";
  $seq2 ="GCGCCCAUAGGGACGC";
  $dup  = RNA::duplexfold($seq1, $seq2);
  print "Region ", $dup->{i}+1-length($seq1), " to ",
        $dup->{i}, " of seq1 ",
        "pairs up with ", $dup->{j}, " to ",
        $dup->{j}+length($dup->{structure})-length($seq1)-2,
        " of seq2\n";

=back

Partition function Folding (from part_func.h)

=over 4

=item pf_fold SEQUENCE

=item pf_fold SEQUENCE, CONSTRAINTS

calculates the partition function over all possible secondary
structures and the matrix of pair probabilities for SEQUENCE and
returns a two element list consisting of a string summarizing possible
structures. See below on how to access the pair probability matrix. As
with L<fold|/fold> the second argument can be used to specify folding
constraints. Constraints are implemented by excluding base pairings
that contradict the constraint, but without bonus
energies. Constraints of type '|' (paired base) are ignored.  In the
two argument version CONSTRAINTS is modified to contain the structure
string on return (obsolete feature, for backwards compatibility only)

=item get_pr I, J

After calling C<pf_fold> the global C variable C<pr> points to the
computed pair probabilities. Perl access to the C is facilitated by
the C<get_pr> helper function that looks up and returns the
probability of the pair (I,J).

=item free_pf_arrays

frees memory allocated for pf_fold

=item update_pf_params LENGTH

recalculate energy parameters for pf_fold. In most cases (such as
simple changes to L<$temperature|/$temperature>) C<pf_fold>
will take appropriate action automatically.

=item pbacktrack SEQUENCE

return a random structure chosen according to it's Boltzmann probability.
Use to produce samples representing the thermodynamic ensemble of
structures.

  RNA::pf_fold($sequence);
  for (1..1000) {
     push @sample, RNA::pbacktrack($sequence);
  }

=item co_pf_fold SEQUENCE

=item co_pf_fold SEQUENCE, CONSTRAINTS

calculates the partition function over all possible secondary
structures and the matrix of pair probabilities for SEQUENCE.
SEQUENCE is a concatenation of two sequences (see cofold).
Returns a five element list consisting of a string summarizing possible
structures as first element. The second element is the Gibbs free energy of Sequence 1 (as computed also with pf_fold), the third element the Gibbs free energy of Sequence 2. The fourth element is the Gibbs free energy of all structures that have INTERmolecular base pairs, and finally the fifth element is the Gibbs free energy of the whole ensemble (dimers as well as monomers).
See above on how to access the pair probability matrix. As
with L<fold|/fold> the second argument can be used to specify folding
constraints. Constraints are implemented by excluding base pairings
that contradict the constraint, but without bonus
energies. Constraints of type '|' (paired base) are ignored.  In the
two argument version CONSTRAINTS is modified to contain the structure
string on return (obsolete feature, for backwards compatibility only)

=item free_co_pf_arrays

frees memory allocated for co_pf_fold

=item update_pf_co_params LENGTH

recalculate energy parameters for co_pf_fold. In most cases (such as
simple changes to L<$temperature|/$temperature>) C<co_pf_fold>
will take appropriate action automatically.

=item get_concentrations FdAB, FdAA, FdBB, FA, FB, CONCA, CONCB

calculates equilibrium concentrations of the three dimers AB, AA, and BB, as well as the two monomers A and B out of the free energies of the duplexes (FdAB, FdAA, FdBB, these are the fourth elements returned by co_pf_fold), the monomers (FA, FB (e.g. the second and third elements returned by co_pf_fold with sequences AB) and the start concentrations of A and B. It returns as first element the concentration of AB dimer, than AA and BB dimer, as fourth element the A monomer concentration, and as fifth and last element the B monomer concentration.
So, to compute concentrations, you first have to run 3 co_pf_folds (with sequences AB, AA and BB).

=back

Suboptimal Folding (from subopt.h)

=over 4

=item subopt SEQUENCE, CONSTRAINTS, DELTA

=item subopt SEQUENCE, CONSTRAINTS, DELTA, FILEHANDLE

compute all structures of SEQUENCE within DELTA*0.01 kcal/mol of the
optimum. If specified, results are written to FILEHANDLE and nothing
is returned. Else, the C function returnes a list of C structs of type
SOLUTION. The list is wrapped by SWIG as a perl object that can be
accesses as follows:

  $solution = subopt($seq, undef, 500);
  for (0..$solution->size()-1) {
     printf "%s %6.2f\n",  $solution->get($_)->{structure},
			   $solution->get($_)->{energy};
  }

=back

Alignment Folding (from alifold.h)

=over 4

=item alifold REF

=item fold REF, CONSTRAINTS

similar to fold() but compute the consensus structure for a set of aligned
sequences. E.g.:

  @align = ("GCCAUCCGAGGGAAAGGUU",
	    "GAUCGACAGCGUCU-AUCG",
	    "CCGUCUUUAUGAGUCCGGC");
  ($consens_struct, $consens_en) = RNA::alifold(\@align);

=item consensus REF
=item consens_mis REF

compute a simple consensus sequence or "most informative sequence" form an
alignment. The simple consensus returns the most frequent character for
each column, the MIS uses the IUPAC symbol that contains all characters
that are overrepresented in the column.

  $mis = consensus_mis(\@align);


=back

Inverse Folding (from inverse.h)

=over 4

=item inverse_fold START, TARGET

find a sequence that folds into structure TARGET, by optimizing the
sequence until its mfe structure (as returned by L<fold|/fold>) is
TARGET. Startpoint of the optimization is the sequence START. Returns
a list containing the sequence found and the final value of the cost
function, i.e. 0 if the search was successful. A random start sequence
can be generated using L<random_string|/random_string>.

=item inverse_pf_fold START, TARGET

optimizes a sequence (beginning with START) by maximising the
frequency of the structure TARGET in the thermodynamic ensemble
of structures. Returns a list containing the optimized sequence and
the final value of the cost function. The cost function is given by
C<energy_of_struct(seq, TARGET) - pf_fold(seq)>, i.e.C<-RT*log(p(TARGET))>

=item $final_cost [float]

holds the value of the cost function where the optimization in
C<inverse_pf_fold> should stop. For values <=0 the optimization will
only terminate at a local optimimum (which might take very long to reach).

=item $symbolset [char *]

the string symbolset holds the allowed characters to be used by
C<inverse_fold> and C<inverse_pf_fold>, the default alphabet is "AUGC"


=item $give_up [int]

If non-zero stop optimization when its clear that no exact solution
can be found. Else continue and eventually return an approximate
solution. Default 0.

=back

Cofolding of two RNA molecules (from cofold.h)

=over 4


=back

Global Variables to Modify Folding (from fold_vars.h)

=over 4

=item $noGU [int]

Do not allow GU pairs to form, default 0.

=item $no_closingGU [int]

allow GU only inside stacks, default 0.

=item $tetra_loop [int]

Fold with specially stable 4-loops, default 1.

=item $energy_set [int]

0 = BP; 1=any mit GC; 2=any mit AU-parameter, default 0.

=item $dangles [int]

How to compute dangling ends. 0: no dangling end energies, 1: "normal"
dangling ends (default), 2: simplified dangling ends, 3: "normal" +
co-axial stacking. Note that L<pf_fold|/pf_fold> treats cases 1 and 3
as 2. The same holds for the main computation in L<subopt|/subopt>,
however subopt will re-evalute energies using
L<energy_of_struct|energy_of_struct> for cases 1 and 3. See the more
detailed discussion in RNAlib.texinfo.

=item $nonstandards [char *]

contains allowed non standard bases, default empty string ""

=item $temperature [double]

temperature in degrees Celsius for rescaling parameters, default 37C.

=item $logML [int]

use logarithmic multiloop energy function in
L<energy_of_struct|/energy_of_struct>, default 0.

=item $noLonelyPairs [int]

consider only structures without isolated base pairs (helices of length 1).
For L<pf_fold|/pf_fold> only eliminates pairs
that can B<only> occur as isolated pairs. Default 0.

=item $base_pair [struct bond *]

list of base pairs from last call to L<fold|/fold>. Better use
the structure string returned by  L<fold|/fold>.

=item $pf_scale [double]

scaling factor used by L<pf_fold|/pf_fold> to avoid overflows. Should
be set to exp(-F/(RT*length)) where F is a guess for the ensmble free
energy (e.g. use the mfe).


=item $fold_constrained [int]

apply constraints in the folding algorithms, default 0.

=item $do_backtrack [int]

If 0 do not compute the pair probabilities in L<pf_fold|/pf_fold>
(only the partition function). Default 1.

=item $backtrack_type [char]

usually 'F'; 'C' require (1,N) to be bonded; 'M' backtrack as if the
sequence was part of a multi loop. Used by L<inverse_fold|/inverse_fold>

=item $pr [double *]

the base pairing prob. matrix computed by L<pf_fold|/pf_fold>.

=item $iindx [int *]

Array of indices for moving withing the C<pr> array. Better use
L<get_pr|/get_pr>.

=back

from move_set.h

=over 4

=item move_standard SEQUENCE, STRUCTURE, MOVE_TYPE, VERBOSITY, SHIFTS, noLP 

Walking method to find local minima. There are three different kinds available
which can be cosen using the MOVE_TYPE enum:
0 - GRADIENT: take the neighbouring structure with the lowest energy
1 - FIRST: take the first neighbour with a lower energy
2 - ADAPTIVE: randomly choose a neighbour
STRUCTURE is the start structure and will also be used to return the target structure.
Others are options set as integers.

=back

=head2 Parsing and Comparing Structures

from RNAstruct.h: these functions convert between strings
representating secondary structures with various levels of coarse
graining. See the documentation of the C library for details

=over 4

=item b2HIT STRUCTURE

Full -> HIT [incl. root]

=item b2C STRUCTURE

Full -> Coarse [incl. root]

=item b2Shapiro STRUCTURE

Full -> weighted Shapiro [i.r.]

=item add_root STRUCTURE

{Tree} -> ({Tree}R)

=item expand_Shapiro COARSE

add S for stacks to coarse struct

=item expand_Full STRUCTURE

Full -> FFull

=item unexpand_Full FSTRUCTURE

FFull -> Full

=item unweight WCOARSE

remove weights from coarse struct

=item unexpand_aligned_F ALIGN



=item parse_structure STRUCTURE

computes structure statistics, and fills the following global variables:

$loops    [int] number of loops (and stacks)
$unpaired [int] number of unpaired positions
$pairs    [int] number of paired positions
$loop_size[int *]  holds all loop sizes
$loop_degree[int *] holds all loop degrees
$helix_size[int *] holds all helix lengths

=back

from treedist.h: routines for computing tree-edit distances between structures

=over 4

=item make_tree XSTRUCT

convert a structure string as produced by the expand_... functions to a
Tree, useable as input to tree_edit_distance.

=item tree_edit_distance T1, T2

compare to structures using tree editing. C<T1>, C<T2> must have been
created using C<tree_edit_distance>

=item print_tree T

mainly for debugging

=item free_tree T

free space allocated by make_tree

=back

from stringdist.h routines to compute structure distances via string-editing

=over 4

=item Make_swString STRUCTURE

[ returns swString * ]
make input for string_edit_distance

=item string_edit_distance S1, S2

[ returns float  ]
compare to structures using string alignment. C<S1>, C<S2> should be
created using C<Make_swString>

=back

from profiledist

=over

=item Make_bp_profile LENGTH

[ returns (float *) ]
condense pair probability matrix C<pr> into a vector containing
probabilities for unpaired, upstream paired and downstream paired.
This resulting probability profile is used as input for
profile_edit_distance

=item profile_edit_distance T1, T2

[ returns float ]
align two probability profiles produced by C<Make_bp_profile>

=item print_bppm T

[ returns void ]
print string representation of probability profile

=item free_profile T

[ returns void ]
free space allocated in Make_bp_profile

=back

Global variables for computing structure distances

=over 4

=item $edit_backtrack [int]

set to 1 if you want backtracking

=item $aligned_line [(char *)[2]]

containes alignmed structures after computing structure distance with
C<edit_backtrack==1>

=item $cost_matrix [int]

0 usual costs (default), 1 Shapiro's costs

=back

=head2 Utilities (from utils.h)

=over 4

=item space SIZE

allocate memory from C. Usually not needed in Perl

=item nrerror MESSGAE

die with error message. Better use Perl's C<die>

=item $xsubi [unsigned short[3]]

libRNA uses the rand48 48bit random number generator if available, the
current random  number is always stored in $xsubi.

=item init_rand

initialize the $xsubi random number from current time

=item urn

returns a random number between 0 and 1 using the random number
generator from the RNA library.

=item int_urn FROM, TO

returns random integer in the range [FROM..TO]

=item time_stamp

current date in a string. In perl you might as well use C<locatime>

=item random_string LENGTH, SYMBOLS

returns a string of length LENGTH using characters from the string
SYMBOLS

=item hamming S1, S2

calculate hamming distance of the strings C<S1> and C<S2>.


=item pack_structure STRUCTURE

pack secondary structure, using a 5:1 compression via 3
encoding. Returns the packed string.

=item unpack_structure PACKED

unpacks a secondary structure packed with pack_structure

=item make_pair_table STRUCTURE

returns a pair table as a newly allocated (short *) C array, such
that: table[i]=j if (i.j) pair or 0 if i is unpaired, table[0]
contains the length of the structure.

=item bp_distance STRUCTURE1, STRUCTURE2

returns the base pair distance of the two STRUCTURES. dist = {number
of base pairs in one structure but not in the other} same as edit
distance with open-pair close-pair as move-set

=back

from PS_plot.h

=over 4

=item PS_rna_plot SEQUENCE, STRUCTURE, FILENAME

write PostScript drawing of structure to FILENAME. Returns 1 on
sucess, 0 else.

=item PS_rna_plot_a SEQUENCE, STRUCTURE, FILENAME, PRE, POST

write PostScript drawing of structure to FILENAME. The strings PRE and
POST contain PostScript code that is included verbatim in the plot just
before (after) the data.  Returns 1 on sucess, 0 else.

=item gmlRNA SEQUENCE, STRUCTURE, FILENAME, OPTION

write structure drawing in gml (Graph Meta Language) to
FILENAME. OPTION should be a single character. If uppercase the gml
output will include the SEQUENCE as node labels. IF OPTION equal 'x'
or 'X' write graph with coordinates (else only connectivity
information). Returns 1 on sucess, 0 else.

=item ssv_rna_plot SEQUENCE, STRUCTURE, SSFILE

write structure drfawing as coord file for SStructView Returns 1 on
sucess, 0 else.

=item xrna_plot SEQUENCE, STRUCTURE, SSFILE

write structure drawing as ".ss" file for further editing in XRNA.
Returns 1 on sucess, 0 else.

=item PS_dot_plot SEQUENCE, FILENAME

write a PostScript dot plot of the pair probability matix to
FILENAME. Returns 1 on sucess, 0 else.

=item $rna_plot_type [int]

Select layout algorithm for structure drawings. Currently available
0= simple coordinates, 1= naview, default 1.

=back

from read_epars.c

=over 4

=item read_parameter_file FILENAME

read energy parameters from FILENAME

=item write_parameter_file FILENAME

write energy parameters to FILENAME

=back

=head2 SWIG helper functions

The package includes generic helper functions to access C arrays
of type C<int>, C<float> and C<double>, such as:

=over 4

=item intP_getitem POINTER, INDEX

return the element INDEX from the array

=item intP_setitem POINTER, INDEX, VALUE

set element INDEX to VALUE

=item new_intP NELEM

allocate a new C array of integers with NELEM elements and return the pointer

=item delete_intP POINTER

deletes the C array by calling free()

=back

substituting C<intP> with C<floatP>, C<doubleP>, C<ushortP>,
C<shortP>, gives the corresponding functions for arrays of float or
double, unsigned short, and short. You need to know the correct C
type however, and the functions work only for arrays of simple types.
Note, that the shortP... functions were used for unsigned short in previous
versions, while starting with v1.8.3 it can only access signed short arrays.

On the lowest level the C<cdata> function gives direct access to any data
in the form of a Perl string.

=over

=item cdata POINTER, SIZE

copies SIZE bytes at POINTER to a Perl string (with binary data)

=item memmove POINTER, STRING

copies the (binary) string STRING to the memory location pointed to by
POINTER.
Note: memmove is broken in current swig versions (e.g. 1.3.31)

=back

In combination with Perl's C<unpack> this provides a generic way to convert
C data structures to Perl. E.g.

  RNA::parse_structure($structure);  # fills the $RNA::loop_degree array
  @ldegrees = unpack "I*", RNA::cdata($RNA::loop_degree, ($RNA::loops+1)*4);

Warning: using these functions with wrong arguments will corrupt your
memory and lead to a segmentation fault.

=head1 AUTHOR

Ivo L. Hofacker <ivo@tbi.univie.ac.at>

=cut

# ---------- BASE METHODS -------------

package RNA;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package RNA;

*new_intP = *RNAc::new_intP;
*delete_intP = *RNAc::delete_intP;
*intP_getitem = *RNAc::intP_getitem;
*intP_setitem = *RNAc::intP_setitem;
*new_floatP = *RNAc::new_floatP;
*delete_floatP = *RNAc::delete_floatP;
*floatP_getitem = *RNAc::floatP_getitem;
*floatP_setitem = *RNAc::floatP_setitem;
*new_doubleP = *RNAc::new_doubleP;
*delete_doubleP = *RNAc::delete_doubleP;
*doubleP_getitem = *RNAc::doubleP_getitem;
*doubleP_setitem = *RNAc::doubleP_setitem;
*new_ushortP = *RNAc::new_ushortP;
*delete_ushortP = *RNAc::delete_ushortP;
*ushortP_getitem = *RNAc::ushortP_getitem;
*ushortP_setitem = *RNAc::ushortP_setitem;
*new_shortP = *RNAc::new_shortP;
*delete_shortP = *RNAc::delete_shortP;
*shortP_getitem = *RNAc::shortP_getitem;
*shortP_setitem = *RNAc::shortP_setitem;
*cdata = *RNAc::cdata;
*memmove = *RNAc::memmove;
*params_load = *RNAc::params_load;
*params_save = *RNAc::params_save;
*params_load_from_string = *RNAc::params_load_from_string;
*params_load_RNA_Turner2004 = *RNAc::params_load_RNA_Turner2004;
*params_load_RNA_Turner1999 = *RNAc::params_load_RNA_Turner1999;
*params_load_RNA_Andronescu2007 = *RNAc::params_load_RNA_Andronescu2007;
*params_load_RNA_Langdon2018 = *RNAc::params_load_RNA_Langdon2018;
*params_load_RNA_misc_special_hairpins = *RNAc::params_load_RNA_misc_special_hairpins;
*params_load_DNA_Mathews2004 = *RNAc::params_load_DNA_Mathews2004;
*params_load_DNA_Mathews1999 = *RNAc::params_load_DNA_Mathews1999;
*last_parameter_file = *RNAc::last_parameter_file;
*read_parameter_file = *RNAc::read_parameter_file;
*write_parameter_file = *RNAc::write_parameter_file;
*gettype = *RNAc::gettype;
*settype = *RNAc::settype;
*init_rand = *RNAc::init_rand;
*urn = *RNAc::urn;
*int_urn = *RNAc::int_urn;
*hamming = *RNAc::hamming;
*hamming_bound = *RNAc::hamming_bound;
*encode_seq = *RNAc::encode_seq;
*random_string = *RNAc::random_string;
*hamming_distance = *RNAc::hamming_distance;
*hamming_distance_bound = *RNAc::hamming_distance_bound;
*pack_structure = *RNAc::pack_structure;
*unpack_structure = *RNAc::unpack_structure;
*db_from_ptable = *RNAc::db_from_ptable;
*db_flatten = *RNAc::db_flatten;
*db_from_WUSS = *RNAc::db_from_WUSS;
*abstract_shapes = *RNAc::abstract_shapes;
*ptable = *RNAc::ptable;
*ptable_pk = *RNAc::ptable_pk;
*pt_pk_remove = *RNAc::pt_pk_remove;
*plist = *RNAc::plist;
*db_from_plist = *RNAc::db_from_plist;
*db_pk_remove = *RNAc::db_pk_remove;
*db_to_tree_string = *RNAc::db_to_tree_string;
*tree_string_unweight = *RNAc::tree_string_unweight;
*tree_string_to_db = *RNAc::tree_string_to_db;
*make_loop_index = *RNAc::make_loop_index;
*loopidx_from_ptable = *RNAc::loopidx_from_ptable;
*hx_from_ptable = *RNAc::hx_from_ptable;
*bp_distance = *RNAc::bp_distance;
*dist_mountain = *RNAc::dist_mountain;
*db_pack = *RNAc::db_pack;
*db_unpack = *RNAc::db_unpack;
*db_to_element_string = *RNAc::db_to_element_string;
*consensus = *RNAc::consensus;
*consens_mis = *RNAc::consens_mis;
*aln_mpi = *RNAc::aln_mpi;
*aln_pscore = *RNAc::aln_pscore;
*aln_conservation_struct = *RNAc::aln_conservation_struct;
*aln_conservation_col = *RNAc::aln_conservation_col;
*move_standard = *RNAc::move_standard;
*filename_sanitize = *RNAc::filename_sanitize;
*get_xy_coordinates = *RNAc::get_xy_coordinates;
*simple_circplot_coordinates = *RNAc::simple_circplot_coordinates;
*naview_xy_coordinates = *RNAc::naview_xy_coordinates;
*simple_xy_coordinates = *RNAc::simple_xy_coordinates;
*my_PS_rna_plot_snoop_a = *RNAc::my_PS_rna_plot_snoop_a;
*file_PS_rnaplot = *RNAc::file_PS_rnaplot;
*file_PS_rnaplot_a = *RNAc::file_PS_rnaplot_a;
*gmlRNA = *RNAc::gmlRNA;
*ssv_rna_plot = *RNAc::ssv_rna_plot;
*svg_rna_plot = *RNAc::svg_rna_plot;
*xrna_plot = *RNAc::xrna_plot;
*PS_rna_plot = *RNAc::PS_rna_plot;
*PS_rna_plot_a = *RNAc::PS_rna_plot_a;
*PS_rna_plot_a_gquad = *RNAc::PS_rna_plot_a_gquad;
*file_PS_aln = *RNAc::file_PS_aln;
*PS_color_dot_plot = *RNAc::PS_color_dot_plot;
*PS_color_dot_plot_turn = *RNAc::PS_color_dot_plot_turn;
*PS_dot_plot_turn = *RNAc::PS_dot_plot_turn;
*PS_dot_plot_list = *RNAc::PS_dot_plot_list;
*PS_dot_plot = *RNAc::PS_dot_plot;
*eval_structure_simple = *RNAc::eval_structure_simple;
*eval_circ_structure = *RNAc::eval_circ_structure;
*eval_gquad_structure = *RNAc::eval_gquad_structure;
*eval_circ_gquad_structure = *RNAc::eval_circ_gquad_structure;
*eval_structure_pt_simple = *RNAc::eval_structure_pt_simple;
*energy_of_structure = *RNAc::energy_of_structure;
*energy_of_circ_structure = *RNAc::energy_of_circ_structure;
*energy_of_gquad_structure = *RNAc::energy_of_gquad_structure;
*energy_of_structure_pt = *RNAc::energy_of_structure_pt;
*energy_of_move = *RNAc::energy_of_move;
*energy_of_move_pt = *RNAc::energy_of_move_pt;
*loop_energy = *RNAc::loop_energy;
*energy_of_struct = *RNAc::energy_of_struct;
*energy_of_struct_pt = *RNAc::energy_of_struct_pt;
*energy_of_circ_struct = *RNAc::energy_of_circ_struct;
*E_ext_stem = *RNAc::E_ext_stem;
*exp_E_ext_stem = *RNAc::exp_E_ext_stem;
*E_Stem = *RNAc::E_Stem;
*E_ExtLoop = *RNAc::E_ExtLoop;
*exp_E_ExtLoop = *RNAc::exp_E_ExtLoop;
*exp_E_Stem = *RNAc::exp_E_Stem;
*E_Hairpin = *RNAc::E_Hairpin;
*exp_E_Hairpin = *RNAc::exp_E_Hairpin;
*E_IntLoop = *RNAc::E_IntLoop;
*exp_E_IntLoop = *RNAc::exp_E_IntLoop;
*E_IntLoop_Co = *RNAc::E_IntLoop_Co;
*ubf_eval_int_loop = *RNAc::ubf_eval_int_loop;
*ubf_eval_int_loop2 = *RNAc::ubf_eval_int_loop2;
*ubf_eval_ext_int_loop = *RNAc::ubf_eval_ext_int_loop;
*E_ml_rightmost_stem = *RNAc::E_ml_rightmost_stem;
*E_MLstem = *RNAc::E_MLstem;
*exp_E_MLstem = *RNAc::exp_E_MLstem;
*maximum_matching = *RNAc::maximum_matching;
*fold = *RNAc::fold;
*alifold = *RNAc::alifold;
*cofold = *RNAc::cofold;
*circfold = *RNAc::circfold;
*free_arrays = *RNAc::free_arrays;
*update_fold_params = *RNAc::update_fold_params;
*circalifold = *RNAc::circalifold;
*free_alifold_arrays = *RNAc::free_alifold_arrays;
*free_co_arrays = *RNAc::free_co_arrays;
*update_cofold_params = *RNAc::update_cofold_params;
*initialize_cofold = *RNAc::initialize_cofold;
*Lfoldz = *RNAc::Lfoldz;
*Lfold = *RNAc::Lfold;
*aliLfold = *RNAc::aliLfold;
*pf_fold = *RNAc::pf_fold;
*pf_circ_fold = *RNAc::pf_circ_fold;
*pf_add = *RNAc::pf_add;
*pf_float_precision = *RNAc::pf_float_precision;
*pbacktrack = *RNAc::pbacktrack;
*pbacktrack5 = *RNAc::pbacktrack5;
*pbacktrack_circ = *RNAc::pbacktrack_circ;
*free_pf_arrays = *RNAc::free_pf_arrays;
*update_pf_params = *RNAc::update_pf_params;
*mean_bp_distance = *RNAc::mean_bp_distance;
*init_pf_fold = *RNAc::init_pf_fold;
*centroid = *RNAc::centroid;
*co_pf_fold = *RNAc::co_pf_fold;
*get_concentrations = *RNAc::get_concentrations;
*free_co_pf_arrays = *RNAc::free_co_pf_arrays;
*update_co_pf_params = *RNAc::update_co_pf_params;
*get_pr = *RNAc::get_pr;
*get_centroid_struct_pl = *RNAc::get_centroid_struct_pl;
*get_centroid_struct_pr = *RNAc::get_centroid_struct_pr;
*MEA_from_plist = *RNAc::MEA_from_plist;
*pfl_fold = *RNAc::pfl_fold;
*pfl_fold_up = *RNAc::pfl_fold_up;
*subopt = *RNAc::subopt;
*zukersubopt = *RNAc::zukersubopt;
*inverse_fold = *RNAc::inverse_fold;
*inverse_pf_fold = *RNAc::inverse_pf_fold;
*b2HIT = *RNAc::b2HIT;
*b2C = *RNAc::b2C;
*b2Shapiro = *RNAc::b2Shapiro;
*add_root = *RNAc::add_root;
*expand_Shapiro = *RNAc::expand_Shapiro;
*expand_Full = *RNAc::expand_Full;
*unexpand_Full = *RNAc::unexpand_Full;
*unweight = *RNAc::unweight;
*unexpand_aligned_F = *RNAc::unexpand_aligned_F;
*parse_structure = *RNAc::parse_structure;
*make_tree = *RNAc::make_tree;
*tree_edit_distance = *RNAc::tree_edit_distance;
*print_tree = *RNAc::print_tree;
*free_tree = *RNAc::free_tree;
*Make_swString = *RNAc::Make_swString;
*string_edit_distance = *RNAc::string_edit_distance;
*profile_edit_distance = *RNAc::profile_edit_distance;
*Make_bp_profile_bppm = *RNAc::Make_bp_profile_bppm;
*print_bppm = *RNAc::print_bppm;
*free_profile = *RNAc::free_profile;
*Make_bp_profile = *RNAc::Make_bp_profile;
*deref_any = *RNAc::deref_any;
*get_aligned_line = *RNAc::get_aligned_line;
*file_SHAPE_read = *RNAc::file_SHAPE_read;
*file_fasta_read = *RNAc::file_fasta_read;
*extract_record_rest_structure = *RNAc::extract_record_rest_structure;
*read_record = *RNAc::read_record;
*get_multi_input_line = *RNAc::get_multi_input_line;
*file_msa_detect_format = *RNAc::file_msa_detect_format;
*file_msa_write = *RNAc::file_msa_write;
*file_msa_read = *RNAc::file_msa_read;
*file_msa_read_record = *RNAc::file_msa_read_record;
*seq_encode = *RNAc::seq_encode;
*file_commands_read = *RNAc::file_commands_read;
*enumerate_necklaces = *RNAc::enumerate_necklaces;
*rotational_symmetry = *RNAc::rotational_symmetry;
*boustrophedon = *RNAc::boustrophedon;
*duplexfold = *RNAc::duplexfold;
*duplex_subopt = *RNAc::duplex_subopt;
*aliduplexfold = *RNAc::aliduplexfold;
*aliduplex_subopt = *RNAc::aliduplex_subopt;
*path_options_findpath = *RNAc::path_options_findpath;
*get_path = *RNAc::get_path;
*find_saddle = *RNAc::find_saddle;
*free_path = *RNAc::free_path;
*heat_capacity = *RNAc::heat_capacity;
*fc_add_perl_callback = *RNAc::fc_add_perl_callback;
*fc_add_perl_data = *RNAc::fc_add_perl_data;
*sc_add_f_perl_callback = *RNAc::sc_add_f_perl_callback;
*sc_add_bt_perl_callback = *RNAc::sc_add_bt_perl_callback;
*sc_add_exp_f_perl_callback = *RNAc::sc_add_exp_f_perl_callback;
*sc_add_perl_data = *RNAc::sc_add_perl_data;
*ud_set_data = *RNAc::ud_set_data;
*ud_set_prod_rule_cb = *RNAc::ud_set_prod_rule_cb;
*ud_set_exp_prod_rule_cb = *RNAc::ud_set_exp_prod_rule_cb;
*ud_set_prob_cb = *RNAc::ud_set_prob_cb;
*Lfold_cb = *RNAc::Lfold_cb;
*Lfoldz_cb = *RNAc::Lfoldz_cb;
*aliLfold_cb = *RNAc::aliLfold_cb;
*pfl_fold_cb = *RNAc::pfl_fold_cb;
*pfl_fold_up_cb = *RNAc::pfl_fold_up_cb;

############# Class : RNA::intArray ##############

package RNA::intArray;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_intArray(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_intArray($self);
        delete $OWNER{$self};
    }
}

*getitem = *RNAc::intArray_getitem;
*setitem = *RNAc::intArray_setitem;
*cast = *RNAc::intArray_cast;
*frompointer = *RNAc::intArray_frompointer;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::floatArray ##############

package RNA::floatArray;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_floatArray(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_floatArray($self);
        delete $OWNER{$self};
    }
}

*getitem = *RNAc::floatArray_getitem;
*setitem = *RNAc::floatArray_setitem;
*cast = *RNAc::floatArray_cast;
*frompointer = *RNAc::floatArray_frompointer;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::doubleArray ##############

package RNA::doubleArray;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_doubleArray(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_doubleArray($self);
        delete $OWNER{$self};
    }
}

*getitem = *RNAc::doubleArray_getitem;
*setitem = *RNAc::doubleArray_setitem;
*cast = *RNAc::doubleArray_cast;
*frompointer = *RNAc::doubleArray_frompointer;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::DoublePair ##############

package RNA::DoublePair;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_DoublePair(@_);
    bless $self, $pkg if defined($self);
}

*swig_first_get = *RNAc::DoublePair_first_get;
*swig_first_set = *RNAc::DoublePair_first_set;
*swig_second_get = *RNAc::DoublePair_second_get;
*swig_second_set = *RNAc::DoublePair_second_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_DoublePair($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::IntVector ##############

package RNA::IntVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_IntVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::IntVector_size;
*empty = *RNAc::IntVector_empty;
*clear = *RNAc::IntVector_clear;
*push = *RNAc::IntVector_push;
*pop = *RNAc::IntVector_pop;
*get = *RNAc::IntVector_get;
*set = *RNAc::IntVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_IntVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::UIntVector ##############

package RNA::UIntVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_UIntVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::UIntVector_size;
*empty = *RNAc::UIntVector_empty;
*clear = *RNAc::UIntVector_clear;
*push = *RNAc::UIntVector_push;
*pop = *RNAc::UIntVector_pop;
*get = *RNAc::UIntVector_get;
*set = *RNAc::UIntVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_UIntVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::DoubleVector ##############

package RNA::DoubleVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_DoubleVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::DoubleVector_size;
*empty = *RNAc::DoubleVector_empty;
*clear = *RNAc::DoubleVector_clear;
*push = *RNAc::DoubleVector_push;
*pop = *RNAc::DoubleVector_pop;
*get = *RNAc::DoubleVector_get;
*set = *RNAc::DoubleVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_DoubleVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::StringVector ##############

package RNA::StringVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_StringVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::StringVector_size;
*empty = *RNAc::StringVector_empty;
*clear = *RNAc::StringVector_clear;
*push = *RNAc::StringVector_push;
*pop = *RNAc::StringVector_pop;
*get = *RNAc::StringVector_get;
*set = *RNAc::StringVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_StringVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::ConstCharVector ##############

package RNA::ConstCharVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_ConstCharVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::ConstCharVector_size;
*empty = *RNAc::ConstCharVector_empty;
*clear = *RNAc::ConstCharVector_clear;
*push = *RNAc::ConstCharVector_push;
*pop = *RNAc::ConstCharVector_pop;
*get = *RNAc::ConstCharVector_get;
*set = *RNAc::ConstCharVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_ConstCharVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::SOLUTIONVector ##############

package RNA::SOLUTIONVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_SOLUTIONVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::SOLUTIONVector_size;
*empty = *RNAc::SOLUTIONVector_empty;
*clear = *RNAc::SOLUTIONVector_clear;
*push = *RNAc::SOLUTIONVector_push;
*pop = *RNAc::SOLUTIONVector_pop;
*get = *RNAc::SOLUTIONVector_get;
*set = *RNAc::SOLUTIONVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_SOLUTIONVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::CoordinateVector ##############

package RNA::CoordinateVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_CoordinateVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::CoordinateVector_size;
*empty = *RNAc::CoordinateVector_empty;
*clear = *RNAc::CoordinateVector_clear;
*push = *RNAc::CoordinateVector_push;
*pop = *RNAc::CoordinateVector_pop;
*get = *RNAc::CoordinateVector_get;
*set = *RNAc::CoordinateVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_CoordinateVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::DoubleDoubleVector ##############

package RNA::DoubleDoubleVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_DoubleDoubleVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::DoubleDoubleVector_size;
*empty = *RNAc::DoubleDoubleVector_empty;
*clear = *RNAc::DoubleDoubleVector_clear;
*push = *RNAc::DoubleDoubleVector_push;
*pop = *RNAc::DoubleDoubleVector_pop;
*get = *RNAc::DoubleDoubleVector_get;
*set = *RNAc::DoubleDoubleVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_DoubleDoubleVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::IntIntVector ##############

package RNA::IntIntVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_IntIntVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::IntIntVector_size;
*empty = *RNAc::IntIntVector_empty;
*clear = *RNAc::IntIntVector_clear;
*push = *RNAc::IntIntVector_push;
*pop = *RNAc::IntIntVector_pop;
*get = *RNAc::IntIntVector_get;
*set = *RNAc::IntIntVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_IntIntVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::ElemProbVector ##############

package RNA::ElemProbVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_ElemProbVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::ElemProbVector_size;
*empty = *RNAc::ElemProbVector_empty;
*clear = *RNAc::ElemProbVector_clear;
*push = *RNAc::ElemProbVector_push;
*pop = *RNAc::ElemProbVector_pop;
*get = *RNAc::ElemProbVector_get;
*set = *RNAc::ElemProbVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_ElemProbVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::HelixVector ##############

package RNA::HelixVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_HelixVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::HelixVector_size;
*empty = *RNAc::HelixVector_empty;
*clear = *RNAc::HelixVector_clear;
*push = *RNAc::HelixVector_push;
*pop = *RNAc::HelixVector_pop;
*get = *RNAc::HelixVector_get;
*set = *RNAc::HelixVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_HelixVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::PathVector ##############

package RNA::PathVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_PathVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::PathVector_size;
*empty = *RNAc::PathVector_empty;
*clear = *RNAc::PathVector_clear;
*push = *RNAc::PathVector_push;
*pop = *RNAc::PathVector_pop;
*get = *RNAc::PathVector_get;
*set = *RNAc::PathVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_PathVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::MoveVector ##############

package RNA::MoveVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_MoveVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::MoveVector_size;
*empty = *RNAc::MoveVector_empty;
*clear = *RNAc::MoveVector_clear;
*push = *RNAc::MoveVector_push;
*pop = *RNAc::MoveVector_pop;
*get = *RNAc::MoveVector_get;
*set = *RNAc::MoveVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_MoveVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::param ##############

package RNA::param;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_id_get = *RNAc::param_id_get;
*swig_id_set = *RNAc::param_id_set;
*swig_stack_get = *RNAc::param_stack_get;
*swig_stack_set = *RNAc::param_stack_set;
*swig_hairpin_get = *RNAc::param_hairpin_get;
*swig_hairpin_set = *RNAc::param_hairpin_set;
*swig_bulge_get = *RNAc::param_bulge_get;
*swig_bulge_set = *RNAc::param_bulge_set;
*swig_internal_loop_get = *RNAc::param_internal_loop_get;
*swig_internal_loop_set = *RNAc::param_internal_loop_set;
*swig_mismatchExt_get = *RNAc::param_mismatchExt_get;
*swig_mismatchExt_set = *RNAc::param_mismatchExt_set;
*swig_mismatchI_get = *RNAc::param_mismatchI_get;
*swig_mismatchI_set = *RNAc::param_mismatchI_set;
*swig_mismatch1nI_get = *RNAc::param_mismatch1nI_get;
*swig_mismatch1nI_set = *RNAc::param_mismatch1nI_set;
*swig_mismatch23I_get = *RNAc::param_mismatch23I_get;
*swig_mismatch23I_set = *RNAc::param_mismatch23I_set;
*swig_mismatchH_get = *RNAc::param_mismatchH_get;
*swig_mismatchH_set = *RNAc::param_mismatchH_set;
*swig_mismatchM_get = *RNAc::param_mismatchM_get;
*swig_mismatchM_set = *RNAc::param_mismatchM_set;
*swig_dangle5_get = *RNAc::param_dangle5_get;
*swig_dangle5_set = *RNAc::param_dangle5_set;
*swig_dangle3_get = *RNAc::param_dangle3_get;
*swig_dangle3_set = *RNAc::param_dangle3_set;
*swig_int11_get = *RNAc::param_int11_get;
*swig_int11_set = *RNAc::param_int11_set;
*swig_int21_get = *RNAc::param_int21_get;
*swig_int21_set = *RNAc::param_int21_set;
*swig_int22_get = *RNAc::param_int22_get;
*swig_int22_set = *RNAc::param_int22_set;
*swig_ninio_get = *RNAc::param_ninio_get;
*swig_ninio_set = *RNAc::param_ninio_set;
*swig_lxc_get = *RNAc::param_lxc_get;
*swig_lxc_set = *RNAc::param_lxc_set;
*swig_MLbase_get = *RNAc::param_MLbase_get;
*swig_MLbase_set = *RNAc::param_MLbase_set;
*swig_MLintern_get = *RNAc::param_MLintern_get;
*swig_MLintern_set = *RNAc::param_MLintern_set;
*swig_MLclosing_get = *RNAc::param_MLclosing_get;
*swig_MLclosing_set = *RNAc::param_MLclosing_set;
*swig_TerminalAU_get = *RNAc::param_TerminalAU_get;
*swig_TerminalAU_set = *RNAc::param_TerminalAU_set;
*swig_DuplexInit_get = *RNAc::param_DuplexInit_get;
*swig_DuplexInit_set = *RNAc::param_DuplexInit_set;
*swig_Tetraloop_E_get = *RNAc::param_Tetraloop_E_get;
*swig_Tetraloop_E_set = *RNAc::param_Tetraloop_E_set;
*swig_Tetraloops_get = *RNAc::param_Tetraloops_get;
*swig_Tetraloops_set = *RNAc::param_Tetraloops_set;
*swig_Triloop_E_get = *RNAc::param_Triloop_E_get;
*swig_Triloop_E_set = *RNAc::param_Triloop_E_set;
*swig_Triloops_get = *RNAc::param_Triloops_get;
*swig_Triloops_set = *RNAc::param_Triloops_set;
*swig_Hexaloop_E_get = *RNAc::param_Hexaloop_E_get;
*swig_Hexaloop_E_set = *RNAc::param_Hexaloop_E_set;
*swig_Hexaloops_get = *RNAc::param_Hexaloops_get;
*swig_Hexaloops_set = *RNAc::param_Hexaloops_set;
*swig_TripleC_get = *RNAc::param_TripleC_get;
*swig_TripleC_set = *RNAc::param_TripleC_set;
*swig_MultipleCA_get = *RNAc::param_MultipleCA_get;
*swig_MultipleCA_set = *RNAc::param_MultipleCA_set;
*swig_MultipleCB_get = *RNAc::param_MultipleCB_get;
*swig_MultipleCB_set = *RNAc::param_MultipleCB_set;
*swig_gquad_get = *RNAc::param_gquad_get;
*swig_gquad_set = *RNAc::param_gquad_set;
*swig_gquadLayerMismatch_get = *RNAc::param_gquadLayerMismatch_get;
*swig_gquadLayerMismatch_set = *RNAc::param_gquadLayerMismatch_set;
*swig_gquadLayerMismatchMax_get = *RNAc::param_gquadLayerMismatchMax_get;
*swig_gquadLayerMismatchMax_set = *RNAc::param_gquadLayerMismatchMax_set;
*swig_temperature_get = *RNAc::param_temperature_get;
*swig_temperature_set = *RNAc::param_temperature_set;
*swig_model_details_get = *RNAc::param_model_details_get;
*swig_model_details_set = *RNAc::param_model_details_set;
*swig_param_file_get = *RNAc::param_param_file_get;
*swig_param_file_set = *RNAc::param_param_file_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_param(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_param($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::exp_param ##############

package RNA::exp_param;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_id_get = *RNAc::exp_param_id_get;
*swig_id_set = *RNAc::exp_param_id_set;
*swig_expstack_get = *RNAc::exp_param_expstack_get;
*swig_expstack_set = *RNAc::exp_param_expstack_set;
*swig_exphairpin_get = *RNAc::exp_param_exphairpin_get;
*swig_exphairpin_set = *RNAc::exp_param_exphairpin_set;
*swig_expbulge_get = *RNAc::exp_param_expbulge_get;
*swig_expbulge_set = *RNAc::exp_param_expbulge_set;
*swig_expinternal_get = *RNAc::exp_param_expinternal_get;
*swig_expinternal_set = *RNAc::exp_param_expinternal_set;
*swig_expmismatchExt_get = *RNAc::exp_param_expmismatchExt_get;
*swig_expmismatchExt_set = *RNAc::exp_param_expmismatchExt_set;
*swig_expmismatchI_get = *RNAc::exp_param_expmismatchI_get;
*swig_expmismatchI_set = *RNAc::exp_param_expmismatchI_set;
*swig_expmismatch23I_get = *RNAc::exp_param_expmismatch23I_get;
*swig_expmismatch23I_set = *RNAc::exp_param_expmismatch23I_set;
*swig_expmismatch1nI_get = *RNAc::exp_param_expmismatch1nI_get;
*swig_expmismatch1nI_set = *RNAc::exp_param_expmismatch1nI_set;
*swig_expmismatchH_get = *RNAc::exp_param_expmismatchH_get;
*swig_expmismatchH_set = *RNAc::exp_param_expmismatchH_set;
*swig_expmismatchM_get = *RNAc::exp_param_expmismatchM_get;
*swig_expmismatchM_set = *RNAc::exp_param_expmismatchM_set;
*swig_expdangle5_get = *RNAc::exp_param_expdangle5_get;
*swig_expdangle5_set = *RNAc::exp_param_expdangle5_set;
*swig_expdangle3_get = *RNAc::exp_param_expdangle3_get;
*swig_expdangle3_set = *RNAc::exp_param_expdangle3_set;
*swig_expint11_get = *RNAc::exp_param_expint11_get;
*swig_expint11_set = *RNAc::exp_param_expint11_set;
*swig_expint21_get = *RNAc::exp_param_expint21_get;
*swig_expint21_set = *RNAc::exp_param_expint21_set;
*swig_expint22_get = *RNAc::exp_param_expint22_get;
*swig_expint22_set = *RNAc::exp_param_expint22_set;
*swig_expninio_get = *RNAc::exp_param_expninio_get;
*swig_expninio_set = *RNAc::exp_param_expninio_set;
*swig_lxc_get = *RNAc::exp_param_lxc_get;
*swig_lxc_set = *RNAc::exp_param_lxc_set;
*swig_expMLbase_get = *RNAc::exp_param_expMLbase_get;
*swig_expMLbase_set = *RNAc::exp_param_expMLbase_set;
*swig_expMLintern_get = *RNAc::exp_param_expMLintern_get;
*swig_expMLintern_set = *RNAc::exp_param_expMLintern_set;
*swig_expMLclosing_get = *RNAc::exp_param_expMLclosing_get;
*swig_expMLclosing_set = *RNAc::exp_param_expMLclosing_set;
*swig_expTermAU_get = *RNAc::exp_param_expTermAU_get;
*swig_expTermAU_set = *RNAc::exp_param_expTermAU_set;
*swig_expDuplexInit_get = *RNAc::exp_param_expDuplexInit_get;
*swig_expDuplexInit_set = *RNAc::exp_param_expDuplexInit_set;
*swig_exptetra_get = *RNAc::exp_param_exptetra_get;
*swig_exptetra_set = *RNAc::exp_param_exptetra_set;
*swig_exptri_get = *RNAc::exp_param_exptri_get;
*swig_exptri_set = *RNAc::exp_param_exptri_set;
*swig_exphex_get = *RNAc::exp_param_exphex_get;
*swig_exphex_set = *RNAc::exp_param_exphex_set;
*swig_Tetraloops_get = *RNAc::exp_param_Tetraloops_get;
*swig_Tetraloops_set = *RNAc::exp_param_Tetraloops_set;
*swig_expTriloop_get = *RNAc::exp_param_expTriloop_get;
*swig_expTriloop_set = *RNAc::exp_param_expTriloop_set;
*swig_Triloops_get = *RNAc::exp_param_Triloops_get;
*swig_Triloops_set = *RNAc::exp_param_Triloops_set;
*swig_Hexaloops_get = *RNAc::exp_param_Hexaloops_get;
*swig_Hexaloops_set = *RNAc::exp_param_Hexaloops_set;
*swig_expTripleC_get = *RNAc::exp_param_expTripleC_get;
*swig_expTripleC_set = *RNAc::exp_param_expTripleC_set;
*swig_expMultipleCA_get = *RNAc::exp_param_expMultipleCA_get;
*swig_expMultipleCA_set = *RNAc::exp_param_expMultipleCA_set;
*swig_expMultipleCB_get = *RNAc::exp_param_expMultipleCB_get;
*swig_expMultipleCB_set = *RNAc::exp_param_expMultipleCB_set;
*swig_expgquad_get = *RNAc::exp_param_expgquad_get;
*swig_expgquad_set = *RNAc::exp_param_expgquad_set;
*swig_expgquadLayerMismatch_get = *RNAc::exp_param_expgquadLayerMismatch_get;
*swig_expgquadLayerMismatch_set = *RNAc::exp_param_expgquadLayerMismatch_set;
*swig_gquadLayerMismatchMax_get = *RNAc::exp_param_gquadLayerMismatchMax_get;
*swig_gquadLayerMismatchMax_set = *RNAc::exp_param_gquadLayerMismatchMax_set;
*swig_kT_get = *RNAc::exp_param_kT_get;
*swig_kT_set = *RNAc::exp_param_kT_set;
*swig_pf_scale_get = *RNAc::exp_param_pf_scale_get;
*swig_pf_scale_set = *RNAc::exp_param_pf_scale_set;
*swig_temperature_get = *RNAc::exp_param_temperature_get;
*swig_temperature_set = *RNAc::exp_param_temperature_set;
*swig_alpha_get = *RNAc::exp_param_alpha_get;
*swig_alpha_set = *RNAc::exp_param_alpha_set;
*swig_model_details_get = *RNAc::exp_param_model_details_get;
*swig_model_details_set = *RNAc::exp_param_model_details_set;
*swig_param_file_get = *RNAc::exp_param_param_file_get;
*swig_param_file_set = *RNAc::exp_param_param_file_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_exp_param(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_exp_param($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::md ##############

package RNA::md;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_temperature_get = *RNAc::md_temperature_get;
*swig_temperature_set = *RNAc::md_temperature_set;
*swig_betaScale_get = *RNAc::md_betaScale_get;
*swig_betaScale_set = *RNAc::md_betaScale_set;
*swig_pf_smooth_get = *RNAc::md_pf_smooth_get;
*swig_pf_smooth_set = *RNAc::md_pf_smooth_set;
*swig_dangles_get = *RNAc::md_dangles_get;
*swig_dangles_set = *RNAc::md_dangles_set;
*swig_special_hp_get = *RNAc::md_special_hp_get;
*swig_special_hp_set = *RNAc::md_special_hp_set;
*swig_noLP_get = *RNAc::md_noLP_get;
*swig_noLP_set = *RNAc::md_noLP_set;
*swig_noGU_get = *RNAc::md_noGU_get;
*swig_noGU_set = *RNAc::md_noGU_set;
*swig_noGUclosure_get = *RNAc::md_noGUclosure_get;
*swig_noGUclosure_set = *RNAc::md_noGUclosure_set;
*swig_logML_get = *RNAc::md_logML_get;
*swig_logML_set = *RNAc::md_logML_set;
*swig_circ_get = *RNAc::md_circ_get;
*swig_circ_set = *RNAc::md_circ_set;
*swig_gquad_get = *RNAc::md_gquad_get;
*swig_gquad_set = *RNAc::md_gquad_set;
*swig_uniq_ML_get = *RNAc::md_uniq_ML_get;
*swig_uniq_ML_set = *RNAc::md_uniq_ML_set;
*swig_energy_set_get = *RNAc::md_energy_set_get;
*swig_energy_set_set = *RNAc::md_energy_set_set;
*swig_backtrack_get = *RNAc::md_backtrack_get;
*swig_backtrack_set = *RNAc::md_backtrack_set;
*swig_backtrack_type_get = *RNAc::md_backtrack_type_get;
*swig_backtrack_type_set = *RNAc::md_backtrack_type_set;
*swig_compute_bpp_get = *RNAc::md_compute_bpp_get;
*swig_compute_bpp_set = *RNAc::md_compute_bpp_set;
*swig_nonstandards_get = *RNAc::md_nonstandards_get;
*swig_nonstandards_set = *RNAc::md_nonstandards_set;
*swig_max_bp_span_get = *RNAc::md_max_bp_span_get;
*swig_max_bp_span_set = *RNAc::md_max_bp_span_set;
*swig_min_loop_size_get = *RNAc::md_min_loop_size_get;
*swig_min_loop_size_set = *RNAc::md_min_loop_size_set;
*swig_window_size_get = *RNAc::md_window_size_get;
*swig_window_size_set = *RNAc::md_window_size_set;
*swig_oldAliEn_get = *RNAc::md_oldAliEn_get;
*swig_oldAliEn_set = *RNAc::md_oldAliEn_set;
*swig_ribo_get = *RNAc::md_ribo_get;
*swig_ribo_set = *RNAc::md_ribo_set;
*swig_cv_fact_get = *RNAc::md_cv_fact_get;
*swig_cv_fact_set = *RNAc::md_cv_fact_set;
*swig_nc_fact_get = *RNAc::md_nc_fact_get;
*swig_nc_fact_set = *RNAc::md_nc_fact_set;
*swig_sfact_get = *RNAc::md_sfact_get;
*swig_sfact_set = *RNAc::md_sfact_set;
*swig_rtype_get = *RNAc::md_rtype_get;
*swig_rtype_set = *RNAc::md_rtype_set;
*swig_alias_get = *RNAc::md_alias_get;
*swig_alias_set = *RNAc::md_alias_set;
*swig_pair_get = *RNAc::md_pair_get;
*swig_pair_set = *RNAc::md_pair_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_md(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_md($self);
        delete $OWNER{$self};
    }
}

*reset = *RNAc::md_reset;
*set_from_globals = *RNAc::md_set_from_globals;
*option_string = *RNAc::md_option_string;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::ep ##############

package RNA::ep;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_i_get = *RNAc::ep_i_get;
*swig_i_set = *RNAc::ep_i_set;
*swig_j_get = *RNAc::ep_j_get;
*swig_j_set = *RNAc::ep_j_set;
*swig_p_get = *RNAc::ep_p_get;
*swig_p_set = *RNAc::ep_p_set;
*swig_type_get = *RNAc::ep_type_get;
*swig_type_set = *RNAc::ep_type_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_ep(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_ep($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::hx ##############

package RNA::hx;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_start_get = *RNAc::hx_start_get;
*swig_start_set = *RNAc::hx_start_set;
*swig_end_get = *RNAc::hx_end_get;
*swig_end_set = *RNAc::hx_end_set;
*swig_length_get = *RNAc::hx_length_get;
*swig_length_set = *RNAc::hx_length_set;
*swig_up5_get = *RNAc::hx_up5_get;
*swig_up5_set = *RNAc::hx_up5_set;
*swig_up3_get = *RNAc::hx_up3_get;
*swig_up3_set = *RNAc::hx_up3_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_hx(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_hx($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::struct_en ##############

package RNA::struct_en;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_energy_get = *RNAc::struct_en_energy_get;
*swig_energy_set = *RNAc::struct_en_energy_set;
*swig_structure_get = *RNAc::struct_en_structure_get;
*swig_structure_set = *RNAc::struct_en_structure_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_struct_en(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_struct_en($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::COORDINATE ##############

package RNA::COORDINATE;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*get = *RNAc::COORDINATE_get;
*swig_X_get = *RNAc::COORDINATE_X_get;
*swig_X_set = *RNAc::COORDINATE_X_set;
*swig_Y_get = *RNAc::COORDINATE_Y_get;
*swig_Y_set = *RNAc::COORDINATE_Y_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_COORDINATE(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_COORDINATE($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::pbacktrack_mem ##############

package RNA::pbacktrack_mem;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_pbacktrack_mem(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_pbacktrack_mem($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::SOLUTION ##############

package RNA::SOLUTION;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_energy_get = *RNAc::SOLUTION_energy_get;
*swig_energy_set = *RNAc::SOLUTION_energy_set;
*swig_structure_get = *RNAc::SOLUTION_structure_get;
*swig_structure_set = *RNAc::SOLUTION_structure_set;
*get = *RNAc::SOLUTION_get;
*size = *RNAc::SOLUTION_size;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_SOLUTION($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = RNAc::new_SOLUTION(@_);
    bless $self, $pkg if defined($self);
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::subopt_solution ##############

package RNA::subopt_solution;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_energy_get = *RNAc::subopt_solution_energy_get;
*swig_energy_set = *RNAc::subopt_solution_energy_set;
*swig_structure_get = *RNAc::subopt_solution_structure_get;
*swig_structure_set = *RNAc::subopt_solution_structure_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_subopt_solution($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = RNAc::new_subopt_solution(@_);
    bless $self, $pkg if defined($self);
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::SuboptVector ##############

package RNA::SuboptVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_SuboptVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::SuboptVector_size;
*empty = *RNAc::SuboptVector_empty;
*clear = *RNAc::SuboptVector_clear;
*push = *RNAc::SuboptVector_push;
*pop = *RNAc::SuboptVector_pop;
*get = *RNAc::SuboptVector_get;
*set = *RNAc::SuboptVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_SuboptVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::cmd ##############

package RNA::cmd;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_cmd(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_cmd($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::duplexT ##############

package RNA::duplexT;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_i_get = *RNAc::duplexT_i_get;
*swig_i_set = *RNAc::duplexT_i_set;
*swig_j_get = *RNAc::duplexT_j_get;
*swig_j_set = *RNAc::duplexT_j_set;
*swig_structure_get = *RNAc::duplexT_structure_get;
*swig_structure_set = *RNAc::duplexT_structure_set;
*swig_energy_get = *RNAc::duplexT_energy_get;
*swig_energy_set = *RNAc::duplexT_energy_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_duplexT($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::duplex_list_t ##############

package RNA::duplex_list_t;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_i_get = *RNAc::duplex_list_t_i_get;
*swig_i_set = *RNAc::duplex_list_t_i_set;
*swig_j_get = *RNAc::duplex_list_t_j_get;
*swig_j_set = *RNAc::duplex_list_t_j_set;
*swig_energy_get = *RNAc::duplex_list_t_energy_get;
*swig_energy_set = *RNAc::duplex_list_t_energy_set;
*swig_structure_get = *RNAc::duplex_list_t_structure_get;
*swig_structure_set = *RNAc::duplex_list_t_structure_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_duplex_list_t($self);
        delete $OWNER{$self};
    }
}

sub new {
    my $pkg = shift;
    my $self = RNAc::new_duplex_list_t(@_);
    bless $self, $pkg if defined($self);
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::DuplexVector ##############

package RNA::DuplexVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_DuplexVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::DuplexVector_size;
*empty = *RNAc::DuplexVector_empty;
*clear = *RNAc::DuplexVector_clear;
*push = *RNAc::DuplexVector_push;
*pop = *RNAc::DuplexVector_pop;
*get = *RNAc::DuplexVector_get;
*set = *RNAc::DuplexVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_DuplexVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::move ##############

package RNA::move;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_pos_5_get = *RNAc::move_pos_5_get;
*swig_pos_5_set = *RNAc::move_pos_5_set;
*swig_pos_3_get = *RNAc::move_pos_3_get;
*swig_pos_3_set = *RNAc::move_pos_3_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_move(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_move($self);
        delete $OWNER{$self};
    }
}

*is_removal = *RNAc::move_is_removal;
*is_insertion = *RNAc::move_is_insertion;
*is_shift = *RNAc::move_is_shift;
*compare = *RNAc::move_compare;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::path ##############

package RNA::path;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_type_get = *RNAc::path_type_get;
*swig_type_set = *RNAc::path_type_set;
*swig_en_get = *RNAc::path_en_get;
*swig_en_set = *RNAc::path_en_set;
*swig_s_get = *RNAc::path_s_get;
*swig_s_set = *RNAc::path_s_set;
*swig_move_get = *RNAc::path_move_get;
*swig_move_set = *RNAc::path_move_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_path(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_path($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::path_options ##############

package RNA::path_options;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_path_options(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_path_options($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::heat_capacity_result ##############

package RNA::heat_capacity_result;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_temperature_get = *RNAc::heat_capacity_result_temperature_get;
*swig_temperature_set = *RNAc::heat_capacity_result_temperature_set;
*swig_heat_capacity_get = *RNAc::heat_capacity_result_heat_capacity_get;
*swig_heat_capacity_set = *RNAc::heat_capacity_result_heat_capacity_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_heat_capacity_result(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_heat_capacity_result($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::HeatCapacityVector ##############

package RNA::HeatCapacityVector;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my $self = RNAc::new_HeatCapacityVector(@_);
    bless $self, $pkg if defined($self);
}

*size = *RNAc::HeatCapacityVector_size;
*empty = *RNAc::HeatCapacityVector_empty;
*clear = *RNAc::HeatCapacityVector_clear;
*push = *RNAc::HeatCapacityVector_push;
*pop = *RNAc::HeatCapacityVector_pop;
*get = *RNAc::HeatCapacityVector_get;
*set = *RNAc::HeatCapacityVector_set;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_HeatCapacityVector($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::basepair ##############

package RNA::basepair;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*swig_i_get = *RNAc::basepair_i_get;
*swig_i_set = *RNAc::basepair_i_set;
*swig_j_get = *RNAc::basepair_j_get;
*swig_j_set = *RNAc::basepair_j_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_basepair(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_basepair($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : RNA::fold_compound ##############

package RNA::fold_compound;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( RNA );
%OWNER = ();
%ITERATORS = ();
*params_reset = *RNAc::fold_compound_params_reset;
*params_subst = *RNAc::fold_compound_params_subst;
*exp_params_rescale = *RNAc::fold_compound_exp_params_rescale;
*exp_params_reset = *RNAc::fold_compound_exp_params_reset;
*exp_params_subst = *RNAc::fold_compound_exp_params_subst;
*plist_from_probs = *RNAc::fold_compound_plist_from_probs;
*db_from_probs = *RNAc::fold_compound_db_from_probs;
*constraints_add = *RNAc::fold_compound_constraints_add;
*hc_init = *RNAc::fold_compound_hc_init;
*hc_add_up = *RNAc::fold_compound_hc_add_up;
*hc_add_bp_nonspecific = *RNAc::fold_compound_hc_add_bp_nonspecific;
*hc_add_bp = *RNAc::fold_compound_hc_add_bp;
*hc_add_from_db = *RNAc::fold_compound_hc_add_from_db;
*sc_remove = *RNAc::fold_compound_sc_remove;
*sc_init = *RNAc::fold_compound_sc_init;
*sc_add_up = *RNAc::fold_compound_sc_add_up;
*sc_add_bp = *RNAc::fold_compound_sc_add_bp;
*sc_set_bp = *RNAc::fold_compound_sc_set_bp;
*sc_set_up = *RNAc::fold_compound_sc_set_up;
*sc_set_stack = *RNAc::fold_compound_sc_set_stack;
*sc_add_stack = *RNAc::fold_compound_sc_add_stack;
*sc_add_SHAPE_deigan = *RNAc::fold_compound_sc_add_SHAPE_deigan;
*sc_add_SHAPE_deigan_ali = *RNAc::fold_compound_sc_add_SHAPE_deigan_ali;
*sc_add_SHAPE_zarringhalam = *RNAc::fold_compound_sc_add_SHAPE_zarringhalam;
*sc_add_hi_motif = *RNAc::fold_compound_sc_add_hi_motif;
*eval_structure = *RNAc::fold_compound_eval_structure;
*eval_structure_pt = *RNAc::fold_compound_eval_structure_pt;
*eval_structure_verbose = *RNAc::fold_compound_eval_structure_verbose;
*eval_structure_pt_verbose = *RNAc::fold_compound_eval_structure_pt_verbose;
*eval_covar_structure = *RNAc::fold_compound_eval_covar_structure;
*eval_loop_pt = *RNAc::fold_compound_eval_loop_pt;
*eval_move = *RNAc::fold_compound_eval_move;
*eval_move_pt = *RNAc::fold_compound_eval_move_pt;
*eval_ext_stem = *RNAc::fold_compound_eval_ext_stem;
*E_hp_loop = *RNAc::fold_compound_E_hp_loop;
*E_ext_hp_loop = *RNAc::fold_compound_E_ext_hp_loop;
*eval_ext_hp_loop = *RNAc::fold_compound_eval_ext_hp_loop;
*eval_hp_loop = *RNAc::fold_compound_eval_hp_loop;
*exp_E_hp_loop = *RNAc::fold_compound_exp_E_hp_loop;
*E_int_loop = *RNAc::fold_compound_E_int_loop;
*eval_int_loop = *RNAc::fold_compound_eval_int_loop;
*E_ext_int_loop = *RNAc::fold_compound_E_ext_int_loop;
*E_stack = *RNAc::fold_compound_E_stack;
*exp_E_int_loop = *RNAc::fold_compound_exp_E_int_loop;
*exp_E_interior_loop = *RNAc::fold_compound_exp_E_interior_loop;
*maxmimum_matching = *RNAc::fold_compound_maxmimum_matching;
*mfe = *RNAc::fold_compound_mfe;
*mfe_dimer = *RNAc::fold_compound_mfe_dimer;
*backtrack = *RNAc::fold_compound_backtrack;
*mfe_window = *RNAc::fold_compound_mfe_window;
*mfe_window_zscore = *RNAc::fold_compound_mfe_window_zscore;
*zsc_filter_init = *RNAc::fold_compound_zsc_filter_init;
*zsc_filter_update = *RNAc::fold_compound_zsc_filter_update;
*zsc_filter_free = *RNAc::fold_compound_zsc_filter_free;
*zsc_filter_on = *RNAc::fold_compound_zsc_filter_on;
*zsc_filter_threshold = *RNAc::fold_compound_zsc_filter_threshold;
*zsc_compute = *RNAc::fold_compound_zsc_compute;
*pf = *RNAc::fold_compound_pf;
*mean_bp_distance = *RNAc::fold_compound_mean_bp_distance;
*ensemble_defect = *RNAc::fold_compound_ensemble_defect;
*positional_entropy = *RNAc::fold_compound_positional_entropy;
*pr_structure = *RNAc::fold_compound_pr_structure;
*pr_energy = *RNAc::fold_compound_pr_energy;
*pf_dimer = *RNAc::fold_compound_pf_dimer;
*bpp = *RNAc::fold_compound_bpp;
*centroid = *RNAc::fold_compound_centroid;
*MEA = *RNAc::fold_compound_MEA;
*subopt = *RNAc::fold_compound_subopt;
*subopt_zuker = *RNAc::fold_compound_subopt_zuker;
*sequence_add = *RNAc::fold_compound_sequence_add;
*sequence_remove = *RNAc::fold_compound_sequence_remove;
*sequence_remove_all = *RNAc::fold_compound_sequence_remove_all;
*sequence_prepare = *RNAc::fold_compound_sequence_prepare;
*ud_add_motif = *RNAc::fold_compound_ud_add_motif;
*ud_remove = *RNAc::fold_compound_ud_remove;
*commands_apply = *RNAc::fold_compound_commands_apply;
*file_commands_apply = *RNAc::fold_compound_file_commands_apply;
*rotational_symmetry_db = *RNAc::fold_compound_rotational_symmetry_db;
*neighbors = *RNAc::fold_compound_neighbors;
*path = *RNAc::fold_compound_path;
*path_gradient = *RNAc::fold_compound_path_gradient;
*path_random = *RNAc::fold_compound_path_random;
*path_findpath_saddle = *RNAc::fold_compound_path_findpath_saddle;
*path_findpath = *RNAc::fold_compound_path_findpath;
*path_direct = *RNAc::fold_compound_path_direct;
*heat_capacity = *RNAc::fold_compound_heat_capacity;
*add_auxdata = *RNAc::fold_compound_add_auxdata;
*add_callback = *RNAc::fold_compound_add_callback;
*sc_add_data = *RNAc::fold_compound_sc_add_data;
*sc_add_f = *RNAc::fold_compound_sc_add_f;
*sc_add_bt = *RNAc::fold_compound_sc_add_bt;
*sc_add_exp_f = *RNAc::fold_compound_sc_add_exp_f;
*ud_set_data = *RNAc::fold_compound_ud_set_data;
*ud_set_prod_rule_cb = *RNAc::fold_compound_ud_set_prod_rule_cb;
*ud_set_exp_prod_rule_cb = *RNAc::fold_compound_ud_set_exp_prod_rule_cb;
*ud_set_prob_cb = *RNAc::fold_compound_ud_set_prob_cb;
*subopt_cb = *RNAc::fold_compound_subopt_cb;
*pbacktrack = *RNAc::fold_compound_pbacktrack;
*pbacktrack5 = *RNAc::fold_compound_pbacktrack5;
*pbacktrack_sub = *RNAc::fold_compound_pbacktrack_sub;
*mfe_window_cb = *RNAc::fold_compound_mfe_window_cb;
*mfe_window_zscore_cb = *RNAc::fold_compound_mfe_window_zscore_cb;
*probs_window = *RNAc::fold_compound_probs_window;
*heat_capacity_cb = *RNAc::fold_compound_heat_capacity_cb;
*swig_type_get = *RNAc::fold_compound_type_get;
*swig_type_set = *RNAc::fold_compound_type_set;
*swig_length_get = *RNAc::fold_compound_length_get;
*swig_length_set = *RNAc::fold_compound_length_set;
*swig_strands_get = *RNAc::fold_compound_strands_get;
*swig_strands_set = *RNAc::fold_compound_strands_set;
*swig_params_get = *RNAc::fold_compound_params_get;
*swig_params_set = *RNAc::fold_compound_params_set;
*swig_exp_params_get = *RNAc::fold_compound_exp_params_get;
*swig_exp_params_set = *RNAc::fold_compound_exp_params_set;
sub new {
    my $pkg = shift;
    my $self = RNAc::new_fold_compound(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        RNAc::delete_fold_compound($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- CONSTANT STUBS -------

package RNA;

sub PARAMETER_FORMAT_DEFAULT () { $RNAc::PARAMETER_FORMAT_DEFAULT }
sub UNKNOWN () { $RNAc::UNKNOWN }
sub QUIT () { $RNAc::QUIT }
sub S () { $RNAc::S }
sub S_H () { $RNAc::S_H }
sub HP () { $RNAc::HP }
sub HP_H () { $RNAc::HP_H }
sub B () { $RNAc::B }
sub B_H () { $RNAc::B_H }
sub IL () { $RNAc::IL }
sub IL_H () { $RNAc::IL_H }
sub MMH () { $RNAc::MMH }
sub MMH_H () { $RNAc::MMH_H }
sub MMI () { $RNAc::MMI }
sub MMI_H () { $RNAc::MMI_H }
sub MMI1N () { $RNAc::MMI1N }
sub MMI1N_H () { $RNAc::MMI1N_H }
sub MMI23 () { $RNAc::MMI23 }
sub MMI23_H () { $RNAc::MMI23_H }
sub MMM () { $RNAc::MMM }
sub MMM_H () { $RNAc::MMM_H }
sub MME () { $RNAc::MME }
sub MME_H () { $RNAc::MME_H }
sub D5 () { $RNAc::D5 }
sub D5_H () { $RNAc::D5_H }
sub D3 () { $RNAc::D3 }
sub D3_H () { $RNAc::D3_H }
sub INT11 () { $RNAc::INT11 }
sub INT11_H () { $RNAc::INT11_H }
sub INT21 () { $RNAc::INT21 }
sub INT21_H () { $RNAc::INT21_H }
sub INT22 () { $RNAc::INT22 }
sub INT22_H () { $RNAc::INT22_H }
sub ML () { $RNAc::ML }
sub TL () { $RNAc::TL }
sub TRI () { $RNAc::TRI }
sub HEX () { $RNAc::HEX }
sub NIN () { $RNAc::NIN }
sub MISC () { $RNAc::MISC }
sub GASCONST () { $RNAc::GASCONST }
sub K0 () { $RNAc::K0 }
sub INF () { $RNAc::INF }
sub EMAX () { $RNAc::EMAX }
sub FORBIDDEN () { $RNAc::FORBIDDEN }
sub BONUS () { $RNAc::BONUS }
sub NBPAIRS () { $RNAc::NBPAIRS }
sub TURN () { $RNAc::TURN }
sub MAXLOOP () { $RNAc::MAXLOOP }
sub UNIT () { $RNAc::UNIT }
sub MINPSCORE () { $RNAc::MINPSCORE }
sub NBASES () { $RNAc::NBASES }
sub MAXALPHA () { $RNAc::MAXALPHA }
sub FILENAME_MAX_LENGTH () { $RNAc::FILENAME_MAX_LENGTH }
sub FILENAME_ID_LENGTH () { $RNAc::FILENAME_ID_LENGTH }
sub PLIST_TYPE_BASEPAIR () { $RNAc::PLIST_TYPE_BASEPAIR }
sub PLIST_TYPE_GQUAD () { $RNAc::PLIST_TYPE_GQUAD }
sub PLIST_TYPE_H_MOTIF () { $RNAc::PLIST_TYPE_H_MOTIF }
sub PLIST_TYPE_I_MOTIF () { $RNAc::PLIST_TYPE_I_MOTIF }
sub PLIST_TYPE_UD_MOTIF () { $RNAc::PLIST_TYPE_UD_MOTIF }
sub PLIST_TYPE_STACK () { $RNAc::PLIST_TYPE_STACK }
sub STRUCTURE_TREE_HIT () { $RNAc::STRUCTURE_TREE_HIT }
sub STRUCTURE_TREE_SHAPIRO_SHORT () { $RNAc::STRUCTURE_TREE_SHAPIRO_SHORT }
sub STRUCTURE_TREE_SHAPIRO () { $RNAc::STRUCTURE_TREE_SHAPIRO }
sub STRUCTURE_TREE_SHAPIRO_EXT () { $RNAc::STRUCTURE_TREE_SHAPIRO_EXT }
sub STRUCTURE_TREE_SHAPIRO_WEIGHT () { $RNAc::STRUCTURE_TREE_SHAPIRO_WEIGHT }
sub STRUCTURE_TREE_EXPANDED () { $RNAc::STRUCTURE_TREE_EXPANDED }
sub BRACKETS_RND () { $RNAc::BRACKETS_RND }
sub BRACKETS_ANG () { $RNAc::BRACKETS_ANG }
sub BRACKETS_SQR () { $RNAc::BRACKETS_SQR }
sub BRACKETS_CLY () { $RNAc::BRACKETS_CLY }
sub BRACKETS_ALPHA () { $RNAc::BRACKETS_ALPHA }
sub BRACKETS_DEFAULT () { $RNAc::BRACKETS_DEFAULT }
sub BRACKETS_ANY () { $RNAc::BRACKETS_ANY }
sub ALN_DEFAULT () { $RNAc::ALN_DEFAULT }
sub ALN_RNA () { $RNAc::ALN_RNA }
sub ALN_DNA () { $RNAc::ALN_DNA }
sub ALN_UPPERCASE () { $RNAc::ALN_UPPERCASE }
sub ALN_LOWERCASE () { $RNAc::ALN_LOWERCASE }
sub MEASURE_SHANNON_ENTROPY () { $RNAc::MEASURE_SHANNON_ENTROPY }
sub GRADIENT () { $RNAc::GRADIENT }
sub FIRST () { $RNAc::FIRST }
sub ADAPTIVE () { $RNAc::ADAPTIVE }
sub DECOMP_PAIR_HP () { $RNAc::DECOMP_PAIR_HP }
sub DECOMP_PAIR_IL () { $RNAc::DECOMP_PAIR_IL }
sub DECOMP_PAIR_ML () { $RNAc::DECOMP_PAIR_ML }
sub DECOMP_ML_ML_ML () { $RNAc::DECOMP_ML_ML_ML }
sub DECOMP_ML_STEM () { $RNAc::DECOMP_ML_STEM }
sub DECOMP_ML_ML () { $RNAc::DECOMP_ML_ML }
sub DECOMP_ML_UP () { $RNAc::DECOMP_ML_UP }
sub DECOMP_ML_ML_STEM () { $RNAc::DECOMP_ML_ML_STEM }
sub DECOMP_ML_COAXIAL () { $RNAc::DECOMP_ML_COAXIAL }
sub DECOMP_EXT_EXT () { $RNAc::DECOMP_EXT_EXT }
sub DECOMP_EXT_UP () { $RNAc::DECOMP_EXT_UP }
sub DECOMP_EXT_STEM () { $RNAc::DECOMP_EXT_STEM }
sub DECOMP_EXT_EXT_EXT () { $RNAc::DECOMP_EXT_EXT_EXT }
sub DECOMP_EXT_STEM_EXT () { $RNAc::DECOMP_EXT_STEM_EXT }
sub DECOMP_EXT_STEM_OUTSIDE () { $RNAc::DECOMP_EXT_STEM_OUTSIDE }
sub DECOMP_EXT_EXT_STEM () { $RNAc::DECOMP_EXT_EXT_STEM }
sub DECOMP_EXT_EXT_STEM1 () { $RNAc::DECOMP_EXT_EXT_STEM1 }
sub CONSTRAINT_DB () { $RNAc::CONSTRAINT_DB }
sub CONSTRAINT_DB_ENFORCE_BP () { $RNAc::CONSTRAINT_DB_ENFORCE_BP }
sub CONSTRAINT_DB_PIPE () { $RNAc::CONSTRAINT_DB_PIPE }
sub CONSTRAINT_DB_DOT () { $RNAc::CONSTRAINT_DB_DOT }
sub CONSTRAINT_DB_X () { $RNAc::CONSTRAINT_DB_X }
sub CONSTRAINT_DB_ANG_BRACK () { $RNAc::CONSTRAINT_DB_ANG_BRACK }
sub CONSTRAINT_DB_RND_BRACK () { $RNAc::CONSTRAINT_DB_RND_BRACK }
sub CONSTRAINT_DB_INTRAMOL () { $RNAc::CONSTRAINT_DB_INTRAMOL }
sub CONSTRAINT_DB_INTERMOL () { $RNAc::CONSTRAINT_DB_INTERMOL }
sub CONSTRAINT_DB_GQUAD () { $RNAc::CONSTRAINT_DB_GQUAD }
sub CONSTRAINT_DB_DEFAULT () { $RNAc::CONSTRAINT_DB_DEFAULT }
sub CONSTRAINT_CONTEXT_EXT_LOOP () { $RNAc::CONSTRAINT_CONTEXT_EXT_LOOP }
sub CONSTRAINT_CONTEXT_HP_LOOP () { $RNAc::CONSTRAINT_CONTEXT_HP_LOOP }
sub CONSTRAINT_CONTEXT_INT_LOOP () { $RNAc::CONSTRAINT_CONTEXT_INT_LOOP }
sub CONSTRAINT_CONTEXT_INT_LOOP_ENC () { $RNAc::CONSTRAINT_CONTEXT_INT_LOOP_ENC }
sub CONSTRAINT_CONTEXT_MB_LOOP () { $RNAc::CONSTRAINT_CONTEXT_MB_LOOP }
sub CONSTRAINT_CONTEXT_MB_LOOP_ENC () { $RNAc::CONSTRAINT_CONTEXT_MB_LOOP_ENC }
sub CONSTRAINT_CONTEXT_ENFORCE () { $RNAc::CONSTRAINT_CONTEXT_ENFORCE }
sub CONSTRAINT_CONTEXT_NO_REMOVE () { $RNAc::CONSTRAINT_CONTEXT_NO_REMOVE }
sub CONSTRAINT_CONTEXT_ALL_LOOPS () { $RNAc::CONSTRAINT_CONTEXT_ALL_LOOPS }
sub CONSTRAINT_CONTEXT_NONE () { $RNAc::CONSTRAINT_CONTEXT_NONE }
sub CONSTRAINT_CONTEXT_CLOSING_LOOPS () { $RNAc::CONSTRAINT_CONTEXT_CLOSING_LOOPS }
sub CONSTRAINT_CONTEXT_ENCLOSED_LOOPS () { $RNAc::CONSTRAINT_CONTEXT_ENCLOSED_LOOPS }
sub ZSCORE_OPTIONS_NONE () { $RNAc::ZSCORE_OPTIONS_NONE }
sub ZSCORE_FILTER_ON () { $RNAc::ZSCORE_FILTER_ON }
sub ZSCORE_PRE_FILTER () { $RNAc::ZSCORE_PRE_FILTER }
sub ZSCORE_REPORT_SUBSUMED () { $RNAc::ZSCORE_REPORT_SUBSUMED }
sub ZSCORE_MODEL_DEFAULT () { $RNAc::ZSCORE_MODEL_DEFAULT }
sub ZSCORE_SETTINGS_DEFAULT () { $RNAc::ZSCORE_SETTINGS_DEFAULT }
sub PBACKTRACK_DEFAULT () { $RNAc::PBACKTRACK_DEFAULT }
sub PBACKTRACK_NON_REDUNDANT () { $RNAc::PBACKTRACK_NON_REDUNDANT }
sub EXT_LOOP () { $RNAc::EXT_LOOP }
sub HP_LOOP () { $RNAc::HP_LOOP }
sub INT_LOOP () { $RNAc::INT_LOOP }
sub MB_LOOP () { $RNAc::MB_LOOP }
sub ANY_LOOP () { $RNAc::ANY_LOOP }
sub PROBS_WINDOW_BPP () { $RNAc::PROBS_WINDOW_BPP }
sub PROBS_WINDOW_UP () { $RNAc::PROBS_WINDOW_UP }
sub PROBS_WINDOW_STACKP () { $RNAc::PROBS_WINDOW_STACKP }
sub PROBS_WINDOW_UP_SPLIT () { $RNAc::PROBS_WINDOW_UP_SPLIT }
sub PROBS_WINDOW_PF () { $RNAc::PROBS_WINDOW_PF }
sub MAXDOS () { $RNAc::MAXDOS }
sub FILE_FORMAT_MSA_CLUSTAL () { $RNAc::FILE_FORMAT_MSA_CLUSTAL }
sub FILE_FORMAT_MSA_DEFAULT () { $RNAc::FILE_FORMAT_MSA_DEFAULT }
sub FILE_FORMAT_MSA_FASTA () { $RNAc::FILE_FORMAT_MSA_FASTA }
sub FILE_FORMAT_MSA_MAF () { $RNAc::FILE_FORMAT_MSA_MAF }
sub FILE_FORMAT_MSA_NOCHECK () { $RNAc::FILE_FORMAT_MSA_NOCHECK }
sub FILE_FORMAT_MSA_STOCKHOLM () { $RNAc::FILE_FORMAT_MSA_STOCKHOLM }
sub FILE_FORMAT_MSA_MIS () { $RNAc::FILE_FORMAT_MSA_MIS }
sub FILE_FORMAT_MSA_UNKNOWN () { $RNAc::FILE_FORMAT_MSA_UNKNOWN }
sub FILE_FORMAT_MSA_QUIET () { $RNAc::FILE_FORMAT_MSA_QUIET }
sub FILE_FORMAT_MSA_SILENT () { $RNAc::FILE_FORMAT_MSA_SILENT }
sub FILE_FORMAT_MSA_APPEND () { $RNAc::FILE_FORMAT_MSA_APPEND }
sub SEQUENCE_RNA () { $RNAc::SEQUENCE_RNA }
sub SEQUENCE_DNA () { $RNAc::SEQUENCE_DNA }
sub UNSTRUCTURED_DOMAIN_EXT_LOOP () { $RNAc::UNSTRUCTURED_DOMAIN_EXT_LOOP }
sub UNSTRUCTURED_DOMAIN_HP_LOOP () { $RNAc::UNSTRUCTURED_DOMAIN_HP_LOOP }
sub UNSTRUCTURED_DOMAIN_INT_LOOP () { $RNAc::UNSTRUCTURED_DOMAIN_INT_LOOP }
sub UNSTRUCTURED_DOMAIN_MB_LOOP () { $RNAc::UNSTRUCTURED_DOMAIN_MB_LOOP }
sub UNSTRUCTURED_DOMAIN_ALL_LOOPS () { $RNAc::UNSTRUCTURED_DOMAIN_ALL_LOOPS }
sub UNSTRUCTURED_DOMAIN_MOTIF () { $RNAc::UNSTRUCTURED_DOMAIN_MOTIF }
sub CMD_PARSE_DEFAULTS () { $RNAc::CMD_PARSE_DEFAULTS }
sub CMD_PARSE_HC () { $RNAc::CMD_PARSE_HC }
sub CMD_PARSE_SC () { $RNAc::CMD_PARSE_SC }
sub CMD_PARSE_SD () { $RNAc::CMD_PARSE_SD }
sub CMD_PARSE_UD () { $RNAc::CMD_PARSE_UD }
sub MOVESET_INSERTION () { $RNAc::MOVESET_INSERTION }
sub MOVESET_DELETION () { $RNAc::MOVESET_DELETION }
sub MOVESET_SHIFT () { $RNAc::MOVESET_SHIFT }
sub MOVESET_NO_LP () { $RNAc::MOVESET_NO_LP }
sub MOVESET_DEFAULT () { $RNAc::MOVESET_DEFAULT }
sub NEIGHBOR_CHANGE () { $RNAc::NEIGHBOR_CHANGE }
sub NEIGHBOR_INVALID () { $RNAc::NEIGHBOR_INVALID }
sub NEIGHBOR_NEW () { $RNAc::NEIGHBOR_NEW }
sub PATH_STEEPEST_DESCENT () { $RNAc::PATH_STEEPEST_DESCENT }
sub PATH_RANDOM () { $RNAc::PATH_RANDOM }
sub PATH_NO_TRANSITION_OUTPUT () { $RNAc::PATH_NO_TRANSITION_OUTPUT }
sub PATH_DEFAULT () { $RNAc::PATH_DEFAULT }
sub PATH_TYPE_DOT_BRACKET () { $RNAc::PATH_TYPE_DOT_BRACKET }
sub PATH_TYPE_MOVES () { $RNAc::PATH_TYPE_MOVES }
sub FC_TYPE_SINGLE () { $RNAc::FC_TYPE_SINGLE }
sub FC_TYPE_COMPARATIVE () { $RNAc::FC_TYPE_COMPARATIVE }
sub STATUS_MFE_PRE () { $RNAc::STATUS_MFE_PRE }
sub STATUS_MFE_POST () { $RNAc::STATUS_MFE_POST }
sub STATUS_PF_PRE () { $RNAc::STATUS_PF_PRE }
sub STATUS_PF_POST () { $RNAc::STATUS_PF_POST }
sub OPTION_DEFAULT () { $RNAc::OPTION_DEFAULT }
sub OPTION_MFE () { $RNAc::OPTION_MFE }
sub OPTION_PF () { $RNAc::OPTION_PF }
sub OPTION_HYBRID () { $RNAc::OPTION_HYBRID }
sub OPTION_EVAL_ONLY () { $RNAc::OPTION_EVAL_ONLY }
sub OPTION_WINDOW () { $RNAc::OPTION_WINDOW }

# ------- VARIABLE STUBS --------

package RNA;

*lxc37 = *RNAc::lxc37;
*stack37 = *RNAc::stack37;
*stackdH = *RNAc::stackdH;
*hairpin37 = *RNAc::hairpin37;
*hairpindH = *RNAc::hairpindH;
*bulge37 = *RNAc::bulge37;
*bulgedH = *RNAc::bulgedH;
*internal_loop37 = *RNAc::internal_loop37;
*internal_loopdH = *RNAc::internal_loopdH;
*mismatchI37 = *RNAc::mismatchI37;
*mismatchIdH = *RNAc::mismatchIdH;
*mismatch1nI37 = *RNAc::mismatch1nI37;
*mismatch23I37 = *RNAc::mismatch23I37;
*mismatch1nIdH = *RNAc::mismatch1nIdH;
*mismatch23IdH = *RNAc::mismatch23IdH;
*mismatchH37 = *RNAc::mismatchH37;
*mismatchM37 = *RNAc::mismatchM37;
*mismatchHdH = *RNAc::mismatchHdH;
*mismatchMdH = *RNAc::mismatchMdH;
*mismatchExt37 = *RNAc::mismatchExt37;
*mismatchExtdH = *RNAc::mismatchExtdH;
*dangle5_37 = *RNAc::dangle5_37;
*dangle3_37 = *RNAc::dangle3_37;
*dangle3_dH = *RNAc::dangle3_dH;
*dangle5_dH = *RNAc::dangle5_dH;
*int11_37 = *RNAc::int11_37;
*int11_dH = *RNAc::int11_dH;
*int21_37 = *RNAc::int21_37;
*int21_dH = *RNAc::int21_dH;
*int22_37 = *RNAc::int22_37;
*int22_dH = *RNAc::int22_dH;
*ML_BASE37 = *RNAc::ML_BASE37;
*ML_BASEdH = *RNAc::ML_BASEdH;
*ML_closing37 = *RNAc::ML_closing37;
*ML_closingdH = *RNAc::ML_closingdH;
*ML_intern37 = *RNAc::ML_intern37;
*ML_interndH = *RNAc::ML_interndH;
*TripleC37 = *RNAc::TripleC37;
*TripleCdH = *RNAc::TripleCdH;
*MultipleCA37 = *RNAc::MultipleCA37;
*MultipleCAdH = *RNAc::MultipleCAdH;
*MultipleCB37 = *RNAc::MultipleCB37;
*MultipleCBdH = *RNAc::MultipleCBdH;
*MAX_NINIO = *RNAc::MAX_NINIO;
*ninio37 = *RNAc::ninio37;
*niniodH = *RNAc::niniodH;
*TerminalAU37 = *RNAc::TerminalAU37;
*TerminalAUdH = *RNAc::TerminalAUdH;
*DuplexInit37 = *RNAc::DuplexInit37;
*DuplexInitdH = *RNAc::DuplexInitdH;
*Tetraloops = *RNAc::Tetraloops;
*Tetraloop37 = *RNAc::Tetraloop37;
*TetraloopdH = *RNAc::TetraloopdH;
*Triloops = *RNAc::Triloops;
*Triloop37 = *RNAc::Triloop37;
*TriloopdH = *RNAc::TriloopdH;
*Hexaloops = *RNAc::Hexaloops;
*Hexaloop37 = *RNAc::Hexaloop37;
*HexaloopdH = *RNAc::HexaloopdH;
*GQuadAlpha37 = *RNAc::GQuadAlpha37;
*GQuadAlphadH = *RNAc::GQuadAlphadH;
*GQuadBeta37 = *RNAc::GQuadBeta37;
*GQuadBetadH = *RNAc::GQuadBetadH;
*GQuadLayerMismatch37 = *RNAc::GQuadLayerMismatch37;
*GQuadLayerMismatchH = *RNAc::GQuadLayerMismatchH;
*GQuadLayerMismatchMax = *RNAc::GQuadLayerMismatchMax;
*Tmeasure = *RNAc::Tmeasure;
*temperature = *RNAc::temperature;
*dangles = *RNAc::dangles;
*betaScale = *RNAc::betaScale;
*pf_smooth = *RNAc::pf_smooth;
*tetra_loop = *RNAc::tetra_loop;
*special_hp = *RNAc::special_hp;
*noLonelyPairs = *RNAc::noLonelyPairs;
*noLP = *RNAc::noLP;
*noGU = *RNAc::noGU;
*no_closingGU = *RNAc::no_closingGU;
*noGUclosure = *RNAc::noGUclosure;
*logML = *RNAc::logML;
*circ = *RNAc::circ;
*gquad = *RNAc::gquad;
*uniq_ML = *RNAc::uniq_ML;
*energy_set = *RNAc::energy_set;
*backtrack = *RNAc::backtrack;
*backtrack_type = *RNAc::backtrack_type;
*do_backtrack = *RNAc::do_backtrack;
*compute_bpp = *RNAc::compute_bpp;
*max_bp_span = *RNAc::max_bp_span;
*min_loop_size = *RNAc::min_loop_size;
*window_size = *RNAc::window_size;
*oldAliEn = *RNAc::oldAliEn;
*ribo = *RNAc::ribo;
*cv_fact = *RNAc::cv_fact;
*nc_fact = *RNAc::nc_fact;
*sfact = *RNAc::sfact;
*pf_scale = *RNAc::pf_scale;
*nonstandards = *RNAc::nonstandards;
*xsubi = *RNAc::xsubi;
*rna_plot_type = *RNAc::rna_plot_type;
*cut_point = *RNAc::cut_point;
*eos_debug = *RNAc::eos_debug;
*st_back = *RNAc::st_back;
*mirnatog = *RNAc::mirnatog;
*F_monomer = *RNAc::F_monomer;
*subopt_sorted = *RNAc::subopt_sorted;
*print_energy = *RNAc::print_energy;
*density_of_states = *RNAc::density_of_states;
*symbolset = *RNAc::symbolset;
*final_cost = *RNAc::final_cost;
*give_up = *RNAc::give_up;
*inv_verbose = *RNAc::inv_verbose;
*loop_size = *RNAc::loop_size;
*helix_size = *RNAc::helix_size;
*loop_degree = *RNAc::loop_degree;
*loops = *RNAc::loops;
*unpaired = *RNAc::unpaired;
*pairs = *RNAc::pairs;
*edit_backtrack = *RNAc::edit_backtrack;
*aligned_line = *RNAc::aligned_line;
*cost_matrix = *RNAc::cost_matrix;
*base_pair = *RNAc::base_pair;
*pr = *RNAc::pr;
*iindx = *RNAc::iindx;
*fold_constrained = *RNAc::fold_constrained;
*csv = *RNAc::csv;
*RibosumFile = *RNAc::RibosumFile;
*james_rule = *RNAc::james_rule;

our $VERSION = '2.5.0';
sub VERSION () { $VERSION };
1;
