import { aws_stepfunctions as stepfunctions } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { WebhookHandlerFunction } from './lambdas/webhook-handler-function';
import { Secrets } from './secrets';
/**
 * Properties for GithubWebhookHandler
 */
export interface GithubWebhookHandlerProps {
    /**
     * Step function in charge of handling the workflow job events and start the runners.
     */
    readonly orchestrator: stepfunctions.StateMachine;
    /**
     * Secrets used to communicate with GitHub.
     */
    readonly secrets: Secrets;
}
/**
 * Create a Lambda with a public URL to handle GitHub webhook events. After validating the event with the given secret, the orchestrator step function is called with information about the workflow job.
 *
 * This construct is not meant to be used by itself.
 */
export declare class GithubWebhookHandler extends Construct {
    /**
     * Public URL of webhook to be used with GitHub.
     */
    readonly url: string;
    /**
     * Webhook event handler.
     */
    readonly handler: WebhookHandlerFunction;
    constructor(scope: Construct, id: string, props: GithubWebhookHandlerProps);
}
