"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.singletonLambda = void 0;
const cdk = require("aws-cdk-lib");
/**
 * @internal
 */
function singletonLambda(functionType, scope, id, props) {
    const constructName = `${id}-dcc036c8-876b-451e-a2c1-552f9e06e9e1`;
    const existing = cdk.Stack.of(scope).node.tryFindChild(constructName);
    if (existing) {
        // Just assume this is true
        return existing;
    }
    return new functionType(cdk.Stack.of(scope), constructName, props);
}
exports.singletonLambda = singletonLambda;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsbUNBQW1DO0FBR25DOztHQUVHO0FBQ0gsU0FBZ0IsZUFBZSxDQUM3QixZQUF1RixFQUN2RixLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE4QjtJQUU1RCxNQUFNLGFBQWEsR0FBRyxHQUFHLEVBQUUsdUNBQXVDLENBQUM7SUFDbkUsTUFBTSxRQUFRLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUN0RSxJQUFJLFFBQVEsRUFBRTtRQUNaLDJCQUEyQjtRQUMzQixPQUFPLFFBQXdCLENBQUM7S0FDakM7SUFFRCxPQUFPLElBQUksWUFBWSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxFQUFFLGFBQWEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUNyRSxDQUFDO0FBWkQsMENBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBhd3NfbGFtYmRhIGFzIGxhbWJkYSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHNpbmdsZXRvbkxhbWJkYTxGdW5jdGlvblR5cGUgZXh0ZW5kcyBsYW1iZGEuRnVuY3Rpb24+KFxuICBmdW5jdGlvblR5cGU6IG5ldyAoczogQ29uc3RydWN0LCBpOiBzdHJpbmcsIHA/OiBsYW1iZGEuRnVuY3Rpb25PcHRpb25zKSA9PiBGdW5jdGlvblR5cGUsXG4gIHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogbGFtYmRhLkZ1bmN0aW9uT3B0aW9ucyk6IEZ1bmN0aW9uVHlwZSB7XG5cbiAgY29uc3QgY29uc3RydWN0TmFtZSA9IGAke2lkfS1kY2MwMzZjOC04NzZiLTQ1MWUtYTJjMS01NTJmOWUwNmU5ZTFgO1xuICBjb25zdCBleGlzdGluZyA9IGNkay5TdGFjay5vZihzY29wZSkubm9kZS50cnlGaW5kQ2hpbGQoY29uc3RydWN0TmFtZSk7XG4gIGlmIChleGlzdGluZykge1xuICAgIC8vIEp1c3QgYXNzdW1lIHRoaXMgaXMgdHJ1ZVxuICAgIHJldHVybiBleGlzdGluZyBhcyBGdW5jdGlvblR5cGU7XG4gIH1cblxuICByZXR1cm4gbmV3IGZ1bmN0aW9uVHlwZShjZGsuU3RhY2sub2Yoc2NvcGUpLCBjb25zdHJ1Y3ROYW1lLCBwcm9wcyk7XG59XG4iXX0=