"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const github_1 = require("./github");
exports.handler = async function (event) {
    const { githubSecrets, octokit } = await github_1.getOctokit(event.installationId);
    const response = await octokit.rest.actions.createRegistrationTokenForRepo({
        owner: event.owner,
        repo: event.repo,
    });
    return {
        domain: githubSecrets.domain,
        token: response.data.token,
    };
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9rZW4tcmV0cmlldmVyLmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9sYW1iZGFzL3Rva2VuLXJldHJpZXZlci5sYW1iZGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBc0M7QUFHdEMsT0FBTyxDQUFDLE9BQU8sR0FBRyxLQUFLLFdBQVcsS0FBOEI7SUFDOUQsTUFBTSxFQUFFLGFBQWEsRUFBRSxPQUFPLEVBQUUsR0FBRyxNQUFNLG1CQUFVLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBRTFFLE1BQU0sUUFBUSxHQUFHLE1BQU0sT0FBTyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsOEJBQThCLENBQUM7UUFDekUsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1FBQ2xCLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtLQUNqQixDQUFDLENBQUM7SUFFSCxPQUFPO1FBQ0wsTUFBTSxFQUFFLGFBQWEsQ0FBQyxNQUFNO1FBQzVCLEtBQUssRUFBRSxRQUFRLENBQUMsSUFBSSxDQUFDLEtBQUs7S0FDM0IsQ0FBQztBQUNKLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGdldE9jdG9raXQgfSBmcm9tICcuL2dpdGh1Yic7XG5pbXBvcnQgeyBTdGVwRnVuY3Rpb25MYW1iZGFJbnB1dCB9IGZyb20gJy4vaGVscGVycyc7XG5cbmV4cG9ydHMuaGFuZGxlciA9IGFzeW5jIGZ1bmN0aW9uIChldmVudDogU3RlcEZ1bmN0aW9uTGFtYmRhSW5wdXQpIHtcbiAgY29uc3QgeyBnaXRodWJTZWNyZXRzLCBvY3Rva2l0IH0gPSBhd2FpdCBnZXRPY3Rva2l0KGV2ZW50Lmluc3RhbGxhdGlvbklkKTtcblxuICBjb25zdCByZXNwb25zZSA9IGF3YWl0IG9jdG9raXQucmVzdC5hY3Rpb25zLmNyZWF0ZVJlZ2lzdHJhdGlvblRva2VuRm9yUmVwbyh7XG4gICAgb3duZXI6IGV2ZW50Lm93bmVyLFxuICAgIHJlcG86IGV2ZW50LnJlcG8sXG4gIH0pO1xuXG4gIHJldHVybiB7XG4gICAgZG9tYWluOiBnaXRodWJTZWNyZXRzLmRvbWFpbixcbiAgICB0b2tlbjogcmVzcG9uc2UuZGF0YS50b2tlbixcbiAgfTtcbn07XG4iXX0=