"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable-next-line import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const helpers_1 = require("./helpers");
const codebuild = new AWS.CodeBuild();
const ecr = new AWS.ECR();
const ib = new AWS.Imagebuilder();
/* eslint-disable @typescript-eslint/no-require-imports, import/no-extraneous-dependencies */
async function handler(event, context) {
    try {
        console.log(JSON.stringify({ ...event, ResponseURL: '...' }));
        const deleteOnly = event.ResourceProperties.DeleteOnly;
        const repoName = event.ResourceProperties.RepoName;
        const projectName = event.ResourceProperties.ProjectName;
        const ibName = event.ResourceProperties.ImageBuilderName;
        // let physicalResourceId: string;
        // let data: { [key: string]: string } = {};
        switch (event.RequestType) {
            case 'Create':
            case 'Update':
                if (deleteOnly) {
                    await helpers_1.customResourceRespond(event, 'SUCCESS', 'OK', 'Deleter', {});
                    break;
                }
                console.log(`Starting CodeBuild project ${projectName}`);
                await codebuild.startBuild({
                    projectName,
                    environmentVariablesOverride: [
                        {
                            type: 'PLAINTEXT',
                            name: 'STACK_ID',
                            value: event.StackId,
                        },
                        {
                            type: 'PLAINTEXT',
                            name: 'REQUEST_ID',
                            value: event.RequestId,
                        },
                        {
                            type: 'PLAINTEXT',
                            name: 'LOGICAL_RESOURCE_ID',
                            value: event.LogicalResourceId,
                        },
                        {
                            type: 'PLAINTEXT',
                            name: 'RESPONSE_URL',
                            value: event.ResponseURL,
                        },
                    ],
                }).promise();
                break;
            case 'Delete':
                const ecrImages = await ecr.listImages({ repositoryName: repoName, maxResults: 100 }).promise();
                if (ecrImages.imageIds && ecrImages.imageIds.length > 0) {
                    await ecr.batchDeleteImage({
                        imageIds: ecrImages.imageIds.map(i => {
                            return { imageDigest: i.imageDigest };
                        }),
                        repositoryName: repoName,
                    }).promise();
                }
                if (ibName) {
                    const ibImages = await ib.listImages({ filters: [{ name: 'name', values: [ibName] }] }).promise();
                    if (ibImages.imageVersionList) {
                        for (const v of ibImages.imageVersionList) {
                            if (v.arn) {
                                const ibImageVersions = await ib.listImageBuildVersions({ imageVersionArn: v.arn }).promise();
                                if (ibImageVersions.imageSummaryList) {
                                    for (const vs of ibImageVersions.imageSummaryList) {
                                        if (vs.arn) {
                                            console.log(`Deleting ${vs.arn}`);
                                            await ib.deleteImage({ imageBuildVersionArn: vs.arn }).promise();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                await helpers_1.customResourceRespond(event, 'SUCCESS', 'OK', event.PhysicalResourceId, {});
                break;
        }
    }
    catch (e) {
        console.error(e);
        await helpers_1.customResourceRespond(event, 'FAILED', e.message || 'Internal Error', context.logStreamName, {});
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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