<br>

![](metadrive/assets/logo-horizon.png)

<br>

# MetaDrive: Composing Diverse Driving Scenarios for Generalizable RL


<div style="text-align: center; width:100%; margin: 0 auto; display: inline-block">
<strong>
[
<a href="https://decisionforce.github.io/metadrive/">Website</a>
|
<a href="https://metadrive-simulator.readthedocs.io">Documentation</a>
|
<a href="https://github.com/decisionforce/metadrive">Github Repo</a>
]
</strong>
</div>

<br>

Welcome to MetaDrive! MetaDrive is an driving simulator with many key features:

- **Lightweight**: Extremely easy to download, install and run in almost all platforms. Up to 300 simulation step per second and easy to parallel.
- **Realistic**: Accurate physics simulation and multiple sensory input including Lidar, sensory data, top-down semantic map and first-person view images. 
- **Compositional**: Support generating infinite scenes and configuring various traffics, vehicles, and environmental settings.


## 🛠 Quick Start
Please install MetaDrive via:

```bash
git clone https://github.com/decisionforce/metadrive.git
cd metadrive
pip install numpy cython
pip install -e .
```

or

```bash
pip install metadrive-simulator
```

You can verify the installation and efficiency of MetaDrive via running:

```bash
# Go to a folder where no sub-folder calls metadrive
python -m metadrive.examples.profile_metadrive
```

The above script is supposed to be runnable in all places.
Note that please do not run the above command in the folder that has a sub-folder called `./metadrive`.

## 🚕 Examples

Please run the following command to drive the car in the environment manually with keyboard! 
Pressing W, A, S, D to move and turn and T to trigger the auto-drive mode!

```bash
python -m metadrive.examples.drive_in_single_agent_env
```

Besides, a scenario where safety must be concerned is included in examples, and this environment also shows how 
to compose a sophisticate scenario.

```bash
python -m metadrive.examples.drive_in_safe_metadrive_env
```

You can also drive in our Multi-agent RL environment. 

```bash
python -m metadrive.examples.drive_in_multi_agent_env --env roundabout
```
Accepted arguments:
- roundabout (default)
- intersection
- tollgate
- bottleneck
- parkinglot
- pgmap

To show the main feature, procedural generation, we provide a script to show BIG:

```bash
python -m metadrive.examples.procedural_generation
```

*Note that the above three scripts can not be run in headless machine.* 
Please refer to the installation guideline in documentation for more information.

Running the following command to draw the generated maps from procedural generation:

```bash
python -m metadrive.examples.draw_maps
```

To build the environment in python script, you can simply run:

```python
import metadrive  # Import this package to register the environment!
import gym

env = gym.make("MetaDrive-v0", config=dict(use_render=True))
# env = metadrive.MetaDriveEnv(config=dict(environment_num=100))  # Or build environment from class
env.reset()
for i in range(1000):
    obs, reward, done, info = env.step(env.action_space.sample())  # Use random policy
    env.render()
    if done:
        env.reset()
env.close()
```


## 📦 Predefined environment sets

We also define several Gym environment names, so user can start training in the minimalist manner:

```python
import gym
import metadrive  # Register the environment

env = gym.make("MetaDrive-v0")
```

The following table presents some predefined environment names. 

|&nbsp;  Gym Environment Name   | Random Seed Range | Number of Maps | Comments                                          |
| ----------------------- | ----------------- | -------------- | ------------------------------------------------------- |
| `MetaDrive-test-v0`       | [0, 200)          | 200            | Test set, not change for all experiments.               |
| `MetaDrive-validation-v0` &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;|[200, 1000)|800| Validation set.|
| `MetaDrive-v0`            | [1000, 1100)      | 100            | Default training setting, for quick start.              |
| `MetaDrive-10envs-v0`     | [1000, 1100)      | 10             | Training environment with 10 maps.                      |
| `MetaDrive-1000envs-v0`   | [1000, 1100)      | 1000           | Training environment with 1000 maps.                    |
| `MetaDrive-training0-v0`  | [3000, 4000)      | 1000           | First set of 1000 environments.                         |
| `MetaDrive-training1-v0`  | [5000, 6000)      | 1000           | Second set of 1000 environments.                        |
| `MetaDrive-training2-v0`  | [7000, 8000)      | 1000           | Thirds set of 1000 environments.                        |
| ...                     |                   |                | *More map set can be added in response to the requests* |



## 🏫 Documentations

Find more detail in: [MetaDrive](https://metadrive-simulator.readthedocs.io)


## 📎 Citation

Working in Progress!

[![build](https://github.com/decisionforce/metadrive/workflows/test/badge.svg)](http://github.com/decisionforce/metadrive/actions)
[![codecov](https://codecov.io/gh/decisionforce/metadrive/branch/main/graph/badge.svg?token=1ZYN8L5397)](https://codecov.io/gh/decisionforce/metadrive)
[![Documentation](https://readthedocs.org/projects/metadrive/badge/?version=latest)](https://metadrive.readthedocs.io)
[![GitHub license](https://img.shields.io/github/license/decisionforce/metadrive)](https://github.com/decisionforce/metadrive/blob/main/LICENSE.txt)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/2d6fabe328a644b49e1269497b741057)](https://www.codacy.com/gh/decisionforce/metadrive/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=decisionforce/metadrive&amp;utm_campaign=Badge_Grade)
[![GitHub contributors](https://img.shields.io/github/contributors/decisionforce/metadrive)](https://github.com/decisionforce/metadrive/graphs/contributors)

![](metadrive/assets/logo.png)
