# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/04-updates-and-cleaning.ipynb (unless otherwise specified).

__all__ = ['filter_cols_for_one_to_many', 'apply_updates']

# Cell
import json
import pandas as pd

import os
from warnings import warn

from powerdict import construct

# Cell
def filter_cols_for_one_to_many(df, cols=['longitude', 'latitude']):
    df_one_to_many_filt = df[df[cols].astype(str).agg(''.join, axis=1).str.contains(', ')]
    return df_one_to_many_filt

# Cell
def apply_updates(df, updates_data_dir):
    update_files = [f for f in os.listdir(updates_data_dir) if f.replace('.json', '') in df.columns]

    for update_file in update_files:
        with open(f'{updates_data_dir}/{update_file}', 'r') as f:
            update_dict = json.load(f)

        update_col = update_file.replace('.json', '')
        df = construct.update_df_col(df, update_col, update_dict)

    return df