"""
pycraigslist.api
~~~~~~~~~~~~~~~~

Suite of pycraigslist objects to interface with Craigslist.
"""

from pycraigslist import constants
from pycraigslist.base import BaseAPI, ParentMethods


class community(BaseAPI, ParentMethods):
    """community"""

    category = "ccc"
    query_filters = constants.query_filters.community

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    class act(BaseAPI):
        """activity partners"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ats(BaseAPI):
        """artists"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class kid(BaseAPI):
        """childcare"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class com(BaseAPI):
        """general community"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class grp(BaseAPI):
        """groups"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class vnn(BaseAPI):
        """local news and views"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class laf(BaseAPI):
        """lost & found"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mis(BaseAPI):
        """missed connections"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class muc(BaseAPI):
        """musicians"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class pet(BaseAPI):
        """pets"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class pol(BaseAPI):
        """politics"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rnr(BaseAPI):
        """rants & raves"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rid(BaseAPI):
        """rideshare"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class vol(BaseAPI):
        """volunteers"""

        query_filters = constants.query_filters.community

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)


class events(BaseAPI, ParentMethods):
    """events"""

    category = "eee"
    query_filters = constants.query_filters.events

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)


class forsale(BaseAPI, ParentMethods):
    """for sale"""

    category = "sss"
    query_filters = constants.query_filters.forsale

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    class ata(BaseAPI):
        """antiques"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ppa(BaseAPI):
        """appliances"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ppd(BaseAPI):
        """appliances - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class app(BaseAPI):
        """appliances - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ara(BaseAPI):
        """arts & crafts"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ard(BaseAPI):
        """arts & crafts - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class art(BaseAPI):
        """arts & crafts - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sna(BaseAPI):
        """atvs, utvs, snowmobiles"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class snd(BaseAPI):
        """atvs, utvs, snowmobiles - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class snw(BaseAPI):
        """atvs, utvs, snowmobiles - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class pta(BaseAPI):
        """auto parts"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ptd(BaseAPI):
        """auto parts - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class pts(BaseAPI):
        """auto parts - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wta(BaseAPI):
        """auto wheels & tires"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wtd(BaseAPI):
        """auto wheels & tires - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wto(BaseAPI):
        """auto wheels & tires - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ava(BaseAPI):
        """aviation"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class avd(BaseAPI):
        """aviation - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class avo(BaseAPI):
        """aviation - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class baa(BaseAPI):
        """baby & kid stuff"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bad(BaseAPI):
        """baby & kid stuff - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bab(BaseAPI):
        """baby & kid stuff - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bar(BaseAPI):
        """barter"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bip(BaseAPI):
        """bicycle parts"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bdp(BaseAPI):
        """bicycle parts - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bop(BaseAPI):
        """bicycle parts - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bia(BaseAPI):
        """bicycles"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bid(BaseAPI):
        """bicycles - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bik(BaseAPI):
        """bicycles - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bpa(BaseAPI):
        """boat parts & accessories"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bpd(BaseAPI):
        """boat parts & accessories - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bpo(BaseAPI):
        """boat parts & accessories - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class boo(BaseAPI):
        """boats"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bod(BaseAPI):
        """boats - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class boa(BaseAPI):
        """boats - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bka(BaseAPI):
        """books & magazines"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bkd(BaseAPI):
        """books & magazines - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bks(BaseAPI):
        """books & magazines - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bfa(BaseAPI):
        """business"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bfd(BaseAPI):
        """business - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bfs(BaseAPI):
        """business - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cta(BaseAPI):
        """cars & trucks"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ctd(BaseAPI):
        """cars & trucks - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cto(BaseAPI):
        """cars & trucks - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ema(BaseAPI):
        """cds / dvds / vhs"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class emq(BaseAPI):
        """cds / dvds / vhs - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class emd(BaseAPI):
        """cds / dvds / vhs - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class moa(BaseAPI):
        """cell phones"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mod(BaseAPI):
        """cell phones - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mob(BaseAPI):
        """cell phones - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cla(BaseAPI):
        """clothing & accessories"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cld(BaseAPI):
        """clothing & accessories - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class clo(BaseAPI):
        """clothing & accessories - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cba(BaseAPI):
        """collectibles"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cbd(BaseAPI):
        """collectibles - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class clt(BaseAPI):
        """collectibles - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class syp(BaseAPI):
        """computer parts"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sdp(BaseAPI):
        """computer parts - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sop(BaseAPI):
        """computer parts - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sya(BaseAPI):
        """computers"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class syd(BaseAPI):
        """computers - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sys(BaseAPI):
        """computers - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ela(BaseAPI):
        """electronics"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class eld(BaseAPI):
        """electronics - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ele(BaseAPI):
        """electronics - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class gra(BaseAPI):
        """farm & garden"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class zip(BaseAPI):
        """free stuff"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class fua(BaseAPI):
        """furniture"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class gms(BaseAPI):
        """garage & moving sales"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class foa(BaseAPI):
        """general for sale"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class fod(BaseAPI):
        """general for sale - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class fur(BaseAPI):
        """general for sale - by owner"""

        # An odd-ball - give 'for' alias 'fur'.

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = "for"
            super().__init__(*args, **kwargs)

    class haa(BaseAPI):
        """health and beauty"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class had(BaseAPI):
        """health and beauty - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hab(BaseAPI):
        """health and beauty - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hva(BaseAPI):
        """heavy equipment"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hvd(BaseAPI):
        """heavy equipment - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hvo(BaseAPI):
        """heavy equipment - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hsa(BaseAPI):
        """household items"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hsd(BaseAPI):
        """household items - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hsh(BaseAPI):
        """household items - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class jwa(BaseAPI):
        """jewelry"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class jwd(BaseAPI):
        """jewelry - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class jwl(BaseAPI):
        """jewelry - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class maa(BaseAPI):
        """materials"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mad(BaseAPI):
        """materials - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mat(BaseAPI):
        """materials - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mpa(BaseAPI):
        """motorcycle parts & accessories"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mpd(BaseAPI):
        """motorcycle parts & accessories - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mpo(BaseAPI):
        """motorcycle parts & accessories - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mca(BaseAPI):
        """motorcycles/scooters"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mcd(BaseAPI):
        """motorcycles/scooters - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mcy(BaseAPI):
        """motorcycles/scooters - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class msa(BaseAPI):
        """musical instruments"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class msd(BaseAPI):
        """musical instruments - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class msg(BaseAPI):
        """musical instruments - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class pha(BaseAPI):
        """photo/video"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class phd(BaseAPI):
        """photo/video - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class pho(BaseAPI):
        """photo/video - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rva(BaseAPI):
        """recreational vehicles"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rvd(BaseAPI):
        """recreational vehicles - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rvs(BaseAPI):
        """recreational vehicles - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sga(BaseAPI):
        """sporting goods"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sgd(BaseAPI):
        """sporting goods - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class spo(BaseAPI):
        """sporting goods - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tia(BaseAPI):
        """tickets"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tid(BaseAPI):
        """tickets - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tix(BaseAPI):
        """tickets - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tla(BaseAPI):
        """tools"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class taa(BaseAPI):
        """toys & games"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tad(BaseAPI):
        """toys & games - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tag(BaseAPI):
        """toys & games - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tra(BaseAPI):
        """trailers"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class trb(BaseAPI):
        """trailers - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tro(BaseAPI):
        """trailers - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class vga(BaseAPI):
        """video gaming"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class vgd(BaseAPI):
        """video gaming - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class vgm(BaseAPI):
        """video gaming - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class waa(BaseAPI):
        """wanted"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wad(BaseAPI):
        """wanted - by dealer"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wan(BaseAPI):
        """wanted - by owner"""

        query_filters = constants.query_filters.forsale

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)


class gigs(BaseAPI, ParentMethods):
    """gigs"""

    category = "ggg"
    query_filters = constants.query_filters.gigs

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    class cpg(BaseAPI):
        """computer gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class crg(BaseAPI):
        """creative gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cwg(BaseAPI):
        """crew gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class dmg(BaseAPI):
        """domestic gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class evg(BaseAPI):
        """event gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class lbg(BaseAPI):
        """labor gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tlg(BaseAPI):
        """talent gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wrg(BaseAPI):
        """writing gigs"""

        query_filters = constants.query_filters.gigs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)


class housing(BaseAPI, ParentMethods):
    """housing"""

    category = "hhh"
    query_filters = constants.query_filters.housing

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    class apa(BaseAPI):
        """apartments / housing for rent"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class swp(BaseAPI):
        """housing swap"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class off(BaseAPI):
        """office & commercial"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class prk(BaseAPI):
        """parking & storage"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rea(BaseAPI):
        """real estate"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class reb(BaseAPI):
        """real estate - by dealer"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class reo(BaseAPI):
        """real estate - by owner"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class roo(BaseAPI):
        """rooms & shares"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sub(BaseAPI):
        """sublets & temporary"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class vac(BaseAPI):
        """vacation rentals"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hou(BaseAPI):
        """wanted: apts"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rew(BaseAPI):
        """wanted: real estate"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sha(BaseAPI):
        """wanted: room/share"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sbw(BaseAPI):
        """wanted: sublet/temp"""

        query_filters = constants.query_filters.housing

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)


class jobs(BaseAPI, ParentMethods):
    """jobs"""

    category = "jjj"
    query_filters = constants.query_filters.jobs

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    class acc(BaseAPI):
        """accounting/finance"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ofc(BaseAPI):
        """admin/office"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class egr(BaseAPI):
        """architect/engineer/cad"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class med(BaseAPI):
        """art/media/design"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bus(BaseAPI):
        """business/mgmt"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class csr(BaseAPI):
        """customer service"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class edu(BaseAPI):
        """education/teaching"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class etc(BaseAPI):
        """et cetera"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class fbh(BaseAPI):
        """food/beverage/hospitality"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class lab(BaseAPI):
        """general labor"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class gov(BaseAPI):
        """government"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hea(BaseAPI):
        """healthcare"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hum(BaseAPI):
        """human resource"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class lgl(BaseAPI):
        """legal/paralegal"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mnu(BaseAPI):
        """manufacturing"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mar(BaseAPI):
        """marketing/advertising/pr"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class npo(BaseAPI):
        """nonprofit"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rej(BaseAPI):
        """real estate"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class ret(BaseAPI):
        """retail/wholesale"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sls(BaseAPI):
        """sales"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class spa(BaseAPI):
        """salon/spa/fitness"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sci(BaseAPI):
        """science/biotech"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sec(BaseAPI):
        """security"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class trd(BaseAPI):
        """skilled trades/artisan"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sof(BaseAPI):
        """software/qa/dba/etc"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sad(BaseAPI):
        """systems/networking"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tch(BaseAPI):
        """technical support"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class trp(BaseAPI):
        """transportation"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class tfr(BaseAPI):
        """tv/film/video/radio"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class web(BaseAPI):
        """web/html/info design"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wri(BaseAPI):
        """writing/editing"""

        query_filters = constants.query_filters.jobs

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)


class resumes(BaseAPI, ParentMethods):
    """resumes"""

    category = "rrr"
    query_filters = constants.query_filters.resumes

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)


class services(BaseAPI, ParentMethods):
    """services"""

    category = "bbb"
    query_filters = constants.query_filters.services

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    class aos(BaseAPI):
        """automotive services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class bts(BaseAPI):
        """beauty services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cms(BaseAPI):
        """cell phone / mobile services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cps(BaseAPI):
        """computer services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class crs(BaseAPI):
        """creative services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class cys(BaseAPI):
        """cycle services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class evs(BaseAPI):
        """event services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class fgs(BaseAPI):
        """farm & garden services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class fns(BaseAPI):
        """financial services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class hss(BaseAPI):
        """household services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class lbs(BaseAPI):
        """labor / hauling / moving"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class lgs(BaseAPI):
        """legal services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class lss(BaseAPI):
        """lessons & tutoring"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class mas(BaseAPI):
        """marine services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class pas(BaseAPI):
        """pet services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class rts(BaseAPI):
        """real estate services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class sks(BaseAPI):
        """skilled trade services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class biz(BaseAPI):
        """small biz ads"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class trv(BaseAPI):
        """travel/vacation services"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)

    class wet(BaseAPI):
        """writing / editing / translation"""

        query_filters = constants.query_filters.services

        def __init__(self, *args, **kwargs):
            self.category = self.__class__.__name__
            super().__init__(*args, **kwargs)
