# coding: utf-8

"""
    Xero Payroll AU

    This is the Xero Payroll API for orgs in Australia region.  # noqa: E501

    OpenAPI spec version: 2.3.3
    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class EarningsLine(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "earnings_rate_id": "str",
        "calculation_type": "EarningsRateCalculationType",
        "annual_salary": "float",
        "number_of_units_per_week": "float",
        "rate_per_unit": "float",
        "normal_number_of_units": "float",
        "amount": "float",
        "number_of_units": "float",
        "fixed_amount": "float",
    }

    attribute_map = {
        "earnings_rate_id": "EarningsRateID",
        "calculation_type": "CalculationType",
        "annual_salary": "AnnualSalary",
        "number_of_units_per_week": "NumberOfUnitsPerWeek",
        "rate_per_unit": "RatePerUnit",
        "normal_number_of_units": "NormalNumberOfUnits",
        "amount": "Amount",
        "number_of_units": "NumberOfUnits",
        "fixed_amount": "FixedAmount",
    }

    def __init__(
        self,
        earnings_rate_id=None,
        calculation_type=None,
        annual_salary=None,
        number_of_units_per_week=None,
        rate_per_unit=None,
        normal_number_of_units=None,
        amount=None,
        number_of_units=None,
        fixed_amount=None,
    ):  # noqa: E501
        """EarningsLine - a model defined in OpenAPI"""  # noqa: E501

        self._earnings_rate_id = None
        self._calculation_type = None
        self._annual_salary = None
        self._number_of_units_per_week = None
        self._rate_per_unit = None
        self._normal_number_of_units = None
        self._amount = None
        self._number_of_units = None
        self._fixed_amount = None
        self.discriminator = None

        self.earnings_rate_id = earnings_rate_id
        if calculation_type is not None:
            self.calculation_type = calculation_type
        if annual_salary is not None:
            self.annual_salary = annual_salary
        if number_of_units_per_week is not None:
            self.number_of_units_per_week = number_of_units_per_week
        if rate_per_unit is not None:
            self.rate_per_unit = rate_per_unit
        if normal_number_of_units is not None:
            self.normal_number_of_units = normal_number_of_units
        if amount is not None:
            self.amount = amount
        if number_of_units is not None:
            self.number_of_units = number_of_units
        if fixed_amount is not None:
            self.fixed_amount = fixed_amount

    @property
    def earnings_rate_id(self):
        """Gets the earnings_rate_id of this EarningsLine.  # noqa: E501

        Xero unique id for earnings rate  # noqa: E501

        :return: The earnings_rate_id of this EarningsLine.  # noqa: E501
        :rtype: str
        """
        return self._earnings_rate_id

    @earnings_rate_id.setter
    def earnings_rate_id(self, earnings_rate_id):
        """Sets the earnings_rate_id of this EarningsLine.

        Xero unique id for earnings rate  # noqa: E501

        :param earnings_rate_id: The earnings_rate_id of this EarningsLine.  # noqa: E501
        :type: str
        """
        if earnings_rate_id is None:
            raise ValueError(
                "Invalid value for `earnings_rate_id`, must not be `None`"
            )  # noqa: E501

        self._earnings_rate_id = earnings_rate_id

    @property
    def calculation_type(self):
        """Gets the calculation_type of this EarningsLine.  # noqa: E501


        :return: The calculation_type of this EarningsLine.  # noqa: E501
        :rtype: EarningsRateCalculationType
        """
        return self._calculation_type

    @calculation_type.setter
    def calculation_type(self, calculation_type):
        """Sets the calculation_type of this EarningsLine.


        :param calculation_type: The calculation_type of this EarningsLine.  # noqa: E501
        :type: EarningsRateCalculationType
        """

        self._calculation_type = calculation_type

    @property
    def annual_salary(self):
        """Gets the annual_salary of this EarningsLine.  # noqa: E501

        Annual salary for earnings line  # noqa: E501

        :return: The annual_salary of this EarningsLine.  # noqa: E501
        :rtype: float
        """
        return self._annual_salary

    @annual_salary.setter
    def annual_salary(self, annual_salary):
        """Sets the annual_salary of this EarningsLine.

        Annual salary for earnings line  # noqa: E501

        :param annual_salary: The annual_salary of this EarningsLine.  # noqa: E501
        :type: float
        """

        self._annual_salary = annual_salary

    @property
    def number_of_units_per_week(self):
        """Gets the number_of_units_per_week of this EarningsLine.  # noqa: E501

        number of units for earning line  # noqa: E501

        :return: The number_of_units_per_week of this EarningsLine.  # noqa: E501
        :rtype: float
        """
        return self._number_of_units_per_week

    @number_of_units_per_week.setter
    def number_of_units_per_week(self, number_of_units_per_week):
        """Sets the number_of_units_per_week of this EarningsLine.

        number of units for earning line  # noqa: E501

        :param number_of_units_per_week: The number_of_units_per_week of this EarningsLine.  # noqa: E501
        :type: float
        """

        self._number_of_units_per_week = number_of_units_per_week

    @property
    def rate_per_unit(self):
        """Gets the rate_per_unit of this EarningsLine.  # noqa: E501

        Rate per unit of the EarningsLine.  # noqa: E501

        :return: The rate_per_unit of this EarningsLine.  # noqa: E501
        :rtype: float
        """
        return self._rate_per_unit

    @rate_per_unit.setter
    def rate_per_unit(self, rate_per_unit):
        """Sets the rate_per_unit of this EarningsLine.

        Rate per unit of the EarningsLine.  # noqa: E501

        :param rate_per_unit: The rate_per_unit of this EarningsLine.  # noqa: E501
        :type: float
        """

        self._rate_per_unit = rate_per_unit

    @property
    def normal_number_of_units(self):
        """Gets the normal_number_of_units of this EarningsLine.  # noqa: E501

        Normal number of units for EarningsLine. Applicable when RateType is \"MULTIPLE\"  # noqa: E501

        :return: The normal_number_of_units of this EarningsLine.  # noqa: E501
        :rtype: float
        """
        return self._normal_number_of_units

    @normal_number_of_units.setter
    def normal_number_of_units(self, normal_number_of_units):
        """Sets the normal_number_of_units of this EarningsLine.

        Normal number of units for EarningsLine. Applicable when RateType is \"MULTIPLE\"  # noqa: E501

        :param normal_number_of_units: The normal_number_of_units of this EarningsLine.  # noqa: E501
        :type: float
        """

        self._normal_number_of_units = normal_number_of_units

    @property
    def amount(self):
        """Gets the amount of this EarningsLine.  # noqa: E501

        Earnings rate amount  # noqa: E501

        :return: The amount of this EarningsLine.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this EarningsLine.

        Earnings rate amount  # noqa: E501

        :param amount: The amount of this EarningsLine.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def number_of_units(self):
        """Gets the number_of_units of this EarningsLine.  # noqa: E501

        Earnings rate number of units.  # noqa: E501

        :return: The number_of_units of this EarningsLine.  # noqa: E501
        :rtype: float
        """
        return self._number_of_units

    @number_of_units.setter
    def number_of_units(self, number_of_units):
        """Sets the number_of_units of this EarningsLine.

        Earnings rate number of units.  # noqa: E501

        :param number_of_units: The number_of_units of this EarningsLine.  # noqa: E501
        :type: float
        """

        self._number_of_units = number_of_units

    @property
    def fixed_amount(self):
        """Gets the fixed_amount of this EarningsLine.  # noqa: E501

        Earnings rate amount. Only applicable if the EarningsRate RateType is Fixed  # noqa: E501

        :return: The fixed_amount of this EarningsLine.  # noqa: E501
        :rtype: float
        """
        return self._fixed_amount

    @fixed_amount.setter
    def fixed_amount(self, fixed_amount):
        """Sets the fixed_amount of this EarningsLine.

        Earnings rate amount. Only applicable if the EarningsRate RateType is Fixed  # noqa: E501

        :param fixed_amount: The fixed_amount of this EarningsLine.  # noqa: E501
        :type: float
        """

        self._fixed_amount = fixed_amount
