# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['tmuxp', 'tmuxp.cli', 'tmuxp.workspace']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'colorama>=0.3.9', 'libtmux>=0.17.2,<0.18.0']

entry_points = \
{'console_scripts': ['tmuxp = tmuxp:cli.cli']}

setup_kwargs = {
    'name': 'tmuxp',
    'version': '1.20.3',
    'description': 'tmux session manager',
    'long_description': '# tmuxp\n\nA session manager for tmux. Built on [libtmux](https://github.com/tmux-python/libtmux).\n\n[![Python Package](https://img.shields.io/pypi/v/tmuxp.svg)](https://pypi.org/project/tmuxp/)\n[![Docs](https://github.com/tmux-python/tmuxp/workflows/docs/badge.svg)](https://tmuxp.git-pull.com/)\n[![Build status](https://github.com/tmux-python/tmuxp/workflows/tests/badge.svg)](https://github.com/tmux-python/tmuxp/actions?query=workflow%3A%22tests%22)\n[![Code Coverage](https://codecov.io/gh/tmux-python/tmuxp/branch/master/graph/badge.svg)](https://codecov.io/gh/tmux-python/tmuxp)\n[![License](https://img.shields.io/github/license/tmux-python/tmuxp.svg)](https://github.com/tmux-python/tmuxp/blob/master/LICENSE)\n\n**New to tmux?** [The Tao of tmux](https://leanpub.com/the-tao-of-tmux)\nis available on Leanpub and [Amazon Kindle](http://amzn.to/2gPfRhC).\nRead and browse the book for free [on the\nweb](https://leanpub.com/the-tao-of-tmux/read).\n\n**Have some spare time?** Help us triage and code review and the tracker. See [issue\n#290](https://github.com/tmux-python/tmuxp/discussions/290)!\n\n# Installation\n\npip:\n\n```console\n$ pip install --user tmuxp\n```\n\nHomebrew:\n\n```console\n$ brew install tmuxp\n```\n\nDebian / ubuntu:\n\n```console\n$ sudo apt install tmuxp\n```\n\nFind the package for your distro on repology: <https://repology.org/project/tmuxp/versions>\n\nDevelopmental releases:\n\n- [pip](https://pip.pypa.io/en/stable/):\n\n  ```console\n  $ pip install --user --upgrade --pre tmuxp\n  ```\n\n- [pipx](https://pypa.github.io/pipx/docs/):\n\n  ```console\n  $ pipx install --suffix=@next \'tmuxp\' --pip-args \'\\--pre\' --force\n  ```\n\n  Then use `tmuxp@next load [session]`.\n\n# Load a tmux session\n\nLoad tmux sessions via json and YAML,\n[tmuxinator](https://github.com/aziz/tmuxinator) and\n[teamocil](https://github.com/remiprev/teamocil) style.\n\n```yaml\nsession_name: 4-pane-split\nwindows:\n  - window_name: dev window\n    layout: tiled\n    shell_command_before:\n      - cd ~/ # run as a first command in all panes\n    panes:\n      - shell_command: # pane no. 1\n          - cd /var/log # run multiple commands in this pane\n          - ls -al | grep \\.log\n      - echo second pane # pane no. 2\n      - echo third pane # pane no. 3\n      - echo forth pane # pane no. 4\n```\n\nSave as _mysession.yaml_, and load:\n\n```console\n$ tmuxp load ./mysession.yaml\n```\n\nProjects with _.tmuxp.yaml_ or _.tmuxp.json_ load via directory:\n\n```console\n$ tmuxp load path/to/my/project/\n```\n\nLoad multiple at once (in bg, offer to attach last):\n\n```console\n$ tmuxp load mysession ./another/project/\n```\n\nName a session:\n\n```console\n$ tmuxp load -s session_name ./mysession.yaml\n```\n\n[simple](http://tmuxp.git-pull.com/examples.html#short-hand-inline) and\n[very\nelaborate](http://tmuxp.git-pull.com/examples.html#super-advanced-dev-environment)\nconfig examples\n\n# User-level configurations\n\ntmuxp checks for configs in user directories:\n\n- `$TMUXP_CONFIGDIR`, if set\n- `$XDG_CONFIG_HOME`, usually _$HOME/.config/tmuxp/_\n- `$HOME/.tmuxp/`\n\nLoad your tmuxp config from anywhere by using the filename, assuming\n_\\~/.config/tmuxp/mysession.yaml_ (or _.json_):\n\n```console\n$ tmuxp load mysession\n```\n\nSee [author\'s tmuxp configs](https://github.com/tony/tmuxp-config) and\nthe projects\'\n[tmuxp.yaml](https://github.com/tmux-python/tmuxp/blob/master/.tmuxp.yaml).\n\n# Shell\n\n_New in 1.6.0_:\n\n`tmuxp shell` launches into a python console preloaded with the attached\nserver, session, and window in\n[libtmux](https://github.com/tmux-python/libtmux) objects.\n\n```console\n$ tmuxp shell\n\n(Pdb) server\n<libtmux.server.Server object at 0x7f7dc8e69d10>\n(Pdb) server.sessions\n[Session($1 your_project)]\n(Pdb) session\nSession($1 your_project)\n(Pdb) session.name\n\'your_project\'\n(Pdb) window\nWindow(@3 1:your_window, Session($1 your_project))\n(Pdb) window.name\n\'your_window\'\n(Pdb) window.panes\n[Pane(%6 Window(@3 1:your_window, Session($1 your_project)))\n(Pdb) pane\nPane(%6 Window(@3 1:your_window, Session($1 your_project))\n```\n\nPython 3.7+ supports [PEP\n553](https://www.python.org/dev/peps/pep-0553/) `breakpoint()`\n(including `PYTHONBREAKPOINT`). Also supports direct commands via `-c`:\n\n```console\n$ tmuxp shell -c \'print(window.name)\'\nmy_window\n\n$ tmuxp shell -c \'print(window.name.upper())\'\nMY_WINDOW\n```\n\nRead more on [tmuxp shell](https://tmuxp.git-pull.com/cli/shell.html) in\nthe CLI docs.\n\n# Pre-load hook\n\nRun custom startup scripts (such as installing project dependencies\nbefore loading tmux. See the\n[bootstrap_env.py](https://github.com/tmux-python/tmuxp/blob/master/bootstrap_env.py)\nand\n[before_script](http://tmuxp.git-pull.com/examples.html#bootstrap-project-before-launch)\nexample\n\n# Load in detached state\n\nYou can also load sessions in the background by passing `-d` flag\n\n# Screenshot\n\n<img src="https://raw.githubusercontent.com/tmux-python/tmuxp/master/docs/_static/tmuxp-demo.gif" class="align-center" style="width:45.0%" alt="image" />\n\n# Freeze a tmux session\n\nSnapshot your tmux layout, pane paths, and window/session names.\n\n```console\n$ tmuxp freeze session-name\n```\n\nSee more about [freezing\ntmux](http://tmuxp.git-pull.com/commands/#freeze-sessions) sessions.\n\n# Convert a session file\n\nConvert a session file from yaml to json and vice versa.\n\n```console\n$ tmuxp convert filename\n```\n\nThis will prompt you for confirmation and shows you the new file that is\ngoing to be written.\n\nYou can auto confirm the prompt. In this case no preview will be shown.\n\n```console\n$ tmuxp convert -y filename\n$ tmuxp convert --yes filename\n```\n\n# Plugin System\n\ntmuxp has a plugin system to allow for custom behavior. See more about\nthe [Plugin System](http://tmuxp.git-pull.com/plugin_system.html).\n\n# Debugging Helpers\n\nThe `load` command provides a way to log output to a log file for\ndebugging purposes.\n\n```console\n$ tmuxp load --log-file <log-file-name> .\n```\n\nCollect system info to submit with a Github issue:\n\n```console\n$ tmuxp debug-info\n------------------\nenvironment:\n    system: Linux\n    arch: x86_64\n\n# ... so on\n```\n\n# Docs / Reading material\n\nSee the [Quickstart](http://tmuxp.git-pull.com/quickstart.html).\n\n[Documentation](http://tmuxp.git-pull.com) homepage (also in\n[中文](http://tmuxp-zh.rtfd.org/))\n\nWant to learn more about tmux itself? [Read The Tao of Tmux\nonline](http://tmuxp.git-pull.com/about_tmux.html).\n\n# Donations\n\nYour donations fund development of new features, testing and support.\nYour money will go directly to maintenance and development of the\nproject. If you are an individual, feel free to give whatever feels\nright for the value you get out of the project.\n\nSee donation options at <https://git-pull.com/support.html>.\n\n# Project details\n\n- tmux support: 1.8+\n- python support: >= 3.7, pypy, pypy3\n- Source: <https://github.com/tmux-python/tmuxp>\n- Docs: <https://tmuxp.git-pull.com>\n- API: <https://tmuxp.git-pull.com/api.html>\n- Changelog: <https://tmuxp.git-pull.com/history.html>\n- Issues: <https://github.com/tmux-python/tmuxp/issues>\n- Test Coverage: <https://codecov.io/gh/tmux-python/tmuxp>\n- pypi: <https://pypi.python.org/pypi/tmuxp>\n- Open Hub: <https://www.openhub.net/p/tmuxp-python>\n- Repology: <https://repology.org/project/tmuxp/versions>\n- License: [MIT](http://opensource.org/licenses/MIT).\n',
    'author': 'Tony Narlock',
    'author_email': 'tony@git-pull.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'http://github.com/tmux-python/tmuxp/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
