
**You are expected to design, code, and present to the class a programming project that has a purpose** *(solves a real problem)* **for a real life user.** 

## **Introduction**
* **Detailed** description of your project including *user/s* and *user requirements*.
  * Our Project is a stock prediction tool that utilises `Machine Learning` algorithms in order to forecast the stock market changes for a certain period of time in the future. Users would be anyone over the age of **18** attempting to build or to improve their *financial portfolio*. Our tool will aid them in investing and buying shares from companies as well allowing them to maximise the profits and minimise their losses. It also allows more inexperienced users to attain an understading of the movement of the **Stock Market** allowing them to make informed decisions about their future.

* **Detailed** description of your *aims* – `SMART` objectives
  * Our aims are to develop the tool as a `python package` and upload it to `PyPi` as an open source package for use all around the world. We want to allow for multiple different `algorithms` to be used thorugh the use of multiple `function` and `iteration` to make the results as accurate and reliable as possible. We expect the package to be finished within 3/4 weeks with `v0.1-alpha` already being released on `GitHub` as a pre-release. Release `v1.0` is expected to be our initial release and first fully functional version released in 3/4 weeks and then after that we shall use user feedback in the form of `issues` and `pull requests` on `GitHub` in order to improve the project.

### Description of current system in place or lack of system. 

* Who are the users?
  * The users are people interested in **finance** or the **economy** and our tool can be easily integrated in websites using the `Django` framework for python or in applications on desktop using `Cython/CPython` and `C++` or mobile through `Java` *(with *`Jython`*)* and `Swift`. 

## Design
	 
### **System Design**

* Show understanding of how to model a **complex** system by only including **essential** details.

* Use a `structure chart` to express the parameters passed between the various modules *(input, process, output)*.

* Identify `procedures/functions` which are part of the `algorithm` design.

* Describe the *purpose* of a structure chart.

* Construct a structure chart for the problem.

* Derive equivalent `pseudocode` from the structure chart.

* Document a simple algorithm using:
	* Structured English
	* `Pseudocode`
	* Program `flowchart`
	
### TaskList

- [x] Write a function to get the Stock data for *user-specified* companies.
- [ ] Write a function to use the data to predict using a `Support Vector Machine` algorithm.
- [ ] Write a function to use the data to predict using an `Artificial Neural Network` algotithm.
- [ ] Write a function to use the data to predict using an `Linear Regression` algorithm.
- [ ] Iterate over the functions settings to find the best algorithm and its settings with the best coeffecient of determination R^2.
- [ ] Develop a GUI for easier use either on an app or on a website.
	
## Testing
				 
### **System implementation** 

* Write the program in a high-level language (e.g. `Python` or `VB.net`)
		 
### **System Testing**

* Show awareness of why errors occur

* Show understanding of how **testing** can expose possible errors.

* Appreciate the significance of testing throughout software development.

* Show understanding of the methods of testing available: `dry run, walkthrough, white-box, black-box, integration, alpha, beta, acceptance.`

* Show understanding of the need for a *test strategy* and *test plan* and their likely contents.

* Choose **appropriate** test data *(normal, abnormal and extreme/boundary)* for a test plan.

## Review
		 
### **User Review**
* Ask your *prospective* users to test and provide **feedback** for your product.

* What **improvements** could you make in the future?

* Peer review from another member of the class.
		  
### **Project Evaluation**

* How did your project go?

* Was it a success, why/why not?

* How many of the `SMART` objectives did you meet – why/why not?

## Final Comment

### Final Comments and review of project

## Footer

###### By Athavan, Anish, Erekle
