# Generated by Django 2.2.9 on 2020-02-20 17:16

try:
    from secrets import token_hex
except ImportError:
    from os import urandom
    def token_hex(nbytes=None):
        return urandom(nbytes).hex()

from django.db import migrations, models


def fill_access_tokens(apps, schema_editor):
    """Fill access tokens."""
    UserCalendar = apps.get_model("modoboa_radicale", "UserCalendar")
    SharedCalendar = apps.get_model("modoboa_radicale", "SharedCalendar")
    for calendar in UserCalendar.objects.all():
        calendar.access_token = token_hex(24)
        calendar.save(update_fields=["access_token"])
    for calendar in SharedCalendar.objects.all():
        calendar.access_token = token_hex(24)
        calendar.save(update_fields=["access_token"])


def backwards(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('modoboa_radicale', '0003_auto_20180324_1834'),
    ]

    operations = [
        migrations.AddField(
            model_name='sharedcalendar',
            name='access_token',
            field=models.CharField(max_length=32, null=True),
        ),
        migrations.AddField(
            model_name='usercalendar',
            name='access_token',
            field=models.CharField(max_length=32, null=True),
        ),
        migrations.RunPython(fill_access_tokens, backwards),
    ]
