# Data Science Environment Setup in single line

This package helps to setup your Data Science environment in single line.

Developed by Ashish Patel(c) 2020.

## datascienv

datascienv is a python package offering a single line Data Science Environment setup. 


### Installation

---

#### Dependencies

`datascienv` is tested to work under Python 3.7+ and greater. The dependency requirements are based on the `datascienv` package update release:

- `pandas`(latest) - https://pandas.pydata.org/
- `numpy`(latest) - https://numpy.org/install/
- `scipy`(latest) - https://www.scipy.org/
- `scikit-learn`(latest) - https://scikit-learn.org/
- `joblib`(latest) - https://joblib.readthedocs.io/en/latest/
- `statmodels`(latest) - https://www.statsmodels.org/stable/index.html
- `matplotlib`(latest) - https://matplotlib.org/
- `seaborn`(latest) - https://seaborn.pydata.org/
- `xgboost`(latest) - https://xgboost.ai/sponsors
- `imbalanced-learn`(latest) - https://imbalanced-learn.org/
- `bokeh`(latest) - https://docs.bokeh.org/en/latest/
- `Boruta`(latest) - https://github.com/scikit-learn-contrib/boruta_py
- `jupyter`(latest) - https://jupyter.org/
- `spyder`(latest) - https://www.spyder-ide.org/
- `mlxtend`(latest) - http://rasbt.github.io/mlxtend/
- `lightgbm`(lightgbm) - https://lightgbm.readthedocs.io/en/latest/
- `catboost`(latest) - https://catboost.ai/
- `pycaret`(latest) - https://pycaret.org/


#### Installation

datasciecne is currently available on the PyPi's repository and you can install it via pip:

```bash
pip install -U datascienv
```

The package is release also in Anaconda Cloud platform:

```bash
conda install -c conda-forge datascienv
```

If you prefer, you can clone it and run the setup.py file. Use the following commands to get a copy from GitHub and install all dependencies:

```bash
git clone https://github.com/ashishpatel26/datascienv.git
cd datascienv
pip install .
```

Or install using pip and GitHub:

```bash
pip install -U git+https://github.com/ashishpatel26/datascienv.git
```