# RedditApp MCP Server

An MCP Server for the RedditApp API.

## 🛠️ Tool List

This is automatically generated from OpenAPI schema for the RedditApp API.


| Tool | Description |
|------|-------------|
| `get_subreddit_posts` | Fetches a specified number of top-rated posts from a particular subreddit, allowing results to be filtered by a specific timeframe (e.g., 'day', 'week'). This is a simplified version compared to `get_subreddit_top_posts`, which uses more complex pagination parameters instead of a direct time filter. |
| `search_subreddits` | Searches for subreddits by name and description using a query string, with results sortable by relevance or activity. Unlike the broader `search_reddit` function, this method exclusively discovers subreddits, not posts, comments, or users. |
| `get_post_flairs` | Fetches a list of available post flairs (tags) for a specified subreddit. This is primarily used to discover the correct `flair_id` needed to categorize a new submission when using the `create_post` function. It returns flair details or a message if none are available. |
| `create_post` | Creates a new Reddit post in a specified subreddit. It supports text ('self') or link posts, requiring a title and corresponding content (text or URL). An optional flair can be assigned. Returns the API response or a formatted error message on failure. |
| `get_comment_by_id` | Retrieves a single Reddit comment's data, such as author and score, using its unique 't1_' prefixed ID. Unlike `get_post_comments_details` which fetches all comments for a post, this function targets one specific comment directly, returning an error dictionary if it is not found. |
| `post_comment` | Posts a new comment as a reply to a specified Reddit post or another comment. Using the parent's full ID and the desired text, it submits the comment via the API and returns the response containing the new comment's details. |
| `edit_content` | Modifies the text of a specific Reddit post or comment via its unique ID. Unlike creation or deletion functions, this method specifically handles updates to existing user-generated content, submitting the new text to the API and returning a JSON response detailing the edited item. |
| `delete_content` | Deletes a specified Reddit post or comment using its full identifier (`content_id`). It sends a POST request to the `/api/del` endpoint for permanent removal, unlike `edit_content` which only modifies. On success, it returns a confirmation message. |
| `get_post_comments_details` | Fetches a specific Reddit post's details and its complete comment tree using the post's unique ID. This function returns the entire discussion, including the original post and all associated comments, providing broader context than `get_comment_by_id` which only retrieves a single comment. |
| `get_current_user_info` | Retrieves the full profile information for the currently authenticated user by making a GET request to the `/api/v1/me` Reddit API endpoint. This differs from `get_user_profile`, which requires a username, and `get_current_user_karma`, which specifically fetches karma data. |
| `get_current_user_karma` | Fetches the karma breakdown for the authenticated user from the Reddit API. This function specifically targets the `/api/v1/me/karma` endpoint, returning karma statistics per subreddit, which is more specific than `get_current_user_info` that retrieves general profile information. |
| `get_hot_posts` | Retrieves trending 'hot' posts from the global Reddit feed. Unlike `get_subreddit_hot_posts`, this operates across all of Reddit, not a specific subreddit. It supports pagination and optional filtering by geographical region to customize the listing of returned posts. |
| `get_new_posts` | Fetches a list of the newest posts from across all of Reddit, not limited to a specific subreddit. This function supports optional pagination and filtering parameters to customize the API response, differentiating it from `get_subreddit_new_posts` which targets a single subreddit. |
| `get_top_posts` | Fetches top-rated posts from across all of Reddit, distinct from `get_subreddit_top_posts`, which operates on a specific subreddit. The function supports standard API pagination parameters like `limit`, `after`, and `before` to navigate results, providing a broad, site-wide view of top content. |
| `get_rising_posts` | Retrieves a list of rising posts from across all of Reddit. Unlike subreddit-specific listing functions (e.g., `get_subreddit_hot_posts`), this operates globally. It supports optional pagination and filtering parameters, such as `limit` and `after`, to customize the API response and navigate through results. |
| `get_controversial_posts` | Fetches a global list of the most controversial posts from across all of Reddit, distinct from subreddit-specific queries. Optional parameters allow for pagination and customization of the results, returning the direct API response data with the post listings. |
| `get_subreddit_hot_posts` | Retrieves a list of 'hot' posts from a specified subreddit, supporting pagination and geographical filtering. Unlike `get_hot_posts`, which queries all of Reddit, this function targets a single subreddit to fetch its currently trending content, distinct from top or new posts. |
| `get_subreddit_new_posts` | Retrieves a list of the newest posts from a specified subreddit, sorted chronologically. Unlike `get_new_posts` which targets all of Reddit, this function is subreddit-specific and supports standard pagination parameters like `limit` and `after` to navigate through the listing of recent submissions. |
| `get_subreddit_top_posts` | Fetches top-rated posts from a specific subreddit using standard API pagination parameters. Unlike the simpler `get_subreddit_posts` which filters by timeframe, this function offers more direct control over retrieving listings, distinguishing it from the site-wide `get_top_posts` which queries all of Reddit. |
| `search_reddit` | Executes a broad, keyword-based search across Reddit for various content types like posts, comments, or users. This general-purpose function offers extensive filtering options, distinguishing it from the more specialized `search_subreddits` which only finds communities. |
| `get_user_profile` | Retrieves public profile information for a specified Reddit user via the `/user/{username}/about` endpoint. Unlike `get_current_user_info`, which targets the authenticated user, this function fetches data like karma and account age for any user identified by their username. |
