# Generated by Django 2.2.2 on 2019-07-12 14:43

import uuid

import django.contrib.postgres.fields.jsonb
import django.core.serializers.json
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [("audittrails", "0008_audittrail_resource_weergave")]

    operations = [
        migrations.AlterField(
            model_name="audittrail",
            name="aanmaakdatum",
            field=models.DateTimeField(
                auto_now=True, help_text="De datum waarop de handeling is gedaan."
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="actie",
            field=models.CharField(
                help_text="De uitgevoerde handeling.", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="actie_weergave",
            field=models.CharField(
                blank=True, help_text="Vriendelijke naam van de actie.", max_length=200
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="applicatie_id",
            field=models.CharField(
                blank=True,
                help_text="Unieke identificatie van de applicatie, binnen de organisatie.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="applicatie_weergave",
            field=models.CharField(
                blank=True,
                help_text="Vriendelijke naam van de applicatie.",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="bron",
            field=models.CharField(
                choices=[
                    ("ac", "Autorisatiecomponent"),
                    ("nrc", "Notificatierouteringcomponent"),
                    ("zrc", "Zaakregistratiecomponent"),
                    ("ztc", "Zaaktypecatalogus"),
                    ("drc", "Documentregistratiecomponent"),
                    ("brc", "Besluitregistratiecomponent"),
                ],
                help_text="De naam van het component waar de wijziging in is gedaan.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="gebruikers_id",
            field=models.CharField(
                blank=True,
                help_text="Unieke identificatie van de gebruiker die binnen de organisatie herleid kan worden naar een persoon.",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="gebruikers_weergave",
            field=models.CharField(
                blank=True,
                help_text="Vriendelijke naam van de gebruiker.",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="hoofd_object",
            field=models.URLField(
                help_text="De URL naar het hoofdobject van een component.",
                max_length=1000,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="nieuw",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                encoder=django.core.serializers.json.DjangoJSONEncoder,
                help_text="Volledige JSON body van het object na de actie.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="oud",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                encoder=django.core.serializers.json.DjangoJSONEncoder,
                help_text="Volledige JSON body van het object zoals dat bestond voordat de actie heeft plaatsgevonden.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="resource",
            field=models.CharField(
                help_text="Het type resource waarop de actie gebeurde.", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="resource_url",
            field=models.URLField(help_text="De URL naar het object.", max_length=1000),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="resource_weergave",
            field=models.CharField(
                help_text="Vriendelijke identificatie van het object.", max_length=200
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="resultaat",
            field=models.IntegerField(
                help_text="HTTP status code van de API response van de uitgevoerde handeling.",
                validators=[
                    django.core.validators.MinValueValidator(100),
                    django.core.validators.MaxValueValidator(599),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="toelichting",
            field=models.TextField(
                blank=True,
                help_text="Toelichting waarom de handeling is uitgevoerd.",
                verbose_name="toelichting",
            ),
        ),
        migrations.AlterField(
            model_name="audittrail",
            name="uuid",
            field=models.UUIDField(
                default=uuid.uuid4,
                help_text="Unieke identificatie van de audit regel.",
                unique=True,
            ),
        ),
    ]
