"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlLayer = void 0;
const core_1 = require("@aws-cdk/core");
const crypto = require("crypto");
const KUBECTL_APP_ARN = 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-kubectl';
const KUBECTL_APP_CN_ARN = 'arn:aws-cn:serverlessrepo:cn-north-1:487369736442:applications/lambda-layer-kubectl';
const KUBECTL_APP_VERSION = '1.13.7';
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
class KubectlLayer extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * All runtimes are compatible.
         */
        this.compatibleRuntimes = undefined;
        const uniqueId = crypto.createHash('md5').update(this.node.path).digest('hex');
        const version = props.version || KUBECTL_APP_VERSION;
        this.stack.templateOptions.transforms = ['AWS::Serverless-2016-10-31']; // required for AWS::Serverless
        const resource = new core_1.CfnResource(this, 'Resource', {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: this.isChina() ? KUBECTL_APP_CN_ARN : KUBECTL_APP_ARN,
                    SemanticVersion: version,
                },
                Parameters: {
                    LayerName: `kubectl-${uniqueId}`,
                },
            },
        });
        this.layerVersionArn = core_1.Token.asString(resource.getAtt('Outputs.LayerVersionArn'));
    }
    /**
     * Gets or create a singleton instance of this construct.
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const id = 'kubectl-layer-' + (props.version ? props.version : '8C2542BC-BF2B-4DFE-B765-E181FD30A9A0');
        const exists = stack.node.tryFindChild(id);
        if (exists) {
            return exists;
        }
        return new KubectlLayer(stack, id, props);
    }
    get stack() {
        return core_1.Stack.of(this);
    }
    addPermission(_id, _permission) {
        return;
    }
    isChina() {
        const region = this.stack.region;
        return !core_1.Token.isUnresolved(region) && region.startsWith('cn-');
    }
}
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,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