import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) A Service Catalog AppRegistry Application.
 *
 * @experimental
 */
export interface IApplication extends cdk.IResource {
    /**
     * (experimental) The ARN of the application.
     *
     * @experimental
     * @attribute true
     */
    readonly applicationArn: string;
    /**
     * (experimental) The ID of the application.
     *
     * @experimental
     * @attribute true
     */
    readonly applicationId: string;
}
/**
 * (experimental) Properties for a Service Catalog AppRegistry Application.
 *
 * @experimental
 */
export interface ApplicationProps {
    /**
     * (experimental) Enforces a particular physical application name.
     *
     * @experimental
     */
    readonly applicationName: string;
    /**
     * (experimental) Description for application.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
}
declare abstract class ApplicationBase extends cdk.Resource implements IApplication {
    abstract readonly applicationArn: string;
    abstract readonly applicationId: string;
}
/**
 * (experimental) A Service Catalog AppRegistry Application.
 *
 * @experimental
 */
export declare class Application extends ApplicationBase {
    /**
     * (experimental) Imports an Application construct that represents an external application.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param applicationArn the Amazon Resource Name of the existing AppRegistry Application.
     * @experimental
     */
    static fromApplicationArn(scope: Construct, id: string, applicationArn: string): IApplication;
    /**
     * (experimental) The ARN of the application.
     *
     * @experimental
     */
    readonly applicationArn: string;
    /**
     * (experimental) The ID of the application.
     *
     * @experimental
     */
    readonly applicationId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApplicationProps);
    private validateApplicationProps;
}
export {};
