"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 *
 * @stability stable
 */
class Runtime {
    /**
     * @stability stable
     */
    constructor(name, family, props = {}) {
        var _b, _c;
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        const imageName = (_b = props.bundlingDockerImage) !== null && _b !== void 0 ? _b : `amazon/aws-sam-cli-build-image-${name}`;
        this.bundlingDockerImage = core_1.BundlingDockerImage.fromRegistry(imageName);
        this.supportsCodeGuruProfiling = (_c = props.supportsCodeGuruProfiling) !== null && _c !== void 0 ? _c : false;
        Runtime.ALL.push(this);
    }
    /**
     * @stability stable
     */
    toString() {
        return this.name;
    }
    /**
     * @stability stable
     */
    runtimeEquals(other) {
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-lambda.Runtime", version: "1.94.1" };
/**
 * A list of all known `Runtime`'s.
 *
 * @stability stable
 */
Runtime.ALL = new Array();
/**
 * (deprecated) The NodeJS runtime (nodejs).
 *
 * @deprecated Use {@link NODEJS_12_X}
 */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * (deprecated) The NodeJS 4.3 runtime (nodejs4.3).
 *
 * @deprecated Use {@link NODEJS_12_X}
 */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * (deprecated) The NodeJS 6.10 runtime (nodejs6.10).
 *
 * @deprecated Use {@link NODEJS_12_X}
 */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * (deprecated) The NodeJS 8.10 runtime (nodejs8.10).
 *
 * @deprecated Use {@link NODEJS_12_X}
 */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 10.x runtime (nodejs10.x).
 *
 * @stability stable
 */
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 12.x runtime (nodejs12.x).
 *
 * @stability stable
 */
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 14.x runtime (nodejs14.x).
 *
 * @stability stable
 */
Runtime.NODEJS_14_X = new Runtime('nodejs14.x', RuntimeFamily.NODEJS, { supportsInlineCode: false });
/**
 * The Python 2.7 runtime (python2.7).
 *
 * @stability stable
 */
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.6 runtime (python3.6).
 *
 * @stability stable
 */
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.7 runtime (python3.7).
 *
 * @stability stable
 */
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.8 runtime (python3.8).
 *
 * @stability stable
 */
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 runtime (java8).
 *
 * @stability stable
 */
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 Corretto runtime (java8.al2).
 *
 * @stability stable
 */
Runtime.JAVA_8_CORRETTO = new Runtime('java8.al2', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 11 runtime (java11).
 *
 * @stability stable
 */
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * (deprecated) The .NET Core 1.0 runtime (dotnetcore1.0).
 *
 * @deprecated Use {@link DOTNET_CORE_2_1}
 */
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/**
 * (deprecated) The .NET Core 2.0 runtime (dotnetcore2.0).
 *
 * @deprecated Use {@link DOTNET_CORE_2_1}
 */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.1 runtime (dotnetcore2.1).
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE, {
    bundlingDockerImage: 'lambci/lambda:build-dotnetcore2.1',
});
/**
 * The .NET Core 3.1 runtime (dotnetcore3.1).
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_3_1 = new Runtime('dotnetcore3.1', RuntimeFamily.DOTNET_CORE, {
    bundlingDockerImage: 'lambci/lambda:build-dotnetcore3.1',
});
/**
 * The Go 1.x runtime (go1.x).
 *
 * @stability stable
 */
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO, {
    bundlingDockerImage: 'lambci/lambda:build-go1.x',
});
/**
 * The Ruby 2.5 runtime (ruby2.5).
 *
 * @stability stable
 */
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY);
/**
 * The Ruby 2.7 runtime (ruby2.7).
 *
 * @stability stable
 */
Runtime.RUBY_2_7 = new Runtime('ruby2.7', RuntimeFamily.RUBY);
/**
 * The custom provided runtime (provided).
 *
 * @stability stable
 */
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
/**
 * The custom provided runtime (provided).
 *
 * @stability stable
 */
Runtime.PROVIDED_AL2 = new Runtime('provided.al2', RuntimeFamily.OTHER);
/**
 * A special runtime entry to be used when function is using a docker image.
 *
 * @stability stable
 */
Runtime.FROM_IMAGE = new Runtime('FROM_IMAGE');
//# sourceMappingURL=data:application/json;base64,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