# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dbtenv']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0']

entry_points = \
{'console_scripts': ['dbtenv = dbtenv.main:main']}

setup_kwargs = {
    'name': 'dbtenv',
    'version': '2.1.0',
    'description': 'dbtenv is a version manager for dbt, automatically installing and switching to the needed adapter and version of dbt.',
    'long_description': "# dbtenv\n\ndbtenv is a version manager for dbt, automatically installing and switching to the needed adapter and version of [dbt](https://docs.getdbt.com/docs/introduction).\n\n## Quickstart\n### Installation\n\n1. Install [pipx](https://pypa.github.io/pipx/) ([What is pipx?](https://www.google.com/search?q=pipx&rlz=1C5GCEM_enGB953GB953&oq=Pipx&aqs=chrome.0.69i59i512j0i512l2j69i59j0i512l2j69i60l2.1010j0j7&sourceid=chrome&ie=UTF-8)).\n2. Run `pipx install dbtenv[dbt-alias]`.\n\n### Usage\nIf the `dbt-alias` extra is used (`dbtenv[dbt-alias]`), dbt commands can be used as normal and will be routed through dbtenv. dbtenv will automatically determine, install and use the required dbt adapter and version.\n\nIllustrative example\n```\ndbt --version\ndbtenv info:  Using dbt-bigquery==1.0.0 (set by dbt_project.yml).\ninstalled version: 1.0.4\n   latest version: 1.0.4\n\nUp to date!\n\nPlugins:\n  - bigquery: 1.0.0 - Up to date!\n```\n\n\n## Available Commands\n\n- `dbtenv --help` - Print documentation and available commands. Can also be run for information on a individual command, e.g. `dbtenv versions --help`.\n- `dbtenv versions` - List the installable versions of dbt, marking those which are currently installed. Add the `--installed` flag to show only those which are installed.\n- `dbtenv install <dbt_pip_specifier>` - Install a specific version of dbt, e.g. `dbtenv install dbt-snowflake==1.0.0`.\n- `dbtenv uninstall <dbt_pip_specifier>` - Uninstall a specific version of dbt, e.g. `dbtenv uninstall dbt-snowflake==1.0.0`.\n- `dbtenv version` - Print the dbt version dbtenv determines automatically for the current environment.\n- `dbtenv which` - Print the full path to the executable of the dbt version dbtenv determines automatically for the current environment.\n- `dbtenv execute` - Execute a dbt command.\n\n\n## dbt Version Management\ndbtenv will automatically install the required version of dbt for the current project by default. To disable this behaviour, set the environment variable `DBTENV_AUTO_INSTALL` to `false`.\n\nBy default, dbtenv creates virtual environments for each dbt package version within `~/.dbt/versions`. You can customize this location by setting the `DBTENV_VENVS_DIRECTORY` environment variable.\n\nBy default, dbtenv uses whichever Python version it was installed with to install dbt, but that can be changed by setting a `DBTENV_PYTHON` environment variable to the path of a different Python executable, or specifying `--python <path>` when running `dbtenv install`.\n\n## Switching between dbt versions\n### Adapter type\nIf dbtenv is invoked within a dbt project, dbtenv will look for the project's default target adapter type in `profiles.yml`. If dbt's `--target` argument is set, dbtenv will use that target's adapter type instead. To use the `dbtenv execute` command outside of a dbt project (such as `dbt init`), a pip specifier should be passed to dbtenv execute's `--dbt` argument so that dbtenv knows which adapter to use.\n\n### dbt version\n\ndbtenv determines the dbt version to use from the following sources, using the first one it finds:\n\n1. The `dbtenv execute` command's optional `--dbt <version>` argument.\n2. The `DBT_VERSION` environment variable.\n\n3. If not running within a dbt project:\n    1. The first `.dbt_version` file found searching the working directory path (local version).\n    2. The `~/.dbt/version` file (global version).\n4. The current dbt project's [dbt_project.yml](https://docs.getdbt.com/reference/project-configs/require-dbt-version/) version requirements.\n   - If a local or global dbt version has been set, dbtenv will use that version if in the range set by `require-dbt-version`.\n5. The locally or globally set version.\n6. The max installed dbt version (preferring stable versions).\n7. The max installable dbt version (preferring stable versions).\n\nYou can:\n- Run `dbtenv version --global <version>` to set the dbt version globally in the `~/.dbt/version` file. The `<version>` can be either a dbt version (e.g. 1.0.0) or full pip specifier (e.g. dbt-snowflake==1.0.0). dbtenv will attempt to automatically detect the required adapter or version from the environment if not specified.\n- Run `dbtenv version --local <version>` to set the dbt version for the current directory in a `.dbt_version` file. The `<version>` can be either a dbt version (e.g. 1.0.0) or full pip specifier (e.g. dbt-snowflake==1.0.0). dbtenv will attempt to automatically detect the required adapter or version from the environment if not specified.\n\n## Running dbt through dbtenv\n\n### dbt-alias\n\nThe `dbtenv-dbt-alias` package creates an entrypoint for the `dbt` command to route through dbtenv. The package is installable using the `[dbt-alias]` extra when installing dbtenv. The `dbt` command then acts as a direct shortcut to `dbtenv execute --`, and means that dbtenv can used as a drop-in replacement to installing dbt normally.\n\n### dbtenv execute\n\nRun `dbtenv execute -- <dbt arguments>` to execute the dbt version determined automatically from the current environment, or run `dbtenv execute --dbt <version> -- <dbt arguments>` to execute a specific dbt version.\n\nFor example:\n- `dbtenv execute -- run` will execute `dbt run` using the version determined automatically from the current environment.\n- `dbtenv execute --dbt 1.0.0 -- run` will execute `dbt run` using dbt 1.0.0, automatically detecting the required adapter from the default target in `profiles.yml`.\n- `dbtenv execute --dbt 1.0.0 -- run --target prod` will execute `dbt run` using dbt 1.0.0, using the required adapter for the 'prod' target in `profiles.yml`.\n- `dbtenv execute --dbt 1.0.0==dbt-bigquery -- run` will execute `dbt run` using dbt-bigquery==1.0.0.\n\n\n## Development\n\n### Development setup\n1. Clone this repository onto your computer.\n2. Install Poetry `pipx install poetry` ([What is pipx?](https://www.google.com/search?q=pipx&rlz=1C5GCEM_enGB953GB953&oq=Pipx&aqs=chrome.0.69i59i512j0i512l2j69i59j0i512l2j69i60l2.1010j0j7&sourceid=chrome&ie=UTF-8))\n3. Navigate to the `dbtenv` directory, and install the project into a virtual environment `poetry install`\n4. Activate the virtual environment `poetry shell`\n5. Any `dbtenv` commands will run using the local version of the project.\n",
    'author': 'Brooklyn Data Co.',
    'author_email': 'hello@brooklyndata.co',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/brooklyn-data/dbtenv',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8',
}


setup(**setup_kwargs)
