/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import cz.vutbr.fit.knot.NNetLanguageIdentifierWrapper;
import java.util.ArrayList;
import java.util.List;

public class DetectLanguage {
    NNetLanguageIdentifierWrapper identifier = null;
    NNetLanguageIdentifierWrapper.Result[] result;
    String defaultLang = "";
    int numLangs = 5;

    public DetectLanguage() {
        try {
            this.identifier = new NNetLanguageIdentifierWrapper(0, 1000);
        }
        catch (Exception | UnsatisfiedLinkError e) {
            this.identifier = null;
            throw e;
        }
    }

    public List<LanguageResult> find(String text) {
        ArrayList<LanguageResult> resultlist = new ArrayList<LanguageResult>();
        if (this.identifier != null) {
            this.result = this.identifier.findTopNMostFreqLangs(text, this.numLangs);
            if (this.result != null && this.result.length > 0) {
                for (NNetLanguageIdentifierWrapper.Result prop : this.result) {
                    if (!(prop.proportion > 0.0f)) continue;
                    resultlist.add(new LanguageResult(prop.language, prop.proportion * 100.0f, prop.isReliable));
                }
            }
        }
        return resultlist;
    }

    public class LanguageResult {
        public String language = "";
        public float percent = 0.0f;
        public boolean reliable = false;

        public LanguageResult(String language_, float percent_, boolean _realiable) {
            this.language = language_;
            this.percent = percent_;
            this.reliable = _realiable;
        }
    }
}

