# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['anime_api',
 'anime_api.apis',
 'anime_api.apis.anime_facts_rest_api',
 'anime_api.apis.animechan',
 'anime_api.apis.animu',
 'anime_api.apis.hmtai',
 'anime_api.apis.kyoko',
 'anime_api.apis.neko_love',
 'anime_api.apis.nekobot',
 'anime_api.apis.nekos_life',
 'anime_api.apis.studio_ghibli_api',
 'anime_api.apis.trace_moe',
 'anime_api.apis.waifu_pics']

package_data = \
{'': ['*']}

install_requires = \
['pykakasi>=2.2.1,<3.0.0', 'requests>=2.28.1,<3.0.0']

setup_kwargs = {
    'name': 'anime-api',
    'version': '0.11.0',
    'description': 'A collection of wrappers for anime-related APIs',
    'long_description': '# The Anime API Project\n\n![Loli count](https://count.getloli.com/get/@anime-api?theme=gelbooru)\n\nThe Anime API is a collection of wrappers for different types of free anime-related APIs.\n\n\n## Why anime-api (and not others)?\n\nThere are several reasons why would you prefer using anime-api:\n- **Intuitive**: anime-api is designed to be intuitive. Supports autocompletion everywhere.\n- **Complete**: Every actively supported API has no feature left apart.\n- **Simple**: Get all the anime information you want with a single line of code.\n- **Legal**: I shouldn\'t need to say this, but all the APIs are legal. (no free streaming services/others)\n- **Actively supported**: Get new releases (with new API wrappers) every now and then.\n\n\n## Installation\n\nUsing Poetry:\n```\npoetry add anime-api\n```\n\nUsing pip:\n```\npip install anime-api\n```\n\n## Documentation\n\nThe full documentation can be found [here](https://nekidev.github.io/anime-api/docs/).\n\n\n## APIs\n\nThese are the currently supported and planned to add support for APIs:\n\n| Name                        | API Documentation                                                                   | Available |\n|-----------------------------|-------------------------------------------------------------------------------------|-----------|\n| Anime Facts Rest API        | [Documentation](https://chandan-02.github.io/anime-facts-rest-api/)                 | ✅        |\n| Trace.moe                   | [Documentation](https://soruly.github.io/trace.moe-api/)                            | ✅        |\n| Animechan                   | [Documentation](https://animechan.vercel.app/guide)                                 | ✅        |\n| Jikan (MyAnimeList)         | [Documentation](https://jikan.docs.apiary.io/)                                      | ❌        |\n| Waifu Pics                  | [Documentation](https://waifu.pics/docs)                                            | ✅        |\n| Studio Ghibli API           | [Documentation](https://ghibliapi.herokuapp.com/)                                   | ✅        |\n| Kitsu                       | [Documentation](https://kitsu.docs.apiary.io/)                                      | ❌        |\n| AniList                     | [Documentation](https://anilist.gitbook.io/anilist-apiv2-docs/)                     | ❌        |\n| AniDB                       | [Documentation](https://wiki.anidb.net/w/API)                                       | ❌        |\n| Kyoko                       | [Documentation](https://github.com/Elliottophellia/kyoko)                           | ✅        |\n| Animu                       | [Documentation](https://docs.animu.ml/)                                             | ✅        |\n| Anisearch                   | [Documentation](https://anisearch.com/developers)                                   | ❌        |\n| Anime News Network          | [Documentation](https://www.animenewsnetwork.com/encyclopedia/api.php)              | ❌        |\n| Notify.moe (Anime Notifier) | [Documentation](https://notify.moe/api)                                             | ❌        |\n| Hmtai                       | [Documentation](https://hmtai.herokuapp.com/endpoints)                              | ✅        |\n| Nekos.life                  | [Documentation](https://github.com/Nekos-life/nekos.py)                             | ✅        |\n| NekoBot                     | [Documentation](https://docs.nekobot.xyz/)                                          | ✅        |\n| Neko-Love                   | [Documentation](https://docs.neko-love.xyz/)                                        | ✅        |\n| Nekos.best                  | [Documentation](https://docs.nekos.best/)                                           | ❌        |\n| Nekos.moe                   | [Documentation](https://docs.nekos.moe/)                                            | ❌        |\n| Shikimori                   | [Documentation](https://shikimori.one/api/doc)                                      | ❌        |\n| MangaDex                    | [Documentation](https://api.mangadex.org/docs.html)                                 | ❌        |\n| Danbooru                    | [Documentation](https://danbooru.donmai.us/wiki_pages/help:api)                     | ❌        |\n| Yandere                     | [Documentation](https://yande.re/help/api)                                          | ❌        |\n| Konachan                    | [Documentation](https://konachan.com/help/api)                                      | ❌        |\n| Waifus.im                   | [Documentation](https://waifu.im/)                                                  | ❌        |\n| Catboys                     | [Documentation](https://catboys.com/api)                                            | ❌        |\n| Anime Character Database    | [Documentation](http://wiki.animecharactersdatabase.com/index.php?title=API_Access) | ❌        |\n\n\n### APIs by feature\n\nYou know what you want to do, but have no idea of what API will work for you? This list orders the APIs by features. See which fits you best!\n\n\n#### Images\n\n- Animu:\n  - Tons of anime gifs and images\n  - Get reaction gifs from +60 different categories\n  - Completely free\n- Hmtai:\n  - Tons of anime gifs and images\n  - SFW and NSFW images\n  - Get random images from +70 different categories\n  - Completely free\n- Nekos.life\n  - Lots of different neko pics\n  - Get random neko images from +20 different categories\n  - Completely free\n- Waifu.pics\n  - Lots of different waifu images\n  - Get random images from +30 categories\n  - SFW and NSFW images\n  - Get 30 different images with a single API call\n  - Get a different image every time\n  - Completely free\n- NekoBot\n  - Image generation (memes, ships, etc.)\n  - Get random images from 30 different categories\n  - SFW and NSFW images\n  - Completely free\n\n\n#### Facts\n\n- Anime Facts Rest API:\n  - Lots of different anime facts\n  - Get random fact from an anime\n  - Save fact ID and refetch the fact later\n  - Get a list of all available animes\n  - Completely free\n- Animu:\n  - Lots of anime facts\n  - Get random anime facts\n  - Completely free\n- Kyoko:\n  - Lots of different anime facts\n  - Get random reaction gifs from 3 different categories\n  - Completely free\n- Nekos.life\n  - Lots of different anime facts\n  - Get random anime facts\n  - Completely free\n\n\n#### Quotes\n\n- Animechan:\n  - Lots of different quotes from a large list of characters and animes\n  - Get random anime quotes\n  - Get 10 random anime quotes with a single api call\n  - Search quotes by character name or anime title\n  - Get a list of all available animes\n  - Completely free\n- Animu:\n  - Lots of different anime quotes with information about who said them and where\n  - Get random anime quotes\n  - Completely free.\n- Kyoko:\n  - Lots of different anime quotes\n  - Get random quotes with information about who said them and where\n  - Completely free\n\n\n#### Waifus\n\n- Animu:\n  - Lots of different waifus from Video Games, Animes, Movies and more.\n  - Get random waifus with their statistics, source, many images and more.\n  - Completely free\n\n\n#### Animes\n\n- Anime Facts Rest API:\n  - Get a list of lots of snake-case anime titles with their images and facts about them\n  - Completely free\n- Animechan:\n  - Get a list of lots of anime titles with random quotes from them\n  - Completely free\n- Studio Ghibli API\n  - Get Studio Ghibli animes with information such as director, producer, etc.\n  - Dynamic loading support\n  - Get super specific anime details such as veichles, locations, people, and species.\n  - Completely free\n\n\n#### Entertainment\n\n- Nekos.life\n  - Get an answer from an 8ball with an aditional image of an 8ball showing the answer.\n  - Get a random "why?" question\n  - Completely free\n\n\n#### Utilities\n\n- Trace.moe\n  - Find an anime from a screenshot with information about the specific anime, episode and time of the screenshot.\n  - Completely free\n- Nekos.life\n  - Get a random cat text emoji\n  - Generate random names\n  - Owoify text (`hello` => `hewwo`)\n  - Mark text as spoiler (`hello` => `||hello||`) (API endpoint is currently bugged)\n  - Completely free\n- Animu:\n  - Generate a secure password\n  - Completely free\n\n\n### APIs that will not be supported\n- Illegal anime streaming services\n- Non anime-related APIs\n- APIs that are not APIs (i.e. web scrapping)\n\n\n## Contributing\n\nRead the following before contributing:\n\n\n### Adding an API\n\nIf you want to add an API to the list, please make sure that:\n\n- The API is free to use\n- The API is anime-related (or manga-related)\n- You follow the same architecture as the other API wrappers\n- Document the code you write\n- Add all the necessary tests to the `tests` folder\n\n\n### Fixing an API wrapper\n\nBefore fixing an API wrapper, please make sure that:\n\n- The bug is not being fixed in another PR\n- The bug is actually a bug and not a feature (xd)\n- The bug is not a bug from the API itself\n- You have created an issue. If you have not created an issue, please create one before fixing the bug.\n\n\n### Requesting a new API\n\nIf you want to request a new API, please make sure that:\n\n- The API is free to use\n- The API is anime-related (or manga-related)\n- It is not already in the list (wether available or not)\n\nOnce you have checked this, please create an issue with the following information:\n\n- The name of the API\n- The API docs link\n- List of all the features the API has\n\n\n## Mantainers\n\n<table>\n  <tr>\n    <td style="align:center;">\n      <a href="https://github.com/Nekidev">\n        <img src="https://avatars.githubusercontent.com/u/84998222?s=256&v=4" height="100" width="100" alt="Nekidev avatar" />\n        <br>\n        <span>Nekidev</span>\n      </a>\n    </td>\n  </tr>\n</table>\n',
    'author': 'Neki',
    'author_email': '84998222+Nekidev@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
