import * as iam from '@aws-cdk/aws-iam';
import * as logs from '@aws-cdk/aws-logs';
import * as s3 from '@aws-cdk/aws-s3';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ISubnet, IVpc } from './vpc';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) A FlowLog.
 *
 * @experimental
 */
export interface IFlowLog extends IResource {
    /**
     * (experimental) The Id of the VPC Flow Log.
     *
     * @experimental
     * @attribute true
     */
    readonly flowLogId: string;
}
/**
 * (experimental) The type of VPC traffic to log.
 *
 * @experimental
 */
export declare enum FlowLogTrafficType {
    /**
     * (experimental) Only log accepts.
     *
     * @experimental
     */
    ACCEPT = "ACCEPT",
    /**
     * (experimental) Log all requests.
     *
     * @experimental
     */
    ALL = "ALL",
    /**
     * (experimental) Only log rejects.
     *
     * @experimental
     */
    REJECT = "REJECT"
}
/**
 * (experimental) The available destination types for Flow Logs.
 *
 * @experimental
 */
export declare enum FlowLogDestinationType {
    /**
     * (experimental) Send flow logs to CloudWatch Logs Group.
     *
     * @experimental
     */
    CLOUD_WATCH_LOGS = "cloud-watch-logs",
    /**
     * (experimental) Send flow logs to S3 Bucket.
     *
     * @experimental
     */
    S3 = "s3"
}
/**
 * (experimental) The type of resource to create the flow log for.
 *
 * @experimental
 */
export declare abstract class FlowLogResourceType {
    /**
     * (experimental) The subnet to attach the Flow Log to.
     *
     * @experimental
     */
    static fromSubnet(subnet: ISubnet): FlowLogResourceType;
    /**
     * (experimental) The VPC to attach the Flow Log to.
     *
     * @experimental
     */
    static fromVpc(vpc: IVpc): FlowLogResourceType;
    /**
     * (experimental) The Network Interface to attach the Flow Log to.
     *
     * @experimental
     */
    static fromNetworkInterfaceId(id: string): FlowLogResourceType;
    /**
     * (experimental) The type of resource to attach a flow log to.
     *
     * @experimental
     */
    abstract resourceType: string;
    /**
     * (experimental) The Id of the resource that the flow log should be attached to.
     *
     * @experimental
     */
    abstract resourceId: string;
}
/**
 * (experimental) The destination type for the flow log.
 *
 * @experimental
 */
export declare abstract class FlowLogDestination {
    /**
     * (experimental) Use CloudWatch logs as the destination.
     *
     * @experimental
     */
    static toCloudWatchLogs(logGroup?: logs.ILogGroup, iamRole?: iam.IRole): FlowLogDestination;
    /**
     * (experimental) Use S3 as the destination.
     *
     * @experimental
     */
    static toS3(bucket?: s3.IBucket): FlowLogDestination;
    /**
     * (experimental) Generates a flow log destination configuration.
     *
     * @experimental
     */
    abstract bind(scope: CoreConstruct, flowLog: FlowLog): FlowLogDestinationConfig;
}
/**
 * (experimental) Flow Log Destination configuration.
 *
 * @experimental
 */
export interface FlowLogDestinationConfig {
    /**
     * (experimental) The type of destination to publish the flow logs to.
     *
     * @default - CLOUD_WATCH_LOGS
     * @experimental
     */
    readonly logDestinationType: FlowLogDestinationType;
    /**
     * (experimental) The IAM Role that has access to publish to CloudWatch logs.
     *
     * @default - default IAM role is created for you
     * @experimental
     */
    readonly iamRole?: iam.IRole;
    /**
     * (experimental) The CloudWatch Logs Log Group to publish the flow logs to.
     *
     * @default - default log group is created for you
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
    /**
     * (experimental) S3 bucket to publish the flow logs to.
     *
     * @default - undefined
     * @experimental
     */
    readonly s3Bucket?: s3.IBucket;
}
/**
 * (experimental) Options to add a flow log to a VPC.
 *
 * @experimental
 */
export interface FlowLogOptions {
    /**
     * (experimental) The type of traffic to log.
     *
     * You can log traffic that the resource accepts or rejects, or all traffic.
     *
     * @default ALL
     * @experimental
     */
    readonly trafficType?: FlowLogTrafficType;
    /**
     * (experimental) Specifies the type of destination to which the flow log data is to be published.
     *
     * Flow log data can be published to CloudWatch Logs or Amazon S3
     *
     * @default FlowLogDestinationType.toCloudWatchLogs()
     * @experimental
     */
    readonly destination?: FlowLogDestination;
}
/**
 * (experimental) Properties of a VPC Flow Log.
 *
 * @experimental
 */
export interface FlowLogProps extends FlowLogOptions {
    /**
     * (experimental) The name of the FlowLog.
     *
     * It is not recommended to use an explicit name.
     *
     * @default If you don't specify a flowLogName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     * @experimental
     */
    readonly flowLogName?: string;
    /**
     * (experimental) The type of resource for which to create the flow log.
     *
     * @experimental
     */
    readonly resourceType: FlowLogResourceType;
}
/**
 * The base class for a Flow Log
 *
 * @experimental
 */
declare abstract class FlowLogBase extends Resource implements IFlowLog {
    /**
     * The Id of the VPC Flow Log
     *
     * @attribute
     */
    abstract readonly flowLogId: string;
}
/**
 * (experimental) A VPC flow log.
 *
 * @experimental
 * @resource AWS::EC2::FlowLog
 */
export declare class FlowLog extends FlowLogBase {
    /**
     * (experimental) Import a Flow Log by it's Id.
     *
     * @experimental
     */
    static fromFlowLogId(scope: Construct, id: string, flowLogId: string): IFlowLog;
    /**
     * (experimental) The Id of the VPC Flow Log.
     *
     * @experimental
     * @attribute true
     */
    readonly flowLogId: string;
    /**
     * (experimental) The S3 bucket to publish flow logs to.
     *
     * @experimental
     */
    readonly bucket?: s3.IBucket;
    /**
     * (experimental) The iam role used to publish logs to CloudWatch.
     *
     * @experimental
     */
    readonly iamRole?: iam.IRole;
    /**
     * (experimental) The CloudWatch Logs LogGroup to publish flow logs to.
     *
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: FlowLogProps);
}
export {};
