import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type JFrog::Vpc::MultiAz::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * Availability Zone 1 to use for the subnets in the VPC.
     *
     * Two Availability Zones are used for this deployment.
     *
     * @schema CfnModulePropsParameters#AvailabilityZone1
     */
    readonly availabilityZone1?: CfnModulePropsParametersAvailabilityZone1;
    /**
     * Availability Zone 2 to use for the subnets in the VPC.
     *
     * Two Availability Zones are used for this deployment.
     *
     * @schema CfnModulePropsParameters#AvailabilityZone2
     */
    readonly availabilityZone2?: CfnModulePropsParametersAvailabilityZone2;
    /**
     * Set to false when creating only private subnets.
     *
     * If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
     *
     * @schema CfnModulePropsParameters#CreateNATGateways
     */
    readonly createNatGateways?: CfnModulePropsParametersCreateNatGateways;
    /**
     * Set to false to create only private subnets.
     *
     * If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
     *
     * @schema CfnModulePropsParameters#CreatePublicSubnets
     */
    readonly createPublicSubnets?: CfnModulePropsParametersCreatePublicSubnets;
    /**
     * Set to false to create only public subnets.
     *
     * If false, the CIDR parameters for ALL private subnets will be ignored.
     *
     * @schema CfnModulePropsParameters#CreatePrivateSubnets
     */
    readonly createPrivateSubnets?: CfnModulePropsParametersCreatePrivateSubnets;
    /**
     * CIDR block for private subnet 1A located in Availability Zone 1.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet1ACIDR
     */
    readonly privateSubnet1Acidr?: CfnModulePropsParametersPrivateSubnet1Acidr;
    /**
     * CIDR block for private subnet 2A located in Availability Zone 2.
     *
     * @schema CfnModulePropsParameters#PrivateSubnet2ACIDR
     */
    readonly privateSubnet2Acidr?: CfnModulePropsParametersPrivateSubnet2Acidr;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetATag1
     */
    readonly privateSubnetATag1?: CfnModulePropsParametersPrivateSubnetATag1;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PrivateSubnetATag2
     */
    readonly privateSubnetATag2?: CfnModulePropsParametersPrivateSubnetATag2;
    /**
     * CIDR block for the public DMZ subnet 1 located in Availability Zone 1.
     *
     * @schema CfnModulePropsParameters#PublicSubnet1CIDR
     */
    readonly publicSubnet1Cidr?: CfnModulePropsParametersPublicSubnet1Cidr;
    /**
     * CIDR block for the public DMZ subnet 2 located in Availability Zone 2.
     *
     * @schema CfnModulePropsParameters#PublicSubnet2CIDR
     */
    readonly publicSubnet2Cidr?: CfnModulePropsParametersPublicSubnet2Cidr;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PublicSubnetTag1
     */
    readonly publicSubnetTag1?: CfnModulePropsParametersPublicSubnetTag1;
    /**
     * tag to add to public subnets, in format Key=Value (Optional).
     *
     * @schema CfnModulePropsParameters#PublicSubnetTag2
     */
    readonly publicSubnetTag2?: CfnModulePropsParametersPublicSubnetTag2;
    /**
     * CIDR block for the VPC.
     *
     * @schema CfnModulePropsParameters#VPCCIDR
     */
    readonly vpccidr?: CfnModulePropsParametersVpccidr;
    /**
     * The allowed tenancy of instances launched into the VPC.
     *
     * @schema CfnModulePropsParameters#VPCTenancy
     */
    readonly vpcTenancy?: CfnModulePropsParametersVpcTenancy;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#DHCPOptions
     */
    readonly dhcpOptions?: CfnModulePropsResourcesDhcpOptions;
    /**
     * @schema CfnModulePropsResources#VPC
     */
    readonly vpc?: CfnModulePropsResourcesVpc;
    /**
     * @schema CfnModulePropsResources#VPCDHCPOptionsAssociation
     */
    readonly vpcdhcpOptionsAssociation?: CfnModulePropsResourcesVpcdhcpOptionsAssociation;
    /**
     * @schema CfnModulePropsResources#InternetGateway
     */
    readonly internetGateway?: CfnModulePropsResourcesInternetGateway;
    /**
     * @schema CfnModulePropsResources#VPCGatewayAttachment
     */
    readonly vpcGatewayAttachment?: CfnModulePropsResourcesVpcGatewayAttachment;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1A
     */
    readonly privateSubnet1A?: CfnModulePropsResourcesPrivateSubnet1A;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2A
     */
    readonly privateSubnet2A?: CfnModulePropsResourcesPrivateSubnet2A;
    /**
     * @schema CfnModulePropsResources#PublicSubnet1
     */
    readonly publicSubnet1?: CfnModulePropsResourcesPublicSubnet1;
    /**
     * @schema CfnModulePropsResources#PublicSubnet2
     */
    readonly publicSubnet2?: CfnModulePropsResourcesPublicSubnet2;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1ARouteTable
     */
    readonly privateSubnet1ARouteTable?: CfnModulePropsResourcesPrivateSubnet1ARouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1ARoute
     */
    readonly privateSubnet1ARoute?: CfnModulePropsResourcesPrivateSubnet1ARoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet1ARouteTableAssociation
     */
    readonly privateSubnet1ARouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2ARouteTable
     */
    readonly privateSubnet2ARouteTable?: CfnModulePropsResourcesPrivateSubnet2ARouteTable;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2ARoute
     */
    readonly privateSubnet2ARoute?: CfnModulePropsResourcesPrivateSubnet2ARoute;
    /**
     * @schema CfnModulePropsResources#PrivateSubnet2ARouteTableAssociation
     */
    readonly privateSubnet2ARouteTableAssociation?: CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnetRouteTable
     */
    readonly publicSubnetRouteTable?: CfnModulePropsResourcesPublicSubnetRouteTable;
    /**
     * @schema CfnModulePropsResources#PublicSubnetRoute
     */
    readonly publicSubnetRoute?: CfnModulePropsResourcesPublicSubnetRoute;
    /**
     * @schema CfnModulePropsResources#PublicSubnet1RouteTableAssociation
     */
    readonly publicSubnet1RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet1RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#PublicSubnet2RouteTableAssociation
     */
    readonly publicSubnet2RouteTableAssociation?: CfnModulePropsResourcesPublicSubnet2RouteTableAssociation;
    /**
     * @schema CfnModulePropsResources#NAT1EIP
     */
    readonly nat1Eip?: CfnModulePropsResourcesNat1Eip;
    /**
     * @schema CfnModulePropsResources#NAT2EIP
     */
    readonly nat2Eip?: CfnModulePropsResourcesNat2Eip;
    /**
     * @schema CfnModulePropsResources#NATGateway1
     */
    readonly natGateway1?: CfnModulePropsResourcesNatGateway1;
    /**
     * @schema CfnModulePropsResources#NATGateway2
     */
    readonly natGateway2?: CfnModulePropsResourcesNatGateway2;
    /**
     * @schema CfnModulePropsResources#S3VPCEndpoint
     */
    readonly s3VpcEndpoint?: CfnModulePropsResourcesS3VpcEndpoint;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Availability Zone 1 to use for the subnets in the VPC.
 *
 * Two Availability Zones are used for this deployment.
 *
 * @schema CfnModulePropsParametersAvailabilityZone1
 */
export interface CfnModulePropsParametersAvailabilityZone1 {
    /**
     * @schema CfnModulePropsParametersAvailabilityZone1#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAvailabilityZone1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAvailabilityZone1' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAvailabilityZone1(obj: CfnModulePropsParametersAvailabilityZone1 | undefined): Record<string, any> | undefined;
/**
 * Availability Zone 2 to use for the subnets in the VPC.
 *
 * Two Availability Zones are used for this deployment.
 *
 * @schema CfnModulePropsParametersAvailabilityZone2
 */
export interface CfnModulePropsParametersAvailabilityZone2 {
    /**
     * @schema CfnModulePropsParametersAvailabilityZone2#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersAvailabilityZone2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersAvailabilityZone2' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersAvailabilityZone2(obj: CfnModulePropsParametersAvailabilityZone2 | undefined): Record<string, any> | undefined;
/**
 * Set to false when creating only private subnets.
 *
 * If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
 *
 * @schema CfnModulePropsParametersCreateNatGateways
 */
export interface CfnModulePropsParametersCreateNatGateways {
    /**
     * @schema CfnModulePropsParametersCreateNatGateways#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreateNatGateways#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreateNatGateways' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreateNatGateways(obj: CfnModulePropsParametersCreateNatGateways | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only private subnets.
 *
 * If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
 *
 * @schema CfnModulePropsParametersCreatePublicSubnets
 */
export interface CfnModulePropsParametersCreatePublicSubnets {
    /**
     * @schema CfnModulePropsParametersCreatePublicSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreatePublicSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreatePublicSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreatePublicSubnets(obj: CfnModulePropsParametersCreatePublicSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only public subnets.
 *
 * If false, the CIDR parameters for ALL private subnets will be ignored.
 *
 * @schema CfnModulePropsParametersCreatePrivateSubnets
 */
export interface CfnModulePropsParametersCreatePrivateSubnets {
    /**
     * @schema CfnModulePropsParametersCreatePrivateSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersCreatePrivateSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersCreatePrivateSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersCreatePrivateSubnets(obj: CfnModulePropsParametersCreatePrivateSubnets | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 1A located in Availability Zone 1.
 *
 * @schema CfnModulePropsParametersPrivateSubnet1Acidr
 */
export interface CfnModulePropsParametersPrivateSubnet1Acidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet1Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet1Acidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet1Acidr(obj: CfnModulePropsParametersPrivateSubnet1Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 2A located in Availability Zone 2.
 *
 * @schema CfnModulePropsParametersPrivateSubnet2Acidr
 */
export interface CfnModulePropsParametersPrivateSubnet2Acidr {
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnet2Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnet2Acidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnet2Acidr(obj: CfnModulePropsParametersPrivateSubnet2Acidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetATag1
 */
export interface CfnModulePropsParametersPrivateSubnetATag1 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetATag1' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetATag1(obj: CfnModulePropsParametersPrivateSubnetATag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPrivateSubnetATag2
 */
export interface CfnModulePropsParametersPrivateSubnetATag2 {
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPrivateSubnetATag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPrivateSubnetATag2' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPrivateSubnetATag2(obj: CfnModulePropsParametersPrivateSubnetATag2 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 1 located in Availability Zone 1.
 *
 * @schema CfnModulePropsParametersPublicSubnet1Cidr
 */
export interface CfnModulePropsParametersPublicSubnet1Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet1Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet1Cidr(obj: CfnModulePropsParametersPublicSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 2 located in Availability Zone 2.
 *
 * @schema CfnModulePropsParametersPublicSubnet2Cidr
 */
export interface CfnModulePropsParametersPublicSubnet2Cidr {
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnet2Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnet2Cidr(obj: CfnModulePropsParametersPublicSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPublicSubnetTag1
 */
export interface CfnModulePropsParametersPublicSubnetTag1 {
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnetTag1' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnetTag1(obj: CfnModulePropsParametersPublicSubnetTag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional).
 *
 * @schema CfnModulePropsParametersPublicSubnetTag2
 */
export interface CfnModulePropsParametersPublicSubnetTag2 {
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersPublicSubnetTag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersPublicSubnetTag2' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersPublicSubnetTag2(obj: CfnModulePropsParametersPublicSubnetTag2 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the VPC.
 *
 * @schema CfnModulePropsParametersVpccidr
 */
export interface CfnModulePropsParametersVpccidr {
    /**
     * @schema CfnModulePropsParametersVpccidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpccidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpccidr' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpccidr(obj: CfnModulePropsParametersVpccidr | undefined): Record<string, any> | undefined;
/**
 * The allowed tenancy of instances launched into the VPC.
 *
 * @schema CfnModulePropsParametersVpcTenancy
 */
export interface CfnModulePropsParametersVpcTenancy {
    /**
     * @schema CfnModulePropsParametersVpcTenancy#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcTenancy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcTenancy' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcTenancy(obj: CfnModulePropsParametersVpcTenancy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesDhcpOptions
 */
export interface CfnModulePropsResourcesDhcpOptions {
    /**
     * @schema CfnModulePropsResourcesDhcpOptions#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesDhcpOptions#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesDhcpOptions' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesDhcpOptions(obj: CfnModulePropsResourcesDhcpOptions | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpc
 */
export interface CfnModulePropsResourcesVpc {
    /**
     * @schema CfnModulePropsResourcesVpc#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpc#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpc' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpc(obj: CfnModulePropsResourcesVpc | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcdhcpOptionsAssociation
 */
export interface CfnModulePropsResourcesVpcdhcpOptionsAssociation {
    /**
     * @schema CfnModulePropsResourcesVpcdhcpOptionsAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcdhcpOptionsAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcdhcpOptionsAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcdhcpOptionsAssociation(obj: CfnModulePropsResourcesVpcdhcpOptionsAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInternetGateway
 */
export interface CfnModulePropsResourcesInternetGateway {
    /**
     * @schema CfnModulePropsResourcesInternetGateway#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInternetGateway#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInternetGateway' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInternetGateway(obj: CfnModulePropsResourcesInternetGateway | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesVpcGatewayAttachment
 */
export interface CfnModulePropsResourcesVpcGatewayAttachment {
    /**
     * @schema CfnModulePropsResourcesVpcGatewayAttachment#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesVpcGatewayAttachment#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesVpcGatewayAttachment' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesVpcGatewayAttachment(obj: CfnModulePropsResourcesVpcGatewayAttachment | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1A
 */
export interface CfnModulePropsResourcesPrivateSubnet1A {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1A' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1A(obj: CfnModulePropsResourcesPrivateSubnet1A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2A
 */
export interface CfnModulePropsResourcesPrivateSubnet2A {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2A' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2A(obj: CfnModulePropsResourcesPrivateSubnet2A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet1
 */
export interface CfnModulePropsResourcesPublicSubnet1 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet1(obj: CfnModulePropsResourcesPublicSubnet1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet2
 */
export interface CfnModulePropsResourcesPublicSubnet2 {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet2(obj: CfnModulePropsResourcesPublicSubnet2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet1ARouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1ARouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1ARouteTable(obj: CfnModulePropsResourcesPrivateSubnet1ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1ARoute
 */
export interface CfnModulePropsResourcesPrivateSubnet1ARoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1ARoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1ARoute(obj: CfnModulePropsResourcesPrivateSubnet1ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet1ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTable
 */
export interface CfnModulePropsResourcesPrivateSubnet2ARouteTable {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2ARouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2ARouteTable(obj: CfnModulePropsResourcesPrivateSubnet2ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2ARoute
 */
export interface CfnModulePropsResourcesPrivateSubnet2ARoute {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2ARoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2ARoute(obj: CfnModulePropsResourcesPrivateSubnet2ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation
 */
export interface CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation(obj: CfnModulePropsResourcesPrivateSubnet2ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnetRouteTable
 */
export interface CfnModulePropsResourcesPublicSubnetRouteTable {
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnetRouteTable' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnetRouteTable(obj: CfnModulePropsResourcesPublicSubnetRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnetRoute
 */
export interface CfnModulePropsResourcesPublicSubnetRoute {
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnetRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnetRoute' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnetRoute(obj: CfnModulePropsResourcesPublicSubnetRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet1RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet1RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet1RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet1RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet1RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation
 */
export interface CfnModulePropsResourcesPublicSubnet2RouteTableAssociation {
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesPublicSubnet2RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesPublicSubnet2RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesPublicSubnet2RouteTableAssociation(obj: CfnModulePropsResourcesPublicSubnet2RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNat1Eip
 */
export interface CfnModulePropsResourcesNat1Eip {
    /**
     * @schema CfnModulePropsResourcesNat1Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNat1Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNat1Eip' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNat1Eip(obj: CfnModulePropsResourcesNat1Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNat2Eip
 */
export interface CfnModulePropsResourcesNat2Eip {
    /**
     * @schema CfnModulePropsResourcesNat2Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNat2Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNat2Eip' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNat2Eip(obj: CfnModulePropsResourcesNat2Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNatGateway1
 */
export interface CfnModulePropsResourcesNatGateway1 {
    /**
     * @schema CfnModulePropsResourcesNatGateway1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNatGateway1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNatGateway1' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNatGateway1(obj: CfnModulePropsResourcesNatGateway1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesNatGateway2
 */
export interface CfnModulePropsResourcesNatGateway2 {
    /**
     * @schema CfnModulePropsResourcesNatGateway2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesNatGateway2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesNatGateway2' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesNatGateway2(obj: CfnModulePropsResourcesNatGateway2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesS3VpcEndpoint
 */
export interface CfnModulePropsResourcesS3VpcEndpoint {
    /**
     * @schema CfnModulePropsResourcesS3VpcEndpoint#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesS3VpcEndpoint#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesS3VpcEndpoint' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesS3VpcEndpoint(obj: CfnModulePropsResourcesS3VpcEndpoint | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `JFrog::Vpc::MultiAz::MODULE`.
 *
 * @external
 * @cloudformationResource JFrog::Vpc::MultiAz::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "JFrog::Vpc::MultiAz::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `JFrog::Vpc::MultiAz::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
