# Generated by Django 4.1.2 on 2023-02-16 11:12

from django.db import migrations


def convert_author(author_string):
    author_string = author_string.strip()
    if " " in author_string:
        author_parts = author_string.split(" ")
        firstname = author_parts.pop(0)
        lastname = " ".join(author_parts)
        return {"firstname": firstname, "lastname": lastname}
    else:
        return {"firstname": author_string}


def update_publications(apps, schema_editor):
    Publication = apps.get_model("website", "Publication")
    publications = Publication.objects.all().iterator()
    for publication in publications:
        publication.authors = list(map(convert_author, publication.authors))
        publication.save()


class Migration(migrations.Migration):
    dependencies = [
        ("website", "0010_alter_publication_status"),
    ]

    operations = [
        migrations.RunPython(update_publications),
    ]
