# AUTOGENERATED! DO NOT EDIT! File to edit: ../03_express.ipynb.

# %% auto 0
__all__ = ['px', 'update_legend_and_yaxis', 'Express']

# %% ../03_express.ipynb 3
from functools import partial, wraps
import inspect
import pandas as pd
from plotly import express
from fastcore.all import *
from .core import *
from .case import *

# %% ../03_express.ipynb 4
def update_legend_and_yaxis(fun):
    @wraps(fun)
    def _inner(*args, **kwargs):
        fig = fun(*args, **kwargs)
        for t in fig.data:
            if hasattr(t, 'name'):
                t.update(name=px_labeler[t.name])
            if hasattr(t, 'legendgroup'):
                t.update(legendgroup=px_labeler[t.name])
            if hasattr(t, 'hovertemplate'):
                if not t.hovertemplate is None:
                    t.update(hovertemplate=t.hovertemplate.replace(t.name, px_labeler[t.name]))
        # some express functions like ecdf and histogram write their own yaxis text so we update it here
        if nested_attr(fig, 'layout.yaxis.title.text'):
            fig.update_layout(yaxis_title=px_labeler[fig.layout.yaxis.title.text])
        return fig
    return _inner

# %% ../03_express.ipynb 5
class Express:
    '''Like `plotly.express` but defaults to labels=`px_labeler`'''
    def __getattr__(self, attr):
        fun = getattr(express, attr)
        docstr = fun.__doc__
        if hasattr(fun, '__call__'): 
            sig = inspect.signature(fun)
            if 'labels' in sig.parameters.keys():
                if attr=='imshow':
                    imshow_labeler = PxLabeler()
                    imshow_labeler['x'] = None
                    imshow_labeler['y'] = None
                    fun = partial(fun, labels=imshow_labeler)
                else:
                    fun = update_legend_and_yaxis(partial(fun, labels=px_labeler))
        fun.__doc__ = docstr
        return fun
    __dir__ = express.__dir__
px = Express()
