import luigi
from servicecatalog_puppet.workflow import tasks


class GetCloudFormationTemplateFromS3(tasks.PuppetTask):
    puppet_account_id = luigi.Parameter()
    bucket = luigi.Parameter()
    key = luigi.Parameter()
    version_id = luigi.Parameter()

    def params_for_results_display(self):
        return {
            "puppet_account_id": self.puppet_account_id,
            "bucket": self.bucket,
            "key": self.key,
            "version_id": self.version_id,
        }

    def run(self):
        with self.hub_client("s3") as s3:
            response = s3.get_object(
                Bucket=self.bucket, Key=self.key, VersionId=self.version_id,
            )
            self.write_output(
                response.get("Body").read().decode("utf8"), skip_json_dump=True
            )
