#!/usr/bin/env python3
from __future__ import annotations

import os
import glob
import argparse

from praatio.data_classes.textgrid import Textgrid

from dynamicfluency.aeneas_conversion import aeneas_tier_from_file


def parse_arguments() -> argparse.Namespace:
    parser = argparse.ArgumentParser(
        description="Processes tokens and phrases .json files generated by aeneas a .TextGrid"
    )
    parser.add_argument(
        "-d",
        "--directory",
        nargs="?",
        default="output",
        help="The directory the tokens and phases is expected in, and the output is saved to",
    )
    return parser.parse_args()


def main():
    args: argparse.Namespace = parse_arguments()

    word_allignments = glob.glob(f"./{args.directory}/*.tokens.json")
    phrase_allignments = glob.glob(f"./{args.directory}/*.phrases.json")

    for words, phrases in zip(word_allignments, phrase_allignments):
        words_tier = aeneas_tier_from_file(words, "Words")
        phrases_tier = aeneas_tier_from_file(phrases, "Phrases")

        allignment_grid = Textgrid()
        allignment_grid.addTier(words_tier)
        allignment_grid.addTier(phrases_tier)
        name = words.replace(".tokens.json", ".allignment.TextGrid")
        allignment_grid.save(name, format="long_textgrid", includeBlankSpaces=True)

        os.remove(words)
        os.remove(phrases)


if __name__ == "__main__":
    main()
