#!/usr/bin/env python3
"""
MCP server for: Create a simple test MCP with one tool that returns hello world
Generated by KEN-MCP on 2025-06-27

TODO: Claude, please customize this MCP server based on these requirements:
Create a simple test MCP with one tool that returns hello world
Analysis Results:
- Domain: general
- Primary actions: create, validate
- Key entities: 
- Operations: filtering

Instructions:
1. Rename the placeholder tools to match the actual functionality needed
2. Update tool descriptions and parameters based on requirements
3. Implement the actual logic in each tool function
4. Add/remove tools, resources, and prompts as needed
5. Update dependencies in pyproject.toml if additional packages are required

IMPORTANT: If the MCP fails to load in Claude:
- Run: python diagnose.py to check for common issues
- Never use print() statements - use logger.info() instead
- Ensure all output goes to stderr, not stdout
"""

from fastmcp import FastMCP, Context
from fastmcp.exceptions import ToolError
from typing import Dict, List, Any, Optional
from pathlib import Path
import json
import os
import sys
import logging

# CRITICAL: Configure logging to use stderr ONLY - stdout is reserved for MCP protocol
logging.basicConfig(
    level=logging.INFO,
    format='%(asctime)s - %(name)s - %(levelname)s - %(message)s',
    stream=sys.stderr  # All logs MUST go to stderr, never stdout!
)
logger = logging.getLogger(__name__)

# Silence any stdout from imported libraries during initialization
_original_stdout = sys.stdout
sys.stdout = sys.stderr  # Temporarily redirect stdout to stderr

# Initialize the MCP server
mcp = FastMCP(
    name="test-minimal-mcp",
    instructions="""
    MCP server for: Create a simple test MCP with one tool that returns hello world
    
    Original Requirements:
    Create a simple test MCP with one tool that returns hello world
Analysis Results:
- Domain: general
- Primary actions: create, validate
- Key entities: 
- Operations: filtering
    
    TODO: Claude should update these instructions based on the actual implementation.
    """,
    log_level="ERROR"  # Only log errors to prevent stdout pollution
)

# Restore stdout for MCP protocol communication
sys.stdout = _original_stdout

# IMPORTANT: From this point on, NEVER use print() statements!
# Use logger.info(), logger.debug(), etc. instead
# Any output to stdout will break the MCP protocol


@mcp.tool
async def hello_world(
    ctx: Context
) -> Dict[str, Any]:
    """Simple hello world tool for testing MCP connection"""
    await ctx.info("Hello world tool called")
    logger.info("Hello world tool executed successfully")
    
    return {
        "status": "success",
        "message": "Hello, World!",
        "timestamp": "2025-06-27"
    }



if __name__ == "__main__":
    mcp.run()
